package hiro.yoshioka.sql;

import hiro.yoshioka.sdh2.ResultSetDataHolder2;
import hiro.yoshioka.sql.engine.GettingResourceRequest;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.util.StringUtil;

import java.sql.Driver;
import java.sql.SQLException;

public class GeneralSQL extends AbsTransactionSQL {
	public static final String[] RESULT_MESSAGE = { "RESULT" };

	public static boolean MODE_DEBUG;

	class TableComment {
		String _owner;

		String _name;

		String _type;

		String _comment;

		public TableComment(String owner, String name, String type,
				String comment) {
			_owner = owner;
			_name = name;
			_type = type;
			_comment = comment;
		}

		public String toString() {
			return "N/C [" + _name + "/" + _comment + "]";
		}
	}

	// --------------------------------------------------------------------------
	// --
	/**
	 * デフォルトコンストラクタ。 <BR>
	 * 
	 * @param driver
	 *            ドライバ
	 * @param url
	 *            URL
	 * @param user
	 *            ユーザ
	 * @param pass
	 *            パスワード
	 */
	// --------------------------------------------------------------------------
	// --
	protected GeneralSQL(Driver driver) {
		super(driver);
	}

	/**
	 * @param operationCode
	 * @return
	 */
	public boolean canDoOperation(SQLOperationType operation) {
		switch (operation) {
		case SELECT_SESSION:
			return false;
		case SELECT_LOCK:
			return false;

		case WORST_SQL:

			return false;

		default:
			return super.canDoOperation(operation);
		}
	}

	public static String getSuggestURL() {
		return StringUtil.EMPTY_STRING;
	}

	public static String getLimitString() {
		return "WHERE ROWNUM < 30";
	}

	@Override
	public ResultSetDataHolder2 getLockInfo() throws SQLException {
		return null;
	}

	@Override
	public ResultSetDataHolder2 getSessionInfo() throws SQLException {
		return null;
	}

	@Override
	protected void getTrigger(GettingResourceRequest request)
			throws SQLException {
	}

	@Override
	protected void setComments(GettingResourceRequest request)
			throws SQLException {
	}

	@Override
	protected boolean setTableText(GettingResourceRequest request)
			throws SQLException {
		fLogger.fatal("Not support yet...");
		return false;
	}

	@Override
	protected void getSequence(GettingResourceRequest request)
			throws SQLException {
		fLogger.fatal("Not support yet...");

	}

	// @Override
	// protected boolean createSchema(String schemaName) throws SQLException {
	// // TODO Auto-generated method stub
	// return false;
	// }
	//
	// @Override
	// protected boolean dropSchema(String schemaName, boolean cascade)
	// throws SQLException {
	// // TODO Auto-generated method stub
	// return false;
	// }

}