package hiro.yoshioka.sql.engine;

public enum SQLOperationType {
	/** close connection */
	CLOSE,
	/** connect to db */
	CONNECT,
	/** mirroring db resource */
	RESOURCE_MIRRORING,
	/** difference_in_structure */
	DIFFERENCE_IN_STRUCTURE,
	/** db resource caption */
	RESOURCE_CAPTION,
	/** check error */
	CHECK_VALIDATION,

	/** Statement#execute */
	EXECUTE,
	/** PreparedStatement#execute */
	PREPARED_EXECUTE,
	/** PreparedStatement#executeQuery */
	PREPARED_EXECUTE_QUERY,
	/** Statement#executeBatch */
	EXECUTE_BAT,
	/** Statement#registerOutParameter => execute */

	PREPARED_CALL,

	/** Statement#cansel */
	CANSEL,
	/** Statement#commit */
	COMMIT,
	/** Statement#rollback */
	ROLLBACK,
	/** CREATE_TRIG_FNC_PROC (replace invalid charactor) */
	CREATE_TRIG_FNC_PROC,
	/** count(*) */
	COUNT,
	/** many of count(*) */
	COUNTS,
	/** Select all */
	SELECT_ALL,
	/** TRUNCATE */
	TRUNCATE,
	// -------------------------------------------------------------------------
	// DDL
	// -------------------------------------------------------------------------
	/** CREATE_LOGIN_ROLE */
	CREATE_LOGIN_ROLE,
	/** CREATE_SCHEMA */
	CREATE_SCHEMA,
	/** CREATE_DATABASE */
	CREATE_DATABASE,
	/** DROP_DATABASE */
	DROP_DATABASE,
	/** rename field */
	RENAME_FIELD,
	/** get ddl */
	GET_DDL,
	// -------------------------------------------------------------------------
	// DML
	// -------------------------------------------------------------------------

	// -------------------------------------------------------------------------
	// FOR DOMINO
	// -------------------------------------------------------------------------
	/** select by unid */
	UNID_EXECUTE_QUERY,
	/** show AccessControL */
	SHOW_ACL,
	// -------------------------------------------------------------------------
	// extra info
	// -------------------------------------------------------------------------
	/** show session */
	SELECT_,
	/** show session */
	SELECT_SESSION,
	/** show lock info */
	SELECT_LOCK,
	/** explain plan */
	EXPLAIN_PLAN,
	/** show worst sql */
	WORST_SQL,
	/** data generate */
	DATA_GENERATE,
	// -------------------------------------------------------------------------
	// test
	// -------------------------------------------------------------------------
	/** test */
	TEST;
	// -------------------------------------------------------------------------
	// Transaction Request Tyeps
	// -------------------------------------------------------------------------
	public boolean typeOfTransationRequest() {
		switch (this) {
		case SELECT_ALL:
			return true;
		case SELECT_LOCK:
			return true;
		case SELECT_SESSION:
			return true;
		case WORST_SQL:
			return true;
		}
		return false;
	}

	public boolean isClose() {
		return CLOSE == this;
	}

	public boolean isConnect() {
		return CONNECT == this;
	}
}
