package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.Serializable;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Font extends PardefElement implements Serializable {
	private static final long serialVersionUID = -5200604478654470486L;
	String name, pitch, truetype, familyid, color;
	String size, style;

	public Font(Node atts) {
		NamedNodeMap names = atts.getAttributes();
		name = Form.getAttrValueString(names, "name");
		pitch = Form.getAttrValueString(names, "pitch");
		truetype = Form.getAttrValueString(names, "truetype");
		familyid = Form.getAttrValueString(names, "familyid");
		color = Form.getAttrValueString(names, "color");
		size = Form.getAttrValueString(names, "size");
		style = Form.getAttrValueString(names, "style");
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row, File imgDir) {
		StringBuilder buf = new StringBuilder();
		buf.append("<span ");
		if (!StringUtil.isEmpty(pitch)) {
			buf.append(" pitch='").append(pitch).append("'");
		}
		if (!StringUtil.isEmpty(truetype)) {
			buf.append(" truetype='").append(truetype).append("'");
		}
		if (!StringUtil.isEmpty(familyid)) {
			buf.append(" familyid='").append(familyid).append("'");
		}
		buf.append(" style='");
		if (!StringUtil.isEmpty(name)) {
			buf.append(" font-family:").append(name).append("; ");
		}
		if (!StringUtil.isEmpty(color)) {
			buf.append(" color:").append(color).append(";");
		}
		if (!StringUtil.isEmpty(size)) {
			buf.append(" font-size:").append(size).append(";");
		}
		if (!StringUtil.isEmpty(style)) {
			if (style.indexOf("italic") >= 0) {
				buf.append("font-style:italic;");
			}
			if (style.indexOf("bold") >= 0) {
				buf.append("font-weight:bold;");
			}
			if (style.indexOf("underline") >= 0
					&& style.indexOf("strikethrough") >= 0) {
				buf.append("text-decoration:underline line-through;");
			} else {
				if (style.indexOf("underline") >= 0) {
					buf.append("text-decoration:underline;");
				}
				if (style.indexOf("strikethrough") >= 0) {
					buf.append("text-decoration:line-through;");
				}
			}
			if (style.indexOf("superscript") >= 0) {
				buf.append("vertical-align: super;");
			}
			if (style.indexOf("subscript") >= 0) {
				buf.append("vertical-align: sub;");
			}
			if (style.indexOf("emboss") >= 0) {
				buf.append("font-effect:emboss;");
			}
			if (style.indexOf("shadow") >= 0) {
				buf.append("font-effect:engrave;");
			}
			if (style.indexOf("extrude") >= 0) {
				buf.append("font-effect:outline;");
			}
		}
		buf.append("'");
		buf.append(" >");
		if (!StringUtil.isEmpty(charactors)) {
			buf.append(charactors);
		}
		return buf.toString();
	}

	@Override
	public String itemToHtmlString() {
		return toHtmlString(null, 0, null);
	}

}
