package hiro.yoshioka.sql.notes.ddl;

import hiro.yoshioka.sdh.ResultSetDataHolder;
import hiro.yoshioka.util.StringUtil;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Pardef implements Serializable {
	private static final long serialVersionUID = 7750406701987747843L;
	int id;
	String align, leftmargin, rightmargin, linespacing, tabs;
	List<Par> parList;
	private Map<Integer, Pardef> subFormMap;

	public Pardef(Node atts) {
		NamedNodeMap names = atts.getAttributes();
		this.id = Form.getAttrValueInt(names, "id");
		align = Form.getAttrValueString(names, "align");
		leftmargin = Form.getAttrValueString(names, "leftmargin");
		rightmargin = Form.getAttrValueString(names, "rightmargin");
		linespacing = Form.getAttrValueString(names, "linespacing");
		tabs = Form.getAttrValueString(names, "tabs");
	}

	public int getId() {
		return id;
	}

	public void addElement(Par element) {
		if (parList == null) {
			parList = new ArrayList<Par>();
		}
		parList.add(element);
	}

	@Override
	public String toString() {
		return toHtmlString(null, 0, null);
	}

	public String toHtmlString(ResultSetDataHolder rdh, int row, File imgDir) {
		StringBuilder buf = new StringBuilder();
		buf.append("<div style=\"");
		if (true) {
			buf.append("border:solid 1px;");
		}
		if (!StringUtil.isEmpty(align)) {
			buf.append("text-align:").append(align).append(";");
		}
		if (!StringUtil.isEmpty(leftmargin)) {
			buf.append("margin-left:").append(leftmargin).append(";");
		}
		if (!StringUtil.isEmpty(rightmargin)) {
			// if (!StringUtil.isEmpty(rightmargin) &&
			// !"100%".equals(rightmargin)) {
			buf.append("margin-right:").append(rightmargin).append(";");
		}
		if (!StringUtil.isEmpty(tabs)) {
			buf.append("tabs:").append(tabs).append(";");
		}
		buf.append("\">");
		buf.append(StringUtil.LINE_SEPARATOR);

		if (subFormMap != null) {
			for (Pardef element : subFormMap.values()) {
				buf.append(element.toHtmlString(rdh, row, imgDir));
				buf.append(StringUtil.LINE_SEPARATOR);
			}
		}
		for (Par element : parList) {
			buf.append(String.format("  %s%n<br>",
					element.toHtmlString(rdh, row, imgDir)));
		}
		buf.append("</div>");
		return buf.toString();
	}

	public void setSubForm(Map<Integer, Pardef> subFormMap) {
		this.subFormMap = subFormMap;
	}

	public String toCssString(boolean doBorder) {
		StringBuilder buf = new StringBuilder();
		buf.append("");
		if (doBorder) {
			buf.append("border:solid 1px;");
		}
		if (!StringUtil.isEmpty(align)) {
			buf.append("text-align:").append(align).append(";");
		}
		if (!StringUtil.isEmpty(leftmargin)) {
			buf.append("margin-left:").append(leftmargin).append(";");
		}
		if (!StringUtil.isEmpty(rightmargin) && !"100%".equals(rightmargin)) {
			buf.append("margin-right:").append(rightmargin).append(";");
		}
		if (!StringUtil.isEmpty(tabs)) {
			buf.append("tabs:").append(tabs).append(";");
		}
		return buf.toString();
	}
}
