package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbsWolfDominoReflection {
	protected Log log = LogFactory.getLog(getClass());
	protected Class dominoClass;
	protected Object targetInstance;
	protected ClassManager classManager;
	protected Map<String, Method> methodCacheMap;

	public AbsWolfDominoReflection(ClassManager classManager)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		this(classManager, null);
	}

	public AbsWolfDominoReflection(ClassManager classManager,
			Object targetInstance) throws MalformedURLException,
			ClassNotFoundException, SecurityException, NoSuchMethodException {
		this.classManager = classManager;
		this.targetInstance = targetInstance;
		dominoClass = classManager.getClassForName(getDominoClassName());
	}

	public abstract String getDominoClassName();

	public Object getTargetInstance() {
		return targetInstance;
	}

	public void setTargetInstance(Object targetInstance) {
		this.targetInstance = targetInstance;
	}

	public Class getDominoClass() {
		return dominoClass;
	}

	public void recycle() throws IllegalArgumentException,
			IllegalAccessException, InvocationTargetException {
		Method m;
		try {
			m = targetInstance.getClass().getMethod("recycle");
			m.invoke(targetInstance);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
