package hiro.yoshioka.sql.notes.reflect;

public enum UserType {

	TYPE_MIXED_GROUP(3, "混在グループ"),

	TYPE_PERSON(1, "ユーザー"),

	TYPE_PERSON_GROUP(4, "ユーザーグループ"),

	TYPE_SERVER(2, "サーバー"),

	TYPE_SERVER_GROUP(5, "サーバーグループ"),

	TYPE_UNSPECIFIED(0, "指定なし"), UNKOWN(-99999999, "不明");

	private int typeId;
	private String name;

	private UserType(int typeId, String name) {
		this.typeId = typeId;
		this.name = name;
	}

	public String getName() {
		return name;
	}

	public static UserType parse(int typeId) {
		for (UserType target : values()) {
			if (target.typeId == typeId) {
				return target;
			}
		}
		return UNKOWN;
	}

	public int getTypeId() {
		return typeId;
	}

}
