package hiro.yoshioka.sql.notes.reflect;

import hiro.yoshioka.classmanager.ClassManager;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;

public class WolfEmbeddedObject extends AbsWolfDominoReflection {
	public static int EMBED_ATTACHMENT = 1454;
	Method getType;
	Method getSource;
	Method extractFile;
	Method remove;

	public WolfEmbeddedObject(ClassManager classManager, Object targetInstance)
			throws MalformedURLException, ClassNotFoundException,
			SecurityException, NoSuchMethodException {
		super(classManager, targetInstance);
	 

		getType = targetInstance.getClass().getMethod("getType");
		getSource = targetInstance.getClass().getMethod("getSource");
		extractFile = targetInstance.getClass().getMethod("extractFile", String.class);
		remove = targetInstance.getClass().getMethod("remove");

	}

	@Override
	public String getDominoClassName() {
		return "lotus.domino.EmbeddedObject";
	}
 
	public int getType() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException { 
		return (Integer) getType.invoke(targetInstance);
	}

	public String getSource() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		return (String) getSource.invoke(targetInstance);
	}

	public void extractFile(String absolutePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		extractFile.invoke(targetInstance,absolutePath);

	}

	public void remove() throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
		remove.invoke(targetInstance );
	}
 
 

}
