package hiro.yoshioka.sql.resource;

import hiro.yoshioka.sql.resource.DBColumn.SearchableType;
import hiro.yoshioka.util.SQLDataType;

import java.nio.charset.Charset;
import java.util.Collection;

public interface IDBColumn extends IDBResource {

	SQLDataType getDataType();

	void setDataTypeString(String dataTypeString);

	String getNameWithAsComment(Charset charset);

	String getDataTypeString();

	int getSize();

	/** 小数点以下桁数を得る */
	int getDecimalDigits();

	boolean hasDecimalDigits();

	short getColumnType();

	boolean isNotNull();

	boolean isIndex();

	boolean isIndexColumn();

	boolean isColumnOut();

	boolean isColumnIn();

	boolean isColumnInOut();

	boolean isColumnReturn();

	boolean isOnClickable();

	boolean isInsertDisabled();

	void setInsertDisabled(boolean insertDisabled);

	void setPKey(Collection<String> pkeyCollection);

	boolean isPkey();

	void setPKey(boolean pkey);

	static final String PKEY = "pkey";

	static final String TYPE = "type";

	static final String SIZE = "size";

	static final String NOTNULL = "notnull";

	String getProposalString();

	int getMaxColumnNameLength();

	void setMaxColumnNameLength(int maxColumnNameLength);

	void setConditionParameter(SearchableType usingCondition);

	SearchableType getSearchableType();

	String getDefaultConditionValue();

	public abstract void setParent(INameFamily parent);

}