package hiro.yoshioka.sql.resource.evernote;

import hiro.yoshioka.sql.resource.DBRoot;
import hiro.yoshioka.sql.resource.DBSchema;
import hiro.yoshioka.sql.resource.IDBResource;

import java.io.Serializable;

public class EvernoteDBSchema extends DBSchema implements Serializable {
	private static final long serialVersionUID = 2085582260341176166L;
	private EvernoteSchemaType schemaType;

	public EvernoteDBSchema(DBRoot root, EvernoteSchemaType schemaType) {
		super(root);
		this.schemaType = schemaType;
		setName(schemaType.name());
		// setComment(schemaType.getSchemaName());
	}

	public EvernoteSchemaType getSchemaType() {
		return schemaType;
	}

	public void putTag(EvernoteTag tagResource) {
		putResource(tagResource.getName(), tagResource);
	}

	@Override
	public void setValueFromOld(IDBResource schema) {
		this.schemaType = ((EvernoteDBSchema) schema).schemaType;
	}

}