package hiro.yoshioka.sql.resource.xml;

import hiro.yoshioka.sql.resource.IDBColumn;

public class STC {
	String schema;
	String table;
	String column;

	public STC() {
	}

	public STC(String schema, String table, String column) {
		this.schema = schema;
		this.table = table;
		this.column = column;
	}

	public STC(IDBColumn column) {
		this.column = column.getName();
		this.table = column.getParent().getName();
		this.schema = column.getParent().getParent().getName();
	}

	@Override
	public boolean equals(Object obj) {
		if (obj instanceof STC) {
			STC you = (STC) obj;
			if (schema.equals(you.schema) && table.equals(you.table)
					&& column.equals(you.column)) {
				return true;
			}
		}
		return false;
	}

	public String getSchema() {
		return schema;
	}

	public void setSchema(String schema) {
		this.schema = schema;
	}

	public String getTable() {
		return table;
	}

	public void setTable(String table) {
		this.table = table;
	}

	public String getColumn() {
		return column;
	}

	public void setColumn(String column) {
		this.column = column;
	}
}
