package hiro.yoshioka.sql.util;

import hiro.yoshioka.sdh.DatabaseType;
import hiro.yoshioka.sql.resource.DBResourceType;

import java.util.ArrayList;
import java.util.List;

public class CreateDBResourceHelper {
	public static List<TypedProperty> getCreateProperties(DatabaseType db_type,
			DBResourceType db_resource_type) {
		List<TypedProperty> retList = new ArrayList<CreateDBResourceHelper.TypedProperty>();
		switch (db_type) {
		case POSTGRES:
			switch (db_resource_type) {
			case DATABASE:
				retList.add(new TypedProperty(TypedEnum.Owner, null, false));
				retList.add(new TypedProperty(TypedEnum.MaxConnection, null,
						false));
				retList.add(new TypedProperty(TypedEnum.Encoding, "UTF8", true));
				break;
			case LOGIN_ROLE:
				retList.add(new TypedProperty(TypedEnum.Password, null, false));
				retList.add(new TypedProperty(TypedEnum.MaxConnection, null,
						false));
				retList.add(new TypedProperty(TypedEnum.SuperUser, false, false));
				retList.add(new TypedProperty(TypedEnum.CreateDb, false, false));
				retList.add(new TypedProperty(TypedEnum.CreateRole, false,
						false));
				retList.add(new TypedProperty(
						TypedEnum.CanInitiateStreamingReplicationAndBackups,
						false, false));
				break;
			}
			break;
		}
		return retList;
	}

	public static enum TypedEnum {
		/** エンコード */
		Encoding("エンコード", String.class),
		/** オーナー */
		Owner("オーナー", String.class),
		/** パスワード */
		Password("パスワード", String.class),
		/** 接続制限数 */
		MaxConnection("接続制限数", Integer.class),
		/** スーパーユーザ */
		SuperUser("スーパーユーザ", Boolean.class),
		/** Can create databases */
		CreateDb("Can create databases", Boolean.class),
		/** ロール作成権限 */
		CreateRole("ロール作成権限", Boolean.class),
		/** Can initiate streaming replication and backups */
		CanInitiateStreamingReplicationAndBackups(
				"Can initiate streaming replication and backups", Boolean.class);

		private String title;
		private Class clazz;

		private TypedEnum(String title, Class clazz) {
			this.title = title;
			this.clazz = clazz;
		}

		public String getTitle() {
			return title;
		}

		public Class getClazz() {
			return clazz;
		}

		public boolean isStringClazz() {
			return String.class.equals(getClazz());
		}

		public boolean isIntegerClazz() {
			return Integer.class.equals(getClazz());
		}

		public boolean isBooleanClazz() {
			return Boolean.class.equals(getClazz());
		}

		public boolean isPassword() {
			return Password.equals(this);
		}

		public boolean isMaxConnection() {
			return MaxConnection.equals(this);
		}

		public static TypedEnum parse(Object key) {
			if (key instanceof TypedEnum) {
				return (TypedEnum) key;
			}
			String skey = (String) key;
			for (TypedEnum type : values()) {
				if (type.name().equalsIgnoreCase(skey)
						|| type.getTitle().equalsIgnoreCase(skey)) {
					return type;
				}
			}
			return null;
		}
	}

	public static class TypedProperty {

		TypedEnum type;
		Object default_value;
		boolean required;

		public TypedProperty() {
		}

		public TypedProperty(TypedEnum type, Object default_value,
				boolean required) {

			this.type = type;
			this.default_value = default_value;
			this.required = required;
		}

		public TypedEnum getType() {
			return type;
		}

		public void setType(TypedEnum type) {
			this.type = type;
		}

		public Object getDefault_value() {
			return default_value;
		}

		public void setDefault_value(Object default_value) {
			this.default_value = default_value;
		}

		public boolean isRequired() {
			return required;
		}

		public void setRequired(boolean required) {
			this.required = required;
		}

	}
}
