package hiro.yoshioka.sql.util;

import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.SSHProperties;
import hiro.yoshioka.util.FileUtil;
import hiro.yoshioka.util.StringUtil;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class SSHTunnelingConfigDialog extends TitleAreaDialog implements
		KeyListener, SelectionListener {
	private static final String DEF_MESSAGE_AUTH_DISP = Messages
			.getString("SSHTunnelingConfigDialog.InputDefinitionName"); //$NON-NLS-1$
	private static final String DEF_MESSAGE_AUTH_HOST = Messages
			.getString("SSHTunnelingConfigDialog.InputHostName"); //$NON-NLS-1$
	private static final String DEF_MESSAGE_AUTH_USER = Messages
			.getString("SSHTunnelingConfigDialog.InputUserName"); //$NON-NLS-1$
	private static final String DEF_MESSAGE_AUTH_PASS = Messages
			.getString("SSHTunnelingConfigDialog.InputPassword"); //$NON-NLS-1$
	private static final String DEF_MESSAGE_LPF_HOST = Messages
			.getString("SSHTunnelingConfigDialog.InputHostName"); //$NON-NLS-1$
	private static final String DEF_MESSAGE_RPF_BIND_ADDR = Messages
			.getString("SSHTunnelingConfigDialog.InputBindAddress"); //$NON-NLS-1$
	private static final String DEF_MESSAGE_RPF_TARGET_ADDR = Messages
			.getString("SSHTunnelingConfigDialog.InputTargetAddress"); //$NON-NLS-1$
	protected Log fLogger = LogFactory.getLog(this.getClass());

	static enum MODE {
		ADD, EDIT, CLONE;
	}

	MODE mode;
	Text fDefinitionName;
	Text fAuth_host;
	Text fAuth_user;
	Text fAuth_pass;
	Spinner fAuth_port;

	// [ Local Port Forwarder ]
	Spinner fLpf_port;
	Spinner fLpf_to_port;

	SSHProperties fSSHProperties;

	String originalName;

	@Override
	protected boolean isResizable() {
		return true;
	}

	public SSHTunnelingConfigDialog(Shell shell, SSHProperties selectedItem,
			MODE mode) {
		super(shell);

		fSSHProperties = selectedItem;
		this.mode = mode;
	}

	Text createText(Composite parent) {
		Text ret = new Text(parent, SWT.BORDER);
		// ret.setEditable(false);
		ret.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		return ret;
	}

	private Label createLabel(Composite parent, String text) {
		Label lb = new Label(parent, SWT.NONE);
		lb.setText(text);
		return lb;
	}

	private void validate() {
		if (this.testConnectButton != null) {
			testConnectButton.setEnabled(false);
		}
		setErrorMessage(null);
		Button bt = getButton(IDialogConstants.OK_ID);
		if (bt == null) {
			return;
		}
		bt.setEnabled(false);
		String definition = fDefinitionName.getText();
		if (StringUtil.isEmpty(definition)) {
			setErrorMessage(DEF_MESSAGE_AUTH_DISP);
			return;
		}
		SSHProperties sh = SQLServerThread.getSQLServer()
				.getConnectionSettingBean().getSSHProperties(definition);
		if (sh != null) {
			System.out.println("mode:" + this.mode); //$NON-NLS-1$
			System.out.println("[" + definition + "][" + originalName + "]:"); //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
			if (this.mode == MODE.EDIT && (definition.equals(originalName))) {
			} else {
				setErrorMessage(String
						.format(Messages
								.getString("SSHTunnelingConfigDialog.DefinitionDefinedd"), //$NON-NLS-1$
						definition));
				return;
			}
		}

		if (StringUtil.isEmpty(fAuth_host.getText())) {
			setErrorMessage(DEF_MESSAGE_AUTH_HOST);
			return;
		}
		if (StringUtil.isEmpty(fAuth_user.getText())) {
			setErrorMessage(DEF_MESSAGE_AUTH_USER);
			return;
		}
		if (StringUtil.isEmpty(fAuth_pass.getText())) {
			setErrorMessage(DEF_MESSAGE_AUTH_PASS);
			return;
		}
		testConnectButton.setEnabled(true);

		bt.setEnabled(true);

	}

	private GridData createTextGridData() {
		GridData data = new GridData(GridData.FILL_HORIZONTAL);
		data.widthHint = 210;
		return data;
	}

	protected Control createDialogArea(Composite parent) {

		getShell()
				.setText(
						Messages.getString("SSHTunnelingConfigDialog.SSHTunnelingSetting")); //$NON-NLS-1$
		Composite inner = new Composite(parent, SWT.NONE);
		inner.setLayoutData(new GridData(GridData.FILL_BOTH));
		GridLayout layout = new GridLayout(1, false);
		inner.setLayout(layout);

		// [ Authenticate ]
		Group baseGroup = createGroup(inner,
				Messages.getString("SSHTunnelingConfigDialog.Authenticate"), 2); //$NON-NLS-1$

		createLabel(baseGroup,
				Messages.getString("SSHTunnelingConfigDialog.definitionName")); //$NON-NLS-1$
		fDefinitionName = new Text(baseGroup, SWT.SINGLE | SWT.BORDER);
		fDefinitionName.setLayoutData(createTextGridData());
		fDefinitionName.addKeyListener(this);
		fDefinitionName.setMessage(DEF_MESSAGE_AUTH_DISP);

		createLabel(baseGroup,
				Messages.getString("SSHTunnelingConfigDialog.hostName")); //$NON-NLS-1$
		fAuth_host = new Text(baseGroup, SWT.SINGLE | SWT.BORDER);
		fAuth_host.setLayoutData(createTextGridData());
		fAuth_host.addKeyListener(this);
		fAuth_host.setMessage(DEF_MESSAGE_AUTH_HOST);

		createLabel(baseGroup,"Port");
		fAuth_port = new Spinner(baseGroup, SWT.NONE);
		fAuth_port.setValues(22, 22, 99999, 0, 1, 1);
		fAuth_port.setLayoutData(createTextGridData());
		fAuth_port.addKeyListener(this);

		createLabel(baseGroup,
				Messages.getString("SSHTunnelingConfigDialog.userName")); //$NON-NLS-1$
		fAuth_user = new Text(baseGroup, SWT.SINGLE | SWT.BORDER); //$NON-NLS-1$
		fAuth_user.setLayoutData(createTextGridData());
		fAuth_user.addKeyListener(this);
		fAuth_user.setMessage(DEF_MESSAGE_AUTH_USER);

		createLabel(baseGroup,
				Messages.getString("SSHTunnelingConfigDialog.password")); //$NON-NLS-1$
		fAuth_pass = new Text(baseGroup, SWT.SINGLE | SWT.BORDER | SWT.PASSWORD);
		fAuth_pass.setLayoutData(createTextGridData());
		fAuth_pass.addKeyListener(this);
		fAuth_pass.setMessage(DEF_MESSAGE_AUTH_PASS);

		// [ Local Port Forwarder ]
		Group lpfGroup = createGroup(
				inner,
				Messages.getString("SSHTunnelingConfigDialog.LocalPortForwarder"), 2); //$NON-NLS-1$

		createLabel(lpfGroup,
				Messages.getString("SSHTunnelingConfigDialog.localPort")); //$NON-NLS-1$
		fLpf_port = new Spinner(lpfGroup, SWT.NONE);
		fLpf_port.setValues(15432, 0, 100000, 0, 1, 5);
		fLpf_port.setLayoutData(createTextGridData());

		createLabel(lpfGroup,
				Messages.getString("SSHTunnelingConfigDialog.portToConnect")); //$NON-NLS-1$
		fLpf_to_port = new Spinner(lpfGroup, SWT.NONE);
		fLpf_to_port.setValues(5432, 0, 100000, 0, 1, 5);
		fLpf_to_port.setLayoutData(createTextGridData());


		switch (this.mode) {
		case EDIT:
		case CLONE:
			fDefinitionName.setText(this.fSSHProperties.getDefinition_name());
			fAuth_host.setText(this.fSSHProperties.hostname);
			fAuth_port.setSelection(this.fSSHProperties.ssh_port);
			fAuth_user.setText(this.fSSHProperties.username);
			fAuth_pass.setText(this.fSSHProperties.password);
			fLpf_port.setSelection(this.fSSHProperties.local_port);
			fLpf_to_port.setSelection(this.fSSHProperties.port_to_connect);

			break;
		}
		if (this.mode == MODE.EDIT) {
			this.originalName = this.fSSHProperties.getDefinition_name();
		}

		return parent;
	}

	private Group createGroup(Composite parent, String title, int columns) {
		Group group = new Group(parent, SWT.NONE);
		group.setText(title);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.grabExcessHorizontalSpace = true;
		gd.grabExcessVerticalSpace = true;
		group.setLayoutData(gd);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = columns;
		group.setLayout(gridLayout);
		return group;
	}

	@Override
	protected Control createButtonBar(Composite parent) {
		Control ret = super.createButtonBar(parent);
		validate();
		return ret;
	}

	private final int TEST_CONNECT_BUTTON_ID = 10560824;
	private Button testConnectButton;
	private final int SHOW_HELP_BUTTON_ID = 20560826;
	private Button showHelpButton;

	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		testConnectButton = createButton(parent, TEST_CONNECT_BUTTON_ID,
				Messages.getString("DBConfigDialog.CheckConnection"), false); //$NON-NLS-1$
		testConnectButton.setEnabled(false);
		showHelpButton = createButton(
				parent,
				SHOW_HELP_BUTTON_ID,
				Messages.getString("SSHTunnelingConfigDialog.ShowParametersHint"), false); //$NON-NLS-1$
		super.createButtonsForButtonBar(parent);
	}

	@Override
	protected void buttonPressed(int buttonId) {
		fLogger.debug(" buttonId:" + buttonId);
		super.buttonPressed(buttonId);
		if (TEST_CONNECT_BUTTON_ID == buttonId) {
			SSHProperties p = null;
			try {
				setOnProperties(p);
				fLogger.debug("Clone after properties::" + p);
				MessageDialog.openInformation(getShell(), "Result", //$NON-NLS-1$
						SQLServerThread.test(p));
			} catch (Exception e) {
				fLogger.debug(StringUtil.EMPTY_STRING, e);
			}

		} else if (SHOW_HELP_BUTTON_ID == buttonId) {
			FileUtil util = new FileUtil(this.getClass(), "tunneling.pdf"); //$NON-NLS-1$
			try {
				File temp = File.createTempFile("yon", ".pdf"); //$NON-NLS-1$ //$NON-NLS-2$
				temp.deleteOnExit();
				FileOutputStream out = new FileOutputStream(temp);
				BufferedInputStream input = util.getStream();
				byte[] buff = new byte[256];
				int len = 0;
				while ((len = input.read(buff, 0, 256)) > 0) {
					out.write(buff, 0, len);
				}
				out.close();
				input.close();
				if (!Program.launch(temp.getAbsolutePath())) {
					fLogger.error("pdf support nothing.");
				}
			} catch (Exception e1) {
				fLogger.debug(StringUtil.EMPTY_STRING, e1);
			}
		}
	}

	protected void okPressed() {
		this.setOnProperties(fSSHProperties);

		close();
	}

	private void setOnProperties(SSHProperties p) {
		p.definition_name = fDefinitionName.getText();
		p.hostname = fAuth_host.getText();
		p.ssh_port = fAuth_port.getSelection();
		p.username = fAuth_user.getText();
		p.password = fAuth_pass.getText();

		p.local_port = fLpf_port.getSelection();
		p.port_to_connect = fLpf_to_port.getSelection();

	}

	public SSHProperties getSSHProperties() {
		return fSSHProperties;
	}

	@Override
	public void keyPressed(KeyEvent arg0) {
		// TODO Auto-generated method stub

	}

	@Override
	public void keyReleased(KeyEvent arg0) {
		validate();
	}

	@Override
	public void widgetDefaultSelected(SelectionEvent arg0) {
		// TODO Auto-generated method stub

	}

	@Override
	public void widgetSelected(SelectionEvent arg0) {

	}
}