package sql.mirroring;

import hiro.yoshioka.sql.engine.MirroringRequest;
import hiro.yoshioka.sql.engine.Request;
import hiro.yoshioka.sql.engine.RequestAdaptor;
import hiro.yoshioka.sql.engine.SQLOperationType;
import hiro.yoshioka.sql.engine.SQLServerThread;
import hiro.yoshioka.sql.params.ConnectionProperties;

public class MirroringFromDominoToSQLiteTest extends AbsMirroringTest {

	@Override
	void setUpMirroringConnection() {
		for (ConnectionProperties p : bean.getConnectionList()) {
			if (p.getDatabaseType().isDomino()) {
				this.mirroring_from_con_properties = p;
			} else if (p.getDatabaseType().isSQLite()) {
				this.mirroring_to_con_properties = p;
			}
		}
	}

	public void testMirroringHoge() {
		MirroringRequest request = new MirroringRequest(
				this.mirroring_from_con_properties,
				this.mirroring_to_con_properties);
		request.dropTable = true;
		request.cascade = true;
		request.makeBlob = true;
		request.maxRowNum = 1002;
		request.mapToDefaultSchema("hoge");
		request.putMirroringTable("hoge", "ReportDoc", true);
		request.mapToDefaultSchema("エイリアス有");
		request.putMirroringTable("エイリアス有", "NewsDoc", true);

		request.addListener(new RequestAdaptor() {
			@Override
			public void beginTask(String taskName, int row) {
				System.out.println(String.format("  BEGINE %s [%d]", taskName,
						row));
			}

			@Override
			public void subTask(String subTaskName) {
				System.out.println(String.format("  SUB_TASK %s", subTaskName));
			}

			@Override
			public void called_done(Request request,
					SQLOperationType operation,
					ConnectionProperties properteis, Object o) {
				System.out.println(String.format("  DONE %s [%s]", operation,
						properteis.getDisplayString()));
			}
		});
		boolean result = SQLServerThread.runNowThisRequest(request);
		if (request.getRdh() != null) {
			System.out.println(request.getRdh());
		}
		assertTrue("Mirroring Success", result);
	}

}
