package sql.notes;

import hiro.yoshioka.classmanager.ClassManager;
import hiro.yoshioka.sql.notes.reflect.WolfItem;
import hiro.yoshioka.util.FileUtil;

import java.io.File;
import java.util.UUID;
import java.util.Vector;

import lotus.domino.Database;
import lotus.domino.Document;
import lotus.domino.DocumentCollection;
import lotus.domino.DxlExporter;
import lotus.domino.Item;
import lotus.domino.NoteCollection;
import lotus.domino.NotesException;
import lotus.domino.NotesFactory;
import lotus.domino.RichTextItem;
import lotus.domino.Session;

public class NCSOTester {

	static String host = "localhost"; // server address
	static String cName = "yuko admin/org"; // username
	static String dbname = "hoge2.nsf"; // database (e.g. mail\\hnagashi.nsf)
	static String password = "password"; // internet password

	public static void main(String args[]) {
		try {
			System.out.println("run..");
			Session s = NotesFactory.createSession(host, cName, password);
			System.out.println("session=" + s);
			Database db = s.getDatabase("", dbname);
			if (!db.isOpen()) {
				db.open();
			}
			String title = db.getTitle();
			String uname = s.getUserName();

			System.out.println("UserName " + uname);
			System.out.println("ServerName " + db.getServer());
			System.out.println("Title " + title);

			DocumentCollection dc = db.getAllDocuments();
			Document doc = dc.getFirstDocument();
			ClassManager classManager = new ClassManager(new File(
					"C:/kyoyu/NCSO.jar"));

			StringBuilder buf = new StringBuilder();

			while (doc != null) {
				FileUtil.writeFile(new File("C:/tmp/xm_" + UUID.randomUUID()
						+ ".xml"), doc.generateXML(), "sjis");
				DxlExporter ecp = s.createDxlExporter();
				ecp.setOutputDOCTYPE(false);
				ecp.setConvertNotesBitmapsToGIF(true);

				NoteCollection nc = db.createNoteCollection(false);
				nc.add(doc);
				nc.selectAllDesignElements(true);
				nc.selectAllNotes(true);
				String dxl2 = ecp.exportDxl(nc);

				FileUtil.writeFile(new File("C:/tmp/xm_" + UUID.randomUUID()
						+ "_4.xml"), dxl2, "sjis");

				for (Item item : (Vector<Item>) doc.getItems()) {
					// item.recycle();
					if (item instanceof RichTextItem) {
						WolfItem wi = new WolfItem(classManager, item);
						String str = wi.getRichText2HtmlString();
						System.out.println(wi.getName() + "//" + str
								+ "<br><br>");
						buf.append(str + "<br>");
						// RichTextItem ri = (RichTextItem) item;
						// RichTextNavigator navi = ri.createNavigator();
						// if
						// (navi.findFirstElement(RichTextItem.RTELEM_TYPE_TEXTPARAGRAPH))
						// {
						// RichTextRange range = ri.createRange();
						// range.setBegin(navi);
						// System.out.println(range.getTextParagraph());
						// while (navi
						// .findNextElement(RichTextItem.RTELEM_TYPE_TEXTPARAGRAPH))
						// {
						// // range = ri.createRange();
						// range.setBegin(navi);
						//
						// System.out.println(range.getTextParagraph());
						// }
						// }
						// if (navi.findLastElement()) {
						//
						// }
						System.out
								.println("===============================================");
						buf.append("<hr>");
					}
				}
				doc.recycle();
				doc = dc.getNextDocument();
			}
			FileUtil.writeFile(new File("C:/tmp/h.html"), buf.toString(),
					"sjis");
			dc.recycle();
		} catch (NotesException ne) {
			System.out.println(ne.id + ne.text);
			ne.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}
