<?php
/* ==================================================
 *   Redirect to external sites
   ================================================== */

if (defined('ABSPATH')) {
	require_once ABSPATH . 'wp-config.php';
} else {
	require_once dirname(dirname(dirname(dirname(__FILE__)))) . '/wp-config.php';
}

if (! isset($Ktai_Style) || ! $Ktai_Style->is_ktai()) {
	wp_redirect(get_bloginfo('url'));
} else {
	$Redir = new Ktai_Style_Redir;
}
exit();

/* ==================================================
 *   Ktai_Style_Redir class
   ================================================== */

class Ktai_Style_Redir {
	private $url = NULL;

// ==================================================
public function __construct() {
	if (isset($_GET['url']) && ! empty($_GET['url'])) {
		$this->url = clean_url($_GET['url']);
		$mobile_url = $this->discover_mobile($this->url);
		if ($mobile_url) {
			wp_redirect($mobile_url);
			exit;
		}
		$this->output();
	} else {
		wp_redirect(get_bloginfo('url'));
	}
}

/* ==================================================
 * @param	none
 * @return	string   $mobile_url
 * based on discover_pingback_server_uri() at comment.php of WP 2.5.1
 */
private function discover_mobile($url) {
	global $wp_version;

	$byte_count = 0;
	$offset = 0;
	$timeout_bytes = 8192;
	$contents = '';
	$headers = '';
	extract(parse_url($url), EXTR_SKIP);
	if ( !isset($host) ) // Not an URL. This should never happen.
		return false;

	$path  = ( !isset($path) ) ? '/'          : $path;
	$path .= ( isset($query) ) ? '?' . $query : '';
	$port  = ( isset($port)  ) ? $port        : 80;

	// Try to connect to the server at $host
	$fp = @fsockopen($host, $port, $errno, $errstr, 2);
	if ( !$fp ) // Couldn't open a connection to $host
		return false;

	// Send the GET request
	$request = "GET $path HTTP/1.1\r\nHost: $host\r\nUser-Agent: WordPress/$wp_version \r\n\r\n";
	// ob_end_flush();
	fputs($fp, $request);

	// Check the content type
	while ( !feof($fp) ) {
		$line = fgets($fp, 512);
		if ( trim($line) == '' )
			break;
		$headers .= trim($line)."\n";
		if ( strpos(strtolower($headers), 'content-type: ') ) {
			preg_match('#content-type: (.+)#is', $headers, $matches);
			$content_type = trim($matches[1]);
		}
	}

	if ( preg_match('#(image|audio|video|model)/#is', $content_type) ) // Not an (x)html, sgml, or xml page, no use going further
		return false;

	while ( !feof($fp) ) {
		$line = fgets($fp, 1024);
		$contents .= trim($line);
		if (preg_match('!<link ([^>]*)/?>!', $contents, $attr, PREG_OFFSET_CAPTURE, $offset)) {
			if (preg_match('/rel=([\'"])alternate\\1/i', $attr[1][0]) && preg_match('/media=([\'"])handheld\\1/i', $attr[1][0]) && preg_match('/href=([\'"])(.*?)\\1/', $attr[1][0], $href)) {
				if (! preg_match('!^(https?:/)?/!', $href[2])) { // relarive URL
					$href[2] = $url . $href[2];
				}
				$mobile_url = sanitize_url($href[2]);
				if ($mobile_url) {
					return $mobile_url;
				}
			}
			$offset = $attr[0][1] + strlen($attr[0][0]);
		}
		$byte_count += strlen($line);
		if ( $byte_count > $timeout_bytes ) {
			// It's no use going further, there probably isn't any pingback
			// server to find in this file. (Prevents loading large files.)
			return false;
		}
	}

	// We didn't find anything.
	return false;
}

// ==================================================
private function output() {
	global $Ktai_Style;
	$charset = $Ktai_Style->ktai->get('charset');
	$title = __('Confirm connecting to external sites', 'ktai_style');
	$full_url = $this->url;
	if (preg_match('|^/|', $this->url)) {
		$full_url = preg_replace('|^(https?://[^/]*)/.*$|', '$1', get_bloginfo('url')) . $this->url;
	}
	$html = '<p>' . __('You are about to visit a website for PC:', 'ktai_style') . "<br />\n"
	      . '<a href="' . attribute_escape($this->url) . '">' . attribute_escape($full_url) . "</a>";
	if ($Ktai_Style->is_ktai() == 'KDDI' && $Ktai_Style->get('type') == 'WAP2.0') {
		$html .= '<br />'. sprintf(__('(<a %s>View the site by PC Site Viewer.</a>)', 'ktai_style'), ' href="device:pcsiteviewer?url=' . attribute_escape($full_url) . '"');
	} elseif ($Ktai_Style->is_ktai() == 'DoCoMo' && $Ktai_Style->get('type') == 'FOMA') {
		$html .= '<br />'. sprintf(__('(<a %s>View the site by Full Browser.</a>)', 'ktai_style'), 'href="' . attribute_escape($this->url) . '" ifb="' . attribute_escape($full_url) . '"');
	}
	$html .= "</p>\n<p>" . __('If you are sure, follow above link. If not, go to the previous page with browser\'s back button.', 'ktai_style') . '</p>';
	$html .='<form action=""><div>' . __('To copy the URL, use below text field:', 'ktai_style') . '<br /><input type="text" name="url" size="80" maxlength="255" value="' . attribute_escape($full_url) . '" /></div></form>';
	nocache_headers();
	$Ktai_Style->ks_die(apply_filters('redir/ktai_style.php', $html, $full_url), $title, FALSE);
}

// ===== End of class ====================
}
?>