/*
 * Decompiled with CFR 0.152.
 */
package lll.Loc;

import lll.Loc.EqSys;
import lll.Loc.Mat;
import lll.Loc.Vec;

public abstract class Vfunc {
    protected int domX;
    protected int domP;
    private thisEqSys self;
    private gradEqSys grad;
    private paramEqSys gradParam;

    public Vfunc(int domX, int domP) {
        this.domX = domX;
        this.domP = domP;
        this.self = new thisEqSys(this);
        this.grad = new gradEqSys(this);
        this.gradParam = new paramEqSys(this);
    }

    public abstract double valueAt(Vec var1, Vec var2);

    public abstract Vec gradAt(Vec var1, Vec var2);

    public abstract Vec gradParamAt(Vec var1, Vec var2);

    public double valueAt(Vec x) {
        return this.valueAt(x, null);
    }

    public Vec gradAt(Vec x) {
        return this.gradAt(x, null);
    }

    public Mat jacobAt(Vec x, Vec p) {
        return this.dDiffAt(x, x.mul(0.01), p);
    }

    public Mat jacobParamAt(Vec x, Vec p) {
        return this.dDiffParamAt(x, p.mul(0.01), p);
    }

    public int domDim() {
        return this.domX;
    }

    public int paramDim() {
        return this.domP;
    }

    public Vec diffAt(Vec x, Vec d, Vec p) {
        if (x.length() != d.length()) {
            return Vec.NaN.copy();
        }
        Vec ret = new Vec(this.domX);
        Vec xx = x.copy();
        double[] retRef = ret.arrayRef();
        double[] xxRef = xx.arrayRef();
        double[] dRef = d.arrayRef();
        double b = this.valueAt(x, p);
        int i = 0;
        while (i < this.domX) {
            double bk = xxRef[i];
            int n = i;
            xxRef[n] = xxRef[n] + dRef[i];
            retRef[i] = (this.valueAt(xx, p) - b) / dRef[i];
            xxRef[i] = bk;
            ++i;
        }
        return ret;
    }

    public Mat dDiffAt(Vec x, Vec d, Vec p) {
        if (x.length() != d.length()) {
            return Mat.NaN.copy();
        }
        Mat ret = new Mat(this.domX, this.domX);
        Vec xx = x.copy();
        double[][] retRef = ret.arrayRef();
        double[] xxRef = xx.arrayRef();
        double[] dRef = d.arrayRef();
        Vec b = this.gradAt(x, p);
        int i = 0;
        while (i < this.domX) {
            double bk = xxRef[i];
            int n = i;
            xxRef[n] = xxRef[n] + dRef[i];
            retRef[i] = this.gradAt(xx, p).sub(b).div(new Vec(dRef[i], this.domX)).arrayRef();
            xxRef[i] = bk;
            ++i;
        }
        return ret;
    }

    public Vec diffParamAt(Vec x, Vec d, Vec p) {
        if (p.length() != d.length()) {
            return Vec.NaN.copy();
        }
        Vec ret = new Vec(this.domP);
        Vec pp = p.copy();
        double[] retRef = ret.arrayRef();
        double[] ppRef = pp.arrayRef();
        double[] dRef = d.arrayRef();
        double b = this.valueAt(x, p);
        int i = 0;
        while (i < this.domP) {
            double bk = ppRef[i];
            int n = i;
            ppRef[n] = ppRef[n] + dRef[i];
            retRef[i] = (this.valueAt(x, pp) - b) / dRef[i];
            ppRef[i] = bk;
            ++i;
        }
        return ret;
    }

    public Mat dDiffParamAt(Vec x, Vec d, Vec p) {
        if (p.length() != d.length()) {
            return Mat.NaN.copy();
        }
        Mat ret = new Mat(this.domP, this.domP);
        Vec pp = p.copy();
        double[][] retRef = ret.arrayRef();
        double[] ppRef = pp.arrayRef();
        double[] dRef = d.arrayRef();
        Vec b = this.gradParamAt(x, p);
        int i = 0;
        while (i < this.domP) {
            double bk = ppRef[i];
            int n = i;
            ppRef[n] = ppRef[n] + dRef[i];
            retRef[i] = this.gradParamAt(x, pp).sub(b).div(new Vec(dRef[i], this.domP)).arrayRef();
            ppRef[i] = bk;
            ++i;
        }
        return ret;
    }

    public Vec solveByNewton(Vec x0, Vec p) {
        this.self.setParam(p);
        return this.self.solveByNewton(x0);
    }

    public Vec solveBySimplex(Vec x0, Vec p, int limit) {
        this.self.setParam(p);
        return this.self.solveBySimplex(x0, limit);
    }

    public Vec findeExtremeByNewton(Vec x0, Vec p) {
        this.grad.setParam(p);
        return this.grad.solveByNewton(x0);
    }

    public Vec findeExtremeBySimplex(Vec x0, Vec p, int limit) {
        this.grad.setParam(p);
        return this.grad.solveBySimplex(x0, limit);
    }

    public Vec findeExtremeBySimplex(Vec x0, Vec p, int limit, int tryal) {
        this.grad.setParam(p);
        return this.grad.solveBySimplex(x0, limit, tryal);
    }

    public double ssrAt(Vec p, Vec obs, Mat samples) {
        double ret = 0.0;
        int i = 0;
        while (i < obs.length()) {
            ret += this.valueAt(samples.rowVec(i), p) - obs.elem(i);
            ++i;
        }
        return ret;
    }

    public Vec ssrGradAt(Vec p, Vec obs, Mat samples) {
        Vec ret = new Vec(this.domP);
        int j = 0;
        while (j < obs.length()) {
            Vec xj = samples.rowVec(j);
            double dj = this.valueAt(xj, p) - obs.elem(j);
            ret = ret.add(this.gradParamAt(xj, p).mul(2.0 * dj));
            ++j;
        }
        return ret;
    }

    public Mat ssrJacobAt(Vec p, Vec obs, Mat samples) {
        Mat ret = new Mat(this.domP, this.domP);
        int j = 0;
        while (j < obs.length()) {
            Vec xj = samples.rowVec(j);
            double dj = this.valueAt(xj, p);
            Vec gradj = this.gradParamAt(xj, p);
            Mat jacobj = this.jacobParamAt(xj, p);
            ret = ret.add(gradj.tensor(gradj).mul(2.0).add(jacobj.mul(2.0 * dj)));
            ++j;
        }
        return ret;
    }

    public Vec bestPrmByNewton(Vec p, Vec obs, Mat samples) {
        this.gradParam.setObs(obs, samples);
        return this.gradParam.solveByNewton(p);
    }

    public Vec bestPrmBySimplex(Vec p, Vec obs, Mat samples, int limit) {
        this.gradParam.setObs(obs, samples);
        return this.gradParam.solveBySimplex(p, limit);
    }

    public Vec bestPrmBySimplex(Vec p, Vec obs, Mat samples, int limit, int trial) {
        this.gradParam.setObs(obs, samples);
        return this.gradParam.solveBySimplex(p, limit, trial);
    }

    private class thisEqSys
    extends EqSys {
        public Vfunc parent;
        public Vec param;

        private void setParam(Vec p) {
            this.param = p;
        }

        public thisEqSys(Vfunc parent) {
            super(parent.domX, parent.domX);
            this.parent = parent;
        }

        public Vec valueAt(Vec x) {
            return new Vec(new double[]{this.parent.valueAt(x, this.param)});
        }

        public Mat jacobAt(Vec x) {
            return new Mat(new double[][]{this.parent.gradAt(x, this.param).toArray()});
        }
    }

    private class gradEqSys
    extends EqSys {
        public Vfunc parent;
        public Vec param;

        private void setParam(Vec p) {
            this.param = p;
        }

        public gradEqSys(Vfunc parent) {
            super(parent.domX, parent.domX);
            this.parent = parent;
        }

        public Vec valueAt(Vec x) {
            return this.parent.gradAt(x, this.param);
        }

        public Mat jacobAt(Vec x) {
            return this.parent.jacobAt(x, this.param);
        }
    }

    private class paramEqSys
    extends EqSys {
        public Vfunc parent;
        public Vec obs;
        public Mat samples;

        public paramEqSys(Vfunc parent) {
            super(parent.domP, parent.domP);
            this.parent = parent;
        }

        private void setObs(Vec obs, Mat samples) {
            this.obs = obs;
            this.samples = samples;
        }

        public Vec valueAt(Vec p) {
            return this.parent.ssrGradAt(p, this.obs, this.samples);
        }

        public Mat jacobAt(Vec p) {
            return this.parent.ssrJacobAt(p, this.obs, this.samples);
        }
    }
}

