<?php
/**
 * Smarty plugin
 * @package xdbase
 * @version $Id$
 */

function smarty_modifier_xdbase_formattimestamp($time, $format='l')
{
	if ($time && is_numeric($time))
	{
		if ($format == 'jl')
		{
			$date = formatTimestamp($time, 'Y'._MD_XDBASE_LANG_YEAR.'n'._MD_XDBASE_LANG_MONTH.'j'._MD_XDBASE_LANG_DAY).' '.getWeek(formatTimestamp($time,'w'), 2);
		}
		elseif ($format == 'jm')
		{
			$date = formatTimestamp($time, 'n'._MD_XDBASE_LANG_MONTH.'j'._MD_XDBASE_LANG_DAY).' '.getWeek(formatTimestamp($time,'w'), 2);
		}
		elseif ($format == 'jd')
		{
			$date = formatTimestamp($time, 'j'._MD_XDBASE_LANG_DAY).' '.getWeek(formatTimestamp($time,'w'), 2);
		}
		else
		{
			$date = formatTimestamp($time, $format);
		}
		return $date;
	}
	return;
}

function getWeek($week_no, $opt)
{
	$week_array = array(_MD_XDBASE_LANG_SUN, _MD_XDBASE_LANG_MON, _MD_XDBASE_LANG_TUE, _MD_XDBASE_LANG_WED, _MD_XDBASE_LANG_THU, _MD_XDBASE_LANG_FRI, _MD_XDBASE_LANG_SAT);
	$week_day = $week_array[$week_no];

	switch ($opt)
	{
		case 1:
			return $week_day._MD_XDBASE_LANG_WEEK;
		case 2:
			return '('.$week_day.')';
		case 3:
			return $week_day;
		break;
	}
}

?>
