<?php
/**
 * @file
 * @package xdbase
 * @version $Id: CatEditAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_Admin_CatEditAction extends Xdbase_AbstractEditAction
{
	/**
	 * @protected
	 */
	function _getId()
	{
		return xdbaseGetRequest('cid');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'cat');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_cat');
		$this->mActionForm->prepare();
	}


	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);

		// categories options
		$catHandler =& $this->_getHandler();
		$catHandler->setTree($catHandler->getCriteria());
		$catObjectArray =& $catHandler->getObjects();
		$this->mTpl->assign('handler', $this->mObjectHandler);
//		$this->mTpl->assign('handler', $catHandler);
		$this->mTpl->assign('catObjectArray', $catObjectArray);

		// group options
		$groupHandler =& xoops_gethandler('group');
		$groups =& $groupHandler->getObjects(null, true);
		$groupOptions = array();
		foreach ($groups as $gid => $group)
		{
			$groupOptions[$gid] = $group->getVar('name');
		}
		$this->mTpl->assign('groupOptions', $groupOptions);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/cat_edit.html');
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mController->executeForward('./index.php?action=CatList');
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=CatList', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=CatList');
	}

	function _doExecute()
	{
		if ($this->mObjectHandler->insert($this->mObject))
		{
			// image file upload
			$this->saveImageFile();
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
		return XDBASE_FRAME_VIEW_ERROR;
	}

	function saveImageFile()
	{
		if ($this->mActionForm->mFormImage != null)
		{
			if ($err = $this->mActionForm->mFormImage->saveResizedImage(_MD_XDBASE_CONST_CATIMG_PATH, _MD_XDBASE_CONST_MAXCATIMGSIZE))
			{
				$this->mController->executeRedirect('./index.php?action=CatList', 3, _MD_XDBASE_ERROR_DBUPDATE_FAILED.$err);
			}
		}
	}

}

?>
