<?php
/**
 * @file
 * @package xdbase
 * @version $Id: DataViewAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractViewAction.class.php';

class Xdbase_Admin_DataViewAction extends Xdbase_AbstractViewAction
{
	/**
	 * @public
	 */
	function _getId()
	{
		return xdbaseGetRequest('did');
	}

	/**
	 * @public
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data');
		return $handler;
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		// visit link
		$visit = xdbaseGetRequest('visit');
		if ($visit != null)
		{
			$this->executeViewVisit($visit);
		}

		$this->mTpl->assign('object', $this->mObject);
		$this->mTpl->assign('handler', $this->mObjectHandler);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/data_view.html');
	}

	// for visit link site
	function executeViewVisit($visit)
	{
		$did = intval(xdbaseGetRequest('did'));
		if ($did == null)
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$did , 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
		}

		$handler =& $this->mController->load('handler', 'data');
		$dataObject =& $handler->get($did);
		if (!xoops_refcheck())
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$did , 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
		}

		if ($url = $dataObject->getShow($visit))
		{
			if (preg_match('/^http/', $url)) // link
			{
				$url = htmlspecialchars(preg_replace('/javascript:/si', 'java script:', $url), ENT_QUOTES);
				header('Location: '.$url);
				echo '<html><head><meta http-equiv="Refresh" content="0; URL='.$url.'"></meta></head><body></body></html>';
				exit();
			}
			else
			{
				$this->mController->executeRedirect('./index.php?action=DataView&did='.$did , 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
			}
		}
		else
		{
			$this->mController->executeRedirect('./index.php?action=DataView&did='.$did , 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
		}
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mController->executeRedirect('./index.php?action=DataList', 1, _MD_XDBASE_ERROR_CONTENT_IS_NOT_FOUND);
	}

}

?>
