<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_configEditAction.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_Admin_Data_configEditAction extends Xdbase_AbstractEditAction
{
	/**
	 * @protected
	 */
	function _getId()
	{
		return xdbaseGetRequest('col');
	}

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler =& $this->mController->load('handler', 'data_config');
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		// $this->mActionForm =& new Xdbase_Admin_Data_configEditForm();
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_data_config');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('object', $this->mObject);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/data_config_edit.html');
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		if (xdbaseGetRequest('add_option') != null)
		{
			$this->mController->executeForward('./index.php?action=Data_configEdit&col='.$this->_getId());
		}
		$this->mController->executeForward('./index.php?action=Data_configList');
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
//		$this->mController->executeRedirect('./index.php?action=Data_configList', 1, _MD_XDBASE_ERROR_DBUPDATE_FAILED);
		$this->mController->executeForward('./index.php?action=Data_configList');
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php?action=Data_configList');
	}
}

?>
