<?php
/**
 * @file
 * @package xdbase
 * @version $Id: ExportAction.class.php,v 1.3 2010/02/23 02:38:27 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/ConvertDataAction.class.php';

class Xdbase_Admin_ExportAction extends Xdbase_Admin_ConvertDataAction
{

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_Export');
		$this->mActionForm->prepare();
	}

	/**
	 * @protected
	 * added by hiro
	 */
	function _setupTemplateName()
	{
		$this->templateName = 'export.html';
	}

	function _setupTableName()
	{
		$this->catTableFrom = _MD_XDBASE_CONST_MODULEDIRNAME.'_cat';
		$this->dataTableFrom = _MD_XDBASE_CONST_MODULEDIRNAME.'_data';
		$this->catTableTo = xdbaseGetRequest('cat_table');
		$this->dataTableTo = xdbaseGetRequest('data_table');
	}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function _doExecute()
	{
		switch ($this->datatype)
		{
			case 1: // MySQL
				$ret = $this->executeMySqlExport();
				break;
			case 2: // CSV
				$ret = $this->executeCsvExport();
				break;
			case 3: // VCard
				$ret = $this->executeVCardExport();
				break;
			case 4: // ContactXML
				$ret = $this->executeContactXMLExport();
				break;
			default:
				$ret = false;
				break;
		}

		if ($ret)
		{
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
		return XDBASE_FRAME_VIEW_ERROR;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$retMessage = 'Export Failed<br />'.$this->getMessage();
		$this->mTpl->assign('retMessage', $retMessage);
		$this->mTpl->assign('progress', 5);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/import.html');
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function executeMySqlExport()
	{
		$updateCat = intval(xdbaseGetRequest('update_cat'));
		$updateData = intval(xdbaseGetRequest('update_data'));

		if ($this->catTableTo != '')
		{
			if ($updateCat)
			{
				list($ret, $messageArray) = $this->mySqlHandler->updateDataFromTable($this->catTableFrom, $this->catTableTo, 'cat', 'cid');
				$this->setMessage($messageArray);
				if ($ret == false) return false;
			}
			else
			{

				list($ret, $messageArray) = $this->mySqlHandler->importDataFromTable($this->catTableFrom, $this->catTableTo, 'cat');
				$this->setMessage($messageArray);
				if ($ret == false) return false;
			}
		}

		if ($this->dataTableTo != '')
		{
			if ($updateData)
			{
				list($ret, $messageArray) = $this->mySqlHandler->updateDataFromTable($this->dataTableFrom, $this->dataTableTo, 'data', 'did');
				$this->setMessage($messageArray);
				if ($ret == false) return false;
			}
			else
			{
				list($ret, $messageArray) = $this->mySqlHandler->importDataFromTable($this->dataTableFrom, $this->dataTableTo, 'data');
				$this->setMessage($messageArray);
				if ($ret == false) return false;
			}
		}
		return true;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function executeContactXMLExport()
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/ContactXMLHandler.php';
		$contactXMLHandler =& new ContactXMLHandler();

		list($rowArray, $messageArray) = $this->mySqlHandler->getExportDataArrayFromTable($this->dataTableFrom);
		$this->setMessage($messageArray);
		$rowCount = count($rowArray);
		if ($rowCount == 0) return false;

		$ret = $contactXMLHandler->createContactXMLFile($rowArray);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function executeVCardExport()
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/VcardHandler.php';
		$vcardHandler =& new VcardHandler();

		list($rowArray, $messageArray) = $this->mySqlHandler->getExportDataArrayFromTable($this->dataTableFrom);
		$this->setMessage($messageArray);
		$rowCount = count($rowArray);
		if ($rowCount == 0) return false;

		$ret = $vcardHandler->createVcardFile($rowArray);
/*
		if ($ret == false) return false;
		return true;
		$str = $rowCount.' records were exported from '.$this->dataTableFrom;
		$this->setMessage($str);
*/
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function executeCsvExport()
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/class/CsvHandler.php';
		$csvHandler =& new CsvHandler();

//		list($rowArray, $messageArray) = $this->mySqlHandler->getExportCSVDataArrayFromTable($this->dataTableFrom);
		list($string, $messageArray) = $this->mySqlHandler->getExportCSVDataFromTable($this->dataTableFrom);

		$this->setMessage($messageArray);
//		$rowCount = count($rowArray);
//		if ($rowCount == 0) return false;

//		$ret = $csvHandler->createCsvFile($rowArray);
		$ret = $csvHandler->createCsvFile($string);
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

?>
