<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeFilterForm.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractFilterForm.class.php';

define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_AID', 1);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_DID', 2);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_TYPE', 3);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_UID', 4);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_EMAIL', 5);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_STATUS', 6);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_POSTER_IP', 7);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_TIMESTAMP', 8);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT01', 9);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT02', 10);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT03', 11);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT04', 12);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT05', 13);
define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_OPTION_VALUE', 14);

define('XDBASE_DATA_ATTRIBUTE_SORT_KEY_DEFAULT', XDBASE_DATA_ATTRIBUTE_SORT_KEY_AID);

class Xdbase_Admin_Data_attributeFilterForm extends Xdbase_AbstractFilterForm
{
	var $mSortKeys = array(
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_AID => 'aid',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_DID => 'did',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_TYPE => 'type',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_UID => 'uid',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_EMAIL => 'email',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_STATUS => 'status',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_POSTER_IP => 'poster_ip',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_TIMESTAMP => 'timestamp',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT01 => 'int01',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT02 => 'int02',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT03 => 'int03',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT04 => 'int04',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_INT05 => 'int05',
		XDBASE_DATA_ATTRIBUTE_SORT_KEY_OPTION_VALUE => 'option_value'
	);

	var $mDispKeys = array(
		'aid' => 1,
		'did' => 1,
		'type' => 1,
		'uid' => 1,
		'email' => 1,
		'status' => 1,
		'poster_ip' => 1,
		'timestamp' => 1,
		'int01' => 1,
		'int02' => 1,
		'int03' => 1,
		'int04' => 1,
		'int05' => 1,
		'option_value' => 1
	);

	/**
	 * @public
	 */
	function getDefaultSortKey()
	{
		return XDBASE_DATA_ATTRIBUTE_SORT_KEY_DEFAULT;
	}

	/**
	 * @public
	 */
	function fetch()
	{
		parent::fetch();

		if (($value = xdbaseGetRequest('aid')) !== null) {
			$this->mNavi->addExtra('aid', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('aid', $value));
		}

		if (($value = xdbaseGetRequest('did')) !== null) {
			$this->mNavi->addExtra('did', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('did', $value));
		}

		if (($value = xdbaseGetRequest('type')) !== null) {
			$this->mNavi->addExtra('type', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('type', $value));
		}

		if (($value = xdbaseGetRequest('uid')) !== null) {
			$this->mNavi->addExtra('uid', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('uid', $value));
		}
	
		if (($value = xdbaseGetRequest('email')) !== null) {
			$this->mNavi->addExtra('email', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('email', $value));
		}
	
		if (($value = xdbaseGetRequest('status')) !== null) {
			$this->mNavi->addExtra('status', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('status', $value));
		}
	
		if (($value = xdbaseGetRequest('poster_ip')) !== null) {
			$this->mNavi->addExtra('poster_ip', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('poster_ip', $value));
		}
	
		if (($value = xdbaseGetRequest('int01')) !== null) {
			$this->mNavi->addExtra('int01', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('int01', $value));
		}
	
		if (($value = xdbaseGetRequest('int02')) !== null) {
			$this->mNavi->addExtra('int02', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('int02', $value));
		}
	
		if (($value = xdbaseGetRequest('int03')) !== null) {
			$this->mNavi->addExtra('int03', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('int03', $value));
		}
	
		if (($value = xdbaseGetRequest('int04')) !== null) {
			$this->mNavi->addExtra('int04', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('int04', $value));
		}
	
		if (($value = xdbaseGetRequest('int05')) !== null) {
			$this->mNavi->addExtra('int05', $value);
			$this->_mCriteria->add(new Xdbase_Criteria('int05', $value));
		}

		$this->_mCriteria->addSort($this->getSort(), $this->getOrder());

		$this->setDispKey();
	}


	function setDispKey()
	{
		$type = intval(xdbaseGetRequest('type'));

		switch ($type)
		{
			case 1: // reservation
				$this->mDispKeys = array(
					'aid' => 1,
					'did' => 1,
					'type' => 1,
					'uid' => 1,
					'email' => 1,
					'status' => 1,
					'poster_ip' => 1,
					'timestamp' => 1,
					'int01' => 0,
					'int02' => 0,
					'int03' => 0,
					'int04' => 0,
					'int05' => 0,
					'option_value' => 1
					);
				break;

			case 2: // vote
				$this->mDispKeys = array(
					'aid' => 1,
					'did' => 1,
					'type' => 0,
					'uid' => 1,
					'email' => 1,
					'status' => 1,
					'poster_ip' => 1,
					'timestamp' => 1,
					'int01' => 1,
					'int02' => 0,
					'int03' => 0,
					'int04' => 0,
					'int05' => 0,
					'option_value' => 0
					);
				break;

			default:
				break;
		}
	}

	function getDispKey($key)
	{
		return $this->mDispKeys[$key];
	}

}

?>
