<?php
/**
 * @file
 * @package xdbase
 * @version $Id: xdbase_calendar_block.php,v 1.2 2010/02/23 02:38:27 bluemelon Exp $
 */

if (!defined('_XDBASE_CALENDAR_BLOCK_LOADED'))
{

define('_XDBASE_CALENDAR_BLOCK_LOADED', 1);

include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/include/function.php';
include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/language/'.$GLOBALS['xoopsConfig']['language'].'/blocks.php';
include_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/language/'.$GLOBALS['xoopsConfig']['language'].'/main.php';


function b_xdbase_calendar_block_show($options)
{
	$mydirname = $options[0];
	$config_handler =& xoops_gethandler('config');
	$moduleConfig =& xdbaseGetConfigsByDirname($mydirname);
	$data_handler =& xdbaseGetModuleHandler('data', $mydirname);
	$cat_handler =& xdbaseGetModuleHandler('cat', $mydirname);
	$cat_handler->setTree($cat_handler->getCriteria());

	$cid = $options[1];
	$include_subcat = $options[2];
	$date_col = $options[3];

	$criteria =& $data_handler->getCriteria();

	if ($cid != '' && $cid != 0)
	{
		$catCriteria = new Xdbase_CriteriaCompo();
		$catCriteria->add(new Xdbase_Criteria('cid', $cid));
		if ($include_subcat)
		{
			$cid_array =& $cat_handler->getAllChildId($cid);
			if (count($cid_array) > 0)
			{
				foreach ($cid_array as $chcid)
				{
					$catCriteria->add(new Xdbase_Criteria('cid', $chcid), 'OR');
				}
			}
		}
		$criteria->add($catCriteria);
	}

	$block = array();
	$calendar = array();

	$year = intval(xdbaseGetRequest('calendar_year'));
	$month = intval(xdbaseGetRequest('calendar_month'));
	if ($year == 0) $year = date('Y');
	if ($month == 0) $month = date('n');

	$selectedUnixTime = mktime(0, 0, 0, $month, 1, $year);
	$startWeek = date('w',$selectedUnixTime);
	$daysCount = date('t',$selectedUnixTime);
	$endofMonthUnixTime = mktime(0, 0, 0, $month + 1, 1, $year) - 86400;
	$endWeek = date('w',$endofMonthUnixTime);
	$limit = $startWeek + $daysCount + (7 - $endWeek);

	$number = 0;
	$week = 0;
	for ($i = 1; $i < $limit; $i++)
	{
		$number = $i - $startWeek;
		if ($i <= $startWeek)
		{
			$calendar[$i]['day'] = false;
			$calendar[$i]['week'] = -1;
			$calendar[$i]['utime'] = false;
			$calendar[$i]['link'] = '';
		}
		elseif ($number > $daysCount)
		{
			$calendar[$i]['day'] = false;
			$calendar[$i]['week'] = -1;
			$calendar[$i]['utime'] = false;
			$calendar[$i]['link'] = '';
		}
		else
		{
			$timeStart = mktime(0, 0, 0, $month, $number, $year);
			$timeEnd = $timeStart + 86400;
			$calendar[$i]['day'] = $number;
			$calendar[$i]['utime'] = $timeStart;
			if ($number == date('j') && $month == date('n') && $year == date('Y'))
			{
				$calendar[$i]['week'] = 7;
			}
			else
			{
				$calendar[$i]['week'] = $week;
			}

			$dateCriteria = new Xdbase_CriteriaCompo();
			$dateCriteria->add(new Xdbase_Criteria($date_col, $timeStart, '>='));
			$dateCriteria->add(new Xdbase_Criteria($date_col, $timeEnd, '<'));
			$criteria->add($dateCriteria);

			$dataCount =& $data_handler->getCount($criteria);
			$link = '';
			if ($dataCount > 0)
			{
				$link = XOOPS_URL.'/modules/'.$mydirname.'/index.php?action=DataList&amp;key1='.$date_col.'&amp;operator1=4&amp;value1='.$timeStart.'&amp;condition=0&amp;key2='.$date_col.'&amp;operator2=3&amp;value2='.$timeEnd;
			}
			$calendar[$i]['link'] = $link;
		}

		if ($i % 7 == 0)
		{
			$week = 0;
		}
		else
		{
			$week++;
		}

		if (($daysCount <= $number) && ($i % 7 == 0))
		{
			break;
		}
	}

	$dateArray = getdate();
	$block['calendar'] = $calendar;
	$block['year'] = xdbaseGetYearStr($year);
	$block['month'] = xdbaseGetMonthStr($month);
	$block['mydirname'] = $mydirname;

	$styleText = '
		<style type="text/css">
		.xdbaseMiniCalendar {
			text-align: center;
		}
		.xdbaseCalendarHead {
			line-height: 2em;
		}
		.xdbaseCalendarSunDay {
			color: #FF0000;
		}
		.xdbaseCalendarSaturDay {
			color: #0000FF;
		}
		.xdbaseCalendarToDay {
			border: 1px solid;
		}
		.xdbaseCalendarDay {
		}
		</style>';

	global $xoopsTpl;
	$xoopsTpl->assign('xoops_module_header', $xoopsTpl->get_template_vars('xoops_module_header')."\n".$styleText);

	return $block;
}


function b_xdbase_calendar_block_edit($options)
{
	$form = '';
	$form .= '<input type="hidden" name="options[0]" value="'.$options[0].'" />';
	$form .= _MB_XDBASE_CATEGORY.'&nbsp;:&nbsp;'.xdbaseBlockRenderCatSelect(1, $options).'&nbsp;';
	$form .= _MB_XDBASE_INCLUDESUBCAT.'&nbsp;'.xdbaseBlockRenderYesNoRadioButton(2, $options).'<br />';
	$form .= _MB_XDBASE_DATE_FIELD.'&nbsp;:&nbsp;'.xdbaseBlockRenderColSelect(3, $options).'<br />';

	return $form;
}


}

?>
