<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Xdbase_Object.class.php,v 1.3 2010/02/23 02:38:27 bluemelon Exp $
 */

if (!defined('XOOPS_ROOT_PATH')) exit();

if (!defined('XOBJ_DTYPE_STRING')) define('XOBJ_DTYPE_STRING', 1);
if (!defined('XOBJ_DTYPE_TEXT')) define('XOBJ_DTYPE_TEXT', 2);
if (!defined('XOBJ_DTYPE_FLOAT')) define('XOBJ_DTYPE_FLOAT', 12);
if (!defined('XOBJ_DTYPE_BOOL')) define('XOBJ_DTYPE_BOOL', 13);


class Xdbase_Object extends XoopsObject
{
	var $mVars = array();
	var $mIsNew = true;
	
	var $_mAllowType = array(XOBJ_DTYPE_BOOL, XOBJ_DTYPE_INT, XOBJ_DTYPE_FLOAT, XOBJ_DTYPE_STRING, XOBJ_DTYPE_TEXT);
	
	function Xdbase_Object()
	{
	}
	
	function setNew()
	{
		$this->mIsNew = true;
	}
	
	function unsetNew()
	{
		$this->mIsNew = false;
	}

	function isNew()
	{
		return $this->mIsNew;
	}
	
	function initVar($key, $dataType, $value = null, $required = false, $size = null)
	{
		if (!in_array($dataType, $this->_mAllowType)) {
			die();	// TODO
		}
		
		$this->mVars[$key] = array(
			'data_type' => $dataType,
			'value' => null,
			'required' => $required ? true : false,
			'maxlength' => $size ? intval($size) : null
		);
		
		$this->assignVar($key, $value);
	}
	
	function assignVar($key, $value)
	{
		if (!isset($this->mVars[$key])) {
			return;
		}
		
		switch ($this->mVars[$key]['data_type']) {
			case XOBJ_DTYPE_BOOL:
				$this->mVars[$key]['value'] = $value ? 1 : 0;
				break;

			case XOBJ_DTYPE_INT:
				$this->mVars[$key]['value'] = $value !== null ? intval($value) : null;
				break;

			case XOBJ_DTYPE_FLOAT:
				$this->mVars[$key]['value'] = $value !== null ? floatval($value) : null;
				break;

			case XOBJ_DTYPE_STRING:
				if ($this->mVars[$key]['maxlength'] !== null && strlen($value) > $this->mVars[$key]['maxlength']) {
					$this->mVars[$key]['value'] = xoops_substr($value, 0, $this->mVars[$key]['maxlength'], null);
				}
				else {
					$this->mVars[$key]['value'] = $value;
				}
				break;

			case XOBJ_DTYPE_TEXT:
				$this->mVars[$key]['value'] = $value;
				break;
		}
	}
	
	function assignVars($values)
	{
		foreach ($values as $key => $value) {
			$this->assignVar($key, $value);
		}
	}
	
	function set($key, $value)
	{
		$this->assignVar($key, $value);
	}
	
	function get($key)
	{
		return $this->mVars[$key]['value'];
	}
	
	function gets()
	{
		$ret = array();
		
		foreach ($this->mVars as $key => $value) {
			$ret[$key] = $value['value'];
		}
		
		return $ret;
	}
	
	function setVar($key, $value)
	{
		$this->assignVar($key, $value);
	}

	function setVars($values)
	{
		$this->assignVars($values);
	}

	/**
	 * @deprecated
	 */	
	function getVar($key)
	{
		return $this->getShow($key);
	}
	
	/**
	 * Return HTML string for displaying only by HTML.
	 * The second parametor doesn't exist.
	 */
	function getShow($key)
	{
		$value = null;
		$myts =& MyTextSanitizer::getInstance();

		switch ($this->mVars[$key]['data_type']) {
			case XOBJ_DTYPE_BOOL:
			case XOBJ_DTYPE_INT:
			case XOBJ_DTYPE_FLOAT:
				$value = $this->mVars[$key]['value'];
				break;

			case XOBJ_DTYPE_STRING:
				$value = $myts->htmlSpecialChars($this->mVars[$key]['value']);
				break;

			case XOBJ_DTYPE_TEXT:
				$value = $myts->displayTarea($this->mVars[$key]['value'], 0, 1, 1, 1, 1);
				break;
		}
		
		return $value;
	}
	
	function getTypeInformations()
	{
		$ret = array();
		foreach (array_keys($this->mVars) as $key) {
			$ret[$key] = $this->mVars[$key]['data_type'];
		}
		
		return $ret;
	}
}

?>
