<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Cat.class.php,v 1.5 2010/02/23 02:38:27 bluemelon Exp $
 */

require_once dirname(dirname(__FILE__)).'/Xdbase_Object.class.php';
require_once dirname(dirname(__FILE__)).'/Xdbase_ObjectHandler.class.php';

class Xdbase_CatObject extends Xdbase_Object
{
	/**
	 * @public
	 */
	function Xdbase_CatObject()
	{
		$this->initVar('cid', XOBJ_DTYPE_INT, '', false);
		$this->initVar('pid', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('title', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('description', XOBJ_DTYPE_TEXT, '', false);
		$this->initVar('img', XOBJ_DTYPE_STRING, '', false, 64);
		$this->initVar('img_height', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('img_width', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('weight', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('status', XOBJ_DTYPE_BOOL, '1', false);
		$this->initVar('access', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('groups', XOBJ_DTYPE_STRING, '', false, 255);
		$this->initVar('created_date', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('updated_date', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('show_map', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('latitude', XOBJ_DTYPE_FLOAT, '0.00000000', false);
		$this->initVar('longitude', XOBJ_DTYPE_FLOAT, '0.00000000', false);
		$this->initVar('zoom', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('icon', XOBJ_DTYPE_STRING, '0', false, 100);
		$this->initVar('icon_width', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('icon_height', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int01', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int02', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int03', XOBJ_DTYPE_INT, '0', false);
	}

	function getAccessGroup()
	{
		$gidArray = explode(',', $this->get('groups'));
		$groupHandler =& xoops_gethandler('group');
		$groups =& $groupHandler->getObjects(null, true);
		if (is_array($gidArray))
		{
			$groupNameArray = array();
			$accessGroups = '';
			foreach ($gidArray as $gid)
			{
				$gid = intval($gid);
				$groupObject =& $groupHandler->get($gid);
				if (is_object($groupObject))
				{
					array_push($groupNameArray, $groupObject->getVar('name'));
				}
			}
			$accessGroups = implode(',', $groupNameArray);
		}
		return $accessGroups;
	}

}

class Xdbase_CatHandler extends Xdbase_ObjectHandler
{
	var $mTable = '{dirname}_cat';
	var $mPrimary = 'cid';
	var $mClass = 'Xdbase_CatObject';
	var $mDirName = null;
	var $_mTree = null;

	function Xdbase_CatHandler(&$db, $dirname)
	{
		$this->mDirName = $dirname;
		$this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
		Xdbase_ObjectHandler::Xdbase_ObjectHandler(&$db);
	}

	function &getCriteria()
	{
//		$configHandler =& xoops_gethandler('config');
//		$xoopsModule = $GLOBALS['xoopsModule'];
//		$moduleConfig =& $configHandler->getConfigsByCat(0,$xoopsModule->getVar('mid'));
		$moduleConfig =& xdbaseGetConfigsByDirname($this->mDirName);

		$criteria =& new Xdbase_CriteriaCompo();
		$criteria->add(new Xdbase_Criteria('status', 1));
		$criteria->setSort('weight', 'ASC');

		if ($moduleConfig['cat_perm'])
		{
			$accessCriteria =& new Xdbase_CriteriaCompo();
			// public
			$accessCriteriaA =& new Xdbase_CriteriaCompo();
			$accessCriteriaA->add(new Xdbase_Criteria('access', 0));
			// by group
			$accessCriteriaB =& new Xdbase_CriteriaCompo();
			$accessCriteriaB->add(new Xdbase_Criteria('access', 1));
			$groupCriteria =& new Xdbase_CriteriaCompo();

			$gidArray = xdbaseGetGroups();
			if (count($gidArray) > 0)
			{
				foreach ($gidArray as $gid)
				{
					$groupCriteria->add(new Xdbase_Criteria('groups', '%'.$gid.'%', 'LIKE'), 'OR');
				}
			}
			$accessCriteriaB->add($groupCriteria);
			$accessCriteria->add($accessCriteriaA, 'OR');
			$accessCriteria->add($accessCriteriaB, 'OR');
			$criteria->add($accessCriteria);
		}

		return $criteria;
	}

	function setTree(&$criteria = null)
	{
		if (is_object($criteria))
		{
			$this->_mTree = new Xdbase_Cat_Tree($this->mTable, 'cid', 'pid', 'title', $criteria);
		}
		else
		{
			$this->_mTree = new Xdbase_Cat_Tree($this->mTable, 'cid', 'pid', 'title');
		}
	}

	function getNicePathFromId($cid, $funcURL)
	{
		$ret = $this->_mTree->getNicePathFromId($cid, $funcURL);
		return $ret;
	}

	function getNicePathFromIdForDetail($cid, $funcURL)
	{
		$ret = $this->_mTree->getNicePathFromIdForDetail($cid, $funcURL);
		return $ret;
	}

	function getFirstChild($cid)
	{
		$ret = $this->_mTree->getFirstChild($cid);
		return $ret;
	}

	function getAllChildId($cid)
	{
		$ret = $this->_mTree->getAllChildId($cid);
		return $ret;
	}

	function getCatOptionArray()
	{
		$catOptionArray = $this->_mTree->getOptionArray();
		return $catOptionArray;
	}

	function getCatTitle($cid)
	{
//		static $ret;
//		if ($ret != '')
//		{
//			return $ret;
//		}
		$ret = '';
		$catObject =& $this->get(intval($cid));
		if (is_object($catObject))
		{
			$ret = $catObject->getShow('title');
		}
		return $ret;
	}

	function getShowMap($cid = 0)
	{
		$ret = '';
		$catObject =& $this->get(intval($cid));
		if (is_object($catObject))
		{
			$ret = $catObject->getShow('show_map');
		}
		return $ret;
	}

	function getDataCount($cid, $criteria = null)
	{

		$dataHandler =& xdbaseGetModuleHandler('data', $this->mDirName);

		$dataCount = 0;
		if (!is_object($dataHandler))
		{
			return $dataCount;
		}

		if (!is_object($criteria))
		{
			$criteria =& new Xdbase_CriteriaCompo();
		}

		$catCriteria =& new Xdbase_CriteriaCompo();
		$cidArray =& $this->_mTree->getAllChildId($cid);
		if (count($cidArray) > 0)
		{
			foreach ($cidArray as $chcid)
			{
				$catCriteria->add(new Xdbase_Criteria('cid', $chcid), 'OR');
				unset($chcid);
			}
		}
		$catCriteria->add(new Xdbase_Criteria('cid', $cid), 'OR');
		$criteria->add($catCriteria);

		$dataCount = $dataHandler->getCount($criteria);
		return $dataCount;
	}

	function getIconArray()
	{
		static $iconArray = array();

		if (count($iconArray) > 0)
		{
			return $iconArray;
		}

		$iconPath = XOOPS_ROOT_PATH.'/modules/'.$this->mDirName.'/images/icon/';
		if (is_dir($iconPath))
		{
			$iconImg = opendir($iconPath);
			$iconArray[''] = 'default.png';
			while (($file = readdir($iconImg)) !== false)
			{
				if (preg_match("/(\w+)\.png/", $file))
				{
					if ($file != 'default.png' && $file != 'shadow.png')
					{
						$iconArray[$file] = $file;
					}
				}
			}
			closedir($iconImg);
			if (!empty($iconArray))
			{
				asort($iconArray);
			}
		}
		return $iconArray;
	}

	function getMarkerIcon($cid)
	{
		$iconUrl = '';
		$catObject =& $this->get(intval($cid));
		if (is_object($catObject))
		{
			$iconName = $catObject->getShow('icon');
			$iconPath = XOOPS_ROOT_PATH.'/modules/'.$this->mDirName.'/images/icon/'.$iconName;
			if (is_file($iconPath))
			{
				$iconUrl = XOOPS_URL.'/modules/'.$this->mDirName.'/images/icon/'.$iconName;
			}
		}
		return $iconUrl;
	}

	function getShadowIcon()
	{
		$shadow_url = '';
		$shadowPath = XOOPS_ROOT_PATH.'/modules/'.$this->mDirName.'/images/icon/shadow.png';
		if (is_file($shadowPath))
		{
			$shadow_url = XOOPS_URL.'/modules/'.$this->mDirName.'/images/icon/shadow.png';
		}
		return $shadow_url;
	}

}



class Xdbase_Cat_Tree
{
	var $_db;
	var $_table;
	var $_idName;
	var $_pidName;
	var $_titleName;
	var $_criteria = null;
	var $_criteriaStr = '';

	function Xdbase_Cat_Tree($tableName, $idName, $pidName, $titleName, $criteria = null)
	{
		$this->_db =& Database::getInstance();
		$this->_table = $tableName;
		$this->_idName = $idName;
		$this->_pidName = $pidName;
		$this->_titleName = $titleName;
		if (is_object($criteria))
		{
			$this->_criteriaStr = ' AND '.$criteria->render();
			foreach ($criteria->getSorts() as $sort)
			{
				$sorts[] = '`'.$sort['sort'].'` '.$sort['order'];
			}
			if ($criteria->getSort() != '')
			{
				$this->_criteriaStr .= ' ORDER BY '.implode(',', $sorts);
			}
		}
	}

	function getAllChildId($keyId, $idArray = array())
	{
		$sql = 'SELECT '.$this->_idName.' FROM '.$this->_table.' WHERE '.$this->_pidName.'='.$keyId.$this->_criteriaStr;
		$result = $this->_db->query($sql);
		$count = $this->_db->getRowsNum($result);
		if ($count == 0)
		{
			return $idArray;
		}
		while (list($pid) = $this->_db->fetchRow($result))
		{
			array_push($idArray, $pid);
			$idArray = $this->getAllChildId($pid, $idArray);
		}
		return $idArray;
	}

	function getFirstChild($keyId)
	{
		$arr = array();
		$sql = 'SELECT * FROM '.$this->_table.' WHERE '.$this->_pidName.'='.intval($keyId).$this->_criteriaStr;
		$result = $this->_db->query($sql);
		$count = $this->_db->getRowsNum($result);
		if ($count == 0)
		{
			return $arr;
		}
		while ($myrow = $this->_db->fetchArray($result))
		{
			array_push($arr, $myrow);
		}
		return $arr;
	}

	function getNicePathFromId($keyId, $funcURL, $separate = '&nbsp;&raquo;&raquo;&nbsp;', $path = '')
	{
		$sql = 'SELECT '.$this->_pidName.', '.$this->_titleName.' FROM '.$this->_table.' WHERE '.$this->_idName.'='.intval($keyId).$this->_criteriaStr;
		$result = $this->_db->query($sql);
		if ($this->_db->getRowsNum($result) == 0)
		{
			return $path;
		}
		list($pid, $title) = $this->_db->fetchRow($result);
		$title = htmlspecialchars($title, ENT_QUOTES);
		if ($path == '')
		{
			$path = $title;
		}
		else
		{
			$path = '<a href="'. $funcURL.'&amp;'.$this->_idName.'='.$keyId.'">'.$title.'</a>'.$separate.$path;
		}
		if ($pid == 0)
		{
			return $path;
		}
		$path = $this->getNicePathFromId($pid, $funcURL, $separate, $path);
		return $path;
	}

	function getNicePathFromIdForDetail($keyId, $funcURL, $separate = '&nbsp;&raquo;&raquo;&nbsp;')
	{
		$sql = 'SELECT '.$this->_pidName.', '.$this->_titleName.' FROM '.$this->_table.' WHERE '.$this->_idName.'='.intval($keyId).$this->_criteriaStr;
		$result = $this->_db->query($sql);
		if ($this->_db->getRowsNum($result) == 0)
		{
			return $path;
		}
		list($pid, $title) = $this->_db->fetchRow($result);
		$title = htmlspecialchars($title, ENT_QUOTES);
		$path = '<a href="'. $funcURL.'&amp;'.$this->_idName.'='.$keyId.'">'.$title.'</a>'.$separate.$path;
		if ($pid == 0)
		{
			return $path;
		}
		$path = $this->getNicePathFromId($pid, $funcURL, $separate, $path);
		return $path;
	}

	function getOptionArray($keyId = 0, $optionArray = array(), $prefix = '')
	{
		if ($keyId == 0 && $prefix == '')
		{
			$optionArray[0][$this->_idName] = 0;
			$optionArray[0][$this->_titleName] = ' ---- ';
		}
		$sql = 'SELECT '.$this->_idName.', '.$this->_titleName.' FROM '.$this->_table.' WHERE '.$this->_pidName.'='.intval($keyId).$this->_criteriaStr;
		$result = $this->_db->query($sql);
		$count = $this->_db->getRowsNum($result);
		if ($count == 0)
		{
			return $optionArray;
		}
		while (list($id, $title) = $this->_db->fetchRow($result))
		{
			$rowArray = array();
			$rowArray[$this->_idName] = intval($id);
			$rowArray[$this->_titleName] = $prefix.htmlspecialchars($title, ENT_QUOTES);
			array_push($optionArray, $rowArray);
			$optionArray = $this->getOptionArray($id, $optionArray, $prefix.'-');
		}
		return $optionArray;
	}

}

?>
