<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attribute.class.php,v 1.3 2010/02/23 02:38:27 bluemelon Exp $
 */

require_once dirname(dirname(__FILE__)).'/Xdbase_Object.class.php';
require_once dirname(dirname(__FILE__)).'/Xdbase_ObjectHandler.class.php';


class Xdbase_Data_AttributeObject extends Xdbase_Object
{
	/**
	 * @public
	 */
	function Xdbase_Data_AttributeObject()
	{
		$this->initVar('aid', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('did', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('type', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('uid', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('email', XOBJ_DTYPE_STRING, '', false, 64);
		$this->initVar('status', XOBJ_DTYPE_BOOL, '0', false);
		$this->initVar('poster_ip', XOBJ_DTYPE_STRING, '', false, 15);
		$this->initVar('timestamp', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int01', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int02', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int03', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int04', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('int05', XOBJ_DTYPE_INT, '0', false);
		$this->initVar('option_value', XOBJ_DTYPE_TEXT, '', false);
	}

	function getOptionValue()
	{
		$data_handler =& xdbaseGetModuleHandler('data', _MD_XDBASE_CONST_MODULEDIRNAME);
		$dataObject =& $data_handler->get($this->get('did'));
		if (!is_object($dataObject)) return false;

		$dataOptionValueArray = unserialize($dataObject->get('option_value'));
		if (!is_array($dataOptionValueArray)) return false;

		$optionValueSource = unserialize($this->get('option_value'));
		if (!is_array($optionValueSource)) return false;

		$optionValueArray = array();

		$i = 0;
		foreach ($dataOptionValueArray as $dataOptionValue)
		{
			$optionLabel = htmlspecialchars($dataOptionValue['label'], ENT_QUOTES);
			$optionType = htmlspecialchars($dataOptionValue['type'], ENT_QUOTES);
			$optionValue = htmlspecialchars($optionValueSource[$i], ENT_QUOTES);
			$optionValueArray[$i]['label'] = $optionLabel;
			$optionValueArray[$i]['value'] = $optionValue;
			$i++;
		}
		return $optionValueArray;
	}

	function renderOptionForm()
	{
		$data_handler =& xdbaseGetModuleHandler('data', _MD_XDBASE_CONST_MODULEDIRNAME);
		$dataObject =& $data_handler->get($this->get('did'));
		if (!is_object($dataObject)) return false;

		$optionValueSource = unserialize($this->get('option_value'));
		if (!is_array($optionValueSource)) return false;

		$optionForm = $dataObject->renderOptionForm($optionValueSource);
		return $optionForm;
	}

}


class Xdbase_Data_AttributeHandler extends Xdbase_ObjectHandler
{
	var $mTable = '{dirname}_data_attribute';
	var $mPrimary = 'aid';
	var $mClass = 'Xdbase_Data_AttributeObject';
	var $mDirName = null;

	var $mObject = null;

	function Xdbase_Data_AttributeHandler(&$db, $dirname)
	{
		$this->mDirName = $dirname;
		$this->mTable = str_replace('{dirname}',$dirname,$this->mTable);
		Xdbase_ObjectHandler::Xdbase_ObjectHandler(&$db);
	}


	function getRequest($key)
	{
		$keyArray = array(
			'aid',
			'did',
			'type',
			'uid',
			'email',
			'status',
			'poster_ip',
			'timestamp',
			'int01',
			'int02',
			'int03',
			'int04',
			'int05',
			'option_value'
		);
		$ret = false;
		if (in_array($key, $keyArray))
		{
			$ret = intval(xdbaseGetRequest($key));
		}
		return $ret;
	}

	function getDataTitle($did=false)
	{
		if ($did === false)
		{
			$did = intval(xdbaseGetRequest('did'));
		}
		$data_handler =& xdbaseGetModuleHandler('data', _MD_XDBASE_CONST_MODULEDIRNAME);
		$dataObject =& $data_handler->get($did);
		if (!is_object($dataObject)) return false;
		return $dataObject->get('title');
	}

	function getTypeArray()
	{
		$typeArray = array(
			1=>_MD_XDBASE_LANG_TYPE_RESERVE,
			2=>_MD_XDBASE_LANG_TYPE_VOTE
		);
		return $typeArray;
	}

	function getDisplay($key)
	{
		$type = intval(xdbaseGetRequest('type'));

		switch ($type)
		{
			case 1: // reservation
				$displayKeys = array(
					'aid' => 0,
					'did' => 0,
					'type' => 0,
					'uid' => 1,
					'email' => 1,
					'status' => 1,
					'poster_ip' => 1,
					'timestamp' => 1,
					'int01' => 0,
					'int02' => 0,
					'int03' => 0,
					'int04' => 0,
					'int05' => 0,
					'option_value' => 1
					);
				break;

			case 2: // vote
				$displayKeys = array(
					'aid' => 1,
					'did' => 1,
					'type' => 0,
					'uid' => 1,
					'email' => 1,
					'status' => 1,
					'poster_ip' => 1,
					'timestamp' => 1,
					'int01' => 1,
					'int02' => 0,
					'int03' => 0,
					'int04' => 0,
					'int05' => 0,
					'option_value' => 0
					);
				break;

			default:
				$displayKeys = array(
					'aid' => 1,
					'did' => 1,
					'type' => 1,
					'uid' => 1,
					'email' => 1,
					'status' => 1,
					'poster_ip' => 1,
					'timestamp' => 1,
					'int01' => 1,
					'int02' => 1,
					'int03' => 1,
					'int04' => 1,
					'int05' => 1,
					'option_value' => 1
					);
				break;
		}
		return $displayKeys[$key];
	}

	function getReservationCount($did, $uid)
	{
		$did =intval($did);
		$uid =intval($uid);
		$criteria =& new Xdbase_CriteriaCompo();
		$criteria->add(new Xdbase_Criteria('did', $did));
		$criteria->add(new Xdbase_Criteria('type', 1));
//		$criteria->add(new Xdbase_Criteria('status', 1));
		if ($uid != 0)
		{
			$criteria->add(new Xdbase_Criteria('uid', $uid));
		}
		$count = $this->getCount($criteria);
		return $count;
	}

	function getVoteCount($did=0)
	{
		$did =intval($did);
		$poster_ip = $_SERVER['REMOTE_ADDR'];
		$criteria =& new Xdbase_CriteriaCompo();
		$criteria->add(new Xdbase_Criteria('did', $did));
		$criteria->add(new Xdbase_Criteria('type', 2));
		$ret = false;

		$uid  = xdbaseGetUid();
		if ($uid == 0)
		{
			$criteria->add(new Xdbase_Criteria('poster_ip', $poster_ip));
		}
		else
		{
			$criteria->add(new Xdbase_Criteria('uid', $uid));
		}
		$offset = xdbaseGetTimeOffset();
		$timestamp = time() - $offset;

		$count = $this->getCount($criteria);


		if ($count == 0)
		{
			$this->mObject =& $this->create();
			if (is_object($this->mObject))
			{
				$this->mObject->setVar('did', $did);
				$this->mObject->setVar('type', 2);
				$this->mObject->setVar('uid', $uid);
				$this->mObject->setVar('status', 1);
				$this->mObject->setVar('poster_ip', $poster_ip);
				$this->mObject->setVar('timestamp', $timestamp);
				$this->mObject->setVar('int01', 1);
			}
		}

		return $count;
	}

	function increaseVoteCount($did)
	{
		if ($this->getVoteCount($did) > 0) return false;
		if (!is_object($this->mObject)) return false;
		if ($ret = $this->insert($this->mObject, true))
		{
			return true;
		}
		else
		{
			return false;
		}
	}

}

?>
