<?php
/**
 * @file
 * @package xdbase
 * @version $Id$
 */

require_once dirname(dirname(__FILE__)).'/D3pipesBlockAbstract.class.php' ;

class D3pipesBlockXdbaselist extends D3pipesBlockAbstract
{
	var $target_dirname = '' ;
	var $trustdirname = 'xdbase' ;

	function init()
	{
		// parse and check option for this class
		$params = array_map( 'trim' , explode( '|' , $this->option ) ) ;
		if (empty($params[0]))
		{
			$this->errors[] = _MD_D3PIPES_ERR_INVALIDDIRNAMEINBLOCK."\n($this->pipe_id)";
			return false ;
		}
		$this->target_dirname = preg_replace( '/[^0-9a-zA-Z_-]/' , '' , $params[0] ) ;

		// configurations (file, name, block_options)
		$this->func_file = XOOPS_ROOT_PATH.'/modules/'.$this->target_dirname.'/blocks/xdbase_datalist_block.php' ;
		$this->func_name = 'b_xdbase_datalist_block_show' ;
		$this->block_options = array(
			0 => $this->target_dirname,
			1 => 'title,img01,body,updated_date',
			2 => 5,
			3 => 0,
			4 => 'updated_date',
			5 => 1,
			6 => '',
			7 => 1,
			8 => '',
			9 => 0,
			10 => '',
			11 => 0,
			12 => '',
			13 => 0,
			14 => '',
			15 => 50,
			16 => 400,
			17 => 140
		) ;

		return true ;
	}

//	function reassign(&$data)
	function reassign($data)
	{
		$entries = array() ;
		foreach ($data['data'] as $dataObject)
		{
			$entry = array(
				'pubtime' => $dataObject->getShow('updated_date'),
				'link' => XOOPS_URL.'/modules/'.$this->target_dirname.'/index.php?action=DataView&did='.$dataObject->getShow('did'),
				'headline' => $dataObject->getShow('title'),
				'description' => $dataObject->getShow('body'),
			) ;
			$entry['fingerprint'] = $entry['link'] ;
			$entries[] = $entry ;
		}

		return $entries ;
	}

}

?>