var map;
var lng;
var lat;
var zoom;
var type;
var height;
var point;
var marker;
var marker_list=[];


function initializeGmap(){

	if (!GBrowserIsCompatible()) return false;
	if (!document.getElementById("xdbaseMap")) return false;

	map = new GMap2(document.getElementById("xdbaseMap"));

	map.addControl(new GOverviewMapControl());
	map.addControl(new GLargeMapControl());
	map.addControl(new GScaleControl());
	map.addControl(new GMapTypeControl());
	map.enableDoubleClickZoom();
	map.enableContinuousZoom();
//	map.enableScrollWheelZoom();
	new GKeyboardHandler(map);

	return true;
}


function getMapTypes(type){
	var r;
	switch(type){
		case "G_NORMAL_MAP":
			r = G_NORMAL_MAP;
		case "G_SATELLITE_MAP":
			r = G_SATELLITE_MAP;
		case "G_HYBRID_MAP":
			r = G_HYBRID_MAP;
		default:
			r = G_NORMAL_MAP;
	}
	return r;
}


function drawMapListView(option, data) {

	if (!initializeGmap()) alert("GoogleMaps is not supported.");

	var lat = option['lat'];
	var lng = option['lng'];
	var zoom = option['zoom'];
	var type = getMapTypes(option['type']);
	var total = option['total'];
	var imgmaxwidth = 200;
	var state = option['state'];
	var city = option['city'];

	var point = new GLatLng(lat,lng);
	map.setCenter(point, zoom, type);

	if (state != '' || city != '') {
		searchMapList(state, city);
	}


	for (var i=1; i<=total; i++) {
		if (data[i]) {

			if (data[i]['lat'] != 0 && data[i]['lng'] != 0) {
				var dpoint = new GLatLng(data[i]['lat'], data[i]['lng']);
				var did = data[i]['did'];
				var info = '<div class="infow">';
				info += '<a href="' + data[i]['link'] + '">' + data[i]['title'] + '</a>';
				if (data[i]['body'] != '') {
					info += '<br />' + data[i]['body'];
				}
				if (data[i]['imgsrc'] != '') {
					image = new Image();
					image.src = data[i]['imgsrc'];
					var imghtml = '';
					if (image.width > imgmaxwidth){
						var image_h = Math.floor(imgmaxwidth / image.width * image.height);
						imghtml = '<br /><img src=' + image.src + ' width="' + imgmaxwidth + '" height="' + image_h + '\">';
					} else {
						imghtml = '<br /><img src=' + image.src + '>';
					}
					info += imghtml;
				}
				info += '</div>';

				var dicon = data[i]['icon'];
				var shadow = data[i]['shadow'];
				var dmarker;
				dmarker = createMarker(dpoint, info, dicon, shadow);
				marker_list[did] = dmarker;
				marker_list[did]['info'] = info;
				map.addOverlay(dmarker);
			}
		}
	}

}

function createMarker(dpoint, info, dicon, shadow) {
	var dmarker;
	var icon;
//	var icon_url = dicon['url'];
//	var icon_width = dicon['width'];
//	var icon_hieght = dicon['hieght'];


	if (dicon != '') {
    icon = new GIcon();
    icon.image = dicon;
//    icon.iconSize = new GSize(icon_width, icon_hieght);
    icon.iconSize = new GSize(20,34);
		if (shadow != '') {
	    icon.shadow = shadow;
	    icon.shadowSize = new GSize(34,37);
		}
    icon.iconAnchor = new GPoint(10,17); 
    icon.infoWindowAnchor = new GPoint(10,0); 
		dmarker = new GMarker(dpoint, icon);
	} else {
		dmarker = new GMarker(dpoint);
	}

	GEvent.addListener(dmarker, 'click', function(){
		dmarker.openInfoWindowHtml(info, {maxWidth:220});
		dmarker.setPoint(dpoint);
	});
	return dmarker;
}


function drawMapView() {

	if (!initializeGmap()) alert("GoogleMaps is not supported.");

	lat = document.getElementById("lat").innerHTML;
	lng = document.getElementById("lng").innerHTML;
	zoom = Math.floor(document.getElementById("zoom").innerHTML);
	type = getMapTypes("G_NORMAL_MAP");
//	type = getMapTypes(document.getElementById("maptype").innerHTML);

	point = new GLatLng(lat,lng);
	map.setCenter(point, zoom, type);
	marker = new GMarker(point);
	map.addOverlay(marker);
}

function drawMapEdit() {

	if (!initializeGmap()) alert("GoogleMaps is not supported.");

	lat = document.getElementById("legacy_xoopsform_latitude").value;
	lng = document.getElementById("legacy_xoopsform_longitude").value;
	zoom = Math.floor(document.getElementById("legacy_xoopsform_zoom").value);
//	type = getMapTypes(document.getElementById("maptype").value);
	type = getMapTypes("G_NORMAL_MAP");
	height = document.getElementById("xdbaseMap").style.height;

	point = new GLatLng(lat,lng);
	map.setCenter(point, zoom, type);
	marker = new GMarker(point);

	GEvent.addListener(map, "click", function(overlay, point) {
		if (point) {
			marker.setPoint(point);
			drawLatLngTxt(point);
		}
	});

	map.addOverlay(marker);

	GEvent.addListener(map, "zoomend", function(oldZoomLevel, newZoomLevel) {
		document.getElementById("legacy_xoopsform_zoom").value = newZoomLevel;
		document.getElementById("zoom").innerHTML = newZoomLevel;
	});

	GEvent.addListener(map, "dragend", function() {
		var center_point = map.getCenter();
		drawLatLngTxt(center_point);
	});

	showMap();
//	showMap(document.getElementById("show_map"));
}


function searchMapList(state, city){
	var search_address = state + city;
	var gcg = new GClientGeocoder();

	if (!GBrowserIsCompatible() || search_address=="") return;


	if (gcg) {
		gcg.getLatLng(search_address,function(point) {
			if (!point) {
				alert(search_address + ' notfound');
			} else {
				map.setCenter(point);
			}
		});
	}
}


function searchMap(state, city, address){
	var search_address = state + city + address;
	var gcg = new GClientGeocoder();

	if (!GBrowserIsCompatible() || search_address=="") return;

	if (gcg) {
		gcg.getLatLng(search_address,function(point) {
			if (!point) {
				alert(address + ' notfound');
			} else {
				map.setCenter(point);
				marker.setPoint(point);
				marker.openInfoWindowHtml(search_address);
				drawLatLngTxt(point);
			}
		});
	}
}

function drawLatLngTxt(point){
	document.getElementById("legacy_xoopsform_latitude").value = point.y;
	document.getElementById("lat").innerHTML = point.y;
	document.getElementById("legacy_xoopsform_longitude").value = point.x;
	document.getElementById("lng").innerHTML = point.x;
}

function showMap(){
	if (document.getElementById("legacy_xoopsform_show_map").checked){
		document.getElementById("maparea").style.visibility = "visible";
		document.getElementById("xdbaseMap").style.height = height;
//		document.getElementById("xdbaseMap").style.display = none;
		if (document.getElementById("search_map")) document.getElementById("search_map").style.visibility = "visible";
	}else{
		document.getElementById("maparea").style.visibility = "hidden";
		document.getElementById("xdbaseMap").style.height = "0px";
//		document.getElementById("xdbaseMap").style.display = block;
		if (document.getElementById("search_map")) document.getElementById("search_map").style.visibility = "hidden";
	}
}

function goTo(did){
	map.panTo(marker_list[did].getPoint());
	marker_list[did].openInfoWindowHtml(marker_list[did]['info'], {maxWidth:220});
}

function setIcon(icon){
	map.panTo(marker_list[did].getPoint());
	marker_list[did].openInfoWindowHtml(marker_list[did]['info'], {maxWidth:220});
}

