<?php
/**
 * @file
 * @package xdbase
 * @version $Id: CreateThumbnailAction.class.php,v 1.4 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_AbstractEditAction.class.php';

class Xdbase_Admin_CreateThumbnailAction extends Xdbase_AbstractEditAction
{
	var $message = array();
	var $start = 1;
	var $end = 0;
	var $limit = 10;
	var $force = 0;
	var $progress = 0;
	var $imageCount = 0;

	/**
	 * @protected
	 */
	function &_getHandler()
	{
		$handler = null;
		return $handler;
	}

	/**
	 * @protected
	 */
	function _setupObject()
	{
	}

	/**
	 * @protected
	 */
	function _setupActionForm()
	{
		$this->mActionForm =& $this->mController->create('form', 'admin.edit_CreateThumbnail');
		$this->mActionForm->prepare();
	}

	/**
	 * @public
	 */
	function getDefaultView()
	{
		return XDBASE_FRAME_VIEW_INPUT;
	}

	/**
	 * @public
	 */
	function executeViewInput()
	{
		$this->getImagePathArray();

		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('imageCount', $this->imageCount);
		$this->mTpl->assign('progress', $this->progress);
		$this->mTpl->assign('start', $this->start);
		$this->mTpl->assign('force', $this->force);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/create_thumbnail.html');
	}

	function execute()
	{
		$this->start = intval(xdbaseGetRequest('start'));
		$this->limit = intval(xdbaseGetRequest('limit'));
		$this->force = intval(xdbaseGetRequest('force'));
		$this->progress = intval(xdbaseGetRequest('progress'));

		if (xdbaseGetRequest('_form_control_cancel') != null)
		{
			return XDBASE_FRAME_VIEW_CANCEL;
		}

		$this->mActionForm->fetch();
		$this->mActionForm->validate();

		if ($this->mActionForm->hasError())
		{
			return XDBASE_FRAME_VIEW_INPUT;
		}
		else
		{
			return $this->_doExecute();
		}
	}

	function _doExecute()
	{
		if ($this->executeCreateThumbnail())
		{
			return XDBASE_FRAME_VIEW_SUCCESS;
		}
	
		return XDBASE_FRAME_VIEW_ERROR;
	}


	// get image
	function getImagePathArray()
	{
		static $imagePathArray = array();
		if (count($imagePathArray) > 0)
		{
			return $imagePathArray;
		}

		$photosPath = _MD_XDBASE_CONST_PHOTOS_PATH;

		if (is_dir($photosPath))
		{
			$photos = opendir($photosPath);
			$i = 1;
			while (($file = readdir($photos)) !== false)
			{
//				if (preg_match("/(\w+)/", $file))
//				if (preg_match("/^xdbase(\w+)/", $file))
				if (preg_match("/(\w+)\.jpg|jpeg|gif|png$/i", $file))
				{
					$imagePathArray[$i] = $file;
					$i++;
				}
			}
			closedir($photos);
		}
		else
		{
			$this->mActionForm->addErrorMessage(sprintf(_MD_XDBASE_ERR_NOTDIRECTORY, $photosPath));
		}

		$this->imageCount = count($imagePathArray);
		if ($this->imageCount == 0)
		{
			$this->mActionForm->addErrorMessage(_MD_XDBASE_PHOTONOTEXISTS);
		}
		return $imagePathArray;
	}


	function executeCreateThumbnail()
	{
		require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_Image.class.php';
		$imageHandler =& new Xdbase_Image();

		$imagePathArray = $this->getImagePathArray();

		if ($this->progress == 1)
		{
			$this->start += $this->limit;
		}
		$this->end = $this->start + $this->limit -1;

		if ($this->end >= $this->imageCount)
		{
			$this->end = $this->imageCount;
			$this->progress = 2;
		}
		else
		{
			$this->progress = 1;
		}

		for ($i = $this->start; $i <= $this->end; $i++)
		{
			$imageName = $imagePathArray[$i];
			$photosPath = _MD_XDBASE_CONST_PHOTOS_PATH.'/'.$imageName;
			$thumbsPath = _MD_XDBASE_CONST_THUMBS_PATH.'/'.$imageName;
			if (file_exists($thumbsPath))
			{
				if ($this->force)
				{
					if ($imageHandler->checkFile($thumbsPath) == false)
					{
						unlink($thumbsPath);
					}

					if ($imageHandler->saveResizedImage($photosPath, $thumbsPath, _MD_XDBASE_CONST_MAXTHUMBSIZE, true))
					{
						$this->mActionForm->addErrorMessage(sprintf(_MD_XDBASE_NOTCREATEDTHUMB, $i, $thumbsPath));
					}
					else
					{
						$this->setMessage(sprintf(_MD_XDBASE_RECREATEDTHUMB, $i, $thumbsPath));
					}
				}
				else
				{
					$this->setMessage(sprintf(_MD_XDBASE_SKIPCREATEDTHUMB, $i, $thumbsPath));
				}
			}
			else
			{
				if ($imageHandler->saveResizedImage($photosPath, $thumbsPath, _MD_XDBASE_CONST_MAXTHUMBSIZE))
				{
					$this->mActionForm->addErrorMessage(sprintf(_MD_XDBASE_NOTCREATEDTHUMB, $i, $thumbsPath));
				}
				else
				{
					$this->setMessage(sprintf(_MD_XDBASE_CREATEDTHUMB, $i, $thumbsPath));
				}
			}
		}
		return true;
	}

	function setMessage($message)
	{
		if ($message != '')
		{
			array_push($this->message, $message);
		}
	}

	function getMessage()
	{
		$retMessage = '';
		if (count($this->message) > 0)
		{
			$retMessage = implode('<br />', $this->message);
		}
		return $retMessage;
	}

	/**
	 * @public
	 */
	function executeViewSuccess()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('retMessage', $this->getMessage());
		$this->mTpl->assign('imageCount', $this->imageCount);
		$this->mTpl->assign('start', $this->start);
		$this->mTpl->assign('end', $this->end);
		$this->mTpl->assign('limit', $this->limit);
		$this->mTpl->assign('force', $this->force);
		$this->mTpl->assign('progress', $this->progress);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/create_thumbnail.html');
	}

	/**
	 * @public
	 */
	function executeViewError()
	{
		$this->mTpl->assign('actionForm', $this->mActionForm);
		$this->mTpl->assign('retMessage', $this->getMessage());
		$this->mTpl->assign('imageCount', $this->imageCount);
		$this->mTpl->assign('start', $this->start);
		$this->mTpl->assign('end', $this->end);
		$this->mTpl->assign('limit', $this->limit);
		$this->mTpl->assign('force', $this->force);
		$this->mTpl->assign('progress', $this->progress);

		$this->mTpl->display('file:'.XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/admin/templates/create_thumbnail.html');
	}

	/**
	 * @public
	 */
	function executeViewCancel()
	{
		$this->mController->executeForward('./index.php');
	}

}

?>
