<?php
/**
 * @file
 * @package xdbase
 * @version $Id: CsvHandler.php,v 1.3 2010/02/23 02:38:27 bluemelon Exp $
 */


class CsvHandler
{
	var $message = array();
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function CsvHandler()
	{
		$this->__construct();
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function __construct()
	{
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getRetArray($value)
	{
		$retArray = array($value, $this->message);
		return $retArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////
	function setMessage($str)
	{
		if (!is_null($str))
		{
			array_push($this->message, htmlspecialchars($str, ENT_QUOTES));
		}
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getColumnKeyArray()
	{
		$keyArray = array(
			'did',
			'cid',
			'title',
			'tag',
			'pid',
			'uid',
			'name',
			'poster_ip',
			'created_date',
			'updated_date',
			'published_date',
			'expired_date',
			's_date',
			'e_date',
			'password',
			'url',
			'email',
			'zip',
			'state',
			'city',
			'street',
			'phone',
			'mobile_phone',
			'fax',
			'show_map',
			'latitude',
			'longitude',
			'zoom',
			'img01',
			'img01_height',
			'img01_width',
			'img02',
			'img02_height',
			'img02_width',
			'file01',
			'file01name',
			'file01ext',
			'file01size',
			'body',
			'int01',
			'int02',
			'int03',
			'int04',
			'int05',
			'int06',
			'int07',
			'int08',
			'int09',
			'int10',
			'float01',
			'float02',
			'varchar01',
			'varchar02',
			'varchar03',
			'varchar04',
			'varchar05',
			'varchar06',
			'varchar07',
			'varchar08',
			'varchar09',
			'varchar10',
			'text01',
			'text02',
			'reservation',
			'option_value',
			'weight',
			'status',
			'access',
			'groups',
			'hits',
			'comments',
			'rating',
			'votes',
			'downloads',
			'trackbacks',
			'pipe_id',
			'dohtml',
			'doxcode',
			'dosmiley',
			'doimage',
			'dobr'
		);

		return $keyArray;
	}
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	function getCsvArray($filePath, $i = 0)
	{
		$csvArray = array();
		$columnArray = $this->getColumnKeyArray();

		$fp = fopen($filePath, 'r');

		while (($csvRowArray = fgetcsv($fp)) !== false)
		{
			if (memory_get_usage() < $memory_limit - 200000)
			{
				return $csvArray;
			}
			$csvArray[$i]= $csvRowArray;
			$i++;
		}

		fclose($fp);

		return $csvArray;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//	function createCsvFile($rowArray)
	function createCsvFile($string)
	{
		$fileName = _MD_XDBASE_CONST_MODULEDIRNAME.'_export_'.date('Ymd_Hi').'.csv';
		$filePath = XOOPS_ROOT_PATH.'/uploads/'.$fileName;

		$fp = fopen($filePath, 'w');
/*
		foreach ($rowArray as $row)
		{
			$ret = fputcsv($file, $row);
		}
*/
		$ret = fwrite($fp, $string);

		fclose($fp);

		if (!$ret)
		{
			$str = "File : ".$filePath." couldn't wright";
			$this->setMessage($str);
			return $this->getRetArray(false);
		}

		// Download
		if (file_exists($filePath))
		{
			if (headers_sent()) die('headers are already sent');
//			header('Content-Type:application/octet-stream; charset=Shift-JIS');
			header('Content-Type:application/x-csv');
			header('Content-Disposition: attachment; filename="'.$fileName.'"');
//			header('Content-Transfer-Encoding: binary'); 
//			header('Content-Description: File Transfer');
//			header('Expires: 0');
			header('Content-Length: ' . filesize($filePath));
			if (strstr($_SERVER['HTTP_USER_AGENT'], 'MSIE'))
			{
				header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
				header('Pragma: public');
			}
			else
			{
				header('Pragma: no-cache');
			}

			readfile($filePath);
			@unlink($filePath);
//			exit();
		}
		else
		{
			$str = "File : ".$filePath." not exist";
			$this->setMessage($str);
			return $this->getRetArray(false);
		}
		return;
	}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
}

?>
