<?php
/**
 * @file
 * @package xdbase
 * @version $Id: Data_attributeEditForm.class.php,v 1.3 2010/02/12 04:36:02 bluemelon Exp $
 */

require_once XOOPS_TRUST_PATH.'/modules/'.XDBASE_TRUST_DIRNAME.'/class/Xdbase_ActionForm.class.php';

class Xdbase_Data_attributeEditForm extends Xdbase_ActionForm
{
	var $mIsNew = false;

	/**
	 * @public
	 */
	function getTokenName()
	{
		return 'module.xdbase.Admin_Data_attributeEditForm.TOKEN';
	}

	/**
	 * @public
	 */
	function prepare()
	{
		//
		// Set form properties
		//
		$this->mFormProperties['aid'] =& new Xdbase_IntProperty('aid');
		$this->mFormProperties['did'] =& new Xdbase_IntProperty('did');
		$this->mFormProperties['type'] =& new Xdbase_IntProperty('type');
		$this->mFormProperties['uid'] =& new Xdbase_IntProperty('uid');
		$this->mFormProperties['email'] =& new Xdbase_StringProperty('email');
		$this->mFormProperties['status'] =& new Xdbase_BoolProperty('status');
		$this->mFormProperties['poster_ip'] =& new Xdbase_StringProperty('poster_ip');
		$this->mFormProperties['timestamp'] =& new Xdbase_IntProperty('timestamp');
		$this->mFormProperties['int01'] =& new Xdbase_IntProperty('int01');
		$this->mFormProperties['int02'] =& new Xdbase_IntProperty('int02');
		$this->mFormProperties['int03'] =& new Xdbase_IntProperty('int03');
		$this->mFormProperties['int04'] =& new Xdbase_IntProperty('int04');
		$this->mFormProperties['int05'] =& new Xdbase_IntProperty('int05');
		$this->mFormProperties['option_value'] =& new Xdbase_TextProperty('option_value');

//		$this->mFormProperties['opt'] =& new Xdbase_TextArrayProperty('opt');

		//
		// Set field properties
		//

//		$this->mFieldProperties['aid'] =& new Xdbase_FieldProperty($this);
//		$this->mFieldProperties['aid']->setDependsByArray(array('required'));
//		$this->mFieldProperties['aid']->addMessage('required', _MD_XDBASE_ERROR_REQUIRED, _MD_XDBASE_LANG_AID);

	}


	/**
	 * @public
	 */
	function load(&$obj)
	{
		$this->set('aid', $obj->get('aid'));
		$this->set('did', $obj->get('did'));
		$this->set('type', $obj->get('type'));
		$this->set('uid', $obj->get('uid'));
		$this->set('email', $obj->get('email'));
		$this->set('status', $obj->get('status'));
		$this->set('poster_ip', $obj->get('poster_ip'));
		$this->set('timestamp', $obj->get('timestamp'));
		$this->set('int01', $obj->get('int01'));
		$this->set('int02', $obj->get('int02'));
		$this->set('int03', $obj->get('int03'));
		$this->set('int04', $obj->get('int04'));
		$this->set('int05', $obj->get('int05'));
		$this->set('option_value', $obj->get('option_value'));
	}


	/**
	 * @public
	 */
	function update(&$obj)
	{
		foreach ($this->mFormProperties as $key => $formProperty)
		{
			if (is_null($this->get($key)))
			{
				$this->set($key, $obj->get($key));
			}
		}

		$obj->set('aid', $this->get('aid'));
		$obj->set('did', $this->get('did'));
		$obj->set('type', $this->get('type'));
		$obj->set('uid', $this->get('uid'));
		$obj->set('email', $this->get('email'));
		$obj->set('status', $this->get('status'));
		$obj->set('poster_ip', $_SERVER['REMOTE_ADDR']);
		$obj->set('timestamp', $this->get('timestamp'));
		$obj->set('int01', $this->get('int01'));
		$obj->set('int02', $this->get('int02'));
		$obj->set('int03', $this->get('int03'));
		$obj->set('int04', $this->get('int04'));
		$obj->set('int05', $this->get('int05'));
		$obj->set('option_value', $this->get('option_value'));

		$this->mIsNew = $obj->isNew();

		$offset = xdbaseGetTimeOffset();
		$obj->set('timestamp', time() - $offset);

		if ($this->mIsNew)
		{
			$xoopsUser = $GLOBALS['xoopsUser'];
			if (is_object($xoopsUser))
			{
				$uid = $xoopsUser->getVar('uid');
				$email = $xoopsUser->getVar('email');
			}
			else
			{
				$uid = 0;
				$email = '';
			}

			$obj->set('uid', $uid);
			$obj->set('email', $email);
		}

		$dataHandler =& $this->mController->load('handler', 'data');
		$optionCount = $dataHandler->getOptionCount($this->get('did'));
		$optValueArray = array();
		for ($i=0; $i<=$optionCount; $i++)
		{
			$optValue = xdbaseGetRequest('opt'.$i);
			if (is_array($optValue) && count($optValue) > 0)
			{
				$opt = implode(',', $optValue);
				$optionValueArray[$i] = $opt;
			}
			else
			{
				$optionValueArray[$i] = $optValue;
			}
		}
		$obj->set('option_value', serialize($optionValueArray));

/*
		$opt = $this->get('opt');
		$max = count($opt);
		if (is_array($opt) && $max > 0)
		{
			for ($i=0; $i<=$max; $i++)
			{
				$optValueArray = explode(',', $this->get('opt', $i));
				if (is_array($optValueArray) && count($optValueArray) > 0)
				{
					foreach ($optValueArray as $optValue)
					{
						
					}
				}
			}
			$obj->set('option_value', serialize($opt));
		}
*/

//exit(var_dump($obj));
	}

}

?>
