<?php
// $Id: link_list.php,v 1.4 2005/10/28 11:56:02 ohwada Exp $

// 2005-03-28 K.OHWADA
// bug fix: pagenavi dont work correctly

// 2005-01-20 K.OHWADA
// use get_google_url()

//================================================================
// view link list 
// created from v0.9
// 2004-12-14 K.OHWADA
//================================================================

include 'admin_header.php';

include_once $MODULE_ROOT."/class/pagenavi.php";

// class
$pagenavi = new pagenavi();
$pagenavi->set_max_sortid(3);
$pagenavi->set_show(50);	// 50 lines
$pagenavi->get_get_parm();
$sortid = $pagenavi->get_sortid();

$total_all    = $tbl_link->getNumAll();
$total_broken = $tbl_link->getNumBroken();
$total_nourl  = $tbl_link->getNumNoUrl();

$options_head = array();
switch ($sortid)
{
	case 1:
		$func  = 'getLidArrayAllDesc';
		$total = $total_all;
		$title = _WEBLINKS_ADMIN_LINK_ALL_DESC;
		break;

	case 2:
		$func  = 'getLidArrayBroken';
		$total = $total_broken;
		$title = _WEBLINKS_ADMIN_LINK_BROKEN;
		$options_head = array( _WEBLINKS_COUNT_BROKEN );
		break;

	case 3:
		$func  = 'getLidArrayNoUrl';
		$total = $total_nourl;
		$title = _WEBLINKS_ADMIN_LINK_NOURL;
		break;

	case 0:
	default:
		$func  = 'getLidArrayAll';
		$total = $total_all;
		$title = _WEBLINKS_ADMIN_LINK_ALL_ASC;
		break;

}

// exsample "http://www.google.com/search?hl=en&amp;q=";
$google_url = $lang->get_google_url();

print_top($title, $total_all, $total_broken, $total_nourl);

// --- link list ---
if ($total > 0)
{
	$limit  = $pagenavi->get_show();
	$offset = $pagenavi->get_start($total);

	if ($offset == -1)
	{
		echo "system error: total = $total <br>\n";
		include XOOPS_ROOT_PATH.'/footer.php';
		exit();
	}

	print_start($options_head);

	$lid_arr = $tbl_link->$func($limit, $offset);
	foreach ($lid_arr as $lid) 
	{
		$row = $tbl_link->getRowByLid($lid);

		$lid    = $row['lid'];
		$title  = $row['title'];
		$url    = $row['url'];
		$broken = $row['broken'];

		$options_line = array();

		switch ($sortid)
		{
			case 2:
				$options_line = array( $broken );
				break;

			case 0:
			case 1:
			case 3:
			default:
				break;
		}

		print_line($lid, $title, $url, $options_line);
	}

//if 2 or more items in result, show the sort menu

	$navi = '';
	if($total > 1)
	{
		$script = "link_list.php";

// bug fix: pagenavi dont work correctly
		$navi   = $pagenavi->build_navi($script, $total, -1, -1);

		if ($navi == -1)
		{
			echo "system error: script = $script, total = $total <br>\n";
			include XOOPS_ROOT_PATH.'/footer.php';
			exit();
		}

	}

	print_end($navi);

}
else
{
	echo "<br />";
	echo "<font color='blue'>"._WEBLINKS_NO_LINK."</font><br />";
}

xoops_cp_footer();
exit();
// --- end of main ---


//---------------------------------------------------------
// function
//---------------------------------------------------------
function print_top($title, $all, $broken, $nourl)
{
	global $tbl_link, $tbl_modify, $tbl_broken;
	global $google_url;

	$totalnewlinks = $tbl_modify->getNumNew();
	$totalnewlinks = highlight_number($totalnewlinks);

	$totalmodify = $tbl_modify->getNumMod();
	$totalmodify = highlight_number($totalmodify);

	$totalbrokenlinks = $tbl_broken->getNumAll();
	$totalbrokenlinks = highlight_number($totalbrokenlinks);

	$broken = highlight_number($broken);

	xoops_cp_header();

	echo "<h3>"._WLS_WEBLINKSCONF."</h3>\n";
	echo "<h4>"._WEBLINKS_ADMIN_LINK_MANAGE."</h4>\n";
	printf(_WLS_THEREARE, $all);
	echo "<br /><br />\n";

	echo "<table width='80%' border='0' cellspacing='1' class='outer'>";
	echo "<tr class='odd'><td>";
	echo " - <a href='index.php'>"._WEBLINKS_ADMIN_INDEX."</a>";
	echo "<br /><br />\n";
	echo " - <a href='link_manage.php?op=addLink'>"._WEBLINKS_ADMIN_ADD_LINK."</a>";
	echo "<br /><br />\n";
	echo " - <b>"._WEBLINKS_ADMIN_LINK_LIST."</b>";
	echo "<br /><br />\n";
	echo " --- <a href='link_list.php?sortid=0'>"._WEBLINKS_ADMIN_LINK_ALL_ASC."</a> ($all)";
	echo "<br /><br />\n";
	echo " --- <a href='link_list.php?sortid=1'>"._WEBLINKS_ADMIN_LINK_ALL_DESC."</a> ($all)";
	echo "<br /><br />\n";
	echo " --- <a href='link_list.php?sortid=2'>"._WEBLINKS_ADMIN_LINK_BROKEN."</a> ($broken)";
	echo "<br /><br />\n";
	echo " --- <a href='link_list.php?sortid=3'>"._WEBLINKS_ADMIN_LINK_NOURL."</a> ($nourl)";
	echo "<br /><br />\n";
		echo " - <a href='link_broken_check.php'>"._WEBLINKS_ADMIN_LINK_BROKEN_CHECK."</a>";
	echo "<br /><br />\n";
	echo " - <a href='link_manage.php?op=listNewLinks'>"._WLS_LINKSWAITING." ($totalnewlinks)</a>";
	echo "<br /><br />\n";
	echo " - <a href='link_manage.php?op=listModReq'>"._WLS_MODREQUESTS." ($totalmodify)</a>";
	echo "<br /><br />\n";
	echo " - <a href='index.php?op=listBrokenLinks'>"._WLS_BROKENREPORTS." ($totalbrokenlinks)</a>";
	echo "<br /><br />\n";
	echo"</td></tr></table>\n";

	echo "<h4>".$title."</h4>\n";

	echo _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_NOTICE;

	if ($google_url)
	{
		echo _WEBLINKS_ADMIN_LINK_BROKEN_CHECK_GOOGLE."<br />\n";
	}

	echo "<br />\n";
}

function print_start($options='')
{

	echo "<table border='1'><tr>";
	echo "<th align='center'>"._WLS_LINKID."</th>";
	echo "<th align='center'>"._WLS_SITETITLE."</th>";
	echo "<th align='center'>"._WLS_SITEURL."</th>";

	foreach ($options as $opt)
	{	echo "<th align='center'>$opt</th>";	}

	echo "</tr>\n";

}

function print_end($navi)
{
	echo "</table><br />\n";
	echo "<div align='center'>$navi</div>\n";
}


function print_line($lid, $title, $url, $options='')
{
	global $lang;
	global $google_url;

	$link_id = sprintf("%03d",$lid);

	$modlink = "link_manage.php?op=modLink&lid=".$lid;
	$title   = htmlspecialchars($title);

	echo "<tr>";
	echo "<td><a href='$modlink'>$link_id</a></td>";

	if ($google_url)
	{
		$query  = $lang->convert_to_utf8($title);
		$query  = urlencode($query);
		$google = $google_url.$query;
		echo "<td><a href='$google' target='_blank'>$title</a></td>";
	}
	else
	{
		echo "<td>$title</td>";
	}

	echo "<td><a href='$url' target='_blank'>$url</a></td>";

	foreach ($options as $opt)
	{	echo "<td>$opt</td>";	}

	echo "</tr>\n";

}

?>
