<?php
// $Id: rss_atom_builder.php,v 1.3 2005/10/28 11:56:02 ohwada Exp $

// 2004-12-26 K.OHWADA
// xoops_site_language -> xoops_site_lang_code

//=========================================================
// class for RSS/ATOM builder
// port from whatsnew module
// created since v0.9
// 2004-11-28 K.OHWADA
//=========================================================
class rss_atom_builder extends module_base
{
	var $FEED_GENERATOR;
	var $FEED_GENERATOR_URL;
	var $TITLE_NON;

	var $max_item;
	var $max_summary;

// time parameter
	var $unixtime_now;
	var $rfc822_now;
	var $iso8601_now;
	var $year;

// class instance
	var $xoops_tpl;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function rss_atom_builder()
{
	module_base::module_base();

	$this->CHANNEL_CATEGORY   = 'XOOPS WebLinks';
	$this->FEED_GENERATOR     = 'XOOPS WebLinks 0.9';
	$this->FEED_GENERATOR_URL = 'http://linux.ohwada.jp/';
	$this->TITLE_NON          = 'no title';
	$this->DESC_NON           = 'no description';

	$this->cache_time  = 3600;	// 1 hour
	$this->max_item    = 20;
	$this->max_summary = 200;

	$this->lang =& language_convert::getInstance();

	$this->get_system_param();
}

//=========================================================
// RSS builder
//=========================================================

//---------------------------------------------------------
// http://blogs.law.harvard.edu/tech/rss
// required paramter
// channel elements 
//   - title
//   - link
//   - description
// item elements
//   - title
//   - link
//   - description
//---------------------------------------------------------
function build_rss_channel($image_url='')
{
	$channel = array(
		'title'        => $this->xoops_site_name,
		'link'         => $this->xoops_site_url,
		'description'  => $this->site_desc,
		'lastbuild'    => $this->rfc822_now,
		'webmaster'    => $this->xoops_site_email,
		'editor'       => $this->xoops_site_email,
		'category'     => $this->CHANNEL_CATEGORY,
		'generator'    => $this->FEED_GENERATOR,
		'language'     => $this->xoops_site_lang_code,
	);

	if ($image_url) 
	{
		list($image_width, $image_height)
			= $this->get_image_size($image_url);

		$arr = array(
			'image_url'     => $image_url,
			'image_width'   => $image_width,
			'image_height'  => $image_height,
			'image_title'   => $this->site_title,
			'image_link'    => $this->xoops_site_url,
		);

		$channel = array_merge($channel, $arr);
	}

	return $channel;
}

function assign_rss(&$tpl, $channel, $items)
{
	$channel = $this->arrange_array($channel);
	$items   = $this->arrange_rss_items($items);

	$channel = $this->convert_array_to_utf8($channel);
	$items   = $this->convert_array_array_to_utf8($items);

	$tpl->assign('channel_title',     $channel['title'] );
	$tpl->assign('channel_link',      $channel['link'] );
	$tpl->assign('channel_desc',      $channel['description'] );
	$tpl->assign('channel_lastbuild', $channel['lastbuild'] );
	$tpl->assign('channel_webmaster', $channel['webmaster'] );
	$tpl->assign('channel_editor',    $channel['editor'] );
	$tpl->assign('channel_category',  $channel['category'] );
	$tpl->assign('channel_generator', $channel['generator'] );
	$tpl->assign('channel_language',  $channel['language'] );

	foreach ($items as $item)
	{
		$tpl->append('items', 
			array(
				'title'       => $item['title'],
				'link'        => $item['link'],
				'description' => $item['description'],
				'pubdate'     => $item['pubdate'], 
				'guid'        => $item['guid'],
		));
	
	}
}

function arrange_rss_items($items)
{
	$count = count($items);
	for ($i=0; $i<$count; $i++)
	{
		$item = $items[$i];

		$item['url']         = $this->substitute_value( $item['url'],   $this->xoops_site_url );
		$item['title']       = $this->substitute_value( $item['title'], $this->TITLE_NON );
		$item['description'] = $this->substitute_value( $item['description'], $this->DESC_NON );

		foreach($item as $key => $value)
		{
			$value = strip_tags($value);
			$value = $this->xml_specialchars($value);
			$value = $this->strip_control_code($value);
			$items[$i][$key] = $value;
		}

	}

	return $items;
}


//=========================================================
// ATOM builder
//=========================================================

//---------------------------------------------------------
// http://www.mnot.net/drafts/draft-nottingham-atom-format-02.html
// required paramter
// feed elements 
//   - title
//   - link
//   - modified
//   - author name
// entry elements 
//   - id
//   - title
//   - link
//   - modified
//   - issued
//   - author name
//---------------------------------------------------------
function build_atom_feed()
{
	$feed_id   = $this->make_entry_id();
	$copyright = $this->make_feed_copyright($this->xoops_site_author);

	$feed = array(
		'title'         => $this->xoops_site_name,
		'link'          => $this->xoops_site_url,
		'modified'      => $this->iso8601_now,
		'author_name'   => $this->xoops_site_author,
		'author_email'  => $this->xoops_site_email,
		'author_url'    => $this->xoops_site_url,
		'id'            => $feed_id,
		'copyright'     => $copyright,
		'generator'     => $this->FEED_GENERATOR,
		'generator_url' => $this->FEED_GENERATOR_URL,
	);

	return $feed;
}

function assign_atom(&$tpl, $feed, $entrys)
{
	$feed   = $this->arrange_array($feed);
	$entrys = $this->arrange_atom_entrys($entrys);

	$feed   = $this->convert_array_to_utf8($feed);
	$entrys = $this->convert_array_array_to_utf8($entrys);

	$tpl->assign('feed_link',          $feed['link']);
	$tpl->assign('feed_title',         $feed['title']);
	$tpl->assign('feed_modified',      $feed['modified']);
	$tpl->assign('feed_author_name',   $feed['author_name']);
	$tpl->assign('feed_author_email',  $feed['author_email']);
	$tpl->assign('feed_author_url',    $feed['author_url']);
	$tpl->assign('feed_id',            $feed['id']);
	$tpl->assign('feed_copyright',     $feed['copyright']);
	$tpl->assign('feed_generator',     $feed['generator']);
	$tpl->assign('feed_generator_url', $feed['generator_url']);

	foreach ($entrys as $entry)
	{
		$tpl->append('entrys', 
			array(
				'title'        => $entry['title'],
				'link'         => $entry['link'],
				'modified'     => $entry['modified'],
				'issued'       => $entry['issued'], 
				'created'      => $entry['created'], 
				'id'           => $entry['id'], 
				'summary'      => $entry['summary'],
				'content'      => $entry['content'],
				'content_base' => $entry['content_base'],
				'dc_subject'   => $entry['dc_subject'],
				'author_name'  => $entry['author_name'],
				'author_url'   => $entry['author_url'],
				'author_email' => $entry['author_email'],
			));
	}
}

function arrange_atom_entrys($entrys)
{
	$count = count($entrys);
	for ($i=0; $i<$count; $i++)
	{
		$entry = $entrys[$i];

		$entry['title']       = $this->substitute_value( $entry['title'], $this->TITLE_NON );
		$entry['url']         = $this->substitute_value( $entry['url'],   $this->xoops_site_url );
		$entry['author_name'] = $this->substitute_value( $entry['author_name'], $this->xoops_site_author );
		$entry['modified']    = $this->substitute_value( $entry['modified'], $this->iso8601_now );
		$entry['issued']      = $this->substitute_value( $entry['issued'],   $this->iso8601_now );
		$entry['id']          = $this->substitute_entry_id( $entry['entry_id'], ($i+1) );

		foreach($entry as $key => $value)
		{
			if ($key == 'content')  continue;

			$value = strip_tags($value);
			$value = $this->xml_specialchars($value);
			$value = $this->strip_control_code($value);
			$entrys[$i][$key] = $value;
		}
	}

	return $entrys;
}

function arrange_array($array)
{
	foreach($array as $key => $value)
	{
		$value = strip_tags($value);
		$value = $this->xml_specialchars($value);
		$value = $this->strip_control_code($value);
		$array[$key] = $value;
	}

	return $array;
}

// --------------------------------------------------------
// build parts
// --------------------------------------------------------
function get_system_param()
{
	$parse = parse_url($this->xoops_site_url);
	$this->site_tag = $parse['host'];

	if ($this->xoops_site_description)
	{
		$this->site_desc = $this->xoops_site_description;
	}
	else
	{
		$this->site_desc = $this->xoops_site_slogan;
	}

	$this->unixtime_now = time();
	$this->rfc822_now   = date("r", $this->unixtime_now);
	$this->iso8601_now  = $this->iso8601_date( $this->unixtime_now );
	$this->year = date('Y');

}

function make_feed_copyright($site_author)
{
	$copyright = "Copyright (c) $this->year, $this->xoops_site_author";
	return $copyright;
}

function make_entry_id($count='')
{
	$id    = "tag:$this->site_tag,$this->year://1";
	
	if ($count)
	{
		$id .= ".$count";
	}
	return $id;
}

function make_summary($content)
{
	$summary = strip_tags( $content );
	$summary = $this->shorten_text( $summary, $this->max_summary );
	return $summary;
}

function substitute_value($value1, $value2)
{
	if ( isset($value1) && !empty($value1)  )
	{
		return $value1;
	}

	return $value2;
}

function substitute_entry_id($value, $count)
{
	if ( isset($value) && ($value != '') )
	{
		$id = $value;
	}
	else
	{
		$id = $this->make_entry_id($count);
	}
	
	return $id;
}

// --------------------------------------------------------
// htmlspecialchars
// http://www.fxis.co.jp/xmlcafe/tmp/rec-xml.html#dt-markup
// --------------------------------------------------------
function xml_specialchars($text)
{
	$text = htmlspecialchars($text);
	$text = preg_replace("/'/", '&apos;', $text);
	return $text;
}

// --------------------------------------------------------
// datetime
// --------------------------------------------------------

//---------------------------------------------------------
// http://www.w3.org/TR/NOTE-datetime
// 2003-12-13T18:30:02+09:00
//
// http://www.php.net/manual/ja/function.date.php
// User Contributed Notes
//---------------------------------------------------------
function iso8601_date($unixtime)
{
	if ( !isset($unixtime) )  return '';
	if ( empty($unixtime) )   return '';

	$tzd  = date('O',$unixtime);
	$tzd  = substr( chunk_split( $tzd, 3, ':' ), 0, 6 );
	$date = date('Y-m-d\TH:i:s', $unixtime) . $tzd;
	return $date;
} 

//---------------------------------------------------------
// image
//---------------------------------------------------------
function get_image_size($image_url)
{
	$MIN_WIDTH  =  88;
	$MAX_WIDTH  = 144;
	$MIN_HEIGHT =  31;
	$MAX_HEIGHT = 400;

	list($width, $height) = $this->get_remote_image_size($image_url);
	list($width, $height) = $this->adjust_image_size($width, $height, $MAX_WIDTH, $MAX_HEIGHT);
	list($width, $height) = $this->minimum_image_size($width, $height, $MIN_WIDTH, $MIN_HEIGHT);

	return array($width, $height);
}


// --------------------------------------------------------
// set and get property
// --------------------------------------------------------
function set_max_item($value)
{
	$this->max_item = intval($value);
}

function set_max_summary($value)
{
	$this->max_summary = intval($value);
}

function set_cache_time($value)
{
	$this->cache_time = intval($value);
}


//=========================================================
// use XoopsTpl class
//=========================================================
function build_template( $template )
{

// no output encode
	if (function_exists('mb_http_output')) 
	{	mb_http_output('pass');	}

	header ('Content-Type:text/xml; charset=utf-8');

	$tpl = new XoopsTpl();
	$this->xoops_tpl =& $tpl;

	if ($this->cache_time > 0)
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime($this->cache_time);
	}

	if ( !$tpl->is_cached($template) || ($this->cache_time == 0) )
	{
		$this->assign_template();
	}

	$tpl->display($template);
}

function assign_template()
{
// dummy
}

//---------------------------------------------------------
}

?>
