<?php
// $Id: whatsnew_config_define.php,v 1.3 2005/10/22 08:12:41 ohwada Exp $

//================================================================
// What's New Module
// class config define
// 2005-10-01 K.OHWADA
//================================================================

class Whatsnew_Config_Define
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function Whatsnew_Config_Define()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new Whatsnew_Config_Define();
	}

	return $instance;
}

//---------------------------------------------------------
// function
// same as xoops_version.php
//---------------------------------------------------------
function get_define()
{

// constant
	$MAX_SHOW       = 10;
	$MIM_SHOW       = 1;
	$LIMIT_SUMMARY  = 1;
	$MAX_SUMMARY    = 250;
	$MAX_TITLE      = 30;

	$BLOCK_ICON = 'ball.gray.gif';

	$SITE_URL        = XOOPS_URL.'/';
	$SITE_IMAGE_LOGO = 'images/logo.gif';

// system
	global $xoopsConfig;
	$config_handler        =& xoops_gethandler('config');
	$xoopsConfigMetaFooter =& $config_handler->getConfigsByCat(XOOPS_CONF_METAFOOTER);

	list($site_image_url, $site_image_width, $site_image_height) = 
		$this->get_site_image_size($SITE_IMAGE_LOGO);

// module 
	$config[1]['name']      = 'comment_name';
	$config[1]['catid']     = 1;
	$config[1]['valuetype'] = 'text';
	$config[1]['default']   = _WHATSNEW_SYSTEM_COMMENT;

	$config[2]['name']      = 'comment_weight';
	$config[2]['catid']     = 1;
	$config[2]['valuetype'] = 'int';
	$config[2]['default']   = 99;

// block 
	$config[10]['name']      = 'block_max_show';
	$config[10]['catid']     = 1;
	$config[10]['title']     = '_WHATSNEW_LIMIT_SHOW';
	$config[10]['valuetype'] = 'int';
	$config[10]['default']   = $MAX_SHOW;

	$config[11]['name']      = 'block_min_show';
	$config[11]['catid']     = 1;
	$config[11]['title']     = '_WHATSNEW_MIN_SHOW';
	$config[11]['valuetype'] = 'int';
	$config[11]['default']   = $MIM_SHOW;

	$config[12]['name']      = 'block_limit_summary';
	$config[12]['catid']     = 1;
	$config[12]['title']     = '_WHATSNEW_LIMIT_SUMMARY';
	$config[12]['valuetype'] = 'int';
	$config[12]['default']   = $LIMIT_SUMMARY;

	$config[13]['name']      = 'block_max_summary';
	$config[13]['catid']     = 1;
	$config[13]['title']     = '_WHATSNEW_MAX_SUMMARY';
	$config[13]['valuetype'] = 'int';
	$config[13]['default']   = $MAX_SUMMARY;

	$config[14]['name']      = 'block_image_flag';
	$config[14]['catid']     = 1;
	$config[14]['title']     = '_WHATSNEW_NEW_IMAGE';
	$config[14]['valuetype'] = 'int';
	$config[14]['default']   = 1;

	$config[15]['name']      = 'block_image_width';
	$config[15]['catid']     = 1;
	$config[15]['title']     = '_WHATSNEW_NEW_IMAGE_WIDTH';
	$config[15]['valuetype'] = 'int';
	$config[15]['default']   = 160;

	$config[16]['name']      = 'block_image_height';
	$config[16]['catid']     = 1;
	$config[16]['title']     = '_WHATSNEW_NEW_IMAGE_HEIGHT';
	$config[16]['valuetype'] = 'int';
	$config[16]['default']   = 120;

	$config[17]['name']      = 'block_ping';
	$config[17]['catid']     = 1;
	$config[17]['title']     = '_WHATSNEW_NEW_PING';
	$config[17]['valuetype'] = 'int';
	$config[17]['default']   = 0;

	$config[18]['name']      = 'block_icon_default';
	$config[18]['catid']     = 1;
	$config[18]['title']     = '_WHATSNEW_BLOCK_ICON';
	$config[18]['valuetype'] = 'text';
	$config[18]['default']   = $BLOCK_ICON;

	$config[19]['name']      = 'block_module';
	$config[19]['catid']     = 1;
	$config[19]['title']     = '_WHATSNEW_BLOCK_MODULE';
	$config[19]['valuetype'] = 'int';
	$config[19]['default']   = 0;
	$config[19]['options']   = 
		array(_WHATSNEW_BLOCK_MODULE_0 => 0, _WHATSNEW_BLOCK_MODULE_1 => 1);

	$config[20]['name']      = 'block_max_title';
	$config[20]['catid']     = 1;
	$config[20]['title']     = '_WHATSNEW_BLOCK_MAX_TITLE';
	$config[20]['valuetype'] = 'int';
	$config[20]['default']   = $MAX_TITLE;

	$config[21]['name']      = 'block_summary_html';
	$config[21]['catid']     = 1;
	$config[21]['title']     = '_WHATSNEW_BLOCK_SUMMARY_HTML';
	$config[21]['valuetype'] = 'int';
	$config[21]['default']   = 0;

// rss
	$config[30]['name']      = 'rss_max_show';
	$config[30]['catid']     = 1;
	$config[30]['title']     = '';
	$config[30]['valuetype'] = 'int';
	$config[30]['default']   = $MAX_SHOW;

	$config[31]['name']      = 'rss_min_show';
	$config[31]['catid']     = 1;
	$config[31]['title']     = '';
	$config[31]['valuetype'] = 'int';
	$config[31]['default']   = $MIM_SHOW;

	$config[32]['name']      = 'rss_max_summary';
	$config[32]['catid']     = 1;
	$config[32]['title']     = '';
	$config[32]['valuetype'] = 'int';
	$config[32]['default']   = $MAX_SUMMARY;

// main page
	$config[40]['name']      = 'main_tpl';
	$config[40]['catid']     = 2;
	$config[40]['title']     = '_WHATSNEW_MAIN_TPL';
	$config[40]['formtype']  = 'radio_select';
	$config[40]['valuetype'] = 'int';
	$config[40]['default']   = 0;
	$config[40]['options']   = 
		array(_WHATSNEW_MAIN_TPL_0 => 0, _WHATSNEW_MAIN_TPL_1 => 1);

// site
	$config[50]['name']         = 'site_name';
	$config[50]['catid']        = 3;
	$config[50]['title']        = '_WHATSNEW_SITE_NAME';
	$config[50]['description']  = '_WHATSNEW_SITE_NAME_DESC';
	$config[50]['formtype']     = 'textbox';
	$config[50]['valuetype']    = 'text';
	$config[50]['default']      = $xoopsConfig['sitename'];

	$config[51]['name']         = 'site_url';
	$config[51]['catid']        = 3;
	$config[51]['title']        = '_WHATSNEW_SITE_URL';
	$config[51]['description']  = '_WHATSNEW_SITE_URL_DESC';
	$config[51]['formtype']     = 'textbox';
	$config[51]['valuetype']    = 'text';
	$config[51]['default']      = $SITE_URL;

	$config[52]['name']         = 'site_tag';
	$config[52]['catid']        = 3;
	$config[52]['title']        = '';
	$config[52]['description']  = '_WHATSNEW_SITE_TAG';
	$config[52]['formtype']     = 'label';
	$config[52]['valuetype']    = 'text';
	$config[52]['default']      = $this->get_site_tag( $SITE_URL );

	$config[53]['name']         = 'site_desc';
	$config[53]['catid']        = 3;
	$config[53]['title']        = '_WHATSNEW_SITE_DESC';
	$config[53]['description']  = '_WHATSNEW_SITE_DESC_DESC';
	$config[53]['formtype']     = 'textbox';
	$config[53]['valuetype']    = 'text';
	$config[53]['default']      = $xoopsConfig['slogan'];

	$config[54]['name']         = 'site_author';
	$config[54]['catid']        = 3;
	$config[54]['title']        = '_WHATSNEW_SITE_AUTHOR';
	$config[54]['description']  = '_WHATSNEW_SITE_AUTHOR_DESC';
	$config[54]['formtype']     = 'textbox';
	$config[54]['valuetype']    = 'text';
	$config[54]['default']      = $xoopsConfigMetaFooter['meta_author'];

	$config[55]['name']         = 'site_email';
	$config[55]['catid']        = 3;
	$config[55]['title']        = '_WHATSNEW_SITE_EMAIL';
	$config[55]['description']  = '_WHATSNEW_SITE_EMAIL_DESC';
	$config[55]['formtype']     = 'textbox';
	$config[55]['valuetype']    = 'text';
	$config[55]['default']      = $xoopsConfig['adminmail'];

	$config[56]['name']         = 'site_image_logo';
	$config[56]['catid']        = 3;
	$config[56]['title']        = '_WHATSNEW_SITE_LOGO';
	$config[56]['description']  = '_WHATSNEW_SITE_LOGO_DESC';
	$config[56]['formtype']     = 'textbox';
	$config[56]['valuetype']    = 'text';
	$config[56]['default']      = $SITE_IMAGE_LOGO;

	$config[57]['name']         = 'site_image_url';
	$config[57]['catid']        = 3;
	$config[57]['title']        = '';
	$config[57]['description']  = '_WHATSNEW_SITE_IMAGE_URL';
	$config[57]['formtype']     = 'label_image';
	$config[57]['valuetype']    = 'text';
	$config[57]['default']      = $site_image_url;

	$config[58]['name']         = 'site_image_width';
	$config[58]['catid']        = 3;
	$config[58]['title']        = '';
	$config[58]['description']  = '_WHATSNEW_SITE_IMAGE_WIDTH';
	$config[58]['formtype']     = 'label';
	$config[58]['valuetype']    = 'int';
	$config[58]['default']      = $site_image_width;

	$config[59]['name']         = 'site_image_height';
	$config[59]['catid']        = 3;
	$config[59]['title']        = '';
	$config[59]['description']  = '_WHATSNEW_SITE_IMAGE_HEIGHT';
	$config[59]['formtype']     = 'label';
	$config[59]['valuetype']    = 'int';
	$config[59]['default']      = $site_image_height;

// ping
	$config[70]['name']      = 'ping_servers';
	$config[70]['catid']     = 4;
	$config[70]['title']     = '_WHATSNEW_PING_SERVERS';
	$config[70]['formtype']  = 'textarea';
	$config[70]['valuetype'] = 'text';
	$config[70]['default']   = $this->get_ping_servers();

	$config[71]['name']      = 'ping_pass';
	$config[71]['catid']     = 4;
	$config[71]['title']     = '_WHATSNEW_PING_PASS';
	$config[71]['formtype']  = 'textbox';
	$config[71]['valuetype'] = 'text';
	$config[71]['default']   = $this->get_ping_pass();

	$config[72]['name']      = 'ping_log';
	$config[72]['catid']     = 4;
	$config[72]['title']     = '_WHATSNEW_PING_LOG';
	$config[72]['formtype']  = 'yesno';
	$config[72]['valuetype'] = 'int';
	$config[72]['default']   = 1;

	$config[73]['name']      = 'ping_time';
	$config[73]['catid']     = 0;
	$config[73]['title']     = '';
	$config[73]['valuetype'] = 'int';
	$config[73]['default']   = 0;

	return $config;
}

//---------------------------------------------------------
// defualt value
//---------------------------------------------------------
function get_ping_pass()
{
	srand( (double)microtime()*1000000 );
	$ping_pass = chr( rand(97,122) ).sprintf("%06d", rand(1,999999));
	return $ping_pass;
}

function get_ping_servers()
{
	$class_lang    =& Whatsnew_Lang_Conv::getInstance();
	$ping_servers  = $class_lang->get_ping_server_list();
	$ping_servers .= XOOPS_URL."/modules/whatsnew/bin/server.php\n";
	return $ping_servers;
}

function get_site_tag($url)
{
	$parse = parse_url($url);
	if ( isset($parse['host']) )
	{
		return $parse['host'];
	}
	return false;
}

function get_site_image_size( $logo )
{
// constant
	$WIDTH_MIN  =  88;
	$WIDTH_MAX  = 144;
	$HEIGHT_MIN =  31;
	$HEIGHT_MAX = 400;

	$url    = '';
	$width  = 0;
	$height = 0;

	if ( empty($logo) )  return array($url, $width, $height);

	$url  = XOOPS_URL."/".$logo;
	$path = XOOPS_ROOT_PATH."/".$logo;

	if ( !file_exists($path) )  return array($url, $width, $height);

	$size = getimagesize( $path );

	if ( is_array($size) )
	{
		list($width, $height) = 
			$this->adjust_image_size($size[0], $size[1], $WIDTH_MAX, $HEIGHT_MAX);
	}
	else
	{
		$width  = $WIDTH_MIN;
		$height = $HEIGHT_MIN;
	}

	return array($url, $width, $height);
}

function adjust_image_size($width, $height, $max_width, $max_height)
{
	if ($width > $max_width)
    {
    	$mag    = $max_width / $width;
    	$width  = $max_width;
    	$height = $height * $mag;
    }

	if ($height > $max_height)
    {
    	$mag    = $max_height / $height;
    	$height = $max_height;
    	$width  = $width * $mag;
    }

    $width  = intval($width);
    $height = intval($height);

	return array($width, $height);
}

function get_conf_value_by_name( $name, $config_data )
{
	if ( isset($config_data[$name]) )
	{
		$value = $config_data[$name];
	}
	else
	{
		$value = '';
	}

	switch ($name)
	{
		case 'site_tag':
			$site_url = $config_data['site_url'];
			$val = $this->get_site_tag( $site_url );
			break;

		case 'site_image_url':
			$site_image_logo = $config_data['site_image_logo'];
			list($image_url, $image_width, $image_height)
				= $this->get_site_image_size( $site_image_logo );
			$val = $image_url;
			break;

		case 'site_image_width':
			$site_image_logo = $config_data['site_image_logo'];
			list($image_url, $image_width, $image_height)
				= $this->get_site_image_size( $site_image_logo );
			$val = $image_width;
			break;

		case 'site_image_height':
			$site_image_logo = $config_data['site_image_logo'];
			list($image_url, $image_width, $image_height)
				= $this->get_site_image_size( $site_image_logo );
			$val = $image_height;
			break;

		default:
			$val = $value;
			break;
	}

	return $val;
}

// --- class end ---
}

?>