<?php
// $Id: whatsnew_show_block.php,v 1.5 2005/11/16 11:16:22 ohwada Exp $

// 2005-11-16 K.OHWADA
// REQ 3194: output real user name

// 2005-11-06 K.OHWADA
// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']
// add _html_special_chars_url(), _conv_js()

// 2005-09-28 K.OHWADA
// change block.new.php & func.whatsnew.php to class

//=========================================================
// What's New Module
// class show block
// 2004/08/20 K.OHWADA
//=========================================================
// Hacked by hodaka <hodaka@kuri3.net>
// sort by date, group by module
// 2005/03/11
//=========================================================

class Whatsnew_Show_Block
{
// constatant
	var $FLAG_STRIP_CONTROL = 1;
	var $FLAG_STRIP_CRLF    = 1;
	var $FLAG_STRIP_STYLE   = 1;
	var $FLAG_STRIP_SPACE   = 1;
	var $FLAG_IMAGE_FORCE   = 1;

	var $ICON_DIR      = 'images/icons';
	var $DEFAULT_NULL  = '-';	// user, hits, replies
	var $TIME_PROHIBIT = 180;	// 180 sec

// class
	var $_db;

// table
	var $_table_module;
	var $_table_config;

// local variable
	var $_module_data;
	var $_config_data;

	var $_system_module_array;
	var $_system_weight_array;

	var $_module_work_array;
	var $_module_time_array;
	var $_article_all_array;
	var $_article_time_array;
	var $_article_time_flag_array;
	var $_time_latest;
	var $_icon_default;


//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function Whatsnew_Show_Block()
{
// class
	$this->_db =& Database::getInstance();

// table
	$this->_table_module = $this->_db->prefix('whatsnew_module');
	$this->_table_config = $this->_db->prefix('whatsnew_config');

// get config data
	$this->_get_module_table();
	$this->_get_config_table();

	$this->_icon_default = XOOPS_URL."/modules/whatsnew/".$this->ICON_DIR."/".$this->_config_data['block_icon_default'];
 
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new Whatsnew_Show_Block();
	}

	return $instance;
}

//=========================================================
// main function for block
//=========================================================
//---------------------------------------------------------
// sort by date
//---------------------------------------------------------
function show_block_date()
{
	$article_arr = $this->collect_block_date('block');

	$block = $this->make_block_lang();

	$i = 0;
	foreach ($article_arr as $article)
	{
		$block['lines'][$i] = $this->make_block_line($i, $article);
		$i ++;
	}

// icon list
	$block['icon_list'] = $this->make_block_icon_list();

// send ping
	$this->send_ping();

	return $block;
}


//---------------------------------------------------------
// sort by date, group by module
//---------------------------------------------------------
function show_block_module()
{
	$module_arr = $this->collect_block_module('block');

	$block = $this->make_block_lang();

	$i = 0;
	foreach ($module_arr as $module)
	{
		$block['modules'][$i++] = $this->make_block_module( $module );
	}

// icon list
	$block['icon_list'] = $this->make_block_icon_list();

// send ping
	$this->send_ping();

	return $block;
}

// --------------------------------------------------------
// caller bin/update_ping.php
// --------------------------------------------------------
function get_time_latest_after_collect()
{
	$this->collect_block_date('rss');
	return $this->_time_latest;
}

//=========================================================
// function for show_block_date
//=========================================================
// --------------------------------------------------------
// collect aritciles sortby time
// --------------------------------------------------------
function collect_block_date( $flag_kind='block' )
{
	if ( $flag_kind == 'block' )
	{
		$max_show     = $this->_config_data['block_max_show'];
		$min_show     = $this->_config_data['block_min_show'];
	}
	elseif ( $flag_kind == 'rss' )	
	{
		$max_show     = $this->_config_data['rss_max_show'];
		$min_show     = $this->_config_data['rss_min_show'];
	}
	else
	{
		return false;
	}

// collect from all module
	$module_work_array = $this->collect_all_modules( $flag_kind );

// mark time flag
	$i = 0;
	foreach ($this->_article_time_array as $num => $time)
	{
		$this->_article_time_flag_array[$num] = 1;
		$time_older = $time;

		$i ++;
		if ($i >= $max_show) break;
	}

	$icon_list = array();

// walk through in module array
	if ($min_show > 0)
	{
		foreach ($module_work_array as $mid => $module)
		{
// mark time flag, if less than min show
			$j = 0;
			foreach ($module['article_arr'] as $article) 
			{
				$num = $article['serial_num'];
				$this->_article_time_flag_array[$num] = 1;
				$j ++;

				if ($j >= $min_show)  break;
			}
		}
	}

	$i = 0;
	$article_array = array();

// sort by time
	foreach ($this->_article_time_array as $num => $time)
	{
		if ( $this->_article_time_flag_array[$num] )
		{
			$article_array[$i++] = $this->_article_all_array[$num];
		}
	}

	if ( isset($article_array[0]['time']) )
	{
		$this->_time_latest = $article_array[0]['time'];
	}
// no article
	else
	{
		$this->_time_latest = 0;
	}

	return $article_array;
}

// --------------------------------------------------------
// collect from all modules
// caller show main class
// --------------------------------------------------------
function collect_all_modules( $flag_kind )
{
	if ( $flag_kind == 'block' )
	{
		$module_show  = 'block_show';
		$module_limit = 'block_limit';
	}
	elseif ( $flag_kind == 'rss' )
	{
		$module_show  = 'rss_show';
		$module_limit = 'rss_limit';
	}
	else
	{
		return false;
	}

// system module config
	$this->load_system_module();

	$mod_work_arr = array();
	$mod_time_arr = array();

	$serial = 0;	// all article
	$art_all_arr  = array();
	$art_time_arr = array();
	$art_time_flag_arr = array();

	foreach ( $this->_module_data as $mid => $module) 
	{
		$system = $this->_system_module_array[$mid];

		$mid     = $module['mid'];
		$dirname = $module['dirname'];
		$show    = $module[$module_show];
		$limit   = $module[$module_limit];
		$icon    = $module['block_icon'];

		$sys_dirname  = $system['dirname'];
		$sys_name     = $system['name'];
		$sys_perm     = $system['perm'];

// if not show or unlimited
		if ($show  != 1)  continue;
		if ($limit == 0)  continue;
		if (!$sys_perm)   continue;

// article array from one module
		$art_arr = $this->_collect_one_module($dirname, $limit);

		if ( !is_array($art_arr) || (count($art_arr) == 0))
		{	continue;	} 

		$time = $art_arr[0]['time'];

		$mod_arr = array();
		$mod_arr['mod']['mid']      = $mid;
		$mod_arr['mod']['dirname']  = $sys_dirname;
		$mod_arr['mod']['mod_name'] = $sys_name;
		$mod_arr['mod']['mod_icon'] = $icon;
		$mod_arr['mod']['time']     = $time;

		$j = 0;	// article
		foreach ($art_arr as $article) 
		{
			$art_temp               = $article;
			$art_temp['mod_id']     = $mid;
			$art_temp['mod_name']   = $sys_name;
			$art_temp['mod_icon']   = $icon;
			$art_temp['dirname']    = $sys_dirname;
			$art_temp['serial_num'] = $serial;

			$mod_arr['article_arr'][$j] = $art_temp;

			$art_all_arr[$serial]  = $art_temp;
			$art_time_arr[$serial] = $art_temp['time'];
			$art_time_flag_arr[$serial] = 0;

			$j ++;
			$serial ++;
		}

		$mod_work_arr[$mid] = $mod_arr;
		$mod_time_arr[$mid] = $time;
	}

// sort by time
	arsort($art_time_arr, SORT_NUMERIC);

	$this->_module_work_array       = $mod_work_arr;
	$this->_module_time_array       = $mod_time_arr;
	$this->_article_all_array       = $art_all_arr;
	$this->_article_time_array      = $art_time_arr;
	$this->_article_time_flag_array = $art_time_flag_arr;

	return $mod_work_arr;
}

// --------------------------------------------------------
// collect from one modules
// --------------------------------------------------------
function _collect_one_module($dirname, $limit=0, $offset=0)
{
// if unlimited
	if ($limit == 0)  return false;

// add plugin
	$file_module = XOOPS_ROOT_PATH."/modules/$dirname/include/data.inc.php";
	$file_plugin = XOOPS_ROOT_PATH."/modules/whatsnew/plugins/$dirname/data.inc.php";

	if ( file_exists($file_module) ) 
	{
		include_once $file_module;	
	} 
	elseif ( file_exists($file_plugin) ) 
	{
		include_once $file_plugin;	
	}
	else 
	{	return false;	}

	$func = $dirname."_new";
	if ( function_exists($func) )
	{
		return $func($limit, $offset);
	}

	return false;
}

//=========================================================
// function for show_block_module
//=========================================================
// --------------------------------------------------------
// collect aritciles sortby time, group by module
// --------------------------------------------------------
function collect_block_module( $flag_kind='block' )
{
	$article_time_array = $this->collect_block_date( $flag_kind );

	if ( $this->_config_data['block_module'] )
	{
		return $this->_sortby_module($article_time_array);
	}
	else
	{
		return $this->_sortby_module_time($article_time_array);
	}
}

// --------------------------------------------------------
// sortby module
// --------------------------------------------------------
function _sortby_module($article_time_array)
{
	$i = 0;
	$module_art_arr = array();

// walk through in module weight array
	foreach ( $this->_system_weight_array as $mid => $weight)
	{
		$temp_arr = $this->_store_artcile_in_module($mid);

// store in array
		if ($temp_arr)
		{
			$module_art_arr[$i++] = $temp_arr;
		}
	}

	return $module_art_arr;
}

// --------------------------------------------------------
// store artcile in module
// --------------------------------------------------------
function _store_artcile_in_module($mid)
{
	if ( !isset($this->_module_work_array[$mid]) )  return false;

	$module_temp  = $this->_module_work_array[$mid];
	$module_arr   = array();
	$art_temp_arr = array();

	$j = 0;
	foreach ($module_temp['article_arr'] as $article) 
	{
// store in temp array, if time flag is ok
		$num = $article['serial_num'];
		if ( $this->_article_time_flag_array[$num] )
		{
			$art_temp_arr[$j] = $article;
			$j ++;
		}
	}

	if ( count($art_temp_arr) == 0 )  return false;

// store in array
	$module_arr['mod']         = $module_temp['mod'];
	$module_arr['article_arr'] = $art_temp_arr;

	return $module_arr;
}

// --------------------------------------------------------
// sortby time, group by module
// --------------------------------------------------------
function _sortby_module_time($article_time_array)
{
	$time_array = $this->_module_time_array;

// sort by time
	arsort($time_array, SORT_NUMERIC);

	$i = 0;
	$module_art_arr = array();

// walk through in module time array
	foreach ( $time_array as $mid => $time)
	{
		$temp_arr = $this->_store_artcile_in_module($mid);

// store in array
		if ($temp_arr)
		{
			$module_art_arr[$i++] = $temp_arr;
		}
	}

	return $module_art_arr;
}

//=========================================================
// function for display
//=========================================================
// --------------------------------------------------------
// make language
// --------------------------------------------------------
function make_block_lang()
{
	$lang = array(
		'lang_mod'     => _WHATSNEW_BLOCK_MODULE,
		'lang_cat'     => _WHATSNEW_BLOCK_CATEGORY,
		'lang_title'   => _WHATSNEW_BLOCK_TITLE,
		'lang_user'    => _WHATSNEW_BLOCK_USER,
		'lang_hits'    => _WHATSNEW_BLOCK_HITS,
		'lang_replies' => _WHATSNEW_BLOCK_REPLIES,
		'lang_date'    => _WHATSNEW_BLOCK_DATE,
		'lang_more'    => _WHATSNEW_BLOCK_MORE,
	);

	return $lang;
}

// --------------------------------------------------------
// make module
// --------------------------------------------------------
function make_block_module( $module )
{

// module link
	$dirname  = '';
	$mod_link = '';
	if ( isset($module['mod']['dirname']) && $module['mod']['dirname'] )
	{
		$dirname  = $module['mod']['dirname'];
		$mod_link = XOOPS_URL."/modules/".$dirname."/";
	}

// icon
	if ( isset($module['mod']['mod_icon']) && $module['mod']['mod_icon'] )
	{
		$mod_icon_link = XOOPS_URL."/modules/whatsnew/".$this->ICON_DIR."/".$module['mod']['mod_icon'];
	}
	else
	{
		$mod_icon_link = $this->_icon_default;
	}

	$mod_arr = array(
// sanitaize
		'mod_name'      => $this->_html_special_chars( $module['mod']['mod_name'] ),
		'mod_link'      => $this->_html_special_chars_url( $mod_link ),
		'mod_icon_link' => $this->_html_special_chars_url( $mod_icon_link ),

		'mid'           => intval( $module['mod']['mid'] ),
		'dirname'       => $dirname,
	);

// lines
	$i = 0;
	foreach ( $module['article_arr'] as $article )
	{
		$mod_arr['lines'][$i] = 
			$this->make_block_line($i, $article);
		$i ++;
	}

	return $mod_arr;
}

// --------------------------------------------------------
// make line
// --------------------------------------------------------
function make_block_line($num, $article)
{
	$time = intval( $article['time'] );

// module
	$dirname  = '';
	$mod_link = '';
	if ( isset($article['dirname']) && $article['dirname'] )
	{
		$dirname  = $article['dirname'];
		$mod_link = XOOPS_URL."/modules/".$article['dirname']."/";
	}

// category
	$cat_name = '';
	if ( isset($article['cat_name']) && $article['cat_name'] )
	{
		$cat_name = $article['cat_name'];
	}

	$cat_link = '';
	if ( isset($article['cat_link']) && $article['cat_link'] )
	{
		$cat_link = $article['cat_link'];
	}

// uid
	list($uid, $uname, $rname) = $this->_get_user_name( $article );

// make image width & height
	list($image, $width, $height) = $this->_make_block_image($article);

// icon
	if ( isset($article['mod_icon']) && $article['mod_icon'] )
	{
		$mod_icon_link = XOOPS_URL."/modules/whatsnew/".$this->ICON_DIR."/".$article['mod_icon'];
	}
	else
	{
		$mod_icon_link = $this->_icon_default;
	}

// hit count
	$hits    = $this->_make_block_int($article, 'hits');
	$replies = $this->_make_block_int($article, 'replies');

	$line = array(

// sanitaize
		'title'     => $this->_make_html_title( $article ),
		'desc'      => $this->_make_html_summary( $num, $article ),
		'mod_name'  => $this->_html_special_chars( $article['mod_name'] ),
		'dirname'   => $this->_html_special_chars( $dirname ),
		'cat_name'  => $this->_html_special_chars( $cat_name ),

// REQ 3194: output real user name
		'user'      => $this->_html_special_chars( $uname ),
		'user_name' => $this->_html_special_chars( $uname ),
		'real_name' => $this->_html_special_chars( $rname ),

		'link'      => $this->_html_special_chars_url( $article['link'] ),
		'mod_link'  => $this->_html_special_chars_url( $mod_link ),
		'cat_link'  => $this->_html_special_chars_url( $cat_link ),
		'image'     => $this->_html_special_chars_url( $image ),
		'mod_icon_link' => $this->_html_special_chars_url( $mod_icon_link ),

// int
		'uid'      => $uid,
		'width'    => $width,
		'height'   => $height,
		'hits'     => $hits,
		'replies'  => $replies,

// time stamp
		'time'     => $time,
		'date_s'   => formatTimestamp( $time, 's' ),
		'date_l'   => formatTimestamp( $time, 'mysql'),

// raw data
		'content'  => $article['description'],
	);

	return $line;
}

// --------------------------------------------------------
// make icon list
// --------------------------------------------------------
function make_block_icon_list()
{
	$icon_list = array();
	$i = 0;

	foreach ($this->_module_work_array as $mid => $module)
	{
		if ( $module['mod']['mod_icon'] )
		{
			$mod_link = '';
			if ( $module['mod']['dirname'] )
			{
				$mod_link = XOOPS_URL."/modules/".$module['mod']['dirname']."/";
			}

			$icon_list[$i]['mod_link']  = $mod_link;
			$icon_list[$i]['icon_link'] = XOOPS_URL."/modules/whatsnew/".$this->ICON_DIR."/".$module['mod']['mod_icon'];

			$icon_list[$i]['mod_name'] = $this->_html_special_chars( $module['mod']['mod_name'] );

			$i ++;
		}
	}

	$icon_list[$i]['mod_name']  = $this->_html_special_chars( _WHATSNEW_BLOCK_ETC );
	$icon_list[$i]['icon_link'] = $this->_icon_default;

	return $icon_list;
}

// --------------------------------------------------------
// meke html title
// --------------------------------------------------------
function _make_html_title( $article )
{
	if ( !isset($article['title']) )  return '';

 	$title = $article['title'];
	$title = strip_tags($title);
	$title = $this->_shorten_text($title, $this->_config_data['block_max_title'] );

// sanitize
	$title = $this->_html_special_chars( $title );

	return $title;
}

// --------------------------------------------------------
// make html summary
// --------------------------------------------------------
function _make_html_summary( $num, $article )
{
	if ( !isset($article['description']) )  return '';
	if ( empty($article['description'] ) )  return '';
	if ( $num >= $this->_config_data['block_limit_summary'] )  return '';

	$max = $this->_config_data['block_max_summary'];

	$sum = $article['description'];

	if ($this->FLAG_STRIP_CONTROL)
	{
		$sum = $this->_strip_control_code($sum);
	}

	if ( $this->_config_data['block_summary_html'] && (strlen($sum) < $max) )
	{
		return $sum;
	}

	if ($this->FLAG_STRIP_CRLF)
	{
		$sum = $this->_strip_crlf($sum);
	}

	if ($this->FLAG_STRIP_STYLE)
	{
		$sum = $this->_strip_style_tag($sum);
	}

	$sum = strip_tags($sum);

	if ($this->FLAG_STRIP_SPACE)
	{
		$sum = $this->_strip_space($sum);
	}

	$sum = $this->_shorten_text($sum, $max);

// sanitaize
	$sum = $this->_html_special_chars($sum);

	return $sum;
}

// --------------------------------------------------------
// make block int
// --------------------------------------------------------
function _make_block_int($article, $key)
{
	if ( isset($article[$key]) )
	{
		return intval( $article[$key] );
	}

	return $this->DEFAULT_NULL;
}

// --------------------------------------------------------
// strip control code
// --------------------------------------------------------
function _strip_control_code($text)
{
	$text = preg_replace('/[\x00-\x09]/',' ',$text);
	$text = preg_replace('/[\x0B-\x0C]/',' ',$text);
	$text = preg_replace('/[\x0E-\x1F]/',' ',$text);
	$text = preg_replace('/[\x7F]/',     ' ',$text);
	return $text;
}

// --------------------------------------------------------
// strip return code
// --------------------------------------------------------
function _strip_crlf($text)
{
	$text = preg_replace("/\r/",' ',$text);
	$text = preg_replace("/\n/",' ',$text);
	return $text;
}

// --------------------------------------------------------
// strip style tag
// in strip_tags, cannot strip style tag area well
// --------------------------------------------------------
function _strip_style_tag($text)
{
	return preg_replace('|<\s*style\s?.*?>(.*)<\s*/\s*style\s*>|is', '', $text);
}

// --------------------------------------------------------
// strip space code
// --------------------------------------------------------
function _strip_space($text)
{
	global $xoopsConfig;

	if ( ($xoopsConfig['language'] == 'japanese') && function_exists('mb_convert_kana') )
	{
// zenkaku to hankaku
		$text = mb_convert_kana($text, "s");
	}

// in MyTextSanitizer, replace "&nbsp;" to "&amp;nbsp;"
	$text = preg_replace("/&amp;nbsp;/i", ' ', $text);

	$text = preg_replace("/&nbsp;/i", ' ', $text);
	$text = preg_replace("/[\x20]+/", ' ', $text);
	return $text;
}

// --------------------------------------------------------
// shorten text
// --------------------------------------------------------
function _shorten_text($text, $max=100)
{
	if ( strlen($text) > $max)
	{
		if (function_exists('mb_strimwidth'))
		{
			$text = mb_strimwidth( $text, 0, $max, " ..." );
		}
		else
		{
			$text = substr( $text, 0, $max )." ...";
		}
	} 

	return $text;
}

// --------------------------------------------------------
// convert html_special_chars
// in MyTextSanitizer, replace "&nbsp;" to "&amp;nbsp;"
// in this, not replace "&nbsp;"
//   <  -> &lt;
//   >  -> &gt;
//   "  -> &quot;
//   '  -> &#039;
// --------------------------------------------------------
function _html_special_chars($text)
{
	$text = $this->_strip_control_code($text);
	$text = $this->_conv_js($text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	$text = preg_replace("/&amp;/i", '&', $text);
	return $text;
}

//---------------------------------------------------------
// convert html_special_chars for url
//   <     -> &lt;
//   >     -> &gt;
//   "     -> &quot;
//   '     -> &#039;
//   &     -> &amp;
//   &amp; -> &amp;
//---------------------------------------------------------
// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']
function _html_special_chars_url($text)
{
	$text = $this->_strip_control_code($text);
	$text = $this->_strip_crlf($text);
	$text = $this->_conv_js($text);
	$text = preg_replace('/&amp;/i', '&', $text);
	$text = htmlspecialchars($text, ENT_QUOTES);
	return $text;
}

// BUG 3169: need to sanitaize $_SERVER['PHP_SELF']
function _conv_js($text)
{
	$text = preg_replace('/javascript:/si', 'java script:', $text);
	$text = preg_replace('/about:/si', 'about :', $text);
	return $text;
}

// --------------------------------------------------------
// make image
// --------------------------------------------------------
function _make_block_image($article)
{
	if ( !$this->_config_data['block_image_flag'] ) return array('', '', '');
	if ( !isset($article['image']) ) return array('', '', '');

	$image  = $article['image'];	
	$width  = '';
	$height = '';

	if ( isset($article['width']) && isset($article['height']) )
	{
		list($width, $height) = 
			$this->_adjust_image_size($article['width'], $article['height'], $this->_config_data['block_image_width'], $this->_config_data['block_image_height'] );
	}
	elseif ($this->FLAG_IMAGE_FORCE)
	{
		$width  = $this->_config_data['block_image_width'];
		$height = $this->_config_data['block_image_height'];
	}

	return array($image, intval($width), intval($height) );
}

function _adjust_image_size($width, $height, $max_width, $max_height)
{
	if ($width > $max_width)
    {
    	$mag    = $max_width / $width;
    	$width  = $max_width;
    	$height = $height * $mag;
    }

	if ($height > $max_height)
    {
    	$mag    = $max_height / $height;
    	$height = $max_height;
    	$width  = $width * $mag;
    }

    $width  = intval($width);
    $height = intval($height);

	return array($width, $height);
}

//---------------------------------------------------------
// user name
// REQ 3194: output real user name
//---------------------------------------------------------
function _get_user_name( $article )
{
	global $xoopsConfig;

	$uid   = '';
	$uname = $this->DEFAULT_NULL;
	$rname = $this->DEFAULT_NULL;

	if ( !isset($article['uid']) )
	{
		return array($uid, $uname, $rname);
	}

	if ( $article['uid'] )
	{
		$uid = intval( $article['uid'] );
		$poster = new xoopsUser( $uid );

		if ( $poster->isActive() )
		{
			$uname = $poster->getvar('uname');
			$name  = $poster->getvar('name');

			if ($name)
			{
				$rname = $name;
			}
			else
			{
				$rname = $uname;
			}

		}
		else
		{
			$uid   = 0;
			$uname = $xoopsConfig['anonymous'];
			$rname = $uname;
		}
	}
	elseif ( $article['uid'] == 0 )
	{
		$uid   = 0;
		$uname = $xoopsConfig['anonymous'];
		$rname = $uname;
	}

	return array($uid, $uname, $rname);
}

//=========================================================
// function for system config
//=========================================================
//---------------------------------------------------------
// get system config
// caller show main class
//---------------------------------------------------------
// module & weight key as mid
function load_system_module()
{
	$module_handler     =& xoops_gethandler('module');
	$module_arr         =& $module_handler->getObjects();
	$moduleperm_handler =& xoops_gethandler('groupperm');

// user permission 
	global $xoopsUser;

// registerd user
	if ( is_object($xoopsUser) )
	{
		$groups = $xoopsUser->getGroups();
	}
// guest
	else
	{
		$groups = XOOPS_GROUP_ANONYMOUS;
	}

	$system_arr = array();
	$weight_arr = array();

	foreach ( $module_arr as $module ) 
	{
		$mid     = $module->getVar('mid');
		$dirname = $module->getVar('dirname');
		$name    = $module->getVar('name');
		$weight  = $module->getVar('weight');

// for system comment
		if ($mid == 1)
		{
			$name    = $this->_config_data['comment_name'];
			$weight  = $this->_config_data['comment_weight'];
			$dirname = '';
		}

// check user permission
		if ( $moduleperm_handler->checkRight('module_read', $mid, $groups) )
		{
			$perm = 1;
		}
		else
		{
			$perm = 0;
		}

		$system_arr[$mid]['dirname'] = $dirname;
		$system_arr[$mid]['name']    = $name;
		$system_arr[$mid]['weight'] =  $weight;
		$system_arr[$mid]['perm']    = $perm;

		$weight_arr[$mid] = $weight;
	}

//sort by weight
	asort($weight_arr, SORT_NUMERIC);

	$this->_system_module_array = $system_arr;
	$this->_system_weight_array = $weight_arr;

	return $system_arr;
}

//=========================================================
// function for MySQL table
//=========================================================
// --------------------------------------------------------
// get_config_data
// caller builder base class
// --------------------------------------------------------
function &get_config_data()
{
	return $this->_config_data;
}

// future use
function &get_module_data()
{
	return $this->_module_data;
}

function _get_module_table()
{
	$db =& Database::getInstance();

	$ret = array();

	$sql = 'SELECT * FROM '.$this->_table_module.' ORDER BY mid ASC';

	$res = $this->_db->query($sql, 0, 0);
	if ( !$res )
	{
		return false;
	}

	while ($myrow = $this->_db->fetchArray($res)) 
	{
		$ret[ $myrow['mid'] ] = $myrow;
	}

	$this->_module_data = $ret;
}

function _get_config_table()
{
	$ret = array();

	$sql = 'SELECT * FROM '.$this->_table_config.' ORDER BY conf_id ASC';

	$res = $this->_db->query($sql, 0, 0);
	if ( !$res )
	{
		return false;
	}

	while ($myrow = $this->_db->fetchArray($res)) 
	{
		$ret[ $myrow['conf_name'] ] = $myrow['conf_value'];
	}

	$this->_config_data = $ret;

}

//=========================================================
// function for ping
//=========================================================
// --------------------------------------------------------
// send ping
// --------------------------------------------------------
function send_ping($time='')
{
	if ($time == '')
	{
		$time = $this->_time_latest;
	}

	$ping_flag = $this->_config_data['block_ping'];
	$ping_time = $this->_config_data['ping_time'];

	if ( !$ping_flag ) return;

	if ( ($time - $this->TIME_PROHIBIT) > $ping_time )
	{	return;	}

	include_once XOOPS_ROOT_PATH."/modules/whatsnew/api/api_ping.php";

	$class_ping =& Whatsnew_Ping::getInstance();
	$class_ping->send_ping_cache();

}

// --- class end ---
}

?>