<?php
/*
 * Gallery - a web based photo album viewer and editor
 * Copyright (C) 2000-2002 Bharat Mediratta
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
?>
<?php
// Hack prevention.
if (!empty($HTTP_GET_VARS["GALLERY_BASEDIR"]) ||
		!empty($HTTP_POST_VARS["GALLERY_BASEDIR"]) ||
		!empty($HTTP_COOKIE_VARS["GALLERY_BASEDIR"])) {
	print "Security violation\n";
	exit;
}
?>
<?php require './init.php'; ?>
<?php
// Hack check
if (!$gallery->user->canReadAlbum($gallery->album)) {
    header("Location: " . makeAlbumUrl());
	return;
}

if ($full && !$gallery->user->canViewFullImages($gallery->album)) {
    header("Location: " . makeAlbumUrl($gallery->session->albumName, $id));
    return;
}

if ($id) {
	$index = $gallery->album->getPhotoIndex($id);
	if ($index == -1) {
		// That photo no longer exists.
        header("Location: " . makeAlbumUrl($gallery->session->albumName));
		return;
	}
} else {
	$id = $gallery->album->getPhotoId($index);
}

// is photo hidden?  should user see it anyway?
if (($gallery->album->isHidden($index)) && (!$gallery->user->canWriteToAlbum($gallery->album))){
    header("Location: " . makeAlbumUrl($gallery->session->albumName));
    return;
}


$albumName = $gallery->session->albumName;
if (!$gallery->session->viewedItem[$gallery->session->albumName][$id]) {	
	$gallery->session->viewedItem[$albumName][$id] = 1;
	$gallery->album->incrementItemClicks($index);
}

$photo = $gallery->album->getPhoto($index);
// XOOPS Hack by onokazu http://www.xoops.org
$xoops_imageid = $photo->image->getXoopsImageId();
$xoops_imageid = !empty($xoops_imageid) ? intval($xoops_imageid) : 0;
// XOOPS Hack end
if ($photo->isMovie()) {
	$image = $photo->thumbnail;
} else {
	$image = $photo->image;
}
$photoURL = $gallery->album->getAlbumDirURL("full") . "/" . $image->name . "." . $image->type;
list($imageWidth, $imageHeight) = $image->getRawDimensions();

$do_fullOnly = !strcmp($gallery->session->fullOnly,"on") &&
               !strcmp($gallery->album->fields["use_fullOnly"],"yes");
if ($do_fullOnly) {
	$full = 1;
}
$fitToWindow = !strcmp($gallery->album->fields["fit_to_window"], "yes") && !$gallery->album->isResized($index) && !$full;

if ($full) {
	$fullTag = "?full=1";
}

$numPhotos = $gallery->album->numPhotos($gallery->user->canWriteToAlbum($gallery->album));
$next = $index+1;
if ($next > $numPhotos) {
	//$next = 1;
        $last = 1;
}
$prev = $index-1;
if ($prev <= 0) {
	//$prev = $numPhotos;
        $first = 1;
}

if ($index > $gallery->album->numPhotos(1)) {
	$index = $numPhotos;
}

/*
 * We might be prev/next navigating using this page
 *  so recalculate the 'page' variable
 */
$rows = $gallery->album->fields["rows"];
$cols = $gallery->album->fields["cols"];
$perPage = $rows * $cols;
$page = ceil($index / ($rows * $cols));

/*
 * Relative URLs are tricky if we don't know if we're rewriting
 * URLs or not.  If we're rewriting, then the browser will think
 * we're down 1 dir farther than we really are.  Use absolute 
 * urls wherever possible.
 */
$top = $gallery->app->photoAlbumURL;

$bordercolor = $gallery->album->fields["bordercolor"];
$borderwidth = $gallery->album->fields["border"];
if (!strcmp($borderwidth, "off")) {
	$borderwidth = 1;
}

if (!strcmp($gallery->album->fields["resize_size"], "off")) {
        $mainWidth = 0;
} else {
	$mainWidth = "100%"; 
}

$navigator["id"] = $id;
$navigator["allIds"] = $gallery->album->getIds($gallery->user->canWriteToAlbum($gallery->album));
$navigator["fullWidth"] = "100";
$navigator["widthUnits"] = "%";
$navigator["url"] = ".";
$navigator["bordercolor"] = $bordercolor;

#-- breadcrumb text ---
$breadCount = 0;
$breadtext[$breadCount] = "Х: <a href=\"" . makeAlbumUrl($gallery->session->albumName) . "\">" . $gallery->album->fields['title'] . "</a>";
$breadCount++;
$pAlbum = $gallery->album;
do {
  if (!strcmp($pAlbum->fields["returnto"], "no")) {
    break;
  }
  $pAlbumName = $pAlbum->fields['parentAlbumName'];
  if ($pAlbumName) {
    $pAlbum = new Album();
    $pAlbum->load($pAlbumName);
    $breadtext[$breadCount] = "Х: <a href=\"" . makeAlbumUrl($pAlbumName) .
      "\">" . $pAlbum->fields['title'] . "</a>";
  } else {
    //-- we're at the top! ---
    $breadtext[$breadCount] = "꡼: <a href=\"" . makeGalleryUrl("albums.php") .
      "\">" . $gallery->app->galleryTitle . "</a>";
  }
  $breadCount++;
} while ($pAlbumName);

//-- we built the array backwards, so reverse it now ---
for ($i = count($breadtext) - 1; $i >= 0; $i--) {
    $breadcrumb["text"][] = $breadtext[$i];
}
//$breadcrumb["text"][] = "<b>".$photo->caption."</b>";
?>


<?php
$xoopsOption['template_main'] = 'xoopsgallery_viewphoto.html';
include XOOPS_ROOT_PATH.'/header.php';
$xoopsTpl->assign('gallery_version', $gallery->version);
$xoopsTpl->assign('album_title', $gallery->album->fields["title"]);
$xoopsTpl->assign('album_desc', $gallery->album->fields["description"]);
$xoopsTpl->assign('mainWidth', $mainWidth);

$xoopsTpl->assign('photoIndex', $index);
$xoopsTpl->assign('photoCaption', $photo->caption);
$xoopsTpl->assign('photoIsMovie', $gallery->album->isMovie($id));

$adminHasCommands = false;
if (!$gallery->album->isMovie($id)) {
	if ($gallery->user->canWriteToAlbum($gallery->album)) {
		$adminCommands .= '<a href="#" onClick="'.
			popup("resize_photo.php?index=$index").';return false"><nobr>[եȤΥꥵ]</nobr></a>';
		$adminHasCommands = true;
	}

	if ($gallery->user->canDeleteFromAlbum($gallery->album)) {
		$adminCommands .= '<a href="#" onClick="'.
			popup("delete_photo.php?id=$id").';return false"><nobr>[եȤκ]</nobr></a>';
		$adminHasCommands = true;
	}

	if (!strcmp($gallery->album->fields["use_fullOnly"], "yes")) {
		$link = doCommand("", 
			array("set_fullOnly" => (strcmp($gallery->session->fullOnly,"on") ? "on" : "off")),
			"view_photo.php", 
			array("id" => $id));
		$adminCommands .= "<nobr>View Image: ";
		if (strcmp($gallery->session->fullOnly,"on"))
		{
			$adminCommands .= "Normal Size or <a href=\"$link\">Full Size</a> ";
		} else {
			$adminCommands .= "<a href=\"$link\">Normal Size</a> or Full Size ";
		}
		$adminCommands .= "</nobr>";
	}

    
	if (!strcmp($gallery->album->fields["use_exif"],"yes") && (!strcmp($photo->image->type,"jpg")) &&
	    ($gallery->app->use_exif)) {
		$adminCommands .= "<a href=\"#\" onClick=\"".
						popup("view_photo_properties.php?index=$index").
						"\">[եȾ]</a>&nbsp;&nbsp;";
	}


	if (strcmp($gallery->album->fields["print_photos"],"none") && !$gallery->session->offline && !$gallery->album->isMovie($id)) {
		$photo = $gallery->album->getPhoto($GLOBALS["index"]);
		$photoPath = $gallery->album->getAlbumDirURL("full");
		$rawImage = $photoPath . "/" . $photo->image->name . "." . $photo->image->type;
		
		$thumbImage= $photoPath . "/";
		if ($photo->thumbnail) {
			$thumbImage .= $photo->image->name . "." . "thumb" . "." . $photo->image->type;
		} else if ($photo->image->resizedName) {
			$thumbImage .= $photo->image->name . "." . "sized" . "." . $photo->image->type;
		} else {
			$thumbImage .= $photo->image->name . "." . $photo->image->type;
		}

		list($imageWidth, $imageHeight) = $photo->image->getRawDimensions();
		if (strlen($adminCommands) > 0) {
			$adminCommands .="<br>";
		}
		$adminCommands .= "<a href=# onClick=\"document.sflyc4p.returl.value=document.location; document.sflyc4p.submit();return false\">[ShutterflyǤΥեȤ]</a>";
	}


	if ($adminCommands) {
		$xoopsTpl->assign('adminbox', $adminCommands.'&nbsp;');
		$xoopsTpl->assign('adminHasCommands', $adminHasCommands);
	}
}

$breadcrumb["bordercolor"] = $bordercolor;
$breadcrumb["top"] = true;
ob_start();
include($GALLERY_BASEDIR . "layout/breadcrumb.inc");
$xoopsTpl->assign('breadcrumb', ob_get_contents());
ob_end_clean();
ob_start();
include($GALLERY_BASEDIR . "layout/navphoto.inc");
$xoopsTpl->assign('navphoto', ob_get_contents());
ob_end_clean();

#-- if borders are off, just make them the bgcolor ----
if (!strcmp($gallery->album->fields["border"], "off")) {
	$bordercolor = $gallery->album->fields["bgcolor"];
}

if ($bordercolor) {
	$bordercolor = "bgcolor=$bordercolor";
}

if (!$gallery->user->canViewFullImages($gallery->album)){$full=0;}
$photoTag = $gallery->album->getPhotoTag($index, $full);
if (!$gallery->album->isMovie($id)) {
	if ($gallery->album->isResized($index) && !$do_fullOnly) { 
		if ($full) { 
			$xoopsTpl->assign('photoImage', "<a href=" . makeAlbumUrl($gallery->session->albumName, $id, array('xoops_imageid' => $xoops_imageid)) . ">".$photoTag.'</a>');
	 	} else if ($gallery->user->canViewFullImages($gallery->album)) {
			$xoopsTpl->assign('photoImage', "<a href=" . makeAlbumUrl($gallery->session->albumName, $id, array("full" => 1, 'xoops_imageid' => $xoops_imageid)) . ">".$photoTag.'</a>');
		} else {$xoopsTpl->assign('photoImage', $photoTag);}
	} else {
		$xoopsTpl->assign('photoImage', $photoTag);
	}
} else {
	$xoopsTpl->assign('photoImage', "<a href=" . $gallery->album->getPhotoPath($index) . " target=other>".$photoTag.'</a>');
}
$xoopsTpl->assign('editCaption', editCaption($gallery->album, $index, $edit));

if (!empty($xoops_imageid)) {
	include XOOPS_ROOT_PATH.'/include/comment_view.php';
}

// Shutterfly form additional information
if (!strcmp($gallery->album->fields["print_photos"],"none") || $gallery->album->isMovie($id)) {
	// no form
	$xoopsTpl->assign('shutterfly_form', 'false');
} else {
	$xoopsTpl->assign('shutterfly_form', 'true');
	
	$photo = $gallery->album->getPhoto($GLOBALS["index"]);
	$photoPath = $gallery->album->getAlbumDirURL("full");
	$rawImage = $photoPath . "/" . $photo->image->name . "." . $photo->image->type;
	$imbkprnt = $gallery->album->getCaption($index);
    if (empty($imbkprnt)) {
        $imbkprnt = makeAlbumUrl($gallery->session->albumName, $id);
    }		
	$thumbImage= $photoPath . "/";
	if ($photo->image->resizedName) {
		$thumbImage .= $photo->image->resizedName . "." . $photo->image->type;
	} else {
		$thumbImage .= $photo->image->name . "." . $photo->image->type;
	}
	list($imageWidth, $imageHeight) = $photo->image->getRawDimensions();

	$xoopsTpl->assign('rawImage', $rawImage);
	$xoopsTpl->assign('imageHeight', $imageHeight);
	$xoopsTpl->assign('imageWidth', $imageWidth);
	$xoopsTpl->assign('thumbImage', $thumbImage);
	$xoopsTpl->assign('imageCaption', $imbkprnt);
	if ($gallery->album->fields["print_photos"] == "shutterfly without donation") {
		$xoopsTpl->assign('gallery_pid', "C4P");
		$xoopsTpl->assign('gallery_psid', "AFFL");
	} else {
		$xoopsTpl->assign('gallery_pid', "C4PP");
		$xoopsTpl->assign('gallery_psid', "GALL");
	}
}

$breadcrumb["top"] = false;
ob_start();
include($GALLERY_BASEDIR . "layout/breadcrumb.inc");
$xoopsTpl->assign('breadcrumb_bottom', ob_get_contents());
ob_end_clean();
include XOOPS_ROOT_PATH.'/footer.php';
?>