<?php
if(!defined('_CLASS_WEATHER_LOADED')) {
	define('_CLASS_WEATHER_LOADED', true);

// includes Snoopy class for remote file access
if (file_exists(XOOPS_ROOT_PATH."/class/snoopy.class.php")){
	//xoops 1.3
	require_once(XOOPS_ROOT_PATH."/class/snoopy.class.php");
} else {
	//xoops 2
	require_once(XOOPS_ROOT_PATH."/class/snoopy.php");
}

	class WeatherData {
		var $feedUrl;		// location of the source weather data feed
		var $cacheFile;		// location of the source weather cache data
		var $responseSize;	// maximum length of request data
		var $proxyHost;
		var $proxyPort;
		var $proxyUser;
		var $proxyPass;

		var $feedError		= "";		// fetch error from data feed source
		var $feedResponse	= "";		// response from data feed source
		var $results		= "";		// data results

		var $v_City		= "";
		var $v_SubDiv	= "";
		var $v_Country	= "";
		var $v_Region	= "";
		var $v_Temp		= "";
		var $v_CIcon	= "";
		var $v_WindS	= "";
		var $v_WindD	= "";
		var $v_Baro		= "";
		var $v_Humid	= "";
		var $v_Real		= "";
		var $v_UV		= "";
		var $v_Vis		= "";
		var $v_LastUp	= "";
		var $v_ConText	= "";
		var $v_Fore		= "";
		var $v_Acid		= "";

		var $v_Location = "";

		var $v_WindJ    = "";
		var $v_week_correct = "";

		/*
		 * Object constructor
		 */
		function WeatherData() {
			$this->feedUrl = "";
			$this->cacheFile = "";
			$this->responseSize = "";
			$this->proxyHost = "";
			$this->proxyPort = 80;
			$this->proxyUser = "";
			$this->proxyPass = "";
		}
		/*
		 * Data Feed Fetch
		 *
		 */
		function fetchData( $source_url= "", $cache_file = "") {
			$snoopy = new Snoopy;

			if ( !empty($source_url) ) { $this->feedUrl = $source_url; }
			if ( !empty($cache_file) ) { $this->cacheFile = $cache_file; }

			if ( !empty($this->responseSize) ) {
				$snoopy->maxlength = $this->responseSize;
			}

			if ( !empty($this->proxyHost) ) {
				$snoopy->proxy_host = $this->proxyHost;
				if ( !empty($this->proxyPort) ) { $snoopy->proxy_port = $this->proxyPort; }
				if ( !empty($this->proxyUser) ) { $snoopy->user = $this->proxyUser; }
				if ( !empty($this->proxyPass) ) { $snoopy->pass = $this->proxyPass; }
			}
            if ( IsSet($this->feedUrl) && !empty($this->feedUrl) ) {
				$snoopy->fetch($this->feedUrl);
			} else {
				$snoopy->response_code = "HTTP/1.1 400 Bad Request\r\n";
				$snoopy->error = "Unable to use the Supplied URL, it is either empty or badly formatted";
			}
			$this->feedResponse = $snoopy->response_code;
			if ( IsSet($snoopy->error) && !empty($snoopy->error) ) {
				$this->feedError = $snoopy->error;
			} else {
				if ( !empty($this->cacheFile) ) {
					$fp = fopen($this->cacheFile, "w");
					fwrite($fp, $snoopy->results);
					fclose($fp);
                } else {
					$this->results = $snoopy->results;
				}
			}
			return;
		}
		function processData() {
			if ( !empty($this->results) ) {
				$answer			= explode("{", $this->results, 2);
				$v_array		= explode(";", $answer[1]);

				$v_tmp			= explode("=", $v_array[0]);
				$this->v_City	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[1]);
				$this->v_SubDiv	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[2]);
				$this->v_Country= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[3]);
				$this->v_Region	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[4]);
				$this->v_Temp	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[6]);
				$this->v_CIcon	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[7]);
				$this->v_WindS	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[8]);
				//ܸѴ by Nao-Pon
				$v_tmp[1] = ereg_replace("N", "", $v_tmp[1]);
				$v_tmp[1] = ereg_replace("E", "", $v_tmp[1]);
				$v_tmp[1] = ereg_replace("W", "", $v_tmp[1]);
				$v_tmp[1] = ereg_replace("S", "", $v_tmp[1]);
				$v_tmp[1] = ereg_replace("VAR", "", $v_tmp[1]);
				//ޤ
				$this->v_WindD	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[9]);
				$this->v_Baro	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[10]);
				$this->v_Humid	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[11]);
				$this->v_Real	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[12]);
				$this->v_UV		= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[13]);
				$this->v_Vis	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[14]);
				$v_tmp[1] = substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				//$this->v_LastUp	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);

				//å
				$time_lag = 14;

				//ˤν
				$v_tmp[1] = strtotime ( $v_tmp[1] )+($time_lag*3600);
				$JST_hour = date("H", $v_tmp[1]);
				$this->v_week_correct = ($JST_hour > 9 && $JST_hour < 15)? 1 : 0 ;

				//ܸǥեޥå
				$v_tmp[1] = date("nj H:i", $v_tmp[1]);
				$this->v_LastUp	= $v_tmp[1]."(JST)";

				$v_tmp			= explode("=", $v_array[15]);
				$this->v_ConText= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[16]);
				$this->v_Fore	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				$v_tmp			= explode("=", $v_array[17]);
				$this->v_Acid	= substr($v_tmp[1],2,strlen($v_tmp[1])-3);
				//$this->v_Fore	= explode("|", $v_Fore);
			} else {
				$this->feedError = "No Data to Process";
			}
			return;
		}
		function getIcon($icon) {
			If( $icon <= 10 ) {
				$icon += 20;
			}
			$icon .= ".gif";
			return $icon;
		}
		function getCacheData($forcecache=false) {
			if( $forcecache != true && (!file_exists($this->cacheDir.$this->cacheFile) || (filemtime($this->cacheDir.$this->cacheFile) + $this->cacheTimeout - time()) < 0))
			{
				$snoopy = new Snoopy;
				$snoopy->fetch($this->sourceUrl);
				$data = $snoopy->results;

				$fp = fopen($this->cacheFile, "w");
				$fp($cacheFile, $data);
				fclose($fp);
			}
			// fsockopen failed the last time, so force cache
			elseif ( $forcecache == true )
			{
				if (file_exists($this->cacheDir.$this->cacheFile)) {
					$data = implode('', file($this->cacheDir.$this->cacheFile));
					// set the modified time to a future time, and let the server have time to come up again
					touch($this->cacheDir.$this->cacheFile, time() + $this->cacheTimeout);
				} else {
					$data = "";
				}
			} else {
				$data = implode('', file($this->cacheDir.$this->cacheFile));
			}
			return $data;
		}
		Function setSubDiv($subdiv) {
			$this->v_SubDiv = $subdiv;
		}
		Function getLocation() {
			$this->v_Location = $this->v_City.", ";

			if ( $this->v_SubDiv != "" && $this->v_SubDiv != $this->v_Country && $this->v_SubDiv != $this->v_City ) {
				$this->v_Location .= $this->v_SubDiv;
			} else {
				$this->v_Location .= $this->v_Country;
			}
			return $this->v_Location;
		}
		Function getLocation2($v_City) {
			$this->v_Location = $v_City.", ";

			if ( $this->v_SubDiv != "" && $this->v_SubDiv != $this->v_Country && $this->v_SubDiv != $this->v_City ) {
				$this->v_Location .= $this->v_SubDiv;
			} else {
				$this->v_Location .= $this->v_Country;
			}
			return $this->v_Location;
		}

	}
}
?>