<?php
// $Id: whatsnew_config_define.php,v 1.7 2007/05/16 09:13:23 ohwada Exp $

// 2007-05-12 K.OHWADA
// module dupulication
// XC 2.1 : change author from meta_author to user with uid=1

// 2006-06-20 K.OHWADA
// REQ 3873: login user can read RSS.
// add rss_permit_user

//================================================================
// What's New Module
// class config define
// 2005-10-01 K.OHWADA
//================================================================

// === class begin ===
if( !class_exists('whatsnew_config_define') ) 
{

//=========================================================
// class whatsnew_config_define
//=========================================================
class whatsnew_config_define extends happy_linux_config_define_base
{
	var $_DIRNAME;

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function whatsnew_config_define( $dirname )
{
	$this->happy_linux_config_define_base();

	$this->_DIRNAME = $dirname;
	$this->_build_rss = happy_linux_build_rss::getInstance();
}

function &getInstance( $dirname )
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new whatsnew_config_define( $dirname );
	}
	return $instance;
}

//---------------------------------------------------------
// function
// same as xoops_version.php
//---------------------------------------------------------
function get_define()
{

// constant
	$MAX_SHOW       = 10;
	$MIM_SHOW       = 1;
	$LIMIT_SUMMARY  = 1;
	$MAX_SUMMARY    = 250;
	$MAX_TITLE      = 30;

	$BLOCK_ICON = 'ball.gray.gif';

// site information
	$site_name         = $this->_build_rss->get_default_site_name();
	$site_desc         = $this->_build_rss->get_default_site_desc();
	$site_url          = $this->_build_rss->get_default_site_url();
	$site_tag          = $this->_build_rss->get_default_site_tag();
	$site_author_name  = $this->_build_rss->get_default_site_author_name();
	$site_author_email = $this->_build_rss->get_default_site_author_email();
	$site_author_uri   = $this->_build_rss->get_default_site_author_uri();
	$site_image_logo   = $this->_build_rss->get_default_site_image_logo();
	list($site_image_url, $site_image_width, $site_image_height) = 
		$this->_build_rss->get_site_image_size( $site_image_logo );

//---------------------------------------------------------
// config
//---------------------------------------------------------
// module 
	$config[1]['name']      = 'comment_name';
	$config[1]['catid']     = 1;
	$config[1]['valuetype'] = 'text';
	$config[1]['default']   = _WHATSNEW_SYSTEM_COMMENT;

	$config[2]['name']      = 'comment_weight';
	$config[2]['catid']     = 1;
	$config[2]['valuetype'] = 'int';
	$config[2]['default']   = 99;

// block 
	$config[10]['name']      = 'block_max_show';
	$config[10]['catid']     = 1;
	$config[10]['title']     = '_WHATSNEW_LIMIT_SHOW';
	$config[10]['valuetype'] = 'int';
	$config[10]['default']   = $MAX_SHOW;

	$config[11]['name']      = 'block_min_show';
	$config[11]['catid']     = 1;
	$config[11]['title']     = '_WHATSNEW_MIN_SHOW';
	$config[11]['valuetype'] = 'int';
	$config[11]['default']   = $MIM_SHOW;

	$config[12]['name']      = 'block_limit_summary';
	$config[12]['catid']     = 1;
	$config[12]['title']     = '_WHATSNEW_LIMIT_SUMMARY';
	$config[12]['valuetype'] = 'int';
	$config[12]['default']   = $LIMIT_SUMMARY;

	$config[13]['name']      = 'block_max_summary';
	$config[13]['catid']     = 1;
	$config[13]['title']     = '_WHATSNEW_MAX_SUMMARY';
	$config[13]['valuetype'] = 'int';
	$config[13]['default']   = $MAX_SUMMARY;

	$config[14]['name']      = 'block_image_flag';
	$config[14]['catid']     = 1;
	$config[14]['title']     = '_WHATSNEW_NEW_IMAGE';
	$config[14]['valuetype'] = 'int';
	$config[14]['default']   = 1;

	$config[15]['name']      = 'block_image_width';
	$config[15]['catid']     = 1;
	$config[15]['title']     = '_WHATSNEW_NEW_IMAGE_WIDTH';
	$config[15]['valuetype'] = 'int';
	$config[15]['default']   = 160;

	$config[16]['name']      = 'block_image_height';
	$config[16]['catid']     = 1;
	$config[16]['title']     = '_WHATSNEW_NEW_IMAGE_HEIGHT';
	$config[16]['valuetype'] = 'int';
	$config[16]['default']   = 120;

	$config[17]['name']      = 'block_ping';
	$config[17]['catid']     = 1;
	$config[17]['title']     = '_WHATSNEW_NEW_PING';
	$config[17]['valuetype'] = 'int';
	$config[17]['default']   = 0;

	$config[18]['name']      = 'block_icon_default';
	$config[18]['catid']     = 1;
	$config[18]['title']     = '_WHATSNEW_BLOCK_ICON';
	$config[18]['valuetype'] = 'text';
	$config[18]['default']   = $BLOCK_ICON;

	$config[19]['name']      = 'block_module';
	$config[19]['catid']     = 1;
	$config[19]['title']     = '_WHATSNEW_BLOCK_MODULE';
	$config[19]['valuetype'] = 'int';
	$config[19]['default']   = 0;
	$config[19]['options']   = 
		array(_WHATSNEW_BLOCK_MODULE_0 => 0, _WHATSNEW_BLOCK_MODULE_1 => 1);

	$config[20]['name']      = 'block_max_title';
	$config[20]['catid']     = 1;
	$config[20]['title']     = '_WHATSNEW_BLOCK_MAX_TITLE';
	$config[20]['valuetype'] = 'int';
	$config[20]['default']   = $MAX_TITLE;

	$config[21]['name']      = 'block_summary_html';
	$config[21]['catid']     = 1;
	$config[21]['title']     = '_WHATSNEW_BLOCK_SUMMARY_HTML';
	$config[21]['valuetype'] = 'int';
	$config[21]['default']   = 0;

// rss
	$config[30]['name']      = 'rss_max_show';
	$config[30]['catid']     = 1;
	$config[30]['title']     = '';
	$config[30]['valuetype'] = 'int';
	$config[30]['default']   = $MAX_SHOW;

	$config[31]['name']      = 'rss_min_show';
	$config[31]['catid']     = 1;
	$config[31]['title']     = '';
	$config[31]['valuetype'] = 'int';
	$config[31]['default']   = $MIM_SHOW;

	$config[32]['name']      = 'rss_max_summary';
	$config[32]['catid']     = 1;
	$config[32]['title']     = '';
	$config[32]['valuetype'] = 'int';
	$config[32]['default']   = $MAX_SUMMARY;

// main page
	$config[40]['name']      = 'main_tpl';
	$config[40]['catid']     = 2;
	$config[40]['title']     = '_WHATSNEW_MAIN_TPL';
	$config[40]['formtype']  = 'radio_select';
	$config[40]['valuetype'] = 'int';
	$config[40]['default']   = 0;
	$config[40]['options']   = 
		array(_WHATSNEW_MAIN_TPL_0 => 0, _WHATSNEW_MAIN_TPL_1 => 1);

// site
	$config[50]['name']         = 'site_name';
	$config[50]['catid']        = 3;
	$config[50]['title']        = '_HAPPY_LINUX_VIEW_SITE_TITLE';
	$config[50]['description']  = '_HAPPY_LINUX_VIEW_RSS_ATOM_REQUIRE';
	$config[50]['formtype']     = 'textbox';
	$config[50]['valuetype']    = 'text';
	$config[50]['default']      = $site_name;

	$config[51]['name']         = 'site_url';
	$config[51]['catid']        = 3;
	$config[51]['title']        = '_HAPPY_LINUX_VIEW_SITE_LINK';
	$config[51]['description']  = '_HAPPY_LINUX_VIEW_RSS_ATOM_REQUIRE';
	$config[51]['formtype']     = 'textbox';
	$config[51]['valuetype']    = 'text';
	$config[51]['default']      = $site_url;

	$config[52]['name']         = 'site_tag';
	$config[52]['catid']        = 3;
	$config[52]['title']        = '';
	$config[52]['description']  = '_HAPPY_LINUX_VIEW_SITE_TAG';
	$config[52]['formtype']     = 'label';
	$config[52]['valuetype']    = 'text';
	$config[52]['default']      = $site_tag;

	$config[53]['name']         = 'site_desc';
	$config[53]['catid']        = 3;
	$config[53]['title']        = '_HAPPY_LINUX_VIEW_SITE_DESCRIPTION';
	$config[53]['description']  = '_HAPPY_LINUX_VIEW_RSS_REQUIRE';
	$config[53]['formtype']     = 'textbox';
	$config[53]['valuetype']    = 'text';
	$config[53]['default']      = $site_desc;

	$config[54]['name']         = 'site_author';
	$config[54]['catid']        = 3;
	$config[54]['title']        = '_HAPPY_LINUX_VIEW_AUTHOR_NAME';
	$config[54]['description']  = '_HAPPY_LINUX_VIEW_ATOM_REQUIRE';
	$config[54]['formtype']     = 'textbox';
	$config[54]['valuetype']    = 'text';
	$config[54]['default']      = $site_author_name;

	$config[55]['name']         = 'site_email';
	$config[55]['catid']        = 3;
	$config[55]['title']        = '_HAPPY_LINUX_VIEW_AUTHOR_EMAIL';
	$config[55]['description']  = '_HAPPY_LINUX_VIEW_OPTION';
	$config[55]['formtype']     = 'textbox';
	$config[55]['valuetype']    = 'text';
	$config[55]['default']      = $site_author_email;

	$config[56]['name']         = 'site_image_logo';
	$config[56]['catid']        = 3;
	$config[56]['title']        = '_HAPPY_LINUX_VIEW_SITE_LOGO';
	$config[56]['description']  = '_HAPPY_LINUX_VIEW_OPTION';
	$config[56]['formtype']     = 'textbox';
	$config[56]['valuetype']    = 'text';
	$config[56]['default']      = $site_image_logo;

	$config[57]['name']         = 'site_image_url';
	$config[57]['catid']        = 3;
	$config[57]['title']        = '';
	$config[57]['description']  = '_HAPPY_LINUX_VIEW_RSS_IMAGE_URL';
	$config[57]['formtype']     = 'label_image';
	$config[57]['valuetype']    = 'text';
	$config[57]['default']      = $site_image_url;

	$config[58]['name']         = 'site_image_width';
	$config[58]['catid']        = 3;
	$config[58]['title']        = '';
	$config[58]['description']  = '_HAPPY_LINUX_VIEW_RSS_IMAGE_WIDTH';
	$config[58]['formtype']     = 'extra_site_image_width';
	$config[58]['valuetype']    = 'int';
	$config[58]['default']      = $site_image_width;

	$config[59]['name']         = 'site_image_height';
	$config[59]['catid']        = 3;
	$config[59]['title']        = '';
	$config[59]['description']  = '_HAPPY_LINUX_VIEW_RSS_IMAGE_HEIGHT';
	$config[59]['formtype']     = 'extra_site_image_height';
	$config[59]['valuetype']    = 'int';
	$config[59]['default']      = $site_image_height;

// ping
	$config[70]['name']      = 'ping_servers';
	$config[70]['catid']     = 4;
	$config[70]['title']     = '_WHATSNEW_PING_SERVERS';
	$config[70]['formtype']  = 'textarea';
	$config[70]['valuetype'] = 'textarea';
	$config[70]['default']   = $this->get_ping_servers();

	$config[71]['name']      = 'ping_pass';
	$config[71]['catid']     = 4;
	$config[71]['title']     = '_WHATSNEW_PING_PASS';
	$config[71]['formtype']  = 'textbox';
	$config[71]['valuetype'] = 'text';
	$config[71]['default']   = xoops_makepass();

	$config[72]['name']      = 'ping_log';
	$config[72]['catid']     = 4;
	$config[72]['title']     = '_WHATSNEW_PING_LOG';
	$config[72]['formtype']  = 'yesno';
	$config[72]['valuetype'] = 'int';
	$config[72]['default']   = 1;

	$config[73]['name']      = 'ping_time';
	$config[73]['catid']     = 0;
	$config[73]['title']     = '';
	$config[73]['valuetype'] = 'int';
	$config[73]['default']   = 0;

// REQ 3873: login user can read RSS.
// rss
	$config[81]['name']      = 'rss_permit_user';
	$config[81]['catid']     = 5;
	$config[81]['title']       = '_WHATSNEW_RSS_PERMIT_USER';
	$config[81]['description'] = '_WHATSNEW_RSS_PERMIT_USER_DESC';
	$config[81]['formtype']  = 'yesno';
	$config[81]['valuetype'] = 'int';
	$config[81]['default']   = 0;

//---------------------------------------------------------
	return $config;
}

//---------------------------------------------------------
// default value
//---------------------------------------------------------
function get_ping_servers()
{
	$locate =& happy_linux_locate_factory::getInstance();
	$ping_servers = $locate->get_var( 'ping_servers' );
	$ping_servers .= XOOPS_URL.'/modules/'.$this->_DIRNAME."/bin/server.php\n";
	return $ping_servers;
}

// --- class end ---
}

// === class end ===
}

?>