<?php
// $Id: build_rss.php,v 1.8 2007/05/16 09:20:30 ohwada Exp $

// 2007-05-12 K.OHWADA
// for XC 2.1
// get_default_site_url() etc
// clear_compiled_tpl()

// 2007-03-01 K.OHWADA
// $_SITE_AUTHOR_NAME_DEFAULT

// 2006-09-20 K.OHWADA
// this is new file
// porting from rssc_build_base

//=========================================================
// Happy Linux Framework Module
// 2006-09-01 K.OHWADA
//=========================================================

//=========================================================
// class builder base
//=========================================================
class happy_linux_build_rss
{
	var $_DIRNAME;

// http://www.rssboard.org/rss-specification#ltimagegtSubelementOfLtchannelgt
	var $_SITE_IMAGE_WIDTH_MAX      = 144;
	var $_SITE_IMAGE_WIDTH_DEFAULT  =  88;
	var $_SITE_IMAGE_HEIGHT_MAX     = 400;
	var $_SITE_IMAGE_HEIGHT_DEFAULT =  31;

// constant
	var $_MODULE_ID_DEFUALT = 1;
	var $_HEADER   = 'Content-Type:text/xml; charset=utf-8';
	var $_RSS_DOCS = 'http://backend.userland.com/rss/';
	var $_SITE_AUTHOR_NAME_UID     = 1;
	var $_SITE_AUTHOR_NAME_DEFAULT = 'xoops';
	var $_SITE_IMAGE_LOGO       = 'images/logo.gif';
	var $_MAX_ITEMS = 20;

// flag
	var $_FLAG_UTF8_STRIP_CONTROL = true;

// class instance
	var $_system;
	var $_strings;
	var $_convert;
	var $_image;

// http://web.resource.org/rss/1.0/spec#s5.5.3
// (Suggested) Maximum Length: 500
	var $_max_summary = 500;

// site information
	var $_site_url;
	var $_site_name;
	var $_site_desc;
	var $_site_tag;
	var $_site_year;
	var $_site_copyright;
	var $_site_link_self;
	var $_site_author_name;
	var $_site_author_email;
	var $_site_author_uri;

	var $_site_image_url    = '';
	var $_site_image_link   = '';
	var $_site_image_title  = '';
	var $_site_image_width  = '';
	var $_site_image_height = '';

// set param
	var $_channel = array();
	var $_items   = array();
	var $_cache_time  = 0;	// no cache
	var $_flag_force_build = false;
	var $_view_goto_title  = 'goto index';
	var $_view_goto_url    = null;

// local variable
	var $_count_line = 1;

// override
	var $_GENERATOR     = 'XOOPS Happy Linux';
	var $_GENERATOR_URI = 'http://linux2.ohwada.net/';
	var $_CATEGORY      = 'Happy Linux';
	var $_TITLE         = 'Feeds';
	var $_RDF_TITLE     = 'RDF Feeds';
	var $_RSS_TITLE     = 'RSS Feeds';
	var $_ATOM_TITLE    = 'ATOM Feeds';
	var $_TEMPLATE      = null;
	var $_RDF_TEMPLATE  = null;
	var $_RSS_TEMPLATE  = null;
	var $_ATOM_TEMPLATE = null;
	var $_MODE          = 'other';

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_build_rss()
{
// class instance
	$this->_system  =& happy_linux_system::getInstance();
	$this->_strings =& happy_linux_strings::getInstance();
	$this->_convert =& happy_linux_convert_encoding::getInstance();
	$this->_image   =& happy_linux_image_size::getInstance();

	$this->_init_site_information();
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_build_rss();
	}

	return $instance;
}

//=========================================================
// public
//=========================================================
function build()
{
// no output encode
	happy_linux_http_output('pass');

	header($this->_HEADER);

	$template = $this->_get_template();

	$tpl = new XoopsTpl();

// use cache
	if ( !$this->_flag_force_build && ($this->_cache_time > 0) )
	{
		$tpl->xoops_setCaching(2);
		$tpl->xoops_setCacheTime($this->_cache_time);
	}

// always build
	if ( $this->_flag_force_build || !$tpl->is_cached($template) || ($this->_cache_time == 0) ) 
	{
		$this->_assign( $tpl );
	}

	$tpl->display($template);
}

function view()
{
	header ('Content-Type:text/html; charset=utf-8');

	$template = $this->_get_template();
	if ( empty($template) )
	{
		echo "<font color='red'>No Template</font><br />\n";
		return;
	}

	$tpl = new XoopsTpl();

	$this->_assign( $tpl );

	$xml   = $tpl->fetch($template);
	$body  = $this->_strings->sanitize_textarea( $xml );
	$title = $this->_get_title();

?>
<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=utf-8" />
<title><?php echo $title; ?></title>
</head>
<body>
<h3><?php echo $title; ?></h3>
This is debug mode <br /> <br />
<hr />
<pre>
<?php echo $body; ?>
</pre>
<hr />
<?php

	if ( $this->_view_goto_url && $this->_view_goto_title )
	{
		echo '<a href="'.$this->_view_goto_url.'">'.$this->_view_goto_title.'</a>'."\n";
	}

?>
</body>
</html>
<?php

}

function clear()
{
	$tpl = new XoopsTpl();
	$tpl->clear_cache( $this->_get_template() );
}

function clear_compiled_tpl()
{
	$tpl = new XoopsTpl();
	$tpl->clear_compiled_tpl( $this->_get_template() );
}

//---------------------------------------------------------
// utlity
//---------------------------------------------------------
function build_site_copyright( $author=null, $year=null )
{
	if ( empty($author) )
	{
		$author = $this->get_default_site_author_name();
	}
	if ( empty($year) )
	{
		$year = $this->get_default_site_year();
	}
	$val = 'Copyright (c) ' . $year . ', ' .$author;
	return $val;
}

function build_entry_id( $mid=null, $aid=null, $site_tag=null, $year=null )
{
	if ( empty($mid) )
	{
		$mid = $this->_MODULE_ID_DEFUALT;
	}
	if ( empty($aid) )
	{
		$aid = $this->_count_line;
	}
	if ( empty($site_tag) )
	{
		$site_tag = $this->_site_tag;
	}
	if ( empty($year) )
	{
		$year = $this->_site_year;
	}
	$val = "tag:$site_tag,$year://1.$mid.$aid";;
	return $val;
}

//---------------------------------------------------------
// site information
//---------------------------------------------------------
function get_default_site_url()
{
	return XOOPS_URL.'/';
}

function get_default_site_name()
{
	return $this->_system->get_sitename();
}

function get_default_site_desc()
{
	return $this->_system->get_slogan();
}

function get_default_site_tag()
{
	return $this->parse_site_tag( $this->get_default_site_url() );
}

function get_default_site_year()
{
	return date("Y");
}

function get_default_site_link_self()
{
	$val = 'http://' . $_SERVER['SERVER_NAME'] . $_SERVER['REQUEST_URI'];
	return $val;
}

function get_default_site_author_name()
{
	$name = $this->_system->get_uname_by_uid( $this->_SITE_AUTHOR_NAME_UID );
	if ( empty($name) )
	{
		$name = $this->_SITE_AUTHOR_NAME_DEFAULT;
	}
	return $name;
}

function get_default_site_author_email()
{
	return $this->_system->get_adminmail();
}

function get_default_site_author_uri()
{
	return '';
}

function parse_site_tag($url)
{
	$parse = parse_url($url);
	if ( isset($parse['host']) )
	{
		return $parse['host'];
	}
	return false;
}

//---------------------------------------------------------
// site image
//---------------------------------------------------------
function get_default_site_image_logo()
{
	return $this->_SITE_IMAGE_LOGO;
}

function get_site_image_width_max()
{
	return $this->_SITE_IMAGE_WIDTH_MAX;
}

function get_site_image_height_max()
{
	return $this->_SITE_IMAGE_HEIGHT_MAX;
}

function get_site_image_size( $logo )
{
	$url    = '';
	$width  = 0;
	$height = 0;

	if ( empty($logo) )
	{	return array($url, $width, $height);	}

	$url  = XOOPS_URL."/".$logo;
	$path = XOOPS_ROOT_PATH."/".$logo;

	list($width, $height) = 
		$this->_image->get_size($path);

	return array($url, $width, $height);
}

function check_site_image_width( $width )
{
	$ret  = 0;
	if ( $width > $this->_SITE_IMAGE_WIDTH_MAX )
	{
		$ret = 1;
	}
	return $ret;
}

function check_site_image_height( $height )
{
	$ret  = 0;
	if ( $height > $this->_SITE_IMAGE_HEIGHT_MAX )
	{
		$ret = 1;
	}
	return $ret;
}

// --------------------------------------------------------
// set param
// --------------------------------------------------------
function set_dirname($value)
{
	$this->_DIRNAME = $value;
}

function set_site_url($value)
{
	$this->_site_url = $value;
}

function set_site_name($value)
{
	$this->_site_name = $value;
}

function set_site_desc($value)
{
	$this->_site_desc = $value;
}

function set_site_tag($value)
{
	$this->_site_tag = $value;
}

function set_site_year($value)
{
	$this->_site_year = $value;
}

function set_site_copyright($value)
{
	$this->_site_copyright = $value;
}

function set_site_link_self($value)
{
	$this->_site_link_self = $value;
}

function set_site_author_name($value)
{
	$this->_site_author_name = $value;
}

function set_site_author_email($value)
{
	$this->_site_author_email = $value;
}

function set_site_author_uri($value)
{
	$this->_site_author_uri = $value;
}

function set_site_image_url($value)
{
	$this->_site_image_url = $value;
}

function set_site_image_link($value)
{
	$this->_site_image_link = $value;
}

function set_site_image_title($value)
{
	$this->_site_image_title = $value;
}

function set_site_image_width($value)
{
	$this->_site_image_width = intval($value);
}

function set_site_image_height($value)
{
	$this->_site_image_height = intval($value);
}

function set_cache_time($value)
{
	$this->_cache_time = intval($value);
}

function set_max_summary($value)
{
	$this->_max_summary = intval($value);
}

function set_channel($value)
{
	$this->_channel = $value;
}

function set_items($value)
{
	$this->_items = $value;
}

function set_flag_force_build($value)
{
	$this->_flag_force_build = (bool)$value;
}

function set_view_goto_title($value)
{
	$this->_view_goto_title = $value;
}

function set_view_goto_url($value)
{
	$this->_view_goto_url = $value;
}

function set_mode($val)
{
	switch ( $val )
	{
		case 'rdf':
		case 'atom':
		case 'rss':
			$this->_MODE = $val;
			break;

		default:
			$this->_MODE = 'other';
			break;
	}
}

function set_header($value)
{
	$this->_HEADER = $value;
}

function set_generator($value)
{
	$this->_GENERATOR = $value;
}

function set_generator_uri($value)
{
	$this->_GENERATOR_URI = $value;
}

function set_category($value)
{
	$this->_CATEGORY = $value;
}

function set_template($value)
{
	$this->_TEMPLATE = $value;
}

function set_rdf_template($value)
{
	$this->_RDF_TEMPLATE = $value;
}

function set_rss_template($value)
{
	$this->_RSS_TEMPLATE = $value;
}

function set_atom_template($value)
{
	$this->_ATOM_TEMPLATE = $value;
}

function set_title($value)
{
	$this->_TITLE = $value;
}

function set_rdf_title($value)
{
	$this->_RDF_TITLE = $value;
}

function set_rss_title($value)
{
	$this->_RSS_TITLE = $value;
}

function set_atom_title($value)
{
	$this->_ATOM_TITLE = $value;
}

//=========================================================
// private
//=========================================================
function _init_site_information()
{
	$this->set_site_name(         $this->get_default_site_name() );
	$this->set_site_desc(         $this->get_default_site_desc() );
	$this->set_site_url(          $this->get_default_site_url() );
	$this->set_site_tag(          $this->get_default_site_tag() );
	$this->set_site_year(         $this->get_default_site_year() );
	$this->set_site_link_self(    $this->get_default_site_link_self() );
	$this->set_site_author_name(  $this->get_default_site_author_name() );
	$this->set_site_author_email( $this->get_default_site_author_email() );
	$this->set_site_author_uri(   $this->get_default_site_author_uri() );
	$this->set_site_copyright(    $this->build_site_copyright() );
}

function _assign( &$tpl )
{
	switch ( $this->_MODE )
	{
		case 'rdf':
			$this->_assign_rdf( $tpl );
			break;

		case 'atom':
			$this->_assign_atom( $tpl );
			break;

		case 'rss':
			$this->_assign_rss( $tpl );
			break;

		case 'other':
		default:
			$this->_assign_other( $tpl );
			break;
	}
}

function _get_template()
{
	switch ( $this->_MODE )
	{
		case 'rdf':
			$ret = $this->_RDF_TEMPLATE;
			break;

		case 'atom':
			$ret = $this->_ATOM_TEMPLATE;
			break;

		case 'rss':
			$ret = $this->_RSS_TEMPLATE;
			break;

		case 'other';
		default:
			$ret = $this->_TEMPLATE;
			break;
	}
	return $ret;
}

function _get_title()
{
	switch ( $this->_MODE )
	{
		case 'rdf':
			$ret = $this->_RDF_TITLE;
			break;

		case 'atom':
			$ret = $this->_ATOM_TITLE;
			break;

		case 'rss':
		default:
			$ret = $this->_RSS_TITLE;
			break;
	}
	return $ret;
}

// --------------------------------------------------------
// meke title
// --------------------------------------------------------
function _build_xml_title($title, $flag_char=1, $flag_numeric=1)
{
	if ($flag_char)
	{
		$title = $this->_strip_html_entity_char( $title );
	}

	if ($flag_numeric)
	{
		$title = $this->_strip_html_entity_numeric($title);
	}

	$title = $this->_xml_htmlspecialchars($title);

	return $title;
}

// --------------------------------------------------------
// meke content
// --------------------------------------------------------
function _build_xml_content($content, $flag_control=1, $flag_undo=1)
{
	if ($flag_control)
	{
		$content = $this->_strings->strip_control($content);
	}

	if ($flag_undo)
	{
		$content = $this->_undo_html_special_chars($content);
	}

// not sanitize
	$cont = $this->_convert_cdata($content);

	return $cont;
}

function _convert_cdata($text)
{
	$text = preg_replace("/]]>/", ']]&gt;', $text);
	return $text;
}

// --------------------------------------------------------
// meke summary
// --------------------------------------------------------
function _build_xml_summary($sum, $flag_char=1, $flag_numeric=1, $flag_control=1, $flag_undo=1, $flag_return=1, $flag_tab=1, $flag_style=1, $flag_space=1)
{
	if ($flag_char)
	{
		$sum = $this->_strip_html_entity_char($sum);
	}

	if ($flag_numeric)
	{
		$sum = $this->_strip_html_entity_numeric($sum);
	}

	if ($flag_control)
	{
		$sum = $this->_strings->strip_control($sum);
	}

	if ($flag_undo)
	{
		$sum = $this->_undo_html_special_chars($sum);
	}

	if ($flag_return)
	{
		$sum = $this->_strings->strip_return($sum);
	}

	if ($flag_tab)
	{
		$sum = $this->_strings->strip_tab($sum);
	}

	if ($flag_style)
	{
		$sum = $this->_strings->strip_style_tag($sum);
	}

	$sum = strip_tags($sum);

	if ($flag_space)
	{
		$sum = $this->_strings->strip_space($sum);
	}

	$sum = $this->_strings->shorten_text($sum, $this->_max_summary );
	$sum = $this->_xml_htmlspecialchars($sum);

	return $sum;
}

// --------------------------------------------------------
// htmlspecialchars
// http://www.w3.org/TR/REC-xml/#dt-markup
// http://www.fxis.co.jp/xmlcafe/tmp/rec-xml.html#dt-markup
//   &  -> &amp;	// without html entity
//   <  -> &lt;
//   >  -> &gt;
//   "  -> &quot;
//   '  -> &apos;
// --------------------------------------------------------
function _xml($text)
{
	$ret = $this->_xml_htmlspecialchars_strict($text);
	return $ret;
}

function _xml_url($text)
{
	$ret = $this->_xml_htmlspecialchars_url($text);
	return $ret;
}

function _xml_htmlspecialchars($text)
{
	$text = htmlspecialchars($text);
	$text = preg_replace("/'/", '&apos;', $text);
	return $text;
}

function _xml_htmlspecialchars_strict($text)
{
	$text = $this->_strip_html_entity_char($text);
	$text = $this->_xml_htmlspecialchars($text);
	return $text;
}

function _xml_htmlspecialchars_url($text)
{
	$text = preg_replace("/&amp;/sU", '&', $text);
	$text = $this->_strip_html_entity_char($text);
	$text = $this->_xml_htmlspecialchars($text);
	return $text;
}

// --------------------------------------------------------
// undo XOOPS HtmlSpecialChars
//   &lt;   -> <
//   &gt;   -> >
//   &quot; -> "
//   &#039; -> '
//   &amp;  -> &
//   &amp;nbsp; -> &nbsp;
// --------------------------------------------------------
function _undo_html_special_chars($text)
{
	$text = preg_replace("/&gt;/i",   '>', $text);
	$text = preg_replace("/&lt;/i",   '<', $text);
	$text = preg_replace("/&quot;/i", '"', $text);
	$text = preg_replace("/&#039;/i", "'", $text);	
	$text = preg_replace("/&amp;nbsp;/i", '&nbsp;', $text);
	return $text;
}

// --------------------------------------------------------
// undo html entities
//   &amp;abc;  -> &abc;
// --------------------------------------------------------
function _undo_html_entity_char($text)
{
	$ret = preg_replace("/&amp;([0-9a-zA-z]+);/sU", '&\\1;', $text);
	return $ret;
}

// --------------------------------------------------------
// undo html entities
//   &amp;#123; -> &#123;
// --------------------------------------------------------
function _undo_html_entity_numeric($text)
{
	$ret = preg_replace("/&amp;#([0-9a-fA-F]+);/sU", '&#\\1;', $text);
	return $ret;
}

// --------------------------------------------------------
// strip html entities
//   &abc; -> ' '
// --------------------------------------------------------
function _strip_html_entity_char($text)
{
	$ret = preg_replace("/&[0-9a-zA-z]+;/sU", ' ', $text);
	return $ret;
}

// --------------------------------------------------------
// strip html entities
//   &#123; -> ' '
// --------------------------------------------------------
function _strip_html_entity_numeric($text)
{
	$ret = preg_replace("/&amp;#([0-9a-fA-F]+);/sU", '&#\\1;', $text);
	return $ret;
}

//---------------------------------------------------------
// http://www.w3.org/TR/NOTE-datetime
// 2003-12-13T18:30:02+09:00
//
// http://www.php.net/manual/ja/function.date.php
// User Contributed Notes
//---------------------------------------------------------
function _iso8601_date($time)
{
	$tzd  = date('O',$time);
	$tzd  = substr( chunk_split( $tzd, 3, ':' ), 0, 6 );
	$date = date('Y-m-d\TH:i:s', $time) . $tzd;
	return $date;
}

//-----------------------------------------------
// use convert class
//-----------------------------------------------
function _utf8( $text )
{
	$ret = $this->_convet_to_utf8( $text );
	return $ret;
}

function _convet_to_utf8( $text )
{
	$text = $this->_convert->convert($text, 'utf-8', _CHARSET);

	if ( $this->_FLAG_UTF8_STRIP_CONTROL )
	{
		$text = $this->_strings->strip_control( $text );
	}

	return $text;
}

//=========================================================
// assign to template
//=========================================================

//---------------------------------------------------------
// http://web.resource.org/rss/1.0/spec
// required paramter
// channel elements 
//   - title
//   - link
// item elements
//   - title
//   - link
//---------------------------------------------------------
function _assign_rdf( &$tpl )
{
	$channel = $this->_build_rdf_channel();
	$items   = $this->_build_rdf_items();

	$tpl->assign('xml_lang',       $this->_utf8( $channel['xml_lang'] ) );
	$tpl->assign('channel_title',  $this->_utf8( $channel['title'] ) );
	$tpl->assign('channel_link',   $this->_utf8( $channel['link']  ));
	$tpl->assign('channel_description',  $this->_utf8( $channel['description']  ));
	$tpl->assign('channel_dc_language',  $this->_utf8( $channel['dc_language'] ) );
	$tpl->assign('channel_dc_date',      $this->_utf8( $channel['dc_date'] ) );

	foreach ($items as $item)
	{
		$tpl->append('items', 
			array(
				'link'        => $this->_utf8( $item['link'] ),
				'title'       => $this->_utf8( $item['title'] ),
				'description' => $this->_utf8( $item['description'] ),
				'dc_subject'  => $this->_utf8( $item['dc_subject'] ),
				'dc_creator'  => $this->_utf8( $item['dc_creator'] ), 
				'dc_date'     => $this->_utf8( $item['dc_date'] ), 
				'content_encoded' => $this->_utf8( $item['content_encoded'] ),
			));
	}

}

function _build_rdf_channel()
{
	$ret = $this->_build_common_channel();
	return $ret;
}

function _build_rdf_items()
{
	$arr = array();
	$this->_count_line = 1;

	if ( is_array($this->_items) && count($this->_items) )
	{
		foreach ($this->_items as $item)
		{
			$arr[] = $this->_build_rdf_item( $item );
			$this->_count_line ++;
		}
	}

	return $arr;
}

function _build_rdf_item( $item )
{
	$ret = $this->_build_common_item( $item );
	return $ret;
}

//---------------------------------------------------------
// http://blogs.law.harvard.edu/tech/rss
// required paramter
// channel elements 
//   - title
//   - link
//   - description
// item elements
//   - title
//   - link
//   - description
//---------------------------------------------------------
function _assign_rss( &$tpl )
{
	$channel = $this->_build_rss_channel();
	$items   = $this->_build_rss_items();

	$tpl->assign('channel_title',      $this->_utf8( $channel['title'] ) );
	$tpl->assign('channel_link',       $this->_utf8( $channel['link']  ));
	$tpl->assign('channel_docs',       $this->_utf8( $channel['docs'] ) );
	$tpl->assign('channel_generator',  $this->_utf8( $channel['generator'] ) );
	$tpl->assign('channel_category',   $this->_utf8( $channel['category'] ) );
	$tpl->assign('channel_copyright',  $this->_utf8( $channel['copyright'] ) );
	$tpl->assign('channel_language',   $this->_utf8( $channel['language'] ) );
	$tpl->assign('channel_webmaster',  $this->_utf8( $channel['webmaster'] ) );
	$tpl->assign('channel_lastbuild',  $this->_utf8( $channel['lastbuild'] ) );
	$tpl->assign('channel_pubdate',    $this->_utf8( $channel['pubdate'] ) );
	$tpl->assign('channel_description',    $this->_utf8( $channel['description']  ));
	$tpl->assign('channel_managingeditor', $this->_utf8( $channel['managingeditor'] ) );

	$tpl->assign('image_url',    $this->_utf8( $channel['image_url'] ) );
	$tpl->assign('image_width',  $this->_utf8( $channel['image_width'] ) );
	$tpl->assign('image_height', $this->_utf8( $channel['image_height'] ) );
	$tpl->assign('image_title',  $this->_utf8( $channel['image_title']  ));
	$tpl->assign('image_link',   $this->_utf8( $channel['image_link'] ) );

	foreach ($items as $item)
	{
		$tpl->append('items', 
			array(
				'link'        => $this->_utf8( $item['link'] ),
				'guid'        => $this->_utf8( $item['guid'] ),
				'title'       => $this->_utf8( $item['title'] ),
				'description' => $this->_utf8( $item['description'] ),
				'category'    => $this->_utf8( $item['category'] ),
				'pubdate'     => $this->_utf8( $item['pubdate'] ), 

// for future
//				'dc_creator'      => $this->_utf8( $item['dc_creator'] ), 
//				'content_encoded' => $this->_utf8( $item['content_encoded'] ),
			));
	}

}

function _build_rss_channel()
{
	$channel = $this->_build_common_channel();

	$channel['pubdate'] = $channel['date_rfc822'];

// lastbuild
	$updated_unix = $this->_get_last_updated_unix( $this->_items );
	if ( $updated_unix )
	{
		$channel['lastbuild'] = date("r", $updated_unix );
	}
	else
	{
		$channel['lastbuild'] = '';
	}

	return $channel;
}

function _build_rss_items()
{
	$arr = array();
	$this->_count_line = 1;

	if ( is_array($this->_items) && count($this->_items) )
	{
		foreach ($this->_items as $item)
		{
			$arr[] = $this->_build_rss_item( $item );
			$this->_count_line ++;
		}
	}

	return $arr;
}

function _build_rss_item( $item )
{
	$arr = $this->_build_common_item( $item );

// guid
	if ( empty($arr['guid']) )
	{
		$arr['guid'] = $arr['link'];
	}

// date
	$arr['pubdate'] = $arr['date_rfc822'];

	return $arr;
}

//---------------------------------------------------------
// http://www.mnot.net/drafts/draft-nottingham-atom-format-02.html
// required paramter
// feed elements 
//   - id
//   - title
//   - updated
//   - author name
// entry elements 
//   - id
//   - title
//   - updated
//   - author name
//   - summary or content
//---------------------------------------------------------
function _assign_atom( &$tpl )
{
	$channel = $this->_build_atom_channel();
	$entrys  = $this->_build_atom_entrys();

	$tpl->assign('xml_lang',           $this->_utf8( $channel['xml_lang'] ) );
	$tpl->assign('feed_title',         $this->_utf8( $channel['title'] ) );
	$tpl->assign('feed_link_alt',      $this->_utf8( $channel['link_alt']  ));
	$tpl->assign('feed_link_self',     $this->_utf8( $channel['link_self'] ) );
	$tpl->assign('feed_id',            $this->_utf8( $channel['id'] ) );
	$tpl->assign('feed_generator',     $this->_utf8( $channel['generator'] ) );
	$tpl->assign('feed_generator_uri', $this->_utf8( $channel['generator_uri'] ) );
	$tpl->assign('feed_rights',        $this->_utf8( $channel['rights'] ) );
	$tpl->assign('feed_author_name',   $this->_utf8( $channel['author_name'] ) );
	$tpl->assign('feed_author_uri',    $this->_utf8( $channel['author_uri'] ) );
	$tpl->assign('feed_author_email',  $this->_utf8( $channel['author_email'] ) );
	$tpl->assign('feed_updated',       $this->_utf8( $channel['updated'] ) );

	foreach ($entrys as $entry)
	{
		$tpl->append('entrys', 
			array(
				'title'        => $this->_utf8( $entry['title'] ),
				'link'         => $this->_utf8( $entry['link'] ),
				'id'           => $this->_utf8( $entry['id'] ), 
				'summary'      => $this->_utf8( $entry['summary'] ),
				'category'     => $this->_utf8( $entry['category'] ),
				'content'      => $this->_utf8( $entry['content'] ),
				'author_name'  => $this->_utf8( $entry['author_name'] ),
				'author_uri'   => $this->_utf8( $entry['author_uri'] ),
				'author_email' => $this->_utf8( $entry['author_email'] ),
				'updated'      => $this->_utf8( $entry['updated'] ),
				'published'    => $this->_utf8( $entry['published'] ),
			));
	}
}

function _build_atom_channel()
{
	$channel = $this->_build_common_channel();

// atom id
	$site_id = "tag:".$this->_site_tag.",".$this->_site_year."://1";
	$channel['id'] = $this->_xml( $site_id );

// date
	$channel['updated'] = $channel['date_iso8601'];

	return $channel;
}

function _build_atom_entrys()
{
	$arr = array();
	$this->_count_line = 1;

	if ( is_array($this->_items) && count($this->_items) )
	{
		foreach ($this->_items as $entry)
		{
			$arr[] = $this->_build_atom_entry( $entry );
			$this->_count_line ++;
		}
	}

	return $arr;
}

function _build_atom_entry( $entry )
{
	$arr = $this->_build_common_item( $entry );

// title
	$arr['title'] = $this->_build_xml_title($entry['title'], 0, 0);

// must content or summary
	if ( empty($arr['content']) && empty($arr['summary']) )
	{
		$arr['summary'] = $arr['title'];
	}

// must author_name
	if ( empty($arr['author_name']) )
	{
		$arr['author_name']  = $this->_xml( $this->_site_author_name );
		$arr['author_uri']   = '';
		$arr['author_email'] = '';
	}

// atom id
	if ( $arr['entry_id'] )
	{
		$arr['id'] = $arr['entry_id'];
	}
	else
	{
		$arr['id'] = $this->_xml( $this->build_entry_id() );
	}

// date
	$arr['updated']   = $arr['updated_iso8601'];
	$arr['published'] = $arr['published_iso8601'];

	return $arr;
}

//---------------------------------------------------------
// common
//---------------------------------------------------------
function _build_common_channel()
{
	$site_url_xml          = $this->_xml_url( $this->_site_url );
	$site_author_email_xml = $this->_xml( $this->_site_author_email );
	$site_copyright_xml    = $this->_xml( $this->_site_copyright );
	$language_xml          = $this->_xml( _LANGCODE );

	$time             = time();
	$date_rfc822_xml  = $this->_xml( date("r", $time ) );
	$date_iso8601_xml = $this->_xml( $this->_iso8601_date( $time ) );

	$ret = array(
//url
		'link'           => $site_url_xml,
		'link_alt'       => $site_url_xml,
		'author_uri'     => $site_url_xml,
		'link_self'      => $this->_xml_url( $this->_site_link_self ),
		'image_url'      => $this->_xml_url( $this->_site_image_url ),
		'image_link'     => $this->_xml_url( $this->_site_image_link ),

// text
		'generator_uri'  => $this->_xml_url( $this->_GENERATOR_URI ),
		'language'       => $language_xml,
		'copyright'      => $site_copyright_xml,
		'rights'         => $site_copyright_xml,
		'author_email'   => $site_author_email_xml,
		'webmaster'      => $site_author_email_xml,
		'managingeditor' => $site_author_email_xml,
		'title'          => $this->_xml( $this->_site_name ),
		'description'    => $this->_xml( $this->_site_desc ),
		'generator'      => $this->_xml( $this->_GENERATOR ),
		'category'       => $this->_xml( $this->_CATEGORY ),
		'docs'           => $this->_xml( $this->_RSS_DOCS ),
		'author_name'    => $this->_xml( $this->_site_author_name ),
		'author_uri'     => $this->_xml( $this->_site_author_uri ),
		'image_width'    => $this->_xml( $this->_site_image_width ),
		'image_height'   => $this->_xml( $this->_site_image_height ),
		'image_title'    => $this->_xml( $this->_site_image_title ),

// time
		'date_unix'      => $time,
		'date_rfc822'    => $date_rfc822_xml,
		'date_iso8601'   => $date_iso8601_xml,

		'xml_lang'       => $language_xml,
		'dc_language'    => $language_xml,
		'dc_date'        => $date_iso8601_xml,
	);

	return $ret;
}

function _get_last_updated_unix( $items )
{
	$time = false;
	if ( isset($items[0]['updated_unix']) )
	{
		$time = $items[0]['updated_unix'];
	}
	return $time;
}

//=========================================================
// over ride
//=========================================================
function _assign_other( &$tpl )
{
	// dummy
}

function _build_common_item( $item )
{
	// dummy
}

// --- class end ---
}

?>