<?php
// $Id: date.php,v 1.2 2007/10/23 01:33:00 ohwada Exp $

//=========================================================
// Happy Linux Framework Module
// 2007-10-10 K.OHWADA
//=========================================================

//=========================================================
// class happy_linux_time
//=========================================================
class happy_linux_date
{

//---------------------------------------------------------
// constructor
//---------------------------------------------------------
function happy_linux_date()
{
	// dummy
}

function &getInstance()
{
	static $instance;
	if (!isset($instance)) 
	{
		$instance = new happy_linux_date();
	}
	return $instance;
}

//---------------------------------------------------------
// public
//---------------------------------------------------------
function set_default_timezone_by_xoops_default_timezone()
{
	$hour = $this->get_xoops_default_tz_hour();
	$tz   = $this->get_timezone_name_by_hour( $hour );
	if ( $tz )
	{
		return $this->set_default_timezone( $tz );
	}
	return false;
}

function get_timezone_name_by_hour( $hour )
{
// first try
	$tz = $this->get_timezone_name_by_hour_list( $hour );
	if ( $tz )
	{	return $tz;	}

// second try
	$tz  = $this->get_timezone_name_by_abbr( $hour );
	if ( $tz )
	{	return $tz;	}

// third try
	$tz = $this->get_timezone_name_by_abbreviations_list( $hour );
	if ( $tz )
	{	return $tz;	}

	return false;
}

function get_timezone_name_by_hour_list( $hour )
{
	$hour_10   =  10 * $hour;
	$hour_list =& $this->get_timezone_hour_list();
	$iden_list =& $this->get_timezone_identifiers_list();

	if ( isset( $hour_list[ $hour_10 ] )&& is_array($iden_list) && count($iden_list) )
	{
// check avilable
		$tz = $hour_list[ $hour_10 ];
		if ( in_array( $tz, $iden_list ) )
		{	return $tz;	}
	}

	return false;
}

function &get_timezone_hour_list()
{
	$arr = array(
		'-120' => 'Pacific/Kwajalein',
		'-115' => 'Pacific/Samoa',
		'-110' => 'Pacific/Midway',
		'-105' => 'US/Hawaii',
		'-100' => 'US/Hawaii',
		'-95'  => 'Pacific/Marquesas',
		'-90'  => 'US/Alaska',
		'-80'  => 'US/Pacific', 
		'-70'  => 'US/Mountain',
		'-60'  => 'US/Central',
		'-50'  => 'US/Eastern',
		'-45'  => 'America/Curacao',
		'-40'  => 'Brazil/West', 
		'-35'  => 'Canada/Newfoundland',
		'-30'  => 'Brazil/East',
		'-20'  => 'America/Noronha',
		'-10'  => 'Atlantic/Azores',
		'00'   => 'UTC',
		'10'   => 'Europe/Paris', 
		'20'   => 'Europe/Helsinki', 
		'25'   => 'Africa/Mogadishu',
		'30'   => 'Europe/Moscow', 
		'35'   => 'Asia/Tehran',
		'40'   => 'Asia/Dubai', 
		'45'   => 'Asia/Kabul',
		'50'   => 'Asia/Karachi',
		'55'   => 'Asia/Calcutta',
		'60'   => 'Asia/Dacca',
		'65'   => 'Asia/Calcutta',
		'70'   => 'Asia/Bangkok',
		'75'   => 'Asia/Brunei',
		'80'   => 'Singapore',
		'85'   => 'Asia/Harbin',
		'90'   => 'Japan',
		'95'   => 'Australia/Adelaide',
		'100'  => 'Australia/Melbourne', 
		'105'  => 'Australia/Lord_Howe',
		'110'  => 'Pacific/Guadalcanal',
		'115'  => 'Pacific/Norfolk',
		'120'  => 'Pacific/Auckland', 
	);
	return $arr;
}

function get_timezone_name_by_abbr( $hour )
{
	return $this->get_timezone_name_from_abbr( '', (3600 * $hour), 0 );
}

function get_timezone_name_by_abbreviations_list( $hour )
{
	$sec = 3600 * $hour;

	$list = $this->get_timezone_abbreviations_list( $hour );
	if ( !$list )
	{	return false;	}

	foreach ( $list as $a )
	{
		foreach ( $a as $b )
		{
			if ( $b['offset'] == $sec )
			{
				return $b['timezone_id'];
			}
		}
	}

	return false;
}

//---------------------------------------------------------
// http://www.faqs.org/rfcs/rfc2822
// Thu, 21 Dec 2000 16:01:07 +0200
//
// http://www.php.net/manual/ja/function.date.php
//---------------------------------------------------------
function date_rfc822_user( $time, $timeoffset='' )
{
	return $this->date_rfc822( $this->get_user_timestamp($time, $timeoffset) );
}

function date_rfc822( $time )
{
	return date('r', $time );
}

//---------------------------------------------------------
// http://www.w3.org/TR/NOTE-datetime
// 2003-12-13T18:30:02+09:00
//
// http://www.php.net/manual/ja/function.date.php
// User Contributed Notes
//
// PHP 5 support iso8601 format: date('c')
//---------------------------------------------------------
function date_iso8601_user( $time, $timeoffset='' )
{
	return $this->date_iso8601( $this->get_user_timestamp($time, $timeoffset) );
}

function date_iso8601( $time )
{
	$tzd  = date('O',$time);
	$tzd  = substr( chunk_split( $tzd, 3, ':' ), 0, 6 );
	$date = date('Y-m-d\TH:i:s', $time) . $tzd;
	return $date;
}

function date_year_user( $time=null, $timeoffset='' )
{
	if ( empty($time) )
	{
		$time = time();
	}
	$date = date("Y", $this->get_user_timestamp($time, $timeoffset) );
	return $date;
}

//---------------------------------------------------------
// PHP 5.1 support this function
//---------------------------------------------------------
function set_default_timezone( $tz )
{
	if ( function_exists('date_default_timezone_set') )
	{
		return date_default_timezone_set( $tz );
	}
	return false;
}

function get_default_timezone()
{
	$tz = false;
	if ( function_exists('date_default_timezone_get') )
	{
		$tz = date_default_timezone_get();
	}
	return $tz;
}

function &get_timezone_abbreviations_list()
{
	$arr = false;
	if ( function_exists('timezone_abbreviations_list') )
	{
		$arr = timezone_abbreviations_list();
	}
	return $arr;
}

function &get_timezone_identifiers_list()
{
	$arr = false;
	if ( function_exists('timezone_identifiers_list') )
	{
		$arr = timezone_identifiers_list();
	}
	return $arr;
}

function get_timezone_name_from_abbr( $abbr, $offset=null, $isdst=null )
{
	$tz = false;
	if ( function_exists('timezone_name_from_abbr') )
	{
		if ( $offset === null ) {
			$tz = timezone_name_from_abbr( $abbr );
		} elseif ( $isdst === null ) {
			$tz = timezone_name_from_abbr( $abbr, $offset );
		} else {
			$tz = timezone_name_from_abbr( $abbr, $offset, $isdst );
		}
	}
	return $tz;
}

//---------------------------------------------------------
// XOOPS variable
//---------------------------------------------------------
function get_xoops_server_tz_hour()
{
	global $xoopsConfig;
	return $xoopsConfig['server_TZ'];
}

function get_xoops_default_tz_hour()
{
	global $xoopsConfig;
	return $xoopsConfig['default_TZ'];
}

function get_user_timestamp( $time, $timeoffset='' )
{
	return xoops_getUserTimestamp( $time, $timeoffset );
}

// --- class end ---
}

?>