<?php
/* vim: set expandtab tabstop=4 shiftwidth=4 softtabstop=4: */

/**
 * メール転送設定画面表示アクションクラス
 *
 * @package     NetCommons
 * @author      Noriko Arai,Ryuji Masukawa
 * @copyright   2006-2007 NetCommons Project
 * @license     http://www.netcommons.org/license.txt  NetCommons License
 * @project     NetCommons Project, supported by National Institute of Informatics
 * @access      public
 */
class Pm_View_Main_Forward extends Action 
{
	// Filterによりセット
	var $block_id = null;
	var $room_id = null;
	var $room_arr = null;
	
	// 使用コンポーネントを受け取るため
	var $pmView = null;
	var $request = null;

	// 値をセットするため	
	var $current_menu = null;
	var $mail_no = null;
	var $mail_yes = null;
	var $no_email_flag = null;
	
    /**
     * メール転送設定画面表示アクション
     *
     * @access  public
     */
    function execute()
    {
    	$this->current_menu = PM_LEFTMENU_SETTING;
		$this->no_email_flag = false;
		$setting = $this->pmView->getMailSetting();
		if($setting == false){
			$this->mail_no = _ON;
			$this->mail_yes = _OFF;
			$this->no_email_flag = true;
		}else{
			$this->mail_no = ($setting['forward_state'] == _ON) ? _OFF : _ON;
			$this->mail_yes = ($setting['forward_state'] == _ON) ? _ON : _OFF;
		}
		
		return 'success';
    }
}
?>