#
# * Country/Zones Zen Cart SQL Load for MySQL databases
# * @package Installer
# * @access private
# * @copyright Copyright 2003-2011 Zen Cart Development Team
# * @copyright Portions Copyright 2003 osCommerce
# * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
# * @version $Id: mysql_utf8_japanese_localize.sql 19514 2012-04-20 13:32:00Z kimono $
#
# NOTE: UTF8 files need to be saved with encoding format set to UTF8-without-BOM.
#

#一般設定
UPDATE configuration SET configuration_value=1 WHERE configuration_key='ENTRY_FIRST_NAME_MIN_LENGTH';
UPDATE configuration SET configuration_value=1 WHERE configuration_key='ENTRY_LAST_NAME_MIN_LENGTH';
UPDATE configuration SET configuration_value=1 WHERE configuration_key='ENTRY_STREET_ADDRESS_MIN_LENGTH';
UPDATE configuration SET configuration_value = 'false' WHERE configuration_key = 'ACCOUNT_SUBURB';
UPDATE configuration SET configuration_value = 'true' WHERE configuration_key = 'DISPLAY_PRICE_WITH_TAX';
UPDATE configuration SET configuration_value = '107' WHERE configuration_key = 'SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY';

INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('お問い合わせ時の個人情報確認画面表示', 'DISPLAY_CONTACT_US_PRIVACY_CONDITIONS', 'true', 'お問い合わせする画面で個人情報の確認画面を表示します。<div style="color: red;">2005年4月1日に施行された「個人情報保護法」では、個人情報保護方針を開示することが求められています。</div>', '11', '3', 'zen_cfg_select_option(array(\'true\', \'false\'), ', now());

#マスターテーブル
#住所フォーマット追加
INSERT INTO address_format VALUES (7, '$firstname $lastname$cr$postcode$cr$state$city$cr$streets$cr$country$cr$telephone$cr$fax','$statename $city');

#通貨設定
UPDATE currencies SET value='0.012267' WHERE code='USD';
UPDATE currencies SET value='0.009331' WHERE code='EUR';
UPDATE currencies SET value='0.007638' WHERE code='GBP';
UPDATE currencies SET value='0.012202' WHERE code='CAD';
UPDATE currencies SET value='0.011877' WHERE code='AUD';
INSERT INTO currencies VALUES (6,'Japanese Yen','JPY','','円','.',',','0','1.000000', now());


#言語設定
INSERT INTO languages VALUES (2,'Japanese','ja','icon.gif','japanese',0);

#国設定
#住所フォーマットを変更
UPDATE countries SET address_format_id=7 WHERE countries_id=107;

#地域設定
# Japan
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'北海道','北海道');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'青森県','青森県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'岩手県','岩手県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'宮城県','宮城県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'秋田県','秋田県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'山形県','山形県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'福島県','福島県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'茨城県','茨城県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'栃木県','栃木県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'群馬県','群馬県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'埼玉県','埼玉県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'千葉県','千葉県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'東京都','東京都');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'神奈川県','神奈川県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'新潟県','新潟県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'富山県','富山県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'石川県','石川県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'福井県','福井県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'山梨県','山梨県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'長野県','長野県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'岐阜県','岐阜県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'静岡県','静岡県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'愛知県','愛知県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'三重県','三重県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'滋賀県','滋賀県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'京都府','京都府');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'大阪府','大阪府');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'兵庫県','兵庫県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'奈良県','奈良県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'和歌山県','和歌山県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'鳥取県','鳥取県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'島根県','島根県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'岡山県','岡山県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'広島県','広島県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'山口県','山口県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'徳島県','徳島県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'香川県','香川県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'愛媛県','愛媛県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'高知県','高知県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'福岡県','福岡県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'佐賀県','佐賀県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'長崎県','長崎県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'熊本県','熊本県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'大分県','大分県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'宮崎県','宮崎県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'鹿児島県','鹿児島県');
INSERT INTO zones (zone_country_id, zone_code, zone_name) VALUES (107,'沖縄県','沖縄県');

# 税金・税率設定
UPDATE tax_rates SET tax_rate = '5.0',tax_description = '消費税：5%' WHERE tax_rates_id = '1';
UPDATE geo_zones SET geo_zone_name = '日本',geo_zone_description = '日本（消費税）' WHERE geo_zone_id = '1';
UPDATE zones_to_geo_zones SET zone_country_id = '107',zone_id = NULL WHERE association_id = '1';
UPDATE tax_class SET tax_class_title = '消費税',tax_class_description = '消費税（日本）' WHERE tax_class_id = '1';

#注文ステータス
INSERT INTO orders_status VALUES ('1', '2', '処理待ち');
INSERT INTO orders_status VALUES ('2', '2', '処理中');
INSERT INTO orders_status VALUES ('3', '2', '配送済み');
INSERT INTO orders_status VALUES ('4', '2', '更新');


# 住所に電話番号を追加、個人情報側からは電話番号削除
ALTER TABLE address_book ADD COLUMN entry_telephone varchar(32) NOT NULL;
ALTER TABLE address_book ADD COLUMN entry_fax varchar(32);
ALTER TABLE orders ADD COLUMN delivery_telephone varchar(32);
ALTER TABLE orders ADD COLUMN delivery_fax varchar(32);
ALTER TABLE orders ADD COLUMN billing_telephone varchar(32);
ALTER TABLE orders ADD COLUMN billing_fax varchar(32);
ALTER TABLE orders ADD COLUMN customers_fax varchar(32);
ALTER TABLE customers CHANGE customers_telephone customers_telephone VARCHAR(32);
ALTER TABLE orders CHANGE customers_telephone customers_telephone VARCHAR(32);

# カナを追加する
ALTER TABLE address_book ADD entry_firstname_kana     varchar(32) NOT NULL default '';
ALTER TABLE address_book ADD entry_lastname_kana      varchar(32) NOT NULL default '';
ALTER TABLE customers    ADD customers_firstname_kana varchar(32) NOT NULL default '';
ALTER TABLE customers    ADD customers_lastname_kana  varchar(32) NOT NULL default '';
ALTER TABLE orders       ADD customers_name_kana      varchar(64) NOT NULL default '';
ALTER TABLE orders       ADD delivery_name_kana       varchar(64) NOT NULL default '';
ALTER TABLE orders       ADD billing_name_kana        varchar(64) NOT NULL default '';
INSERT INTO configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) VALUES ('ふりがなが必要な国', 'FURIKANA_NECESSARY_COUNTRIES', 'Japanese', 'ふりがなが必要な国名をカンマで区切って入力してください', '5', '100', '', now());

# 一般設定グループの翻訳
UPDATE configuration_group SET configuration_group_title = 'ショップ全般の設定', configuration_group_description = 'ショップの一般的な項目を設定します。' WHERE  configuration_group_id = '1';
UPDATE configuration_group SET configuration_group_title = '最小値の設定', configuration_group_description = '機能・データ類の最小(少)値について設定します。' WHERE  configuration_group_id = '2';
UPDATE configuration_group SET configuration_group_title = '最大値の設定', configuration_group_description = '機能・データ類の最大値について設定します。' WHERE  configuration_group_id = '3';
UPDATE configuration_group SET configuration_group_title = '画像の設定', configuration_group_description = '各種の画像について設定します。' WHERE  configuration_group_id = '4';
UPDATE configuration_group SET configuration_group_title = '顧客アカウントの設定', configuration_group_description = '顧客について各種の設定をします。' WHERE  configuration_group_id = '5';
UPDATE configuration_group SET configuration_group_title = 'モジュールの設定', configuration_group_description = '(設定画面では隠れています)' WHERE  configuration_group_id = '6';
UPDATE configuration_group SET configuration_group_title = '配送料・パッケージの設定', configuration_group_description = '拝承料・パッケージ(梱包)について各種の設定をします。' WHERE  configuration_group_id = '7';
UPDATE configuration_group SET configuration_group_title = '商品リストの設定', configuration_group_description = '商品リストの表示について各種の設定をします。' WHERE  configuration_group_id = '8';
UPDATE configuration_group SET configuration_group_title = '在庫の設定', configuration_group_description = '在庫について各種の設定をします。' WHERE  configuration_group_id = '9';
UPDATE configuration_group SET configuration_group_title = 'ログの設定', configuration_group_description = 'ログについて各種の設定をします。' WHERE  configuration_group_id = '10';
UPDATE configuration_group SET configuration_group_title = '規約関連の設定', configuration_group_description = '規約について各種の設定をします。' WHERE  configuration_group_id = '11';
UPDATE configuration_group SET configuration_group_title = 'メールの設定', configuration_group_description = 'メールの送受信や書式について各種の設定をします。' WHERE  configuration_group_id = '12';
UPDATE configuration_group SET configuration_group_title = '商品属性の設定', configuration_group_description = '商品属性について各種の設定をします。' WHERE  configuration_group_id = '13';
UPDATE configuration_group SET configuration_group_title = 'GZip圧縮の設定', configuration_group_description = 'GZip圧縮について設定します。' WHERE  configuration_group_id = '14';
UPDATE configuration_group SET configuration_group_title = 'セッション管理の設定', configuration_group_description = 'セッション情報の管理について各種の設定をします。' WHERE  configuration_group_id = '15';
UPDATE configuration_group SET configuration_group_title = 'ギフト券・クーポン券の設定', configuration_group_description = 'ギフト券・クーポン券について各種の設定をします。' WHERE  configuration_group_id = '16';
UPDATE configuration_group SET configuration_group_title = 'クレジットカードの設定', configuration_group_description = 'クレジットカードについて各種の設定をします。' WHERE  configuration_group_id = '17';
UPDATE configuration_group SET configuration_group_title = '商品情報の設定', configuration_group_description = '商品情報の表示について各種の設定をします。' WHERE  configuration_group_id = '18';
UPDATE configuration_group SET configuration_group_title = 'レイアウトの設定', configuration_group_description = 'ショップの表示レイアウトについて各種の設定をします。' WHERE  configuration_group_id = '19';
UPDATE configuration_group SET configuration_group_title = 'メンテナンス表示の設定', configuration_group_description = '「メンテナンス中」表示などについて各種の設定をします。' WHERE  configuration_group_id = '20';
UPDATE configuration_group SET configuration_group_title = '新着商品リストの設定', configuration_group_description = '新着商品リストについて各種の設定をします。' WHERE  configuration_group_id = '21';
UPDATE configuration_group SET configuration_group_title = 'おすすめ商品リストの設定', configuration_group_description = 'おすすめ商品リストについて各種の設定をします。' WHERE  configuration_group_id = '22';
UPDATE configuration_group SET configuration_group_title = '全商品リストの設定', configuration_group_description = '全商品リストについて各種の設定をします。' WHERE  configuration_group_id = '23';
UPDATE configuration_group SET configuration_group_title = 'トップページの表示設定', configuration_group_description = 'トップページの要素表示について各種の設定をします。' WHERE  configuration_group_id = '24';
UPDATE configuration_group SET configuration_group_title = '定番ページの表示設定', configuration_group_description = '定番ページとHTMLAreaなどについて各種の設定をします。' WHERE  configuration_group_id = '25';
UPDATE configuration_group SET configuration_group_title = 'EZ-Pagesの設定', configuration_group_description = 'EZページについて各種の設定をします。' WHERE  configuration_group_id = '30';

UPDATE configuration SET configuration_title='ショップ名', configuration_description='ショップ名を設定します。' WHERE configuration_key='STORE_NAME';
UPDATE configuration SET configuration_title='ショップオーナー名', configuration_description='ショップオーナー名(または運営管理者名)を設定します。' WHERE configuration_key='STORE_OWNER';
UPDATE configuration SET configuration_title='サポート電話窓口', configuration_description='サポート電話窓口の電話番号を入力してください。この番号は支払いモジュールによってはサポート電話窓口として決済会社に情報が送られる場合があります。例）paypalなど' WHERE configuration_key='STORE_TELEPHONE_CUSTSERVICE';
UPDATE configuration SET configuration_title='国', configuration_description='店舗が存在する国名を入力してください。<strong>注意：変更したら店舗のゾーンの更新を忘れずに行ってください。</strong>' WHERE configuration_key='STORE_COUNTRY';
UPDATE configuration SET configuration_title='地域', configuration_description='ショップの所在地域(県名)を設定します。' WHERE configuration_key='STORE_ZONE';
UPDATE configuration SET configuration_title='入荷予定商品のソート順', configuration_description='入荷予定商品のソート順を設定します。<br /><br />\r\n・asc(昇順)<br />\r\n・desc(降順)' WHERE configuration_key='EXPECTED_PRODUCTS_SORT';
UPDATE configuration SET configuration_title='入荷予定商品のソート順に用いるフィールド', configuration_description='入荷予定商品のソート順に使用するフィールドを設定します。<BR>・products_name:品名<BR>・date_expected:予定日' WHERE configuration_key='EXPECTED_PRODUCTS_FIELD';
UPDATE configuration SET configuration_title='表示言語と通貨の連動', configuration_description='表示言語と通貨の変更を連動させるかどうか設定します。<br /><br />true(連動)<br />false(非連動)' WHERE configuration_key='USE_DEFAULT_LANGUAGE_CURRENCY';
UPDATE configuration SET configuration_title='表示言語の選択', configuration_description='ショップのデフォルトの表示言語はショップの初期設定またはユーザーのブラウザ設定のどちらに基づくかを設定します。<br /><br />デフォルト：ショップの初期設定' WHERE configuration_key='LANGUAGE_DEFAULT_SELECTOR';
UPDATE configuration SET configuration_title='サーチエンジンフレンドリーなURL表記(開発中)', configuration_description='サーチエンジンに拾われやすい、静的HTMLのようなURL表記を行うかどうかを設定します。<br /><br />注意：Googleでは動的URLのクロールが強化されたため、あまり意味はないようです。' WHERE configuration_key='SEARCH_ENGINE_FRIENDLY_URLS';
UPDATE configuration SET configuration_title='商品の追加後にカートを表示', configuration_description='商品をカートに追加した直後にカートの内容を表示するか、または元ページにすぐ戻るかを設定します。<br /><br />\r\n・true (表示)<br />\r\n・false (非表示)' WHERE configuration_key='DISPLAY_CART';
UPDATE configuration SET configuration_title='デフォルトの検索演算子', configuration_description='デフォルトの検索演算子を設定します。' WHERE configuration_key='ADVANCED_SEARCH_DEFAULT_OPERATOR';
UPDATE configuration SET configuration_title='ショップの住所と電話番号', configuration_description='ショップ名、国名、住所、電話番号を設定します。' WHERE configuration_key='STORE_NAME_ADDRESS';
UPDATE configuration SET configuration_title='カテゴリ内の商品数を表示', configuration_description='カテゴリ内の商品数を下位カテゴリも含めてカウント表示するかどうかを設定します。<br /><br />\r\n・true (する)<br />\r\n・false (しない)' WHERE configuration_key='SHOW_COUNTS';
UPDATE configuration SET configuration_title='税額の小数点位置', configuration_description='税額の小数点以下の桁数を設定します。' WHERE configuration_key='TAX_DECIMAL_PLACES';
UPDATE configuration SET configuration_title='価格を税込みで表示', configuration_description='価格を税込みで表示するかどうかを設定します。<br /><br />\r\n・true = 価格を税込みで表示<br />\r\n・false = 税額をまとめて表示' WHERE configuration_key='DISPLAY_PRICE_WITH_TAX';
UPDATE configuration SET configuration_title='価格を税込みで表示 - 管理画面', configuration_description='管理画面で価格を税込みで表示するかどうかを設定します。<br /><br />\r\n・true = 価格を税込みで表示<br />\r\n・false = 最後に税額を表示', configuration_value = 'true' WHERE configuration_key='DISPLAY_PRICE_WITH_TAX_ADMIN';
UPDATE configuration SET configuration_title='商品にかかる税額の算定基準', configuration_description='商品にかかる税額を算出する際の基準を設定します。<br /><br />\r\n・Shipping …顧客(商品送付先)の住所<br />\r\n・Billing …顧客の請求先の住所<br />\r\n・Store …ショップの所在地による(送付先・請求先ともショップの所在地域である場合に有効)\r\n' WHERE configuration_key='STORE_PRODUCT_TAX_BASIS';
UPDATE configuration SET configuration_title='送料にかかる税額の算定基準', configuration_description='送料にかかる税金を算出する際の基準を設定します。<br /><br />\r\n・Shipping …顧客(商品送付先)の住所<br />\r\n・Billing …顧客の請求先の住所<br />\r\n・Store …ショップの所在地による(送付先・請求先ともショップの所在地域である場合に有効)<br />\r\n注意：この設定は配送モジュールによってオーバーライド(上書き設定)が可能です。' WHERE configuration_key='STORE_SHIPPING_TAX_BASIS';
UPDATE configuration SET configuration_title='税金の表示', configuration_description='合計額が0円でも税金を表示しますか?<br />0= Off<br />1= On' WHERE configuration_key='STORE_TAX_DISPLAY_STATUS';
UPDATE configuration SET configuration_title='税金の分割表示', configuration_description='税金が複数の種類があった場合、チェックアウトの際、別々に表示するかどうかを設定します。<br /><br />\r\n・true = 税金を別々に表示<br />\r\n・false = 税金をまとめて表示' WHERE configuration_key='SHOW_SPLIT_TAX_CHECKOUT';
UPDATE configuration SET configuration_title='管理画面のタイムアウト設定(秒数)', configuration_description='管理画面がタイムアウトするまでの秒数を設定します。デフォルトは3600秒＝1時間です。<br />あまり短めに設定すると商品登録中などにタイムアウトしてしまいますので注意。<br />900秒未満を設定すると900秒に自動的に設定されます。' WHERE configuration_key='SESSION_TIMEOUT_ADMIN';
UPDATE configuration SET configuration_title='管理画面のプログラム処理の上限時間設定(秒)\r\n', configuration_description='管理画面においてなんらかの操作を行った場合の、プログラム処理の強制終了時間を設定します。デフォルトは60秒＝1分。この設定は、プログラム処理時間に問題がある場合などにだけ変更してください。\r\n' WHERE configuration_key='GLOBAL_SET_TIME_LIMIT';
UPDATE configuration SET configuration_title='Zen Cart新バージョンの自動チェック(ヘッダで告知するか否か)', configuration_description='Zen Cartの新バージョンがリリースされた場合、ヘッダに情報を表示しますか?<br /><br />\r\n注意：この設定をオンにすると、管理者ページの表示が遅くなる場合があります。インターネットに繋がっていないテスト環境などではfalseにしてください。\r\n' WHERE configuration_key='SHOW_VERSION_UPDATE_IN_HEADER';
UPDATE configuration SET configuration_title='ショップのステータス', configuration_description='ショップの状態を設定します。<br /><br />\r\n・0＝通常のショップ<br />\r\n・1＝価格表示なしのデモショップ<br />\r\n・2＝価格表示付きのデモショップ\r\n' WHERE configuration_key='STORE_STATUS';
UPDATE configuration SET configuration_title='サーバの稼動時間(アップタイム)', configuration_description='サーバの稼働時間を表示するかどうかを設定します。この情報はいくつかのサーバでエラーログとして残ることがあります。<br /><br />true＝表示<br /><br />false＝非表示' WHERE configuration_key='DISPLAY_SERVER_UPTIME';
UPDATE configuration SET configuration_title='リンク切れページのチェック', configuration_description='Zen Cartがリンク切れページを検知した際に自動的にトップページに転送しますか?<br /><br />\r\n・On = オン<br />\r\n・Off = オフ<br />\r\n・Page Not Found = ページが見つかりません画面へ遷移する<br />\r\n<br />\r\n注意：デバックの際などにはこの機能をオフにするとよいでしょう。' WHERE configuration_key='MISSING_PAGE_CHECK';
UPDATE configuration SET configuration_title='通貨換算比率', configuration_description='為替レートの更新を行う際、あなたのショップにて換算する比率を加えますか?<br />為替レートは、為替レートサーバーから情報を得てきます。その為替レートにいくらの比率を上乗せするか決めます。<br /><br /><strong>デフォルト: 1.05</strong><br />これは、あなたのショップにて為替レートに1.05％上乗せするということになります。' WHERE configuration_key='CURRENCY_UPLIFT_RATIO';
UPDATE configuration SET configuration_title='HTMLエディタ', configuration_description='メールマガジンや商品説明などで用いるHTML/リッチテキスト用のソフトウェアを設定します。' WHERE configuration_key='HTML_EDITOR_PREFERENCE';
UPDATE configuration SET configuration_title='phpBBへのリンクを表示', configuration_description='Zen Cart上に(インストール済みの)phpBBのフォーラムへのリンクを表示するかどうかを設定します。\r\n' WHERE configuration_key='PHPBB_LINKS_ENABLED';
UPDATE configuration SET configuration_title='カテゴリ内の商品数を表示 - 管理画面', configuration_description='カテゴリ内の商品数を下位カテゴリも含めてカウント表示しますか?<br /><br />\r\n・true (する)<br />\r\n・false (しない)' WHERE configuration_key='SHOW_COUNTS_ADMIN';
UPDATE configuration SET configuration_title='名前の最小文字数', configuration_description='名前の文字数の最小値を設定します。' WHERE configuration_key='ENTRY_FIRST_NAME_MIN_LENGTH';
UPDATE configuration SET configuration_title='姓の最小文字数', configuration_description='姓の文字数の最小値を設定します。' WHERE configuration_key='ENTRY_LAST_NAME_MIN_LENGTH';
UPDATE configuration SET configuration_title='生年月日の最小文字数', configuration_description='生年月日の文字数の最小値を設定します。' WHERE configuration_key='ENTRY_DOB_MIN_LENGTH';
UPDATE configuration SET configuration_title='メールアドレスの最小文字数', configuration_description='メールアドレスの文字数の最小値を設定します。' WHERE configuration_key='ENTRY_EMAIL_ADDRESS_MIN_LENGTH';
UPDATE configuration SET configuration_title='住所の最小文字数', configuration_description='番地・マンション・アパート名の最小文字数を設定します。' WHERE configuration_key='ENTRY_STREET_ADDRESS_MIN_LENGTH';
UPDATE configuration SET configuration_title='会社名の最小文字数', configuration_description='会社名の文字数の最小値を設定します。' WHERE configuration_key='ENTRY_COMPANY_MIN_LENGTH';
UPDATE configuration SET configuration_title='郵便番号の最小文字数', configuration_description='郵便番号の文字数の最小値を設定します。' WHERE configuration_key='ENTRY_POSTCODE_MIN_LENGTH';
UPDATE configuration SET configuration_title='市区町村の最小文字数', configuration_description='市区町村の文字数の最小値を設定します。' WHERE configuration_key='ENTRY_CITY_MIN_LENGTH';
UPDATE configuration SET configuration_title='都道府県名の最小文字数', configuration_description='都道府県の文字数の最小値を設定します。' WHERE configuration_key='ENTRY_STATE_MIN_LENGTH';
UPDATE configuration SET configuration_title='電話番号の最小文字数', configuration_description='電話番号の文字数の最小値を設定します。' WHERE configuration_key='ENTRY_TELEPHONE_MIN_LENGTH';
UPDATE configuration SET configuration_title='パスワードの最小文字数', configuration_description='パスワードの文字数の最小値を設定します。' WHERE configuration_key='ENTRY_PASSWORD_MIN_LENGTH';
UPDATE configuration SET configuration_title='クレジットカード名義の最小文字数', configuration_description='クレジットカード所有者名の文字数の最小値を設定します。' WHERE configuration_key='CC_OWNER_MIN_LENGTH';
UPDATE configuration SET configuration_title='クレジットカード番号の最小文字数', configuration_description='クレジットカード番号の文字数の最小値を設定します。' WHERE configuration_key='CC_NUMBER_MIN_LENGTH';
UPDATE configuration SET configuration_title='クレジットカードCVV番号の最小文字数', configuration_description='クレジットカードCVV番号の文字数の最小値を設定します。' WHERE configuration_key='CC_CVV_MIN_LENGTH';
UPDATE configuration SET configuration_title='レビューの文章の最小文字数', configuration_description='レビューの文章の文字数の最小値を設定します。' WHERE configuration_key='REVIEW_TEXT_MIN_LENGTH';
UPDATE configuration SET configuration_title='ベストセラーの最小表示件数', configuration_description='ベストセラーとして表示する商品の最小値を設定します。' WHERE configuration_key='MIN_DISPLAY_BESTSELLERS';
UPDATE configuration SET configuration_title='「こんな商品も購入しています」の最小表示数', configuration_description='「この商品を購入した人はこんな商品も購入しています」で表示する商品数の最小値を設定します。' WHERE configuration_key='MIN_DISPLAY_ALSO_PURCHASED';
UPDATE configuration SET configuration_title='ニックネームの最小文字数', configuration_description='ニックネームの文字数の最小値を設定します。' WHERE configuration_key='ENTRY_NICK_MIN_LENGTH';
UPDATE configuration SET configuration_title='アドレス帳の最大登録数', configuration_description='顧客が登録できるアドレス帳の登録数の最大値を設定します。' WHERE configuration_key='MAX_ADDRESS_BOOK_ENTRIES';
UPDATE configuration SET configuration_title='管理画面 - 1ページに表示する検索結果の最大数', configuration_description='管理画面の1ページに表示する検索結果の数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS';
UPDATE configuration SET configuration_title='ページ・リンク数の最大表示数', configuration_description='商品リストや購入履歴の一覧表示でページの下などに表示されるページ数・リンク数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_PAGE_LINKS';
UPDATE configuration SET configuration_title='特価商品の最大表示数', configuration_description='特価商品として表示する商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_SPECIAL_PRODUCTS';
UPDATE configuration SET configuration_title='今月の新着商品の最大表示数', configuration_description='今月の新着商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_NEW_PRODUCTS';
UPDATE configuration SET configuration_title='入荷予定商品の最大表示数', configuration_description='入荷予定商品として表示する商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_UPCOMING_PRODUCTS';
UPDATE configuration SET configuration_title='メーカーリスト - スクロールボックスのサイズ/スタイル', configuration_description='スクロールボックスに表示されるメーカー数は ?<br />1か0に設定するとドロップダウンリストになります。' WHERE configuration_key='MAX_MANUFACTURERS_LIST';
UPDATE configuration SET configuration_title='メーカーリスト - 商品の存在を確認', configuration_description='各メーカーについて、1点以上の商品があり、かつ閲覧可能であるかどうかを確認しますか?<br /><br />注意：この機能がONの場合、商品数やメーカーの数が多いと表示が遅くなります。<br />0= off 1= on' WHERE configuration_key='PRODUCTS_MANUFACTURERS_STATUS';
UPDATE configuration SET configuration_title='音楽ジャンルリスト - スクロールボックスのサイズ/スタイル', configuration_description='スクロールボックスに表示される音楽ジャンルリストの数を設定します。1か0に設定すると、ドロップダウンリストになります。\r\n' WHERE configuration_key='MAX_MUSIC_GENRES_LIST';
UPDATE configuration SET configuration_title='レコード会社リスト - スクロールボックスのサイズ/スタイル', configuration_description='スクロールボックスに表示されるレコード会社リストの数です。1か0に設定すると、ドロップダウンリストになります。\r\n' WHERE configuration_key='MAX_RECORD_COMPANY_LIST';
UPDATE configuration SET configuration_title='レコード会社名表示の長さ', configuration_description='レコード会社名ボックスで表示される名前の長さを設定します。設定より長い名前は省略表示されます。\r\n' WHERE configuration_key='MAX_DISPLAY_RECORD_COMPANY_NAME_LEN';
UPDATE configuration SET configuration_title='音楽ジャンル名の文字数の長さ', configuration_description='音楽ジャンルボックスで表示される名前の長さを設定します。設定より長い名前は省略表示されます。\r\n' WHERE configuration_key='MAX_DISPLAY_MUSIC_GENRES_NAME_LEN';
UPDATE configuration SET configuration_title='メーカー名の長さ', configuration_description='メーカーリストで表示されるメーカー名の文字数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_MANUFACTURER_NAME_LEN';
UPDATE configuration SET configuration_title='新しいレビューの表示数最大値', configuration_description='新しいレビューとして表示される数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_NEW_REVIEWS';
UPDATE configuration SET configuration_title='レビューのランダム表示数', configuration_description='ランダムに表示するレビュー数の最大値を設定します。<br /><br />注意：この設定値をXとすると、ランダム表示の対象になるのは、もっとも古いアクティブなレビューから数えてX番目に登録されたアクティブなレビューまでになります。' WHERE configuration_key='MAX_RANDOM_SELECT_REVIEWS';
UPDATE configuration SET configuration_title='新着商品のランダム表示数', configuration_description='ランダムに表示する新着商品数の最大値を設定します。<br /><br />注意：この設定値をXとすると、ランダム表示の対象になるのは、もっとも古いアクティブな新着商品から数えてX番目に登録されたアクティブな新着商品までになります。' WHERE configuration_key='MAX_RANDOM_SELECT_NEW';
UPDATE configuration SET configuration_title='特価商品のランダム表示数', configuration_description='ランダムに表示する特価商品数の最大値を設定します。<br /><br />注意：この設定値をXとすると、ランダム表示の対象になるのは、もっとも古いアクティブな特価商品から数えてX番目に登録されたアクティブな特価商品までになります。' WHERE configuration_key='MAX_RANDOM_SELECT_SPECIALS';
UPDATE configuration SET configuration_title='一行に表示するカテゴリ数', configuration_description='一行に表示するカテゴリ数を設定します。' WHERE configuration_key='MAX_DISPLAY_CATEGORIES_PER_ROW';
UPDATE configuration SET configuration_title='新着商品一覧表示数', configuration_description='新着商品ページ１ページに表示する商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_PRODUCTS_NEW';
UPDATE configuration SET configuration_title='ベストセラーの最大表示件数', configuration_description='ベストセラーページ１ページに表示するベストセラー商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_BESTSELLERS';
UPDATE configuration SET configuration_title='「こんな商品も買っています」の最大表示件数', configuration_description='「こんな商品も買っています」欄に表示する商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_ALSO_PURCHASED';
UPDATE configuration SET configuration_title='顧客の注文履歴ボックスの最大表示数', configuration_description='顧客の注文履歴ボックスに表示する商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_PRODUCTS_IN_ORDER_HISTORY_BOX';
UPDATE configuration SET configuration_title='注文履歴ページの最大表示件数', configuration_description='顧客の注文履歴ページ１ページに表示する商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_ORDER_HISTORY';
UPDATE configuration SET configuration_title='顧客管理ページで表示する顧客数の最大値', configuration_description='' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_CUSTOMER';
UPDATE configuration SET configuration_title='注文管理ページで表示する注文数の最大値', configuration_description='' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_ORDERS';
UPDATE configuration SET configuration_title='レポートページで表示する商品数の最大値', configuration_description='' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_REPORTS';
UPDATE configuration SET configuration_title='カテゴリ/商品ページで表示するリスト数', configuration_description='１ページに表示する商品数の最大値を設定します。' WHERE configuration_key='MAX_DISPLAY_RESULTS_CATEGORIES';
UPDATE configuration SET configuration_title='商品リスト - ページあたり最大表示数', configuration_description='トップページの商品リスト表示での最大表示数を設定します。' WHERE configuration_key='MAX_DISPLAY_PRODUCTS_LISTING';
UPDATE configuration SET configuration_title='商品オプション - オプション名とオプション値の表示', configuration_description='商品オプションページで表示するオプション名/オプション値の最大値を設定します。' WHERE configuration_key='MAX_ROW_LISTS_OPTIONS';
UPDATE configuration SET configuration_title='商品オプション - オプション管理画面', configuration_description='オプション管理画面で表示するオプション数の最大値を設定します。' WHERE configuration_key='MAX_ROW_LISTS_ATTRIBUTES_CONTROLLER';
UPDATE configuration SET configuration_title='商品属性- ダウンロード管理ページの表示', configuration_description='ダウンロード管理画面で、ダウンロード商品の属性の最大表示数を設定します。' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_DOWNLOADS_MANAGER';
UPDATE configuration SET configuration_title='おすすめ商品 - 管理画面でのページあたり表示最大数', configuration_description='管理画面において、ページあたりのおすすめ商品を最大表示件数を設定します。' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_FEATURED_ADMIN';
UPDATE configuration SET configuration_title='おすすめ商品 - トップページでの最大表示数', configuration_description='トップページでおすすめ商品を最大何点表示するかを設定します。' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_FEATURED';
UPDATE configuration SET configuration_title='おすすめ商品 - 商品リストでの最大表示数', configuration_description='商品リストでおすすめ商品をページあたり最大何点表示するかを設定します。' WHERE configuration_key='MAX_DISPLAY_PRODUCTS_FEATURED_PRODUCTS';
UPDATE configuration SET configuration_title='おすすめ商品のランダム表示ボックス - 最大表示数', configuration_description='おすすめ商品のランダム表示ボックスにおいて、最大何点表示するかを設定します。' WHERE configuration_key='MAX_RANDOM_SELECT_FEATURED_PRODUCTS';
UPDATE configuration SET configuration_title='特価商品 - トップページでの最大表示点数', configuration_description='トップページで、特価商品を最大何点表示するかを設定します。' WHERE configuration_key='MAX_DISPLAY_SPECIAL_PRODUCTS_INDEX';
UPDATE configuration SET configuration_title='新着商品 - 表示期限', configuration_description='新着商品の表示期限を設定します。<br />\r\n<br />\r\n・0=全て・降順<br />\r\n・1=当月登録分のみ<br />\r\n・30=登録から30日間<br />\r\n・60=登録から60日間(ほか90、120の設定が可能)' WHERE configuration_key='SHOW_NEW_PRODUCTS_LIMIT';
UPDATE configuration SET configuration_title='商品一覧ページ - ページあたり表示点数', configuration_description='商品一覧において、ページあたりの最大表示点数を設定します。' WHERE configuration_key='MAX_DISPLAY_PRODUCTS_ALL';
UPDATE configuration SET configuration_title='言語サイドボックス -　フラッグ最大表示数', configuration_description='言語サイドボックスにおいて、列あたりのフラッグの最大表示点数を設定します。' WHERE configuration_key='MAX_LANGUAGE_FLAGS_COLUMNS';
UPDATE configuration SET configuration_title='ファイルのアップロードサイズ - 上限', configuration_description='ファイルアップロードの際の上限サイズを設定します。デフォルトは2MB(2,048,000バイト)です。' WHERE configuration_key='MAX_FILE_UPLOAD_SIZE';
UPDATE configuration SET configuration_title='アップロードファイルに許可するファイルタイプ', configuration_description='ユーザーがアップロードするファイルに対して許可するファイルタイプの拡張子を設定します。複数の場合はカンマ(,)で区切り、コロン(.)は含めないでください。<br /><br />設定例: "jpg,jpeg,gif,png,eps,cdr,ai,pdf,tif,tiff,bmp,zip"' WHERE configuration_key='UPLOAD_FILENAME_EXTENSIONS';
UPDATE configuration SET configuration_title='管理画面の注文リストで表示する注文詳細の最大件数', configuration_description='管理画面の注文リストでの注文詳細の最大表示件数は?<br />0 = 無制限' WHERE configuration_key='MAX_DISPLAY_RESULTS_ORDERS_DETAILS_LISTING';
UPDATE configuration SET configuration_title='管理画面のリストで表示するPayPal IPNの最大件数', configuration_description='管理画面のリストでのPayPal IPNの表示件数は?<br />デフォルトは20です。' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_PAYPAL_IPN';
UPDATE configuration SET configuration_title='マルチカテゴリマネージャで商品を表示するカラムの最大数', configuration_description='マルチカテゴリマネージャ(Multiple Categories Manager)で商品を表示するカラムの最大数は?<br />3 = デフォルト' WHERE configuration_key='MAX_DISPLAY_PRODUCTS_TO_CATEGORIES_COLUMNS';
UPDATE configuration SET configuration_title='EZページの表示の最大件数', configuration_description='EZページの表示の最大件数は?<br />20 = デフォルト' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_EZPAGE';
UPDATE configuration SET configuration_title='商品画像(小)の横幅', configuration_description='小さな画像の横幅(ピクセル)を設定します。' WHERE configuration_key='SMALL_IMAGE_WIDTH';
UPDATE configuration SET configuration_title='商品画像(小)の高さ', configuration_description='小さな画像の高さ(ピクセル)を設定します。' WHERE configuration_key='SMALL_IMAGE_HEIGHT';
UPDATE configuration SET configuration_title='ヘッダ画像の横幅 - 管理画面', configuration_description='管理画面でのヘッダ画像の横幅を設定します。' WHERE configuration_key='HEADING_IMAGE_WIDTH';
UPDATE configuration SET configuration_title='ヘッダ画像の高さ - 管理画面', configuration_description='管理画面でのヘッダ画像の高さを設定します。' WHERE configuration_key='HEADING_IMAGE_HEIGHT';
UPDATE configuration SET configuration_title='サブカテゴリ画像の横幅', configuration_description='サブカテゴリ画像の横幅をピクセル数で設定します。' WHERE configuration_key='SUBCATEGORY_IMAGE_WIDTH';
UPDATE configuration SET configuration_title='サブカテゴリ画像の高さ', configuration_description='サブカテゴリ画像の高さをピクセル数で設定します。' WHERE configuration_key='SUBCATEGORY_IMAGE_HEIGHT';
UPDATE configuration SET configuration_title='画像サイズを計算', configuration_description='画像サイズを自動的に計算するかどうかを設定します。' WHERE configuration_key='CONFIG_CALCULATE_IMAGE_SIZE';
UPDATE configuration SET configuration_title='画像を必須とする', configuration_description='画像がないことを表示します。(カタログの作成時に有効)' WHERE configuration_key='IMAGE_REQUIRED';
UPDATE configuration SET configuration_title='ショッピングカートの中身 - 商品画像の表示オン・オフ', configuration_description='ショッピングカートの中身に入っている商品の画像を表示するかどうかを設定します。<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='IMAGE_SHOPPING_CART_STATUS';
UPDATE configuration SET configuration_title='ショッピングカートの中身の画像の横幅', configuration_description='デフォルト = 50' WHERE configuration_key='IMAGE_SHOPPING_CART_WIDTH';
UPDATE configuration SET configuration_title='ショッピングカートの中身の画像の高さ', configuration_description='デフォルト = 40' WHERE configuration_key='IMAGE_SHOPPING_CART_HEIGHT';
UPDATE configuration SET configuration_title='商品情報 - カテゴリアイコン画像の横幅', configuration_description='商品情報ページでのカテゴリアイコンの横幅(ピクセル数)は?' WHERE configuration_key='CATEGORY_ICON_IMAGE_WIDTH';
UPDATE configuration SET configuration_title='商品情報 - カテゴリアイコン画像の高さ', configuration_description='商品情報ページでのカテゴリアイコンの高さ(ピクセル数)は?' WHERE configuration_key='CATEGORY_ICON_IMAGE_HEIGHT';
UPDATE configuration SET configuration_title='商品情報 - 画像の横幅', configuration_description='商品画像の横幅を設定します。' WHERE configuration_key='MEDIUM_IMAGE_WIDTH';
UPDATE configuration SET configuration_title='商品情報 - 画像の高さ', configuration_description='商品画像の高さを設定します。' WHERE configuration_key='MEDIUM_IMAGE_HEIGHT';
UPDATE configuration SET configuration_title='商品情報 - 画像(中)のファイル接尾辞(Suffix)', configuration_description='商品画像のファイル接尾辞を設定します。<br /><br />・デフォルト = _MED' WHERE configuration_key='IMAGE_SUFFIX_MEDIUM';
UPDATE configuration SET configuration_title='商品情報 - 画像(大)のファイル接尾辞(Suffix)', configuration_description='商品画像のファイル接尾辞を設定します。<br /><br />\r\n・デフォルト = _LRG' WHERE configuration_key='IMAGE_SUFFIX_LARGE';
UPDATE configuration SET configuration_title='商品情報 - １行に表示する追加画像数', configuration_description='商品情報で１行に表示する追加画像数を設定します。<br /><br />\r\n・デフォルト = 3' WHERE configuration_key='IMAGES_AUTO_ADDED';
UPDATE configuration SET configuration_title='商品リスト - 画像の横幅', configuration_description='デフォルト = 100' WHERE configuration_key='IMAGE_PRODUCT_LISTING_WIDTH';
UPDATE configuration SET configuration_title='商品リスト - 画像の高さ', configuration_description='デフォルト = 80' WHERE configuration_key='IMAGE_PRODUCT_LISTING_HEIGHT';
UPDATE configuration SET configuration_title='新商品リスト - 画像の横幅', configuration_description='デフォルト = 100' WHERE configuration_key='IMAGE_PRODUCT_NEW_LISTING_WIDTH';
UPDATE configuration SET configuration_title='新商品リスト - 画像の高さ', configuration_description='デフォルト = 80' WHERE configuration_key='IMAGE_PRODUCT_NEW_LISTING_HEIGHT';
UPDATE configuration SET configuration_title='新商品 - 画像の横幅', configuration_description='デフォルト = 100' WHERE configuration_key='IMAGE_PRODUCT_NEW_WIDTH';
UPDATE configuration SET configuration_title='新商品 - 画像の高さ', configuration_description='デフォルト = 80' WHERE configuration_key='IMAGE_PRODUCT_NEW_HEIGHT';
UPDATE configuration SET configuration_title='おすすめ商品 -画像の幅', configuration_description='デフォルト = 100' WHERE configuration_key='IMAGE_FEATURED_PRODUCTS_LISTING_WIDTH';
UPDATE configuration SET configuration_title='おすすめ商品 - 画像の高さ', configuration_description='デフォルト = 80' WHERE configuration_key='IMAGE_FEATURED_PRODUCTS_LISTING_HEIGHT';
UPDATE configuration SET configuration_title='全商品一覧 - 画像の幅', configuration_description='デフォルト = 100' WHERE configuration_key='IMAGE_PRODUCT_ALL_LISTING_WIDTH';
UPDATE configuration SET configuration_title='全商品一覧 - 画像の高さ', configuration_description='デフォルト = 80' WHERE configuration_key='IMAGE_PRODUCT_ALL_LISTING_HEIGHT';
UPDATE configuration SET configuration_title='商品画像 - 画像がない場合のNo Image画像', configuration_description='「No Image」画像を自動的に表示するかどうかを設定します。<br /><br />\r\n・0= off<br />\r\n・1= On<br />' WHERE configuration_key='PRODUCTS_IMAGE_NO_IMAGE_STATUS';
UPDATE configuration SET configuration_title='商品画像 - No Image画像の指定', configuration_description='商品画像がない場合に表示するNo Image画像を設定します。<br /><br />Default = no_picture.gif' WHERE configuration_key='PRODUCTS_IMAGE_NO_IMAGE';
UPDATE configuration SET configuration_title='商品画像 - 商品・カテゴリでプロポーショナルな画像を使う', configuration_description='商品情報・カテゴリでプロポーショナルな画像を使いますか?<br /><br />注意：プロポーショナル画像には高さ・横幅とも"0"(ピクセル)を指定しないでください。<br />0= off 1= on' WHERE configuration_key='PROPORTIONAL_IMAGES_STATUS';
UPDATE configuration SET configuration_title='(メール用)敬称表示(Mr. or Ms)', configuration_description='顧客のアカウント作成の際、メール用の敬称(Mr. or Ms) を表示するかどうかを設定します。' WHERE configuration_key='ACCOUNT_GENDER';
UPDATE configuration SET configuration_title='生年月日', configuration_description='顧客のアカウント作成の際、「生年月日」の欄を表示するかどうかを設定します。<br />注意: 不要な場合はfalseに、必要な場合はtrueを指定してください。' WHERE configuration_key='ACCOUNT_DOB';
UPDATE configuration SET configuration_title='会社名', configuration_description='顧客のアカウント作成の際、「会社名」を表示するかどうかを設定します。' WHERE configuration_key='ACCOUNT_COMPANY';
UPDATE configuration SET configuration_title='住所2', configuration_description='顧客のアカウント作成の際、「住所2」を表示するかどうかを設定します。' WHERE configuration_key='ACCOUNT_SUBURB';
UPDATE configuration SET configuration_title='都道府県名', configuration_description='顧客のアカウント作成の際、「都道府県名」を表示するかどうかを設定します。' WHERE configuration_key='ACCOUNT_STATE';
UPDATE configuration SET configuration_title='都道府県名 - ドロップダウンで表示', configuration_description='「都道府県名」は常にドロップダウン形式で表示しますか?' WHERE configuration_key='ACCOUNT_STATE_DRAW_INITIAL_DROPDOWN';
UPDATE configuration SET configuration_title='アカウントのデフォルト国別IDの作成', configuration_description='アカウントのデフォルト国別IDを設定します。<br />デフォルトは223です。' WHERE configuration_key='SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY';
UPDATE configuration SET configuration_title='Fax番号', configuration_description='顧客のアカウント作成の際、「Fax番号」を表示するかどうかを設定します。' WHERE configuration_key='ACCOUNT_FAX_NUMBER';
UPDATE configuration SET configuration_title='メールマガジンのチェックボックスの表示', configuration_description='メールマガジンのチェックボックスの表示設定をします。<br />0= 表示オフ<br />1= ボックス表示・チェックなし状態<br />2= ボックス表示・チェックあり状態<br />【注意】デフォルトで「チェックあり」の状態にしておくと、各国のスパム規制法規に抵触する恐れがあります。' WHERE configuration_key='ACCOUNT_NEWSLETTER_STATUS';
UPDATE configuration SET configuration_title='デフォルトのメール形式の設定', configuration_description='顧客のデフォルトのメール形式を設定します。<br />0= テキスト形式<br />1= HTML形式' WHERE configuration_key='ACCOUNT_EMAIL_PREFERENCE';
UPDATE configuration SET configuration_title='顧客への商品の通知 - ステータス', configuration_description='顧客がチェックアウト後に、商品の通知(product notifications)について尋ねるかどうかを設定します。<br /><br />\r\n・0= 尋ねない<br />\r\n・1= 尋ねる(サイト全体に対して設定されていない場合)<br />\r\n【注意】サイドボックスはこの設定とは別にオフにする必要があります。' WHERE configuration_key='CUSTOMERS_PRODUCTS_NOTIFICATION_STATUS';
UPDATE configuration SET configuration_title='商品・価格の閲覧制限', configuration_description='顧客がショップ内で商品や価格を閲覧するのを制限するかどうかを設定します。<br />0= 要ログインなどの制限なし<br />1= ブラウスにはログインが必須<br />2= ログインなしでブラウズ可能だが価格は非表示<br />3= 商品閲覧のみ<br /><br />【注意】オプション「2」は、サーチエンジンのロボットに収集されたくない場合や、ログイン済みの顧客にのみ価格を開示したい場合に有効です。' WHERE configuration_key='CUSTOMERS_APPROVAL';
UPDATE configuration SET configuration_title='顧客の購入オーソライズ', configuration_description='ショップでの購入に際して、顧客はショップ側に審査・許可される必要があるかどうかを設定します。<br />0= 不要<br />1= 商品の閲覧にも許可が必要<br />2= 商品の閲覧は自由だが価格の閲覧は許可された顧客のみ<br />【注意】オプション「2」はサーチエンジンのロボット除けに用いることもできます。' WHERE configuration_key='CUSTOMERS_APPROVAL_AUTHORIZATION';
UPDATE configuration SET configuration_title='顧客のオーソライズ(閲覧制限) - ファイル名', configuration_description='顧客のオーソライズ(閲覧制限)に使うファイル名を設定します。拡張子なしで表記してください。<br />デフォルトは\r\n"customers_authorization"' WHERE configuration_key='CUSTOMERS_AUTHORIZATION_FILENAME';
UPDATE configuration SET configuration_title='顧客のオーソライズ(閲覧制限) - ヘッダを隠す', configuration_description='顧客のオーソライズ(閲覧制限) でヘッダを表示するかどうかを設定します。<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='CUSTOMERS_AUTHORIZATION_HEADER_OFF';
UPDATE configuration SET configuration_title='顧客のオーソライズ(閲覧制限) - 左カラムを隠す', configuration_description='顧客のオーソライズ(閲覧制限) で、左カラムを表示するかどうかを設定します。<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='CUSTOMERS_AUTHORIZATION_COLUMN_LEFT_OFF';
UPDATE configuration SET configuration_title='顧客のオーソライズ(閲覧制限) - 右カラムを隠す', configuration_description='顧客のオーソライズ(閲覧制限)で、右カラムを表示するかどうかを設定します。<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='CUSTOMERS_AUTHORIZATION_COLUMN_RIGHT_OFF';
UPDATE configuration SET configuration_title='顧客のオーソライズ(閲覧制限) - フッタを隠す', configuration_description='顧客のオーソライズ(閲覧制限) で、フッタを表示するかどうかを設定します。<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='CUSTOMERS_AUTHORIZATION_FOOTER_OFF';
UPDATE configuration SET configuration_title='顧客のオーソライズ(閲覧制限) - 価格の非表示', configuration_description='顧客のオーソライズで、価格を表示するかどうかを設定します。<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='CUSTOMERS_AUTHORIZATION_PRICES_OFF';
UPDATE configuration SET configuration_title='顧客の紹介(Customers Referral)ステータス', configuration_description='顧客の紹介コードについて設定します。<br />0= Off<br />1= 1st Discount Coupon Code used最初のディスカウントクーポンを使用済み<br />2= アカウント作成の際、顧客自身が追加・編集可能<br /><br />注意：顧客の紹介コードがセットされると、管理画面からだけ変更することができます。' WHERE configuration_key='CUSTOMERS_REFERRAL_STATUS';
UPDATE configuration SET configuration_title='インストール済みの支払いモジュール', configuration_description='インストールされている支払いモジュールのファイル名のリスト( セミコロン(;)区切り )です。この情報は自動的に更新されますので編集の必要はありません。' WHERE configuration_key='MODULE_PAYMENT_INSTALLED';
UPDATE configuration SET configuration_title='インストール済み注文合計モジュール', configuration_description='インストールされている注文合計モジュールのファイル名のリスト(セミコロン(;)区切り)です。\r\n<br /><br />\r\n【注意】この情報は自動的に更新されますので編集の必要はありません。' WHERE configuration_key='MODULE_ORDER_TOTAL_INSTALLED';
UPDATE configuration SET configuration_title='インストール済み配送モジュール', configuration_description='インストールされている配送モジュールのファイル名のリスト(セミコロン(;)区切り)です。この情報は自動的に更新されますので編集の必要はありません。' WHERE configuration_key='MODULE_SHIPPING_INSTALLED';
UPDATE configuration SET configuration_title='代金引換モジュールを有効にする', configuration_description='代金引換モジュールを有効にするかどうかを設定します。' WHERE configuration_key='MODULE_PAYMENT_COD_STATUS';
UPDATE configuration SET configuration_title='支払い地域', configuration_description='地域を選択した場合、選択された地域に対してのみ支払い方法が適用されます。' WHERE configuration_key='MODULE_PAYMENT_COD_ZONE';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定します。数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_PAYMENT_COD_SORT_ORDER';
UPDATE configuration SET configuration_title='注文ステータスの設定', configuration_description='この支払い方法の場合の注文ステータスを設定します。' WHERE configuration_key='MODULE_PAYMENT_COD_ORDER_STATUS_ID';
UPDATE configuration SET configuration_title='クレジットカードモジュールを有効にする', configuration_description='クレジットカードによる支払いを有効にするかどうかを設定します。' WHERE configuration_key='MODULE_PAYMENT_CC_STATUS';
UPDATE configuration SET configuration_title='クレジットカード番号を分割する', configuration_description='メールアドレスが入力された場合、クレジットカードの中間の数字をそのアドレスに送信し、残りの外側の番号をデータベースに保存します。' WHERE configuration_key='MODULE_PAYMENT_CC_EMAIL';
UPDATE configuration SET configuration_title='CVV番号を保存する', configuration_description='CVV番号を収集/保存しますか? 注意：有効にすると、CVV番号はエンコードされた状態でデータベースに保存されます。' WHERE configuration_key='MODULE_PAYMENT_CC_COLLECT_CVV';
UPDATE configuration SET configuration_title='クレジットカードナンバーを収集・保存する', configuration_description='クレジットカード番号を収集・保存するかどうかを設定します。<br /><br />\r\n【注意】クレジットカード番号は暗号化なしに保存されます。セキュリティ上の問題に十分注意してください。' WHERE configuration_key='MODULE_PAYMENT_CC_STORE_NUMBER';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定します. 数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_PAYMENT_CC_SORT_ORDER';
UPDATE configuration SET configuration_title='支払い地域', configuration_description='地域を選択した場合、選択された地域にたいしてのみ支払い方法が適用されます。' WHERE configuration_key='MODULE_PAYMENT_CC_ZONE';
UPDATE configuration SET configuration_title='注文ステータス', configuration_description='この支払い方法の場合の注文ステータスを設定します。' WHERE configuration_key='MODULE_PAYMENT_CC_ORDER_STATUS_ID';
UPDATE configuration SET configuration_title='定額料金', configuration_description='定額料金による配送を提供するかどうかを設定します。' WHERE configuration_key='MODULE_SHIPPING_FLAT_STATUS';
UPDATE configuration SET configuration_title='配送料金', configuration_description='すべての注文に対して適用される配送料金を設定します。' WHERE configuration_key='MODULE_SHIPPING_FLAT_COST';
UPDATE configuration SET configuration_title='税種別', configuration_description='定額料金に適用される税種別を選択します。' WHERE configuration_key='MODULE_SHIPPING_FLAT_TAX_CLASS';
UPDATE configuration SET configuration_title='税率の計算ベース', configuration_description='配送料にかかる税金オプションの設定します。<br /><br />\r\n・Shipping - 顧客の送付先住所に基づく<br />\r\n・Billing - 顧客の請求先住所に基づく<br />\r\n・Store - ショップの所在住所に基づく(送付先/請求先がショップ所在地と同じ地域の場合に有効)' WHERE configuration_key='MODULE_SHIPPING_FLAT_TAX_BASIS';
UPDATE configuration SET configuration_title='配送地域', configuration_description='配送地域を選択すると選択された地域のみで利用可能になります。' WHERE configuration_key='MODULE_SHIPPING_FLAT_ZONE';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定できます。数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_SHIPPING_FLAT_SORT_ORDER';
UPDATE configuration SET configuration_title='デフォルトの通貨', configuration_description='デフォルトの通貨を設定します。' WHERE configuration_key='DEFAULT_CURRENCY';
UPDATE configuration SET configuration_title='デフォルトの言語', configuration_description='デフォルトの言語を設定します。' WHERE configuration_key='DEFAULT_LANGUAGE';
UPDATE configuration SET configuration_title='新規注文のデフォルトステータス', configuration_description='新規の注文を受け付けたときのデフォルトステータスを設定します。' WHERE configuration_key='DEFAULT_ORDERS_STATUS_ID';
UPDATE configuration SET configuration_title='管理画面で設定キー(configuration_key)を表示', configuration_description='管理画面で設定キー(configuration_key)を表示しますか?<br />\r\n表示したい場合は1に設定してください。' WHERE configuration_key='ADMIN_configuration_key_ON';
UPDATE configuration SET configuration_title='出荷国名', configuration_description='配送料の計算に利用するための国名を選択します。' WHERE configuration_key='SHIPPING_ORIGIN_COUNTRY';
UPDATE configuration SET configuration_title='ショップの郵便番号', configuration_description='ショップの郵便番号を入力します。' WHERE configuration_key='SHIPPING_ORIGIN_ZIP';
UPDATE configuration SET configuration_title='一回の配送で配送可能な最大重量(kg)', configuration_description='一回の配送で可能な重量(kg)の最大値を設定します。例えば10kgに設定した状態でカートに30kgの商品があった場合、10kg × 3回の配送という形で処理されます。' WHERE configuration_key='SHIPPING_MAX_WEIGHT';
UPDATE configuration SET configuration_title='小・中パッケージの風袋 - 比率・重量', configuration_description='典型的な小・中パッケージの風袋(ふうたい：大きさと重量)を設定します。<br />\r\n例：10% + 1lb 10:1<br />\r\n10% + 0lbs 10:0<br />\r\n0% + 5lbs 0:5<br />\r\n0% + 0lbs 0:0' WHERE configuration_key='SHIPPING_BOX_WEIGHT';
UPDATE configuration SET configuration_title='大型パッケージの風袋 - 大きさ・重量', configuration_description='大きなパッケージの風袋風袋(ふうたい：大きさと重量)を設定します。<br />\r\n例：10% + 1lb 10:1<br />\r\n10% + 0lbs 10:0<br />\r\n0% + 5lbs 0:5<br />\r\n0% + 0lbs 0:0' WHERE configuration_key='SHIPPING_BOX_PADDING';
UPDATE configuration SET configuration_title='個数と重量の表示', configuration_description='配送する荷物の個数と重量を表示するかどうかを設定します。<br /><br />\r\n・0= off<br />\r\n・1= 個数のみ表示<br />\r\n・2= 重量のみ表示<br />\r\n・3= 両方表示' WHERE configuration_key='SHIPPING_BOX_WEIGHT_DISPLAY';
UPDATE configuration SET configuration_title='送料概算表示の表示・非表示', configuration_description='送料概算ボタンの表示するかどうかを設定します。<br />\r\n・0= Off<br />\r\n・1= ショッピングカート上にボタンとして表示' WHERE configuration_key='SHOW_SHIPPING_ESTIMATOR_BUTTON';
UPDATE configuration SET configuration_title='注文の重量が0なら送料無料に', configuration_description='注文の重量が0の場合、送料無料にしますか?\r\n<br />\r\n・0= いいえ<br />\r\n・1= はい<br />\r\n注意：「送料無料」表記をしたい場合には送料無料モジュールを使うことをお勧めします。このオプションは実際に送料無料のときに表示されるだけです。' WHERE configuration_key='ORDER_WEIGHT_ZERO_STATUS';
UPDATE configuration SET configuration_title='商品イメージの表示', configuration_description='商品一覧中の商品画像の表示・非表示/ソート順を設定します。<br /><br />\r\n・数値が小さいほど先に表示<br />\r\n・0 = 非表示' WHERE configuration_key='PRODUCT_LIST_IMAGE';
UPDATE configuration SET configuration_title='商品メーカーの表示', configuration_description='商品のメーカー名を表示するかどうかを設定します。<br /><br />\r\n・数値が小さいほど先に表示<br />\r\n・0 = 非表示' WHERE configuration_key='PRODUCT_LIST_MANUFACTURER';
UPDATE configuration SET configuration_title='商品型番の表示', configuration_description='商品一覧中の商品型番の表示・非表示/ソート順を設定します。数値が小さいほど先に表示されます。(0 = 非表示)' WHERE configuration_key='PRODUCT_LIST_MODEL';
UPDATE configuration SET configuration_title='商品名', configuration_description='商品一覧中の商品名の表示・非表示/ソート順を設定します。<br /><br />\r\n・数値が小さいほど先に表示<br />\r\n・0 = 非表示' WHERE configuration_key='PRODUCT_LIST_NAME';
UPDATE configuration SET configuration_title='商品価格・「カートに入れる」を表示', configuration_description='商品価格・「カートに入れる」ボタンを表示するかどうかを設定します。<br />\r\n<br />\r\n・数値が小さいほど先に表示<br />\r\n・0 = 非表示' WHERE configuration_key='PRODUCT_LIST_PRICE';
UPDATE configuration SET configuration_title='商品数量の表示', configuration_description='商品一覧中の商品数量の表示・非表示/ソート順を設定します。<br /><br />\r\n・数値が小さいほど先に表示<br />\r\n・0 = 非表示' WHERE configuration_key='PRODUCT_LIST_QUANTITY';
UPDATE configuration SET configuration_title='商品重量の表示', configuration_description='商品一覧中の商品重量の表示・非表示/ソート順を設定します。数値が小さいほど先に表示されます。(0 = 非表示)' WHERE configuration_key='PRODUCT_LIST_WEIGHT';
UPDATE configuration SET configuration_title='商品価格・「カートに入れる」カラムの幅', configuration_description='商品価格・「カートに入れる」ボタンを表示するカラムの幅(ピクセル数)を設定します。<br />\r\n・Default= 125' WHERE configuration_key='PRODUCTS_LIST_PRICE_WIDTH';
UPDATE configuration SET configuration_title='カテゴリ/メーカーの絞り込みの表示', configuration_description='カテゴリ一覧ページで [絞り込み] を表示するかどうかを設定します。<br />\r\n・0=非表示<br />\r\n・1=表示' WHERE configuration_key='PRODUCT_LIST_FILTER';
UPDATE configuration SET configuration_title='[前ページ] [次ページ] の表示位置', configuration_description='[前ページ] [次ページ] の表示位置を設定します。<br /><br />\r\n・1 = 上<br />\r\n・2 = 下<br />\r\n・3 = 両方' WHERE configuration_key='PREV_NEXT_BAR_LOCATION';
UPDATE configuration SET configuration_title='商品リストのデフォルトソート順', configuration_description='商品リストのデフォルトのソート順を設定します。\r\n<br />\r\n注意：商品でソートする場合は空欄に。\r\nSort the Product Listing in the order you wish for the default display to start in to get the sort order setting. Example: 2a' WHERE configuration_key='PRODUCT_LISTING_DEFAULT_SORT_ORDER';
UPDATE configuration SET configuration_title='「カートに入れる」ボタンの表示', configuration_description='「カートに入れる」ボタンを表示するかどうかを設定します。<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='PRODUCT_LIST_PRICE_BUY_NOW';
UPDATE configuration SET configuration_title='複数商品の数量欄の有無・表示位置', configuration_description='複数商品をカートに入れる数量欄の表示するかどうかと、表示位置を設定します。<br />0= off<br />1= 上部<br />2= 下部<br />3= 両方' WHERE configuration_key='PRODUCT_LISTING_MULTIPLE_ADD_TO_CART';
UPDATE configuration SET configuration_title='商品説明の表示', configuration_description='商品説明を表示するかどうかを設定します。<br /><br />0= OFF<br />150= 推奨する長さ。または自由に表示する商品説明の最大文字数を設定してください。' WHERE configuration_key='PRODUCT_LIST_DESCRIPTION';
UPDATE configuration SET configuration_title='商品リストの昇順を表示する記号', configuration_description='商品リストの昇順を示す記号は?<br />デフォルト = +' WHERE configuration_key='PRODUCT_LIST_SORT_ORDER_ASCENDING';
UPDATE configuration SET configuration_title='商品リストの降順を表示する記号', configuration_description='商品リストの降順を示す記号は?<br />デフォルト = -' WHERE configuration_key='PRODUCT_LIST_SORT_ORDER_DESCENDING';
UPDATE configuration SET configuration_title='在庫水準のチェック', configuration_description='十分な在庫があるかチェックするかどうかを設定します。' WHERE configuration_key='STOCK_CHECK';
UPDATE configuration SET configuration_title='在庫数からマイナス', configuration_description='受注時点で各在庫数から注文数をマイナスしますか?' WHERE configuration_key='STOCK_LIMITED';
UPDATE configuration SET configuration_title='チェックアウトを許可', configuration_description='在庫が不足している場合にチェックアウトを許可しますか?' WHERE configuration_key='STOCK_ALLOW_CHECKOUT';
UPDATE configuration SET configuration_title='在庫切れ商品のサイン', configuration_description='注文時点で商品が在庫切れの場合に顧客へ表示するサインを設定します。' WHERE configuration_key='STOCK_MARK_PRODUCT_OUT_OF_STOCK';
UPDATE configuration SET configuration_title='在庫の再注文水準', configuration_description='在庫の再注文が必要になる商品数を設定します。' WHERE configuration_key='STOCK_REORDER_LEVEL';
UPDATE configuration SET configuration_title='在庫切れ商品のステータス変更', configuration_description='商品の在庫がない場合のステータス表示を設定します。<br /><br />0= 商品ステータスをOFFに<br />1= 商品ステータスはONのまま' WHERE configuration_key='SHOW_PRODUCTS_SOLD_OUT';
UPDATE configuration SET configuration_title='在庫切れ商品に「売り切れ」画像表示', configuration_description='在庫がなくなった商品の場合に「カートへ入れる」ボタンの代わりに「売り切れ」画像を表示しますか?<br /><br />\r\n・0= 表示しない<br />\r\n・1= 表示する' WHERE configuration_key='SHOW_PRODUCTS_SOLD_OUT_IMAGE';
UPDATE configuration SET configuration_title='商品数量に指定できる小数点の桁数', configuration_description='商品の数量に小数点の利用を許可する桁数を設定します。<br /><br />\r\n・0= off' WHERE configuration_key='QUANTITY_DECIMALS';
UPDATE configuration SET configuration_title='ショッピングカート - 「削除」チェックボックス/ボタン', configuration_description='「削除」チェックボックス/ボタンの表示について設定します。<br /><br />1= ボタンのみ<br />2= チェックボックスのみ<br />3= ボタン/チェックボックス両方' WHERE configuration_key='SHOW_SHOPPING_CART_DELETE';
UPDATE configuration SET configuration_title='ショッピングカート -「カートの中身を更新」ボタンの位置', configuration_description='「カートの中身を更新」ボタンの位置を設定します。<br /><br />1=「注文数」欄の横<br />2= 商品リストの下<br />3=「注文数」欄の横と商品リストの下<br /><br />注意：この設定は3つの"tpl_shopping_cart_default"ファイルが呼ばれる部分を設定します。' WHERE configuration_key='SHOW_SHOPPING_CART_UPDATE';
UPDATE configuration SET configuration_title='ページのパースに要した時間をログに記録するかどうかを設定します。', configuration_description='ページのパースに要した時間をログに記録するかどうかを設定します。' WHERE configuration_key='STORE_PAGE_PARSE_TIME';
UPDATE configuration SET configuration_title='ページのパースログを保存するディレクトリとファイル名を設定します。', configuration_description='ページのパースログを保存するディレクトリとファイル名を設定します。' WHERE configuration_key='STORE_PAGE_PARSE_TIME_LOG';
UPDATE configuration SET configuration_title='ログに記録する日付形式を設定します。', configuration_description='ログに記録する日付形式を設定します。' WHERE configuration_key='STORE_PARSE_DATE_TIME_FORMAT';
UPDATE configuration SET configuration_title='各ページの下にパース時間を表示するかどうかを設定します。<br />「ページのパース時間を記録」を true にしておく必要はありません。', configuration_description='各ページの下にパース時間を表示するかどうかを設定します。<br />「ページのパース時間を記録」を true にしておく必要はありません。' WHERE configuration_key='DISPLAY_PAGE_PARSE_TIME';
UPDATE configuration SET configuration_title='ログにデータベースクエリーを記録しておくかどうか設定します。(PHP4の場合のみ)', configuration_description='ログにデータベースクエリーを記録しておくかどうか設定します。(PHP4の場合のみ)' WHERE configuration_key='STORE_DB_TRANSACTIONS';
UPDATE configuration SET configuration_title='メール送信 - 接続方法', configuration_description='メール送信にsendmailへのローカル接続を使用するかTCP/IP経由のSMTP接続を使用するかを設定します。サーバのOSがWindowsやMacOSの場合はSMTPに設定してください。<br /><br />SMTPAUTHは、サーバーがメール送信の際にSMTP authorizationを求める場合にのみ使ってください。その場合、管理画面でSMTPAUTH設定を行う必要があります。<br /><br />"Sendmail -f"は、-fパラメータが必要なサーバ向けの設定で、スプーフィングを防ぐために用いられることが多いセキュリティ上の設定です。メールサーバーのホスト側で使用可能な設定になっていない場合、エラーになることがあります。' WHERE configuration_key='EMAIL_TRANSPORT';
UPDATE configuration SET configuration_title='SMTP認証 - メールアカウント', configuration_description='あなたのホスティングサービスが提供しているメールアカウント(例：me@mydomain.com)を入力してください。これはSMTP認証に必要な情報です。<br />メールにSMTP認証を使っている場合にのみ必要です。' WHERE configuration_key='EMAIL_SMTPAUTH_MAILBOX';
UPDATE configuration SET configuration_title='SMTP認証 - パスワード', configuration_description='SMTPメールボックスのパスワードを入力してください。<br />メールにSMTP認証を使っている場合にのみ必要です。' WHERE configuration_key='EMAIL_SMTPAUTH_PASSWORD';
UPDATE configuration SET configuration_title='SMTP認証 - DNS名', configuration_description='SMTPメールサーバのDNS名を入力してください。<br />例：mail.mydomain.com or 55.66.77.88<br />メールにSMTP認証を使っている場合にのみ必要です。' WHERE configuration_key='EMAIL_SMTPAUTH_MAIL_SERVER';
UPDATE configuration SET configuration_title='SMTP認証 - IPポート番号', configuration_description='SMTPメールサーバが運用されているIPポート番号を入力してください。<br />メールにSMTP認証を使っている場合にのみ必要です。' WHERE configuration_key='EMAIL_SMTPAUTH_MAIL_SERVER_PORT';
UPDATE configuration SET configuration_title='テキストメールでの貨幣の変換', configuration_description='テキスト形式のメールに、どんな貨幣の変換が必要ですか?<br />Default = &amp;pound;,￡:&amp;euro;,EUR' WHERE configuration_key='CURRENCIES_TRANSLATIONS';
UPDATE configuration SET configuration_title='メールの改行コード', configuration_description='メールヘッダを区切るのに使用する改行コードを指定します。' WHERE configuration_key='EMAIL_LINEFEED';
UPDATE configuration SET configuration_title='メール送信にMIME HTMLを使用', configuration_description='メールをHTML形式で送信するかどうかを設定します。' WHERE configuration_key='EMAIL_USE_HTML';
UPDATE configuration SET configuration_title='メールアドレスをDNSで確認', configuration_description='メールアドレスをDNSサーバに問い合わせ確認するかどうかを設定します。' WHERE configuration_key='ENTRY_EMAIL_ADDRESS_CHECK';
UPDATE configuration SET configuration_title='メールを送信', configuration_description='E-Mailを外部に送信するかどうかを設定します。' WHERE configuration_key='SEND_EMAILS';
UPDATE configuration SET configuration_title='メール保存の設定', configuration_description='送信済みのメールを保存しておく場合はtrueを設定してください。' WHERE configuration_key='EMAIL_ARCHIVE';
UPDATE configuration SET configuration_title='メール送信エラーの表示', configuration_description='メール送信が失敗した際、人目でわかるエラーを表示しますか? 運営中のショップではtrueに設定することを勧めます。falseに設定するとPHPのエラーメッセージを表示されるので、トラブル解決のヒントになります。' WHERE configuration_key='EMAIL_FRIENDLY_ERRORS';
UPDATE configuration SET configuration_title='メールアドレス (ショップに表示する問い合わせ先)', configuration_description='ショップオーナーのメールアドレスとしてサイト上で表示されるアドレスを設定します。' WHERE configuration_key='STORE_OWNER_EMAIL_ADDRESS';
UPDATE configuration SET configuration_title='メールアドレス (顧客への送信元)', configuration_description='顧客に送信されるメールのデフォルトの送信元として表示されるアドレスを設定します。<br />\r\n管理画面でメールを作成をする都度、書き換えることもできます。' WHERE configuration_key='EMAIL_FROM';
UPDATE configuration SET configuration_title='送信メールの送信元アドレスの実在性', configuration_description='お使いのメールサーバでは、送信するメールの送信元(From)アドレスがWebサーバ上に実在することが必須ですか?<br /><br />spam送信を防止するなどのためにこのように設定されていることがあります。Yesに設定すると、送信元アドレスとメール内のFromアドレスが一致していることが求められます。' WHERE configuration_key='EMAIL_SEND_MUST_BE_STORE';
UPDATE configuration SET configuration_title='管理者が送信するメールフォーマット', configuration_description='管理者が送付するメールフォーマットを設定します。<br /><br />\r\n・TEXT =テキスト形式<br />\r\n・HTML =HTML形式' WHERE configuration_key='ADMIN_EXTRA_EMAIL_FORMAT';
UPDATE configuration SET configuration_title='注文確認メール(コピー)送信先', configuration_description='顧客に送信される注文確認メールのコピーを送付するメールアドレスを設定します。<br />記入例: 名前1 &lt;email@address1&gt;, 名前2 &lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_ORDER_EMAILS_TO';
UPDATE configuration SET configuration_title='アカウント作成完了メール(コピー)の送信', configuration_description='アカウント作成完了メールのコピーを指定のメールアドレスに送信しますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO_STATUS';
UPDATE configuration SET configuration_title='アカウント作成完了メール(コピー)の送信先', configuration_description='アカウント作成完了メールのコピーを送信するメールアドレスを設定します。<br /><br />\r\n記入例： 名前1 &lt;email@address1&gt;, 名前2 &lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_CREATE_ACCOUNT_EMAILS_TO';
UPDATE configuration SET configuration_title='「友達に知らせる」メール(コピー)の送信', configuration_description='「友達に知らせる」メールのコピーを送信しますか?<br />0= off 1= on' WHERE configuration_key='SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO_STATUS';
UPDATE configuration SET configuration_title='「友達に知らせる」メール(コピー)の送信先', configuration_description='「友達に知らせる」メールのコピーを送信するメールアドレスを設定します。記入例: 名前1 &lt;email@address1&gt;, 名前2 &lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_TELL_A_FRIEND_EMAILS_TO';
UPDATE configuration SET configuration_title='ギフト券送付メール(コピー)の送信', configuration_description='顧客が送付するギフト券送付メールのコピーを送信しますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='SEND_EXTRA_GV_CUSTOMER_EMAILS_TO_STATUS';
UPDATE configuration SET configuration_title='ギフト券送付メール(コピー)の送信先', configuration_description='顧客が送付するギフト券送付メールのコピーを送信するメールアドレスを設定します。<br /><br />記入例： 名前1 &lt;email@address1&gt;, 名前2&lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_GV_CUSTOMER_EMAILS_TO';
UPDATE configuration SET configuration_title='ショップ運営者からのギフト券送付メール(コピー)の送信', configuration_description='ショップ運営者からのギフト券送付メールのコピーを送信しますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='SEND_EXTRA_GV_ADMIN_EMAILS_TO_STATUS';
UPDATE configuration SET configuration_title='ショップ運営者からのギフト券送付メール(コピー)の送信先', configuration_description='ショップ運営者からのギフト券送付メールのコピーを送信するメールアドレスを設定します。<br /><br />\r\n記入例：名前1 &lt;email@address1&gt;, 名前2 &lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_GV_ADMIN_EMAILS_TO';
UPDATE configuration SET configuration_title='ショップ運営者からのクーポン券送付メール(コピー)の送信', configuration_description='ショップ運営者からのクーポン券送付メールのコピーを送信しますか?<br />0= off 1= on' WHERE configuration_key='SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO_STATUS';
UPDATE configuration SET configuration_title='ショップ運営者からのクーポン券送付メール(コピー)の送信先', configuration_description='ショップ運営者からのクーポン券送付メールのコピーを送信するメールアドレスを設定します。<br /><br />\r\n記入例： 名前1 &lt;email@address1&gt;, 名前2 &lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_DISCOUNT_COUPON_ADMIN_EMAILS_TO';
UPDATE configuration SET configuration_title='ショップ運営者の注文ステータスメール(コピー)の送信', configuration_description='ショップ運営者の注文ステータスメールのコピーを送信しますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO_STATUS';
UPDATE configuration SET configuration_title='ショップ運営者の注文ステータスメール(コピー)の送信先', configuration_description='ショップ運営者の注文ステータスメールのコピーを送信するメールアドレスを設定します。<br /><br />\r\n記入例： 名前1 &lt;email@address1&gt;, 名前2 &lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_ORDERS_STATUS_ADMIN_EMAILS_TO';
UPDATE configuration SET configuration_title='掲載待ちレビューについてメール送信', configuration_description='掲載待ちのレビューについてメールを送信しますか?<br />0= off 1= on' WHERE configuration_key='SEND_EXTRA_REVIEW_NOTIFICATION_EMAILS_TO_STATUS';
UPDATE configuration SET configuration_title='掲載待ちレビューについてのメール送信先', configuration_description='掲載待ちのレビューについてのメールを送信するアドレスを設定します。<br />フォーマット：Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_REVIEW_NOTIFICATION_EMAILS_TO';
UPDATE configuration SET configuration_title='「お問い合わせ」メールのドロップダウン設定', configuration_description='「お問い合わせ」ページで、メールアドレスのリストを設定し、ドロップダウンリストとして表示できます。<br />\r\nフォーマット：Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;' WHERE configuration_key='CONTACT_US_LIST';
UPDATE configuration SET configuration_title='ゲストに「友達に知らせる」機能を許可', configuration_description='ゲスト(未登録ユーザ)に「友達に知らせる」機能を許可するかどうかを設定します。 <br />[false]に設定すると、この機能を利用しようとした際にログインを促します。' WHERE configuration_key='ALLOW_GUEST_TO_TELL_A_FRIEND';
UPDATE configuration SET configuration_title='「お問い合わせ」にショップ名と住所を表記', configuration_description='「お問い合わせ」画面にショップ名と住所を表記するかどうかを設定します。<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='CONTACT_US_STORE_NAME_ADDRESS';
UPDATE configuration SET configuration_title='在庫わずかになったらメール送信', configuration_description='商品の在庫が水準を下回った際にメールを送信するかどうかを設定します。<br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='SEND_LOWSTOCK_EMAIL';
UPDATE configuration SET configuration_title='在庫わずかになった際のメール送信先', configuration_description='商品の在庫が水準を下回った際にメールを送信するアドレスを設定します。複数設定することができます。<br />\r\nフォーマット：Name 1 &lt;email@address1&gt;, Name 2 &lt;email@address2&gt;' WHERE configuration_key='SEND_EXTRA_LOW_STOCK_EMAILS_TO';
UPDATE configuration SET configuration_title='「メールマガジンの購読解除」リンクの表示', configuration_description='「メールマガジンの購読解除」リンクをインフォメーションサイドボックスに表示しますか?' WHERE configuration_key='SHOW_NEWSLETTER_UNSUBSCRIBE_LINK';
UPDATE configuration SET configuration_title='オンラインユーザー数の表示設定', configuration_description='オンラインのユーザ(audiences/recipients)を表示する際、recipientsを含めますか?<br /><br />\r\n【注意】この設定をtrueにすると、沢山の顧客がいる場合などに表示が遅くなる場合があります。' WHERE configuration_key='AUDIENCE_SELECT_DISPLAY_COUNTS';
UPDATE configuration SET configuration_title='ダウンロードを有効にする', configuration_description='商品のダウンロード機能を設定します。' WHERE configuration_key='DOWNLOAD_ENABLED';
UPDATE configuration SET configuration_title='リダイレクトでダウンロード画面へ', configuration_description='ダウンロードの際にブラウザによるリダイレクト(転送)を可能にするかどうかを設定します。<br />\r\nUNIX系でないサーバではオフにしてください。\r\n<br />注意：この設定をオンにしたら、/pub ディレクトリのパーミッションを777にしてください。' WHERE configuration_key='DOWNLOAD_BY_REDIRECT';
UPDATE configuration SET configuration_title='ストリーミングによるダウンロード', configuration_description='「リダイレクトでダウンロード」がオフで、かつPHP memory_limit設定が8MB以下の場合、この設定をオンにしてください。ストリーミングで、より小さな単位でのファイル転送を行うためです。<br /><br />「リダイレクトでダウンロード」がオンの場合、効果はありません。' WHERE configuration_key='DOWNLOAD_IN_CHUNKS';
UPDATE configuration SET configuration_title='ダウンロードの有効期限(日数)', configuration_description='ダウンロードリンクの有効期間の日数を設定します。<br /><br />\r\n・0 = 無期限' WHERE configuration_key='DOWNLOAD_MAX_DAYS';
UPDATE configuration SET configuration_title='ダウンロード可能回数(商品ごと)', configuration_description='ダウンロードできる回数の最大値を設定します。<br /><br />\r\n・0 = ダウンロード不可' WHERE configuration_key='DOWNLOAD_MAX_COUNT';
UPDATE configuration SET configuration_title='ダウンロード設定 - 注文状況による更新', configuration_description='orders_statusによるダウンロードの有効期限・可能回数のリセットについて設定します。<br />デフォルト = 4' WHERE configuration_key='DOWNLOADS_ORDERS_STATUS_UPDATED_VALUE';
UPDATE configuration SET configuration_title='ダウンロード可能となる注文ステータスのID - デフォルト >= 2', configuration_description='ダウンロード可能となる注文ステータスのID - デフォルト >= 2<br /><br />注文ステータスのIDがこの値より高い注文はダウンロード可能になります。購入完了時の注文ステータスは支払いモジュールに毎に設定されます。' WHERE configuration_key='DOWNLOADS_CONTROLLER_ORDERS_STATUS';
UPDATE configuration SET configuration_title='ダウンロード終了となる注文ステータスのID', configuration_description='ダウンロード終了となる注文ステータスのID - デフォルト >= 4<br /><br />注文ステータスがこの値より高い注文はダウンロードが終了となります。' WHERE configuration_key='DOWNLOADS_CONTROLLER_ORDERS_STATUS_END';
UPDATE configuration SET configuration_Title='Price Factor属性を可能にする', configuration_Description='Price Factor属性を可能にするかどうかを設定します。' WHERE configuration_key='ATTRIBUTES_ENABLED_PRICE_FACTOR';
UPDATE configuration SET configuration_title='Qty Price Discount属性のオン/オフ', configuration_description='「大量購入による値引き」属性のオン/オフを設定します。' WHERE configuration_key='ATTRIBUTES_ENABLED_QTY_PRICES';
UPDATE configuration SET configuration_title='イメージ属性のオン/オフ', configuration_description='イメージ属性のオン/オフを設定します。' WHERE configuration_key='ATTRIBUTES_ENABLED_IMAGES';
UPDATE configuration SET configuration_title='(言葉・文字による)テキストによる価格設定のオン/オフ', configuration_description='テキストによる価格設定の属性のオン/オフを設定します。' WHERE configuration_key='ATTRIBUTES_ENABLED_TEXT_PRICES';
UPDATE configuration SET configuration_title='テキストによる価格設定 - 空欄の場合は無料', configuration_description='テキストによる価格設定の場合、空欄のままなら無料にするかどうかを設定します。<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='TEXT_SPACES_FREE';
UPDATE configuration SET configuration_title='Read Only属性の商品 -「カートに入れる」ボタンの表示', configuration_description='READONLY属性だけが設定された商品に「カートに入れる」ボタンを表示しますか?<br />0= OFF<br />1= ON' WHERE configuration_key='PRODUCTS_OPTIONS_TYPE_READONLY_IGNORED';
UPDATE configuration SET configuration_title='GZip圧縮を使用する', configuration_description='HTTP通信にGZip圧縮を使用してページを転送しますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='GZIP_LEVEL';
UPDATE configuration SET configuration_title='セッション情報保存ディレクトリ', configuration_description='セッション管理がファイルベースの場合に保存するディレクトリを設定します。' WHERE configuration_key='SESSION_WRITE_DIRECTORY';
UPDATE configuration SET configuration_title='クッキーに保存するドメイン名の設定', configuration_description='クッキーに保存するドメイン名について設定します。<br /><br />\r\n\r\n・True = ドメインネーム全体をクッキーに保存(例：www.mydomain.com)<br />\r\n・False = ドメインネームの一部を保存(例：mydomain.com)。<br />\r\nよくわからない場合はこの設定はTrueにしておいてください。' WHERE configuration_key='SESSION_USE_FQDN';
UPDATE configuration SET configuration_title='クッキー利用を必須にする', configuration_description='セッションに必ずクッキーを利用します。True指定するとブラウザのクッキーがオフになっている場合はセッションを開始しません。セキュリティ上の理由から余程の理由のない限りはTrue指定のままとすることを強く推奨します。', configuration_value='True' WHERE configuration_key='SESSION_FORCE_COOKIE_USE';
UPDATE configuration SET configuration_title='SSLセッションIDチェック', configuration_description='全てのHTTPSリクエストでSSLセッションIDをチェックしますか?' WHERE configuration_key='SESSION_CHECK_SSL_SESSION_ID';
UPDATE configuration SET configuration_title='User Agentチェック', configuration_description='全てのリクエスト時にUser Agentのチェックを行いますか?' WHERE configuration_key='SESSION_CHECK_USER_AGENT';
UPDATE configuration SET configuration_title='IPアドレスチェック', configuration_description='全てのリクエスト時にIPアドレスをチェックしますか?' WHERE configuration_key='SESSION_CHECK_IP_ADDRESS';
UPDATE configuration SET configuration_title='ロボット(スパイダー)のセッションを防止', configuration_description='既知のロボット(スパイダー)がセッションを開始することを防止しますか?' WHERE configuration_key='SESSION_BLOCK_SPIDERS';
UPDATE configuration SET configuration_title='セッション再発行', configuration_description='ユーザーがログオンまたはアカウントを作成した場合にセッションを再発行しますか?<br />(PHP4.1以上が必要)' WHERE configuration_key='SESSION_RECREATE';
UPDATE configuration SET configuration_title='IPアドレス変換の設定', configuration_description='IPアドレスをホストアドレスに変換しますか?<br /><br />注意：サーバによっては、この設定でメール送信のスタート・終了が遅くなることがあります。' WHERE configuration_key='SESSION_IP_TO_HOST_ADDRESS';
UPDATE configuration SET configuration_title='ギフト/クーポン券コードの長さ', configuration_description='ギフト/クーポン券コードの長さを設定します。<br /><br />\r\n注意：コードが長いほど安全です。' WHERE configuration_key='SECURITY_CODE_LENGTH';
UPDATE configuration SET configuration_title='差引残高0の場合の注文ステータス', configuration_description='注文の差引残高が0の場合に適用される注文ステータスを設定します。' WHERE configuration_key='DEFAULT_ZERO_BALANCE_ORDERS_STATUS_ID';
UPDATE configuration SET configuration_title='ウェルカムクーポン券', configuration_description='会員登録時にその会員にウェルカムクーポン券として自動発行するクーポン券を選択してください。' WHERE configuration_key='NEW_SIGNUP_DISCOUNT_COUPON';
UPDATE configuration SET configuration_title='新しいギフト券の登録額', configuration_description='新しいギフト券の登録額を設定します。<br /><br />\r\n・空白 = なし<br />\r\n・1000 = 1000円' WHERE configuration_key='NEW_SIGNUP_GIFT_VOUCHER_AMOUNT';
UPDATE configuration SET configuration_title='クーポン券のページあたり最大表示件数', configuration_description='クーポン券の1ページあたりの表示件数を設定します。' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_DISCOUNT_COUPONS';
UPDATE configuration SET configuration_title='クーポン券レポートのページあたり最大表示件数', configuration_description='クーポン券のレポートページでの表示件数を設定します。' WHERE configuration_key='MAX_DISPLAY_SEARCH_RESULTS_DISCOUNT_COUPONS_REPORTS';
UPDATE configuration SET configuration_title='ギフト券残高の最大値数', configuration_description='ギフト券残高の最大値を設定します。ギフト券引き換え結果がこの値を超える場合は引き換え処理ができません。値は100000以下を指定してください。' WHERE configuration_key='MAX_GIFT_AMOUNT';
UPDATE configuration SET configuration_title='クレジットカード利用の可否 - VISA', configuration_description='VISAを有効にしますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='CC_ENABLED_VISA';
UPDATE configuration SET configuration_title='クレジットカード利用の可否 - MasterCard', configuration_description='MasterCardを有効にしますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='CC_ENABLED_MC';
UPDATE configuration SET configuration_title='クレジットカード利用の可否 - AmericanExpress', configuration_description='AmericanExpressを有効にしますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='CC_ENABLED_AMEX';
UPDATE configuration SET configuration_title='クレジットカード利用の可否 - Diners Club', configuration_description='Diners Clubを有効にしますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='CC_ENABLED_DINERS_CLUB';
UPDATE configuration SET configuration_title='クレジットカード利用の可否 - Discover Card', configuration_description='Discover Cardを有効にしますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='CC_ENABLED_DISCOVER';
UPDATE configuration SET configuration_title='クレジットカード利用の可否 - JCB', configuration_description='JCBを有効にしますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='CC_ENABLED_JCB';
UPDATE configuration SET configuration_title='クレジットカード利用の可否 - AUSTRALIAN BANKCARD', configuration_description='AUSTRALIAN BANKCARDを有効にしますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='CC_ENABLED_AUSTRALIAN_BANKCARD';
UPDATE configuration SET configuration_title='利用可能なクレジットカード - 支払いページに表示', configuration_description='利用可能なクレジットカードを支払いページに表示しますか?<br /><br />\r\n・0= off<br />\r\n・1= テキストを表示<br />\r\n・2= 画像を表示<br />\r\n【注意】クレジットカードの画像とテキストは、データベースとランゲージファイル内で定義されている必要があります。' WHERE configuration_key='SHOW_ACCEPTED_CREDIT_CARDS';
UPDATE configuration SET configuration_title='ギフト券の表示', configuration_description='' WHERE configuration_key='MODULE_ORDER_TOTAL_GV_STATUS';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定します。<br />数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_ORDER_TOTAL_GV_SORT_ORDER';
UPDATE configuration SET configuration_title='購入を承認待ちに', configuration_description='ギフト券購入を承認待ちリストに追加しますか?' WHERE configuration_key='MODULE_ORDER_TOTAL_GV_QUEUE';
UPDATE configuration SET configuration_title='送料を含める', configuration_description='合計計算に送料を含めますか?' WHERE configuration_key='MODULE_ORDER_TOTAL_GV_INC_SHIPPING';
UPDATE configuration SET configuration_title='税金を含める', configuration_description='計算時に税金を含めるかどうかを設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_GV_INC_TAX';
UPDATE configuration SET configuration_title='税金を再計算', configuration_description='税金を再計算しますか?' WHERE configuration_key='MODULE_ORDER_TOTAL_GV_CALC_TAX';
UPDATE configuration SET configuration_title='税種別', configuration_description='ギフト券に適用される税種別を設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_GV_TAX_CLASS';
UPDATE configuration SET configuration_title='税金を付加する', configuration_description='ギフト券を計算する際に税金を付加しますか?' WHERE configuration_key='MODULE_ORDER_TOTAL_GV_CREDIT_TAX';
UPDATE configuration SET configuration_title='低額商品取扱い手数料の表示', configuration_description='' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_STATUS';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定します。数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER';
UPDATE configuration SET configuration_title='低額商品取扱い手数料の設定', configuration_description='低額商品取扱い手数料設定を有効にしますか?' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_LOW_ORDER_FEE';
UPDATE configuration SET configuration_title='低額商品取扱い手数料を課金する注文金額', configuration_description='この注文金額未満の場合、手数料を課金します。' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_ORDER_UNDER';
UPDATE configuration SET configuration_title='取扱い手数料の設定', configuration_description='手数料を設定します。<br /><br />\r\n率(%)で計算する場合には「10%」などと記入し、固定の場合には「500」(500円)などと記入します。' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_FEE';
UPDATE configuration SET configuration_title='低額商品取扱い手数料を適用する地域', configuration_description='設定した地域に対して低額商品取扱い手数料が適用されます。' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_DESTINATION';
UPDATE configuration SET configuration_title='税種別', configuration_description='低額商品取扱い手数料金額に適用される税種別を設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_TAX_CLASS';
UPDATE configuration SET configuration_title='低額商品取扱い手数料はヴァーチャル商品には非適用', configuration_description='カート内がヴァーチャル商品だけの際に、低額商品取扱い手数料を徴収するかどうかを設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_VIRTUAL';
UPDATE configuration SET configuration_title='低額商品取扱い手数料はギフト券には非適用', configuration_description='カート内がギフト券などだけのときに低額商品取扱い手数料を徴収するかどうかを設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_LOWORDERFEE_GV';
UPDATE configuration SET configuration_title='送料の表示', configuration_description='' WHERE configuration_key='MODULE_ORDER_TOTAL_SHIPPING_STATUS';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定します。<br />\r\n数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER';
UPDATE configuration SET configuration_title='送料無料設定', configuration_description='送料無料設定を有効にしますか?' WHERE configuration_key='MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING';
UPDATE configuration SET configuration_title='送料無料にする購入金額設定', configuration_description='設定金額以上のご購入の場合は送料を無料にします。' WHERE configuration_key='MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER';
UPDATE configuration SET configuration_title='送料無料にする地域の設定', configuration_description='設定した地域に対して送料無料を適用します。' WHERE configuration_key='MODULE_ORDER_TOTAL_SHIPPING_DESTINATION';
UPDATE configuration SET configuration_title='小計の表示', configuration_description='' WHERE configuration_key='MODULE_ORDER_TOTAL_SUBTOTAL_STATUS';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定します。<br />\r\n数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER';
UPDATE configuration SET configuration_title='税金の表示', configuration_description='' WHERE configuration_key='MODULE_ORDER_TOTAL_TAX_STATUS';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定できます. 数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_ORDER_TOTAL_TAX_SORT_ORDER';
UPDATE configuration SET configuration_title='合計の表示', configuration_description='' WHERE configuration_key='MODULE_ORDER_TOTAL_TOTAL_STATUS';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定できます。<br />\r\n数字が小さいほど上位に表示されます。' WHERE configuration_key='MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER';
UPDATE configuration SET configuration_title='税種別', configuration_description='クーポン券に適用される税種別を設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_COUPON_TAX_CLASS';
UPDATE configuration SET configuration_title='税金を含める - オン/オフ', configuration_description='代金計算に税金を含めるかどうかを設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_COUPON_INC_TAX';
UPDATE configuration SET configuration_title='表示の整列順', configuration_description='表示の整列順を設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_COUPON_SORT_ORDER';
UPDATE configuration SET configuration_title='送料を含める', configuration_description='送料を計算に含めるかどうかを設定します。' WHERE configuration_key='MODULE_ORDER_TOTAL_COUPON_INC_SHIPPING';
UPDATE configuration SET configuration_title='クーポン券の表示', configuration_description='' WHERE configuration_key='MODULE_ORDER_TOTAL_COUPON_STATUS';
UPDATE configuration SET configuration_title='税金を再計算', configuration_description='税金を再計算しますか?' WHERE configuration_key='MODULE_ORDER_TOTAL_COUPON_CALC_TAX';
UPDATE configuration SET configuration_title='管理者デモ -オン/オフ', configuration_description='管理者デモを有効にするかどうかを設定します。<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='ADMIN_DEMO';
UPDATE configuration SET configuration_title='商品オプション - セレクトボックス型', configuration_description='セレクトボックス型の商品オプションの数値は?' WHERE configuration_key='PRODUCTS_OPTIONS_TYPE_SELECT';
UPDATE configuration SET configuration_title='商品オプション - テキスト型', configuration_description='テキスト型の商品オプションの数値は?' WHERE configuration_key='PRODUCTS_OPTIONS_TYPE_TEXT';
UPDATE configuration SET configuration_title='商品オプション - ラジオボタン型', configuration_description='ラジオボタン型の商品オプションの数値は?' WHERE configuration_key='PRODUCTS_OPTIONS_TYPE_RADIO';
UPDATE configuration SET configuration_title='商品オプション - チェックボックス型', configuration_description='チェックボックス型の商品オプションの数値は?' WHERE configuration_key='PRODUCTS_OPTIONS_TYPE_CHECKBOX';
UPDATE configuration SET configuration_title='商品オプション - ファイル型', configuration_description='ファイル型の商品オプションの数値は?' WHERE configuration_key='PRODUCTS_OPTIONS_TYPE_FILE';
UPDATE configuration SET configuration_title='ID for text and file products options values', configuration_description='テキスト型・ファイル型属性のproducts_options_values_idで使われる数値は?' WHERE configuration_key='PRODUCTS_OPTIONS_VALUES_TEXT_ID';
UPDATE configuration SET configuration_title='アップロードオプションの接頭辞(Prefix)', configuration_description='アップロードオプションを他のオプションと区別するために使う接頭辞(Prefix)は?' WHERE configuration_key='UPLOAD_PREFIX';
UPDATE configuration SET configuration_title='テキストの接頭辞(Prefix)', configuration_description='テキストオプションを他のオプションと区別するために使う接頭辞(Prefix)は?' WHERE configuration_key='TEXT_PREFIX';
UPDATE configuration SET configuration_title='商品オプション - READ ONLY型', configuration_description='READ ONLY型の商品オプションの数値は?' WHERE configuration_key='PRODUCTS_OPTIONS_TYPE_READONLY';
UPDATE configuration SET configuration_title='商品情報 - 商品オプションのソート順', configuration_description='商品情報におけるオプション名のソート順を設定します。<br />\r\n<br />\r\n・0= ソート順、オプション名<br />\r\n・1= オプション名' WHERE configuration_key='PRODUCTS_OPTIONS_SORT_ORDER';
UPDATE configuration SET configuration_title='商品情報 - 商品オプション値のソート順', configuration_description='商品説明での商品オプション値のソート順を設定します。<br />\r\n<br />\r\n・0= ソート順、価格<br />\r\n・1= ソート順、オプション値の名称' WHERE configuration_key='PRODUCTS_OPTIONS_SORT_BY_PRICE';
UPDATE configuration SET configuration_title='商品の属性画像の下に表示するオプション値', configuration_description='商品の属性画像の下にオプション名を表示しますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='PRODUCT_IMAGES_ATTRIBUTES_NAMES';
UPDATE configuration SET configuration_title='商品情報 - セール割引表示', configuration_description='セール割引分を表示しますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='SHOW_SALE_DISCOUNT_STATUS';
UPDATE configuration SET configuration_title='商品情報 - セール割引の表示方法(割引額・パーセント)', configuration_description='セール割引の表示方法を設定します。<br /><br />\r\n・1= 割引率(%) でのoff<br />\r\n・2= 割引金額 でのoff' WHERE configuration_key='SHOW_SALE_DISCOUNT';
UPDATE configuration SET configuration_title='商品情報 - 割引率表示の小数点', configuration_description='割引率表示のパーセントの小数点位置を設定します。<br /><br />\r\n・デフォルト= 0' WHERE configuration_key='SHOW_SALE_DISCOUNT_DECIMALS';
UPDATE configuration SET configuration_title='商品情報- 無料商品の画像・テキストのステータス', configuration_description='商品情報での無料商品の画像・イメージの表示を設定します。<br />\r\n<br />\r\n・0= Text<br />\r\n・1= Image' WHERE configuration_key='OTHER_IMAGE_PRICE_IS_FREE_ON';
UPDATE configuration SET configuration_title='商品情報 - お問い合わせ商品表示設定', configuration_description='お問い合わせ商品であることを表示する画像またはテキストについて設定します。<br /><br />\r\n・0= テキスト<br />\r\n・1= 画像' WHERE configuration_key='PRODUCTS_PRICE_IS_CALL_IMAGE_ON';
UPDATE configuration SET configuration_title='商品の数量欄 - 新しく商品を追加する際に', configuration_description='新しく商品を登録する際、商品の数量欄のデフォルト設定をどうしますか?<br /><br />\r\n・0= off<br />\r\n・1= on<br />\r\n注意：onにすると数量欄を表示し、「カートに加える」もonになります。(This will show a Qty Box when ON and default the Add to Cart to 1)' WHERE configuration_key='PRODUCTS_QTY_BOX_STATUS';
UPDATE configuration SET configuration_title='商品レビュー - 承認の要否', configuration_description='商品レビューの表示には承認が必要にしますか?<br /><br />\r\n・0= off<br />\r\n・1= on<br />\r\n注意：レビューが非表示設定になっている場合は無視されます。' WHERE configuration_key='REVIEWS_APPROVAL';
UPDATE configuration SET configuration_title='METAタグ - TITLEタグへの商品価格表示', configuration_description='TITLEタグに商品価格を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='META_TAG_INCLUDE_PRICE';
UPDATE configuration SET configuration_title='METAタグ - Meta Descriptionの長さ', configuration_description='Meta Descriptionの最大の長さを設定してください。<br />デフォルトの最大値(ワード数)：50' WHERE configuration_key='MAX_META_TAG_DESCRIPTION_LENGTH';
UPDATE configuration SET configuration_title='「こんな商品も購入しています」 - 横列あたりの表示点数', configuration_description='「こんな商品も買っています」の横列(Row)あたりの表示点数を設定します。<br />0= off またはソート順を設定' WHERE configuration_key='SHOW_PRODUCT_INFO_COLUMNS_ALSO_PURCHASED_PRODUCTS';
UPDATE configuration SET configuration_title='[前へ] [次へ] - ナビゲーションバーの位置', configuration_description='[前へ] [次へ] ナビゲーションバーの位置を設定します。<br /><br />\r\n・0= off<br />\r\n・1= ページ上部<br />\r\n・2= ページ下部<br />\r\n・3= ページ上部・下部' WHERE configuration_key='PRODUCT_INFO_PREVIOUS_NEXT';
UPDATE configuration SET configuration_title='[前へ] [次へ] - ソート順', configuration_description='商品のソート順を設定します。\r\n<br /><br />\r\n・0= 商品ID<br />\r\n・1= 商品名<br />\r\n・2= 型番<br />\r\n・3= 価格、商品名<br />\r\n・4= 価格、型番<br />\r\n・5= 商品名, 型番' WHERE configuration_key='PRODUCT_INFO_PREVIOUS_NEXT_SORT';
UPDATE configuration SET configuration_title='[前へ] [次へ] - ボタンと画像のステータス', configuration_description='ボタンと画像のステータスを設定します。<br /><br />\r\n・0= Off<br />\r\n・1= On' WHERE configuration_key='SHOW_PREVIOUS_NEXT_STATUS';
UPDATE configuration SET configuration_title='[前へ] [次へ] - ボタンと画像の表示設定', configuration_description='[前へ] [次へ] のボタンと画像の表示を設定します。<br /><br />\r\n・0= ボタンのみ<br />\r\n・1= ボタン・商品画像<br />\r\n・2= 商品画像のみ' WHERE configuration_key='SHOW_PREVIOUS_NEXT_IMAGES';
UPDATE configuration SET configuration_title='[前へ] [次へ] - 画像の横幅', configuration_description='[前へ] [次へ] 画像の横幅の横幅は?' WHERE configuration_key='PREVIOUS_NEXT_IMAGE_WIDTH';
UPDATE configuration SET configuration_title='[前へ] [次へ] - 画像の高さ', configuration_description='[前へ] [次へ] 画像の横幅の高さは?' WHERE configuration_key='PREVIOUS_NEXT_IMAGE_HEIGHT';
UPDATE configuration SET configuration_title='[前へ] [次へ] - カテゴリ名と画像の配置', configuration_description='[前へ] [次へ] のカテゴリの画像と名称の配置は?<br /><br />\r\n・0= off<br />\r\n・1= 左に配置<br />\r\n・2= 中央に配置<br />\r\n・3= 右に配置' WHERE configuration_key='PRODUCT_INFO_CATEGORIES';
UPDATE configuration SET configuration_title='左側サイドボックスの横幅', configuration_description='左側に表示されるサイドボックスの横幅を設定します。pxを含めて入力できます。\r\n<br /><br />\r\n・デフォルト = 150px' WHERE configuration_key='BOX_WIDTH_LEFT';
UPDATE configuration SET configuration_title='右側サイドボックスの横幅', configuration_description='右側に表示されるサイドボックスの横幅を設定します。pxを含めて入力できます。<br /><br />\r\n・Default = 150px' WHERE configuration_key='BOX_WIDTH_RIGHT';
UPDATE configuration SET configuration_title='パン屑リストの区切り文字', configuration_description='パン屑リストの区切り文字を設定します。<br /><br />\r\n【注意】空白を含む場合は&amp;nbsp;を使用することができます。<br />\r\n・デフォルト = &amp;nbsp;::&amp;nbsp;' WHERE configuration_key='BREAD_CRUMBS_SEPARATOR';
UPDATE configuration SET configuration_title='パン屑リストの設定', configuration_description='パン屑リストのリンクを有効にしますか?<br />0= OFF<br />1= ON' WHERE configuration_key='DEFINE_BREADCRUMB_STATUS';
UPDATE configuration SET configuration_title='ベストセラー - 桁数合わせ文字', configuration_description='桁数を合わせるために挿入する文字を設定します。<br />デフォルト = &amp;nbsp;(空白)' WHERE configuration_key='BEST_SELLERS_FILLER';
UPDATE configuration SET configuration_title='ベストセラー - 表示文字数', configuration_description='ベストセラーのサイドボックスで表示する商品名の長さを設定します。<br />デフォルト = 35' WHERE configuration_key='BEST_SELLERS_TRUNCATE';
UPDATE configuration SET configuration_title='ベストセラー - 表示文字数を超えた場合に「...」を表示', configuration_description='商品名が途中で切れた場合に「...」を表示します。<br />デフォルト = true' WHERE configuration_key='BEST_SELLERS_TRUNCATE_MORE';
UPDATE configuration SET configuration_title='カテゴリボックス - 特価商品のリンク表示', configuration_description='カテゴリボックスに特価商品のリンクを表示します。' WHERE configuration_key='SHOW_CATEGORIES_BOX_SPECIALS';
UPDATE configuration SET configuration_title='カテゴリボックス - 新着商品のリンク表示', configuration_description='カテゴリボックスに新着商品へのリンクを表示します。' WHERE configuration_key='SHOW_CATEGORIES_BOX_PRODUCTS_NEW';
UPDATE configuration SET configuration_title='ショッピングカートボックスの表示', configuration_description='ショッピングカートの表示を設定します。<br />\r\n<br />\r\n・0= 常に表示<br />\r\n・1= 商品が入っているときだけ表示<br />\r\n・2= 商品が入っているときに表示するが、ショッピングカートページでは表示しない' WHERE configuration_key='SHOW_SHOPPING_CART_BOX_STATUS';
UPDATE configuration SET configuration_title='カテゴリボックス - おすすめ商品へのリンクを表示', configuration_description='カテゴリボックスにおすすめ商品へのリンクを表示しますか?' WHERE configuration_key='SHOW_CATEGORIES_BOX_FEATURED_PRODUCTS';
UPDATE configuration SET configuration_title='カテゴリボックス - 全商品リストへのリンクを表示', configuration_description='カテゴリボックスに全商品リストへのリンクを表示しますか?' WHERE configuration_key='SHOW_CATEGORIES_BOX_PRODUCTS_ALL';
UPDATE configuration SET configuration_title='左側カラムの表示', configuration_description='左側カラムを表示しますか? (ページをオーバーライドするものがない場合)<br /><br />\r\n・0= 常に非表示<br />\r\n1= オーバーライドがなければ表示' WHERE configuration_key='COLUMN_LEFT_STATUS';
UPDATE configuration SET configuration_title='右側カラムの表示', configuration_description='右側カラムを表示しますか? (ページをオーバーライドするものがない場合)<br /><br />\r\n・0= 常に非表示<br />\r\n・1= オーバーライドがなければ表示' WHERE configuration_key='COLUMN_RIGHT_STATUS';
UPDATE configuration SET configuration_title='左側カラムの横幅', configuration_description='左側カラムの横幅を設定します。pxを含めて指定可能。<br /><br />\r\nデフォルト = 150px' WHERE configuration_key='COLUMN_WIDTH_LEFT';
UPDATE configuration SET configuration_title='右側カラムの横幅', configuration_description='右側カラムの横幅を設定します。pxを含めて指定可能。<br /><br />\r\nデフォルト = 150px' WHERE configuration_key='COLUMN_WIDTH_RIGHT';
UPDATE configuration SET configuration_title='カテゴリ名・リンク間の区切り', configuration_description='カテゴリ名とリンク（「おすすめ商品」など）の間にセパレータ(区切り)を表示しますか?<br /><br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='SHOW_CATEGORIES_SEPARATOR_LINK';
UPDATE configuration SET configuration_title='カテゴリの区切り - カテゴリ名・商品数', configuration_description='カテゴリ名と(カテゴリ内の)商品数の間のセパレータ(区切り)は何にしますか?<br /><br />\r\nデフォルト = -&amp;gt;' WHERE configuration_key='CATEGORIES_SEPARATOR';
UPDATE configuration SET configuration_title='カテゴリの区切り - カテゴリ名とサブカテゴリ名の間', configuration_description='カテゴリ名・サブカテゴリ名の間のセパレータ(区切り)は何にしますか?<br />\r\n<br />\r\nデフォルト = |_&amp;nbsp;' WHERE configuration_key='CATEGORIES_SEPARATOR_SUBS';
UPDATE configuration SET configuration_title='カテゴリ内商品数の接頭辞(Prefix)', configuration_description='カテゴリ内の商品数表示の接頭辞(Prefix)は?\r\n<br /><br />\r\n・デフォルト= (' WHERE configuration_key='CATEGORIES_COUNT_PREFIX';
UPDATE configuration SET configuration_title='カテゴリ内商品数の接尾辞(Suffix)', configuration_description='カテゴリ内の商品数表示の接尾辞(Suffix)は?\r\n<br /><br />\r\n・デフォルト= )' WHERE configuration_key='CATEGORIES_COUNT_SUFFIX';
UPDATE configuration SET configuration_title='カテゴリ・サブカテゴリのインデント', configuration_description='サブカテゴリをインデント(字下げ)表示する際の文字・記号は?<br /><br />\r\n・デフォルト = &nbsp;&nbsp;' WHERE configuration_key='CATEGORIES_SUBCATEGORIES_INDENT';
UPDATE configuration SET configuration_title='商品登録0のカテゴリ - 表示・非表示', configuration_description='商品数が0のカテゴリを表示しますか?<br />\r\n<br />\r\n・0 = off<br />\r\n・1 = on' WHERE configuration_key='CATEGORIES_COUNT_ZERO';
UPDATE configuration SET configuration_title='カテゴリボックスのスプリット(分割)表示', configuration_description='商品タイプによってカテゴリボックスをスプリット(分割)表示するかどうかを設定します。' WHERE configuration_key='CATEGORIES_SPLIT_DISPLAY';
UPDATE configuration SET configuration_title='ショッピングカート - 合計を表示', configuration_description='合計額をショッピングカートの上に表示しますか?<br />・0= off<br />・1= on: 商品の数量、重量合計<br />・2= on: 商品の数量、重量合計(0のときには非表示)<br />・3= on: 商品の数量合計' WHERE configuration_key='SHOW_TOTALS_IN_CART';
UPDATE configuration SET configuration_title='顧客への挨拶 - トップページに表示', configuration_description='顧客への歓迎メッセージを常にトップページに表示しますか?<br />0= off<br />1= on' WHERE configuration_key='SHOW_CUSTOMER_GREETING';
UPDATE configuration SET configuration_title='カテゴリ - トップページに表示', configuration_description='カテゴリを常にトップページに表示しますか?<br />\r\n・0= off<br />\r\n・1= on<br />\r\n・Default category can be set to Top Level or a Specific Top Level' WHERE configuration_key='SHOW_CATEGORIES_ALWAYS';
UPDATE configuration SET configuration_title='カテゴリ - トップページ での開閉', configuration_description='トップページにおけるカテゴリの開閉状態を設定します。<br />\r\n・0= トップレベル(親)カテゴリのみ<br />\r\n・特定のカテゴリを開くにはカテゴリIDで指定。サブカテゴリも指定可能。<br />\r\n【例】3_10 (カテゴリID:3、サブカテゴリID:10)' WHERE configuration_key='CATEGORIES_START_MAIN';
UPDATE configuration SET configuration_title='カテゴリ - サブカテゴリを常に開いておく', configuration_description='カテゴリとサブカテゴリは常に表示しますか?<br />0= OFF 親カテゴリのみ<br />1= ON カテゴリ・サブカテゴリは選択されたら常に表示' WHERE configuration_key='SHOW_CATEGORIES_SUBCATEGORIES_ALWAYS';
UPDATE configuration SET configuration_title='バナー表示グループ - ヘッダポジション1', configuration_description='どのバナーグループをヘッダポジション1に使用しますか? 使わない場合は未記入にします。<br />\r\n<br />\r\nバナー表示グループは1つ(1バナーグループ)または複数(マルチバナーグループ)にすることもできます。マルチバナーグループを表示するためにはグループ名をコロン(<strong>:</strong>)で区切って入力します。<br />\r\n例：Wide-Banners:SideBox-Banners' WHERE configuration_key='SHOW_BANNERS_GROUP_SET1';
UPDATE configuration SET configuration_title='バナー表示グループ - ヘッダポジション2', configuration_description='どのバナーグループをヘッダポジション2に使用しますか? 使わない場合は未記入にします。<br />\r\n<br />\r\nバナー表示グループは1つ(1バナーグループ)または複数(マルチバナーグループ)にすることもできます。マルチバナーグループを表示するためにはグループ名をコロン(<strong>:</strong>)で区切って入力します。<br />\r\n例：Wide-Banners:SideBox-Banners' WHERE configuration_key='SHOW_BANNERS_GROUP_SET2';
UPDATE configuration SET configuration_title='バナー表示グループ - ヘッダポジション3', configuration_description='どのバナーグループをヘッダポジション3に使用しますか? 使わない場合は未記入にします。<br />\r\n<br />\r\nバナー表示グループは1つ(1バナーグループ)または複数(マルチバナーグループ)にすることもできます。マルチバナーグループを表示するためにはグループ名をコロン(<strong>:</strong>)で区切って入力します。<br />\r\n例：Wide-Banners:SideBox-Banners' WHERE configuration_key='SHOW_BANNERS_GROUP_SET3';
UPDATE configuration SET configuration_title='バナー表示グループ - フッタポジション1', configuration_description='どのバナーグループをフッタポジション1に使用しますか? 使わない場合は未記入にします。<br />\r\n<br />\r\nバナー表示グループは1つ(1バナーグループ)または複数(マルチバナーグループ)にすることもできます。マルチバナーグループを表示するためにはグループ名をコロン(<strong>:</strong>)で区切って入力します。<br />\r\n例：Wide-Banners:SideBox-Banners' WHERE configuration_key='SHOW_BANNERS_GROUP_SET4';
UPDATE configuration SET configuration_title='バナー表示グループ - フッタポジション2', configuration_description='どのバナーグループをフッタポジション2に使用しますか? 使わない場合は未記入にします。<br />\r\n<br />\r\nバナー表示グループは1つ(1バナーグループ)または複数(マルチバナーグループ)にすることもできます。マルチバナーグループを表示するためにはグループ名をコロン(<strong>:</strong>)で区切って入力します。<br />\r\n例：Wide-Banners:SideBox-Banners' WHERE configuration_key='SHOW_BANNERS_GROUP_SET5';
UPDATE configuration SET configuration_title='バナー表示グループ - フッタポジション3', configuration_description='どのバナーグループをフッタポジション3に使用しますか? 使わない場合は未記入にします。<br />\r\n<br />\r\nバナー表示グループは1つ(1バナーグループ)または複数(マルチバナーグループ)にすることもできます。マルチバナーグループを表示するためにはグループ名をコロン(<strong>:</strong>)で区切って入力します。<br />\r\n例：Wide-Banners:SideBox-Banners' WHERE configuration_key='SHOW_BANNERS_GROUP_SET6';
UPDATE configuration SET configuration_title='バナー表示グループ - サイドボックス内バナーボックス', configuration_description='どのバナーグループをサイドボックス内バナーボックス2に使用しますか? 使わない場合は未記入にします。<br />\r\nデフォルトのグループはSideBox-Bannersです。<br />\r\n<br />\r\nバナー表示グループは1つ(1バナーグループ)または複数(マルチバナーグループ)にすることもできます。マルチバナーグループを表示するためにはグループ名をコロン(<strong>:</strong>)で区切って入力します。<br />\r\n例：Wide-Banners:SideBox-Banners' WHERE configuration_key='SHOW_BANNERS_GROUP_SET7';
UPDATE configuration SET configuration_title='バナー表示グループ - サイドボックス内バナーボックス2', configuration_description='どのバナーグループをサイドボックス内バナーボックス2に使用しますか? 使わない場合は未記入にします。<br />\r\nデフォルトのグループはSideBox-Bannersです。<br />\r\n<br />\r\nバナー表示グループは1つ(1バナーグループ)または複数(マルチバナーグループ)にすることもできます。マルチバナーグループを表示するためにはグループ名をコロン(<strong>:</strong>)で区切って入力します。<br />\r\n例：Wide-Banners:SideBox-Banners' WHERE configuration_key='SHOW_BANNERS_GROUP_SET8';
UPDATE configuration SET configuration_title='バナー表示グループ - サイドボックス内バナーボックス全て', configuration_description='サイドボックス内バナーボックス全て(Banner All sidebox)で表示するバナー表示グループは、1つです。デフォルトのグループはBannersAllです。どのバナーグループをサイドボックスのbanner_box_allに表示しますか?<br />表示しない場合は空欄にしてください。' WHERE configuration_key='SHOW_BANNERS_GROUP_SET_ALL';
UPDATE configuration SET configuration_title='フッタ - IPアドレスの表示・非表示', configuration_description='顧客のIPアドレスをフッタに表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1= on<br />' WHERE configuration_key='SHOW_FOOTER_IP';
UPDATE configuration SET configuration_title='数量割引 - 追加割引レベル数', configuration_description='数量割引の割引レベルの追加数を指定します。一つの割引レベルに一つの割引設定を行うことができます。' WHERE configuration_key='DISCOUNT_QTY_ADD';
UPDATE configuration SET configuration_title='数量割引 - 一行あたりの表示数', configuration_description='商品情報ページで表示する数量割引設定の一行あたり表示数を指定します。割引設定数（割引レベル数）が一行あたりの表示数を超えた場合は、複数行で表示されます。' WHERE configuration_key='DISCOUNT_QUANTITY_PRICES_COLUMN';
UPDATE configuration SET configuration_title='カテゴリ/商品のソート順', configuration_description='カテゴリ/商品のソート順を設定します。<br />0= カテゴリ/商品 ソート順/名前<br />1= カテゴリ/商品 名前<br />2= 商品モデル<br />3= 商品数量+, 商品名<br />4= 商品数量-, 商品名<br />5= 商品価格+, 商品名<br />6= 商品価格+, 商品名' WHERE configuration_key='CATEGORIES_PRODUCTS_SORT_ORDER';
UPDATE configuration SET configuration_title='オプション名/オプション値の追加・コピー・削除', configuration_description='オプション名/オプション値の追加・コピー・削除の機能についてのグローバルな設定を行います。<br />0= 機能を隠す<br />1= 機能を表示する<br />2= 商品モデル' WHERE configuration_key='OPTION_NAMES_VALUES_GLOBAL_STATUS';
UPDATE configuration SET configuration_title='カテゴリ - タブメニュー', configuration_description='カテゴリ - タブをオンにするとショップ画面のヘッダ部分にカテゴリが表示されます。さまざまな応用ができるでしょう。<br />0= カテゴリのタブを隠す<br />1= カテゴリのタブを表示' WHERE configuration_key='CATEGORIES_TABS_STATUS';
UPDATE configuration SET configuration_title='サイトマップ - Myページの表示', configuration_description='Myページのリンクをサイトマップに表示しますか?<br />注意：サーチエンジンのクローラーがこのページをインデックスしようとしてログインページに誘導されてしまう可能性があり、お勧めしません。<br /><br />デフォルト：false (表示しない)' WHERE configuration_key='SHOW_ACCOUNT_LINKS_ON_SITE_MAP';
UPDATE configuration SET configuration_title='1商品だけのカテゴリの表示をスキップ', configuration_description='商品が1つだけのカテゴリの表示をスキップしますか?<br />このオプションがTrueの場合、ユーザーが商品が1つだけのカテゴリをクリックすると、Zen Cartは直接商品ページを表示するようになります。<br />デフォルト：True' WHERE configuration_key='SKIP_SINGLE_PRODUCT_CATEGORIES';
UPDATE configuration SET configuration_title='CSSボタン', configuration_description='CSS画像(gif/jpg)の代わりにボタンを表示しますか?<br />ONにした場合、ボタンのスタイルはスタイルシートで定義してください。' WHERE configuration_key='IMAGE_USE_CSS_BUTTONS';
UPDATE configuration SET configuration_title='<strong>「メンテナンス中」 オン/オフ</strong>', configuration_description='「メンテナンス中」の表示について設定します。<br />\r\n<br />\r\n・true=on\r\n・false=off' WHERE configuration_key='DOWN_FOR_MAINTENANCE';
UPDATE configuration SET configuration_title='「メンテナンス中」- 表示するファイル', configuration_description='メンテナンス中に表示するファイルのファイル名を設定します。デフォルトは"down_for_maintenance"です。<br /><br />\r\n【注意】拡張子は付けないでください。' WHERE configuration_key='DOWN_FOR_MAINTENANCE_FILENAME';
UPDATE configuration SET configuration_title='「メンテナンス中」- ヘッダを隠す', configuration_description='「メンテナンス中」表示モードの際、ヘッダを隠しますか?<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='DOWN_FOR_MAINTENANCE_HEADER_OFF';
UPDATE configuration SET configuration_title='「メンテナンス中」- 左カラムを隠す', configuration_description='「メンテナンス中」表示モードの際、左カラムを隠しますか?<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='DOWN_FOR_MAINTENANCE_COLUMN_LEFT_OFF';
UPDATE configuration SET configuration_title='「メンテナンス中」- 右カラムを隠す', configuration_description='「メンテナンス中」表示モードの際、右カラムを隠しますか?<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='DOWN_FOR_MAINTENANCE_COLUMN_RIGHT_OFF';
UPDATE configuration SET configuration_title='「メンテナンス中」- フッタを隠す', configuration_description='「メンテナンス中」表示モードの際、フッタを隠しますか?<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='DOWN_FOR_MAINTENANCE_FOOTER_OFF';
UPDATE configuration SET configuration_title='「メンテナンス中」- 価格を表示しない', configuration_description='「メンテナンス中」表示モードの際、商品価格を隠しますか?<br /><br />\r\n・true=hide<br />\r\n・false=show' WHERE configuration_key='DOWN_FOR_MAINTENANCE_PRICES_OFF';
UPDATE configuration SET configuration_title='「メンテナンス中」- 設定したIPアドレスを除く', configuration_description='ショップ管理者用などに、「メンテナンス中」表示モードの際でもアクセス可能なIPアドレスを設定しますか?<br /><br />\r\n複数のIPアドレスを指定するにはカンマ(,)で区切ります。また、あなたのアクセス元のIPアドレスがわからない場合は、ショップのフッタに表示されるIPアドレスをチェックしてください。' WHERE configuration_key='EXCLUDE_ADMIN_IP_FOR_MAINTENANCE';
UPDATE configuration SET configuration_title='「メンテナンス予告(NOTICE PUBLIC)」-  オン/オフ', configuration_description='ショップの「メンテナンス中」表示を出す前に告知を出しますか?<br /><br />\r\n・true=on<br />\r\n・false=off<br />\r\n注意：「メンテナンス中」表示が有効になると、この設定は自動的にfalseに書き換えられます。' WHERE configuration_key='WARN_BEFORE_DOWN_FOR_MAINTENANCE';
UPDATE configuration SET configuration_title='「メンテナンス予告」- メッセージに表示する日時', configuration_description='ヘッダに表示するメンテナンス予告メッセージの開始日と時間を設定します。' WHERE configuration_key='PERIOD_BEFORE_DOWN_FOR_MAINTENANCE';
UPDATE configuration SET configuration_title='「メンテナンス中」- メンテナンスを開始した日時(when webmaster has enabled maintenance)を表示', configuration_description='ショップ管理者がいつ「メンテナンス中」表示をオンにしたか表示しますか?<br /><br />\r\n・true=on<br />\r\n・false=off' WHERE configuration_key='DISPLAY_MAINTENANCE_TIME';
UPDATE configuration SET configuration_title='「メンテナンス中」- メンテナンス期間を表示', configuration_description='メンテナンスの期間を表示しますか?<br /><br />\r\n・true=on<br />\r\n・false=off' WHERE configuration_key='DISPLAY_MAINTENANCE_PERIOD';
UPDATE configuration SET configuration_title='メンテナンス期間', configuration_description='メンテナンス期間を設定します。<br />\r\n書式：(hh:mm)<br />h = 時間　m = 分' WHERE configuration_key='TEXT_MAINTENANCE_PERIOD_TIME';
UPDATE configuration SET configuration_title='チェックアウト時に「ご利用規約」確認画面を表示', configuration_description='チェックアウトの際に「ご利用規約」の画面を表示しますか?' WHERE configuration_key='DISPLAY_CONDITIONS_ON_CHECKOUT';
UPDATE configuration SET configuration_title='アカウント作成時に個人情報保護方針確認画面を表示', configuration_description='アカウント作成の際、個人情報保護方針への同意画面を表示しますか?<br /><div style="color: red;">注意：「個人情報保護法」では、個人情報保護方針を開示することが求められています。</div>' , configuration_value = 'true' WHERE configuration_key='DISPLAY_PRIVACY_CONDITIONS';
UPDATE configuration SET configuration_title='商品画像を表示', configuration_description='商品画像を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_LIST_IMAGE';
UPDATE configuration SET configuration_title='商品の数量を表示', configuration_description='商品数量を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_LIST_QUANTITY';
UPDATE configuration SET configuration_title='「今すぐ買う」ボタンの表示', configuration_description='「今すぐ買う」ボタンを表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_BUY_NOW';
UPDATE configuration SET configuration_title='商品名の表示', configuration_description='商品名を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_LIST_NAME';
UPDATE configuration SET configuration_title='商品型番の表示', configuration_description='商品型番を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_LIST_MODEL';
UPDATE configuration SET configuration_title='商品メーカーの表示', configuration_description='商品メーカーを表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_LIST_MANUFACTURER';
UPDATE configuration SET configuration_title='商品価格の表示', configuration_description='商品価格を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_LIST_PRICE';
UPDATE configuration SET configuration_title='商品重量の表示', configuration_description='商品の重量を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_LIST_WEIGHT';
UPDATE configuration SET configuration_title='商品登録日の表示', configuration_description='商品登録日を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_NEW_LIST_DATE_ADDED';
UPDATE configuration SET configuration_title='商品説明の表示', configuration_description='商品説明(最初の150文字)を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='PRODUCT_NEW_LIST_DESCRIPTION';
UPDATE configuration SET configuration_title='商品の表示 - デフォルトのソート順', configuration_description='新着商品リストの表示のデフォルトのソート順は? デフォルト値は6です。<br /><br />\r\n・1= 商品名<br />\r\n・2= 商品名(降順)<br />\r\n・3= 価格が安いものから商品名<br />\r\n・4= 価格が高いものから商品名<br />\r\n・5= 型番<br />\r\n・6= 商品登録日(降順)<br />\r\n・7= 商品登録日<br />\r\n・8= 商品順(Product Sort)\r\n' WHERE configuration_key='PRODUCT_NEW_LIST_SORT_DEFAULT';
UPDATE configuration SET configuration_title='新着商品 - デフォルトのグループID', configuration_description='新着商品リストの設定グループID(configuration_group_id)は何ですか?<br />\r\n<br />\r\n注意：全商品リストのグループIDがデフォルトの21から変更されたときだけ設定してください。' WHERE configuration_key='PRODUCT_NEW_LIST_GROUP_ID';
UPDATE configuration SET configuration_title='複数商品の数量欄の有無・表示位置', configuration_description='複数商品の数量欄の表示の有無と表示位置について設定します。<br />0= off<br />1= 上部<br />2= 下部<br />3= 両方' WHERE configuration_key='PRODUCT_NEW_LISTING_MULTIPLE_ADD_TO_CART';
UPDATE configuration SET configuration_title='商品画像の表示', configuration_description='商品画像を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />\r\n' WHERE configuration_key='PRODUCT_FEATURED_LIST_IMAGE';
UPDATE configuration SET configuration_title='商品数量の表示', configuration_description='商品数量を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />\r\n' WHERE configuration_key='PRODUCT_FEATURED_LIST_QUANTITY';
UPDATE configuration SET configuration_title='「今すぐ買う」ボタンの表示', configuration_description='「今すぐ買う」ボタンを表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_FEATURED_BUY_NOW';
UPDATE configuration SET configuration_title='商品名の表示', configuration_description='商品名を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_FEATURED_LIST_NAME';
UPDATE configuration SET configuration_title='商品型番の表示', configuration_description='商品型番を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_FEATURED_LIST_MODEL';
UPDATE configuration SET configuration_title='商品メーカーの表示', configuration_description='商品メーカーを表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_FEATURED_LIST_MANUFACTURER';
UPDATE configuration SET configuration_title='商品価格の表示', configuration_description='商品価格を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_FEATURED_LIST_PRICE';
UPDATE configuration SET configuration_title='商品重量の表示', configuration_description='商品重量を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_FEATURED_LIST_WEIGHT';
UPDATE configuration SET configuration_title='商品登録日の表示', configuration_description='商品登録日を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_FEATURED_LIST_DATE_ADDED';
UPDATE configuration SET configuration_title='商品説明の表示', configuration_description='商品説明(最初の150文字)を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='PRODUCT_FEATURED_LIST_DESCRIPTION';
UPDATE configuration SET configuration_title='商品表示 - デフォルトのソート順', configuration_description='おすすめ商品リストの表示のデフォルトのソート順は? デフォルト値は1です。<br />\r\n<br />\r\n・1= 商品名<br />\r\n・2= 商品名(降順)<br />\r\n・3= 価格が安いものから、商品名<br />\r\n・4= 価格が高いものから、商品名<br />\r\n・5= 型番<br />\r\n・6= 商品登録日(降順)<br />\r\n・7= 商品登録日<br />\r\n・8= 商品順(Product Sort)' WHERE configuration_key='PRODUCT_FEATURED_LIST_SORT_DEFAULT';
UPDATE configuration SET configuration_title='おすすめ商品 - デフォルトのグループID', configuration_description='おすすめ商品リストの設定グループID(configuration_group_id)は何ですか?<br />\r\n<br />\r\n注意：おすすめ商品リストのグループIDがデフォルトの22から変更されたときだけ設定してください。\r\n' WHERE configuration_key='PRODUCT_FEATURED_LIST_GROUP_ID';
UPDATE configuration SET configuration_title='複数商品の数量欄の有無・表示位置', configuration_description='複数商品の数量欄の表示の有無と表示位置について設定します。<br />0= off<br />1= 上部<br />2= 下部<br />3= 両方' WHERE configuration_key='PRODUCT_FEATURED_LISTING_MULTIPLE_ADD_TO_CART';
UPDATE configuration SET configuration_title='商品画像の表示', configuration_description='商品画像を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_LIST_IMAGE';
UPDATE configuration SET configuration_title='商品数量の表示', configuration_description='商品数量を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_LIST_QUANTITY';
UPDATE configuration SET configuration_title='「今すぐ買う」ボタンの表示', configuration_description='「今すぐ買う」ボタンを表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_BUY_NOW';
UPDATE configuration SET configuration_title='商品名の表示', configuration_description='商品名を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_LIST_NAME';
UPDATE configuration SET configuration_title='商品型番の表示', configuration_description='商品型番を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_LIST_MODEL';
UPDATE configuration SET configuration_title='商品メーカーの表示', configuration_description='商品メーカーを表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_LIST_MANUFACTURER';
UPDATE configuration SET configuration_title='商品価格の表示', configuration_description='商品価格を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_LIST_PRICE';
UPDATE configuration SET configuration_title='商品重量の表示', configuration_description='商品重量を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_LIST_WEIGHT';
UPDATE configuration SET configuration_title='商品登録日の表示', configuration_description='商品登録日を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1桁目：左か右か<br />\r\n・2・3桁目：(他の表示項目との)ソート順<br />\r\n・4桁目：表示後の改行(br)数<br />' WHERE configuration_key='PRODUCT_ALL_LIST_DATE_ADDED';
UPDATE configuration SET configuration_title='商品説明の表示', configuration_description='商品説明(最初の150文字)を表示しますか?<br />\r\n<br />\r\n・0= off<br />\r\n・1= on' WHERE configuration_key='PRODUCT_ALL_LIST_DESCRIPTION';
UPDATE configuration SET configuration_title='商品表示 - デフォルトのソート順', configuration_description='全商品リストの表示のデフォルトのソート順は? デフォルト値は1です。<br />\r\n<br />\r\n・1= 商品名<br />\r\n・2= 商品名(降順)<br />\r\n・3= 価格が安いものから、商品名<br />\r\n・4= 価格が高いものから、商品名<br />\r\n・5= 型番<br />\r\n・6= 商品登録日(降順)<br />\r\n・7= 商品登録日<br />\r\n・8= 商品順(Product Sort)' WHERE configuration_key='PRODUCT_ALL_LIST_SORT_DEFAULT';
UPDATE configuration SET configuration_title='全商品リスト - デフォルトのグループID', configuration_description='全商品リストの設定グループID(configuration_group_id)は?<br />\r\n<br />\r\n注意：全商品リストのグループIDがデフォルトの23から変更されたときだけ設定してください。\r\n' WHERE configuration_key='PRODUCT_ALL_LIST_GROUP_ID';
UPDATE configuration SET configuration_title='複数商品の数量欄の有無・表示位置', configuration_description='複数商品の数量欄の表示の有無と表示位置について設定します。<br />0= off<br />1= 上部<br />2= 下部<br />3= 両方' WHERE configuration_key='PRODUCT_ALL_LISTING_MULTIPLE_ADD_TO_CART';
UPDATE configuration SET configuration_title='新着商品をトップページに表示する', configuration_description='新着商品をトップページに表示 しますか?\r\n<br />\r\n0= off<br />\r\nまたは表示順を数値(1～4)で設定してください。\r\n' WHERE configuration_key='SHOW_PRODUCT_INFO_MAIN_NEW_PRODUCTS';
UPDATE configuration SET configuration_title='おすすめ商品をトップページに表示する', configuration_description='おすすめ商品をトップページに表示 しますか?\r\n<br />\r\n0= off<br />\r\nまたは表示順を数値(1～4)で設定してください。\r\n' WHERE configuration_key='SHOW_PRODUCT_INFO_MAIN_FEATURED_PRODUCTS';
UPDATE configuration SET configuration_title='特価商品をトップページに表示する', configuration_description='特価商品をトップページに表示 しますか?\r\n<br />\r\n0= off<br />\r\nまたは表示順を数値(1～4)で設定してください。\r\n' WHERE configuration_key='SHOW_PRODUCT_INFO_MAIN_SPECIALS_PRODUCTS';
UPDATE configuration SET configuration_title='入荷予定商品をトップページに表示する', configuration_description='入荷予定商品をトップページに表示 しますか?\r\n<br />\r\n0= off<br />\r\nまたは表示順を数値(1～4)で設定してください。\r\n' WHERE configuration_key='SHOW_PRODUCT_INFO_MAIN_UPCOMING';
UPDATE configuration SET configuration_title='新着商品をトップページに表示する - カテゴリ・サブカテゴリ共に\r\n', configuration_description='新着商品を(トップレベル)カテゴリ・サブカテゴリ共にトップページに表示 しますか?\r\n<br />\r\n0= off<br />\r\nまたは表示順を数値(1～4)で設定してください。\r\n' WHERE configuration_key='SHOW_PRODUCT_INFO_CATEGORY_NEW_PRODUCTS';
UPDATE configuration SET configuration_title='おすすめ商品をトップページに表示する - カテゴリ・サブカテゴリ共に', configuration_description='おすすめ商品を(トップレベル)カテゴリ・サブカテゴリ共にトップページに表示 しますか?\r\n<br />\r\n0= off<br />\r\nまたは表示順を数値(1～4)で設定してください。\r\n' WHERE configuration_key='SHOW_PRODUCT_INFO_CATEGORY_FEATURED_PRODUCTS';
UPDATE configuration SET configuration_title='特価商品をトップページに表示する - カテゴリ・サブカテゴリ共に', configuration_description='特価商品を(トップレベル)カテゴリ・サブカテゴリ共にトップページに表示 しますか?\r\n<br />\r\n0= off<br />\r\nまたは表示順を数値(1～4)で設定してください。\r\n' WHERE configuration_key='SHOW_PRODUCT_INFO_CATEGORY_SPECIALS_PRODUCTS';
UPDATE configuration SET configuration_title='入荷予定商品をトップページに表示する - カテゴリ・サブカテゴリ共に', configuration_description='入荷予定商品を(トップレベル)カテゴリ・サブカテゴリ共にトップページに表示 しますか?\r\n<br />\r\n0= off<br />\r\nまたは表示順を数値(1～4)で設定してください。\r\n' WHERE configuration_key='SHOW_PRODUCT_INFO_CATEGORY_UPCOMING';
UPDATE configuration SET configuration_title='新着商品をトップページに表示する - エラーとリンク切れ商品ページ', configuration_description='新着予定商品をトップページに表示 しますか?\r\n(エラーとリンク切れ商品ページ・/* 訳注・意味不明 */)<br />\r\n0= off<br />\r\nまたは順番を数値(1～4)で設定してください。' WHERE configuration_key='SHOW_PRODUCT_INFO_MISSING_NEW_PRODUCTS';
UPDATE configuration SET configuration_title='おすすめ商品をトップページに表示する - エラーとリンク切れ商品ページ', configuration_description='おすすめ商品をトップページに表示 しますか?\r\n(エラーとリンク切れ商品ページ・/* 訳注・意味不明 */)<br />\r\n0= off<br />\r\nまたは順番を数値(1～4)で設定してください。' WHERE configuration_key='SHOW_PRODUCT_INFO_MISSING_FEATURED_PRODUCTS';
UPDATE configuration SET configuration_title='特価商品をトップページに表示する - エラーとリンク切れ商品ページ', configuration_description='特価商品をトップページに表示 しますか?\r\n(エラーとリンク切れ商品ページ・/* 訳注・意味不明 */)<br />\r\n0= off<br />\r\nまたは順番を数値(1～4)で設定してください。' WHERE configuration_key='SHOW_PRODUCT_INFO_MISSING_SPECIALS_PRODUCTS';
UPDATE configuration SET configuration_title='入荷予定商品をトップページに表示する - エラーとリンク切れ商品ページ', configuration_description='入荷予定商品をトップページに表示 しますか?\r\n(エラーとリンク切れ商品ページ・/* 訳注・意味不明 */)<br />\r\n0= off<br />\r\nまたは順番を数値(1～4)で設定してください。' WHERE configuration_key='SHOW_PRODUCT_INFO_MISSING_UPCOMING';
UPDATE configuration SET configuration_title='新着商品を表示する - 商品リストの下部に', configuration_description='商品リストの下に新着商品を表示しますか?\r\n<br />0= off <br />\r\nまたは配置順を数値(1～4)で設定してください。' WHERE configuration_key='SHOW_PRODUCT_INFO_LISTING_BELOW_NEW_PRODUCTS';
UPDATE configuration SET configuration_title='おすすめ商品を表示する - 商品リストの下部に', configuration_description='商品リストの下におすすめ商品を表示しますか?\r\n<br />0= off <br />\r\nまたは配置順を数値(1～4)で設定してください。' WHERE configuration_key='SHOW_PRODUCT_INFO_LISTING_BELOW_FEATURED_PRODUCTS';
UPDATE configuration SET configuration_title='特価商品を表示する - 商品リストの下部に', configuration_description='商品リストの下に特価商品を表示しますか?\r\n<br />0= off <br />\r\nまたは配置順を数値(1～4)で設定してください。' WHERE configuration_key='SHOW_PRODUCT_INFO_LISTING_BELOW_SPECIALS_PRODUCTS';
UPDATE configuration SET configuration_title='入荷予定商品を表示する - 商品リストの下部に', configuration_description='商品リストの下に入荷予定商品を表示しますか?\r\n<br />0= off <br />\r\nまたは配置順を数値(1～4)で設定してください。' WHERE configuration_key='SHOW_PRODUCT_INFO_LISTING_BELOW_UPCOMING';
UPDATE configuration SET configuration_title='新着商品 - 横列あたりの表示点数', configuration_description='新着商品の列(Row)あたりの配置点数を設定します。' WHERE configuration_key='SHOW_PRODUCT_INFO_COLUMNS_NEW_PRODUCTS';
UPDATE configuration SET configuration_title='おすすめ商品 - 横列あたりの表示点数', configuration_description='おすすめ商品の列(Row)あたりの配置点数を設定します。' WHERE configuration_key='SHOW_PRODUCT_INFO_COLUMNS_FEATURED_PRODUCTS';
UPDATE configuration SET configuration_title='特価商品 - 横列あたりの表示点数', configuration_description='特価商品の列(Row)あたりの配置点数を設定します。' WHERE configuration_key='SHOW_PRODUCT_INFO_COLUMNS_SPECIALS_PRODUCTS';
UPDATE configuration SET configuration_title='トップレベル(親)カテゴリの商品リスト表示 - フィルタ表示・全商品表示', configuration_description='現在のメインカテゴリに商品リストが適用された際、商品をフィルタ表示しますか? それとも全カテゴリから商品を表示しますか?<br />\r\n・0= Filter\r\n・Off 1=Filter On' WHERE configuration_key='SHOW_PRODUCT_INFO_ALL_PRODUCTS';
UPDATE configuration SET configuration_title='EZページの表示 - ページヘッダ', configuration_description='EZページのコンテンツをページヘッダに表示するかどうかをグローバル(サイト全体)に設定します。<br />0 = Off<br />1 = On<br />2= サイトメンテナンスの際に管理者のIPアドレスでアクセスした場合のみ表示<br />注意：ワーニングは公開されず管理者にだけ表示されます。' WHERE configuration_key='EZPAGES_STATUS_HEADER';
UPDATE configuration SET configuration_title='EZページの表示 - ページフッタ', configuration_description='EZページのコンテンツをページフッタに表示するかどうかをグローバル(サイト全体)に設定します。<br />0 = Off<br />1 = On<br />2= サイトメンテナンスの際に管理者のIPアドレスでアクセスした場合のみ表示<br />注意：ワーニングは公開されず管理者にだけ表示されます。' WHERE configuration_key='EZPAGES_STATUS_FOOTER';
UPDATE configuration SET configuration_title='EZページの表示 - サイドボックス', configuration_description='EZページのコンテンツをサイドボックスに表示するかどうかをグローバル(サイト全体)に設定します。<br />0 = Off<br />1 = On<br />2= サイトメンテナンスの際に管理者のIPアドレスでアクセスした場合のみ表示<br />注意：ワーニングは公開されず管理者にだけ表示されます。' WHERE configuration_key='EZPAGES_STATUS_SIDEBOX';
UPDATE configuration SET configuration_title='EZページ のヘッダ - リンクのセパレータ(区切り記号)', configuration_description='EＺページのヘッダのリンク表示のセパレータ(区切り文字)は?<br />デフォルト = &amp;nbsp;::&amp;nbsp;' WHERE configuration_key='EZPAGES_SEPARATOR_HEADER';
UPDATE configuration SET configuration_title='EZページ のフッタ - リンクのセパレータ(区切り記号)', configuration_description='EＺページのフッタのリンク表示のセパレータ(区切り文字)は?<br />デフォルト = &amp;nbsp;::&amp;nbsp;' WHERE configuration_key='EZPAGES_SEPARATOR_FOOTER';
UPDATE configuration SET configuration_title='EZページ - [次へ][前へ]ボタン', configuration_description='EZページのコンテンツ内[前へ][続ける][次へ]ボタンを表示しますか?<br />0=OFF (ボタンなし)<br />1=「続ける」を表示<br />2=「前へ」「続ける」「次へ」を表示<br /><br />デフォルト：2' WHERE configuration_key='EZPAGES_SHOW_PREV_NEXT_BUTTONS';
UPDATE configuration SET configuration_title='EZページ - 目次の表示', configuration_description='EZページの目次を表示しますか?<br />0= OFF<br />1= ON' WHERE configuration_key='EZPAGES_SHOW_TABLE_CONTENTS';
UPDATE configuration SET configuration_title='EZ-ページ - ヘッダで表示しないページ', configuration_description='EZページのうち通常のページヘッダに表示しないページは?<br />表示しないページのページIDをカンマ(,)区切りで記述してください。ページIDは管理画面の[追加設定・ツール]のEZページ設定画面で確認できます。<br />例：1,5,2<br />ない場合は空欄のまま' WHERE configuration_key='EZPAGES_DISABLE_HEADER_DISPLAY_LIST';
UPDATE configuration SET configuration_title='EZ-ページ - フッタで表示しないページ', configuration_description='EZページのうち通常のページフッタに表示しないページは?<br />表示しないページのページIDをカンマ(,)区切りで記述してください。ページIDは管理画面の[追加設定・ツール]のEZページ設定画面で確認できます。<br />例：3,7<br />ない場合は空欄のまま' WHERE configuration_key='EZPAGES_DISABLE_FOOTER_DISPLAY_LIST';
UPDATE configuration SET configuration_title='EZ-ページ - 左カラムで表示しないページ', configuration_description='EZページのうち通常の左カラムに表示しないページは?<br />表示しないページのページIDをカンマ(,)区切りで記述してください。ページIDは管理画面の[追加設定・ツール]のEZページ設定画面で確認できます。<br />例：6,17<br />ない場合は空欄のまま' WHERE configuration_key='EZPAGES_DISABLE_LEFTCOLUMN_DISPLAY_LIST';
UPDATE configuration SET configuration_title='EZ-ページ - 右カラムで表示しないページ', configuration_description='EZページのうち通常の右カラムに表示しないページは?<br />表示しないページのページIDをカンマ(,)区切りで記述してください。ページIDは管理画面の[追加設定・ツール]のEZページ設定画面で確認できます。<br />例：5,23,47<br />ない場合は空欄のまま' WHERE configuration_key='EZPAGES_DISABLE_RIGHTCOLUMN_DISPLAY_LIST';

UPDATE configuration SET configuration_title='トップページの定義領域 - ステータス', configuration_description = '編集された領域の表示を行いますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_MAIN_PAGE_STATUS';
UPDATE configuration SET configuration_title = '「お問い合わせ」ページの表示 - ステータス', configuration_description = '編集された「お問い合わせ」テキストを表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_CONTACT_US_STATUS';
UPDATE configuration SET configuration_title = '「個人情報保護方針」表示 - ステータス', configuration_description = '編集された「個人情報保護方針」を表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_PRIVACY_STATUS';
UPDATE configuration SET configuration_title = '「配送・送料について」 ページ - ステータス', configuration_description = '編集された「配送・送料について」テキストを表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_SHIPPINGINFO_STATUS';
UPDATE configuration SET configuration_title = '「ご利用規約」ページ - ステータス', configuration_description = '編集された「ご利用規約」ページを表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_CONDITIONS_STATUS';
UPDATE configuration SET configuration_title = '「ご注文が完了しました」ページ - ステータス', configuration_description = '編集された「ご注文が完了しました」テキストを表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_CHECKOUT_SUCCESS_STATUS';
UPDATE configuration SET configuration_title = '「クーポン券」ページ - ステータス', configuration_description = '編集された「クーポン券」テキストを表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_DISCOUNT_COUPON_STATUS';
UPDATE configuration SET configuration_title = '「サイトマップ」ページ - ステータス', configuration_description = '編集された「クーポン券」テキストを表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_SITE_MAP_STATUS';
UPDATE configuration SET configuration_title = '自由編集ページ(Define Page) 2', configuration_description = '自由編集ページ2を表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_PAGE_2_STATUS';
UPDATE configuration SET configuration_title = '自由編集ページ(Define Page) 3', configuration_description = '自由編集ページ3 を表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_PAGE_3_STATUS';
UPDATE configuration SET configuration_title = '自由編集ページ(Define Page) 4', configuration_description = '自由編集ページ(Define Page) 4を表示しますか?<br />0= リンク:表示　　編集領域:非表示<br />1= リンク:表示　　編集領域:表示<br />2= リンク:非表示　編集領域:表示<br />3= リンク:非表示　編集領域:非表示' WHERE configuration_key = 'DEFINE_PAGE_4_STATUS';

# メール送信先を翻訳する
UPDATE query_builder SET query_name='全顧客' WHERE query_id=1;
UPDATE query_builder SET query_name='メールマガジン希望者' WHERE query_id=2;
UPDATE query_builder SET query_name='休眠顧客（過去三ヶ月間、配信希望者のみ）' WHERE query_id=3;
UPDATE query_builder SET query_name='稼動顧客（過去三ヶ月間、配信希望者のみ）' WHERE query_id=4;
UPDATE query_builder SET query_name='稼動顧客（過去三ヶ月間）' WHERE query_id=5;
UPDATE query_builder SET query_name='管理者' WHERE query_id=6;
UPDATE query_builder SET query_name='購入を終えていない顧客' WHERE query_id=7;

# product_type_layoutの翻訳

UPDATE product_type_layout SET configuration_title='型番表示', configuration_description='商品情報で型番を表示する 0= off 1= on' WHERE configuration_title='Show Model Number' AND configuration_description='Display Model Number on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='重量表示', configuration_description='商品情報で型番を表示する 0= off 1= on' WHERE  configuration_title='Show Weight' AND configuration_description='Display Weight on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='オプション重量表示', configuration_description='商品情報でオプションの重量を表示する。 0= off 1= on' WHERE  configuration_title='Show Attribute Weight' AND configuration_description='Display Attribute Weight on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='メーカー表示', configuration_description='商品情報でメーカーを表示する 0= off 1= on' WHERE  configuration_title='Show Manufacture' AND configuration_description='Display Manufacture Name on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='カート内の数量表示', configuration_description='商品情報でカート内の数量を表示する。 0= off 1= on' WHERE  configuration_title='Show Quantity in Shopping Cart' AND configuration_description='Display Quantity in Current Shopping Cart on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='在庫数表示', configuration_description='商品情報で在庫数を表示する。 0= off 1= on' WHERE  configuration_title='Show Quantity in Stock' AND configuration_description='Display Quantity in Stock on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='レビュー数表示', configuration_description='商品情報でレビュー数を表示する 0= off 1= on' WHERE  configuration_title='Show Product Reviews Count' AND configuration_description='Display Product Reviews Count on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='レビューボタン表示', configuration_description='商品情報でレビューボタンを表示する 0= off 1= on' WHERE  configuration_title='Show Product Reviews Button' AND configuration_description='Display Product Reviews Button on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='購入可能になった日付の表示', configuration_description='商品情報で商品が購入可能になった日付を表示する。 0= off 1= on' WHERE  configuration_title='Show Date Available' AND configuration_description='Display Date Available on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='登録日表示', configuration_description='商品情報で商品が登録された日付を表示します。 0= off 1= on' WHERE  configuration_title='Show Date Added' AND configuration_description='Display Date Added on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='商品URL表示', configuration_description='商品情報で商品のURLを表示する 0= off 1= on' WHERE  configuration_title='Show Product URL' AND configuration_description='Display URL on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='[前へ][次へ]ナビゲーションボタン表示', configuration_description='商品情報で[前へ][次へ]ナビゲーションボタンを表示する。<br />0= off<br />1= ページ上部<br />2= ページ下部<br />3= ページ上部、下部' WHERE  configuration_title='Previous Next - Navigation Bar Position' AND configuration_description='Location of Previous/Next Navigation Bar<br />0= off<br />1= Top of Page<br />2= Bottom of Page<br />3= Both Top and Bottom of Page';
UPDATE product_type_layout SET configuration_title='[前へ][次へ]ナビゲーションの並び順', configuration_description='[前へ][次へ]ナビゲーションの並び順を設定する。<br />0= 商品ID<br />1= 商品名<br />2= 型番<br />3= 価格、商品名<br />4= 価格, 型番l<br />5= 商品名、型番' WHERE  configuration_title='Previous Next - Sort Order' AND configuration_description='Products Display Order by<br />0= Product ID<br />1= Product Name<br />2= Model<br />3= Price, Product Name<br />4= Price, Model<br />5= Product Name, Model';
UPDATE product_type_layout SET configuration_title='[前へ][次へ]ナビゲーション - カテゴリ表示', configuration_description='[前へ][次へ]ボタンの上に表示するカテゴリ名/画像の表示位置<br />0= off<br />1= 左寄せ<br />2= 中央寄せ<br />3= 右寄せ' WHERE  configuration_title='Previous Next - Navigation Includes Category' AND configuration_description='Product\'s Category Image and Name Alignment Above Previous/Next Navigation Bar<br />0= off<br />1= Align Left<br />2= Align Center<br />3= Align Right';
UPDATE product_type_layout SET configuration_title='「友達に知らせる」ボタン表示', configuration_description='商品情報で「友達に知らせる」ボタンを表示する。<br /><br />Note: この設定をoffにしてもサイドボックスの「友達に知らせる」は消えません。また、サイドボックスの「友達に知らせる」をoffにしてもこのボタン表示の設定に影響はありません。<br />0= off 1= on' WHERE  configuration_title='Show Product Tell a Friend button' AND configuration_description='Display the Tell a Friend button on Product Info<br /><br />Note: Turning this setting off does not affect the Tell a Friend box in the columns and turning off the Tell a Friend box does not affect the button<br />0= off 1= on';
UPDATE product_type_layout SET configuration_title='不明商品ページアクセス時に新商品のページを表示する', configuration_description='不明な商品ページにアクセスがあった場合に新商品ページを表示する 0= off 1= on' WHERE  configuration_title='Show New Products on Missing Products Page' AND configuration_description='Show New Products on Missing Product 0= off 1= on';
UPDATE product_type_layout SET configuration_title='不明商品ページアクセス時に入荷予定商品のページを表示する', configuration_description='不明な商品ページにアクセスがあった場合に入荷予定商品のページを表示する 0= off 1= on' WHERE  configuration_title='Show Upcoming Products on Missing Products Page' AND configuration_description='Show Upcoming Products on Missing Product 0= off 1= on';
UPDATE product_type_layout SET configuration_title='商品情報 - 商品オプションの整列順', configuration_description='商品オプションの整列順に使用する値を設定します。<br>0= 整列順番号、オプション名<br>1= オプション名のみ' WHERE  configuration_title='' AND configuration_description='0';
UPDATE product_type_layout SET configuration_title='商品情報 - 属性整列順', configuration_description='商品オプションの属性の整列順に使用する値を設定します。<br>0= 整列順番号, 価格<br>1= 整列順番号、オプションの値' WHERE  configuration_title='' AND configuration_description='1';
UPDATE product_type_layout SET configuration_title='1行に表示する商品オプション画像数', configuration_description='商品情報 - 一行に表示する商品オプションの画像数を設定します。<br />デフォルト = 5' WHERE  configuration_title='Product Info - Number of Attribute Images per Row' AND configuration_description='Product Info - Enter the number of attribute images to display per row<br />Default = 5';
UPDATE product_type_layout SET configuration_title='商品オプション画像の下に表示するオプションの値', configuration_description='商品オプション画像の下にオプションの値を表示します。<br />0= off 1= on' WHERE  configuration_title='Product Info - Show Option Values Name Below Attributes Image' AND configuration_description='Product Info - Show the name of the Option Value beneath the Attribute Image?<br />0= off 1= on';
UPDATE product_type_layout SET configuration_title='商品情報 - フォーム要素(ラジオボタンまたはチェックボックス)', configuration_description='0= 画像の下にオプション名<br />1= フォーム要素、画像、オプション名<br />2= フォーム要素、画像、下にオプション名<br />3= 画像、フォーム要素、下にオプション名<br />4=画像、オプション名、下にフォーム要素<br />5= 画像、オプション名、上にフォーム要素' WHERE  configuration_title='Product Info - Show Option Values and Attributes Images for Radio Buttons and Checkboxes' AND configuration_description='0= Images Below Option Names<br />1= Element, Image and Option Value<br />2= Element, Image and Option Name Below<br />3= Option Name Below Element and Image<br />4= Element Below Image and Option Name<br />5= Element Above Image and Option Name';
UPDATE product_type_layout SET configuration_title='商品情報 - セール割引表示', configuration_description='セール割引分を表示します。<br />0= off 1= on' WHERE  configuration_title='Product Info - Show Sales Discount Savings Status' AND configuration_description='Product Info - Show the amount of discount savings?<br />0= off 1= on';
UPDATE product_type_layout SET configuration_title='商品情報 - セール割引の表示方法(割引額 , パーセント)', configuration_description='セール割引の表示方法を設定します。:<br />1= 割引率(%) off 2= 割引金額 off' WHERE  configuration_title='Product Info - Show Sales Discount Savings Dollars or Percentage' AND configuration_description='Product Info - Show the amount of discount savings display as:<br />1= % off 2= $amount off';
UPDATE product_type_layout SET configuration_title='商品情報 - 割引率表示の小数点', configuration_description='割引率表示のパーセントの小数点位置を設定します。<br />デフォルト= 0' WHERE  configuration_title='Product Info - Show Sales Discount Savings Percentage Decimals' AND configuration_description='Product Info - Show discount savings display as a Percentage with how many decimals?:<br />Default= 0';
UPDATE product_type_layout SET configuration_title= '商品情報 - 無料商品表示設定', configuration_description='無料商品であることを画像またはテキストで表示します。<br />0= テキスト<br />1= 画像' WHERE  configuration_title='Product Info - Price is Free Image or Text Status' AND configuration_description='Product Info - Show the Price is Free Image or Text on Displayed Price<br />0= Text<br />1= Image';
UPDATE product_type_layout SET configuration_title='商品情報 - お問合せ商品表示設定', configuration_description='お問合せ商品であることを画像またはテキストで表示します。<br />0= テキスト<br />1= 画像' WHERE  configuration_title='Product Info - Price is Call for Price Image or Text Status' AND configuration_description='Product Info - Show the Price is Call for Price Image or Text on Displayed Price<br />0= Text<br />1= Image';
UPDATE product_type_layout SET configuration_title='新商品登録時の在庫表示', configuration_description='新商品登録画面でデフォルトの在庫の表示/非表示ステータスを設定します。<br /><br />0= off<br />1= on<br />NOTE: ONにした場合在庫ボックスを表示するようになり、「カートにいれる」ボックスに1が表示されるようになります。' WHERE  configuration_title='Product Quantity Box Status' AND configuration_description='What should the Default Quantity Box Status be on New Products?<br /><br />0= off<br />1= on<br />NOTE: This will show a Qty Box when ON and default the Add to Cart to 1';
UPDATE product_type_layout SET configuration_title='送料無料のデフォルトステータス - 新商品追加時', configuration_description='新商品を追加する時の、送料無料のデフォルトステータスをONにしますか？' WHERE configuration_title='Product Free Shipping Default Status - Normal Shipping Rules - When adding new products?' AND configuration_description='What should the Default Free Shipping status be when adding new products?';
UPDATE product_type_layout SET configuration_title='送料無料の画像ステータス - カタログ', configuration_description='カタログ中の送料無料の画像/テキストを表示しますか？' WHERE configuration_title='Product Free Shipping Image Status - Catalog' AND configuration_description='Show the Free Shipping image/text in the catalog?';
UPDATE product_type_layout SET configuration_title='税種別のデフォルト - 新商品追加時', configuration_description='新商品を追加する時の、税種別のデフォルトIDを入力してください。' WHERE configuration_title='Product Price Tax Class Default - When adding new products?' AND configuration_description='What should the Product Price Tax Class Default ID be when adding new products?';
UPDATE product_type_layout SET configuration_title='ヴァーチャル商品のデフォルトステータス - 新商品追加時', configuration_description='新商品を追加する時の、ヴァーチャル商品のデフォルトステータスをONにしますか？' WHERE configuration_title='Product Virtual Default Status - Skip Shipping Address - When adding new products?' AND configuration_description='Default Virtual Product status to be ON when adding new products?';
UPDATE product_type_layout SET configuration_title='アーティストの表示', configuration_description='商品ページに、アーティスト名を表示しますか？0= off 1= on' WHERE configuration_title='Show Artist' AND configuration_description='Display Artists Name on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='メーカーの表示', configuration_description='商品ページに、メーカー名を表示しますか？0= off 1= on' WHERE configuration_title='Show Manufacturer' AND configuration_description='Display Manufacturer Name on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='音楽ジャンルの表示', configuration_description='商品ページに、音楽ジャンルを表示しますか？0= off 1= on' WHERE configuration_title='Show Music Genre' AND configuration_description='Display Music Genre on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='レコード会社の表示', configuration_description='商品ページに、レコード会社を表示しますか？0= off 1= on' WHERE configuration_title='Show Record Company' AND configuration_description='Display Recoprd Company on Product Info 0= off 1= on';
UPDATE product_type_layout SET configuration_title='ベース価格の表示', configuration_description='商品ページに、ベース価格を表示しますか？0= off 1= on' WHERE configuration_title='Show Starting At text on Price' AND configuration_description='Display Starting At text on products with attributes Product Info 0= off 1= on';

ALTER TABLE coupon_gv_customer CHANGE amount amount decimal(20,4) NOT NULL default '0.0000';
ALTER TABLE coupon_gv_queue CHANGE amount amount decimal(20,4) NOT NULL default '0.0000';
UPDATE configuration SET configuration_value='On' where configuration_key='MISSING_PAGE_CHECK';
UPDATE configuration SET configuration_value='107' where configuration_key='SHIPPING_ORIGIN_COUNTRY';

# オプションタイプtextの利用可能設定

INSERT INTO products_options_values (products_options_values_id, language_id, products_options_values_name) VALUES (0, 2, 'TEXT');
