import java.awt.geom.Rectangle2D;
import java.util.*;

/*
 * : 2003/12/13
 */

/**
 * ϿޤХå饦ɤɤ߹ॹåɤǤ
 * @author Kumano Tatsuo
 */
class LoadMapThread extends Thread {

	public static void main(String[] args) {
	}

	private double keepCoefficient; // ̲ʬΥǡ¸Ƥ
	private Map maps;
	private MapPanel panel;
	private double preLoadCoefficient; // ̲ʬΥǡɤߤ뤫

	LoadMapThread(Map maps, MapPanel panel) {
		this.maps = maps;
		this.panel = panel;
		preLoadCoefficient = 1;
		keepCoefficient = 2;
	}

	public void run() {
		while (true) {
			try {
				double zoom = ((MapPanel)panel).getZoom();
				boolean isMapChanged = false;
				for (Iterator iter = maps.entrySet().iterator(); iter.hasNext();) {
					Map.Entry entry = (Map.Entry)iter.next();
					MapData mapData = ((MapData)entry.getValue());
					Rectangle2D visibleRectangle = ((MapPanel)panel).getVisibleArea();
					Rectangle2D preLoadRectangle =
						new Rectangle2D.Double(
							visibleRectangle.getX() - visibleRectangle.getWidth() * preLoadCoefficient,
							visibleRectangle.getY() - visibleRectangle.getHeight() * preLoadCoefficient,
							visibleRectangle.getWidth() + visibleRectangle.getWidth() * preLoadCoefficient * 2,
							visibleRectangle.getHeight() + visibleRectangle.getHeight() * preLoadCoefficient * 2);
					Rectangle2D keepRectangle =
						new Rectangle2D.Double(
							visibleRectangle.getX() - visibleRectangle.getWidth() * keepCoefficient,
							visibleRectangle.getY() - visibleRectangle.getHeight() * keepCoefficient,
							visibleRectangle.getWidth() + visibleRectangle.getWidth() * keepCoefficient * 2,
							visibleRectangle.getHeight() + visibleRectangle.getHeight() * keepCoefficient * 2);
					if (preLoadRectangle.intersects(mapData.getBounds())) {
						// Įǡɤ߹
						if (zoom > 0.05) {
							if (!mapData.hasGyousei()) {
								System.out.println("Loaded " + entry.getKey() + ".");
								mapData.loadGyousei();
								isMapChanged = true;
							}
							if(!mapData.hasSi_tyo()){
								System.out.println("Loaded " + entry.getKey() + ".");
								mapData.loadSi_tyo();
								isMapChanged = true;
							}
						}
					} else if (!keepRectangle.intersects(mapData.getBounds())) {
						// Įǡ
						if (mapData.hasGyousei()) {
							System.out.println("Freed " + entry.getKey() + ".");
							mapData.freeGyousei();
							isMapChanged = true;
						}
						if (mapData.hasSi_tyo()) {
							System.out.println("Freed " + entry.getKey() + ".");
							mapData.freeSi_tyo();
							isMapChanged = true;
						}
					}
				}
				if (isMapChanged) {
					panel.repaint();
				}
				Thread.sleep(1000);
			} catch (Exception exception) {
				System.err.println("Failed to load map.");
				exception.printStackTrace(System.err);
			}
			((MapPanel)panel).setMapData(maps);
		}
	}
}
