import java.awt.geom.*;
import java.io.*;
import java.util.*;

/*
 * : 2003/12/11
 */

/**
 * Ͽޥǡ򰷤饹Ǥ
 * @author Kumano Tatsuo
 */
class MapData {

	public static void main(String[] args) throws Exception {
		MapData mapData = new MapData("/home/kumano/map_data/suchi_chizu_2500", "05OF833");
		System.out.println(mapData.getGyousei());
		System.out.println(mapData.getSi_tyo());
	}

	private String baseDir;
	private Map eki;
	private Map gyousei; // String  -> Arc  Map
	private String mapName;
	private Map mizu;
	private Rectangle2D rectangle;
	private Map road;
	private Map sankaku;
	private Map si_tyo; // String -> Polygon  Map
	private Map tatemono;
	private Map tetudou;
	private Map tyome;
	private Map zyouti;

	/**
	 * Ͽޤޤ
	 * @param baseDir ϿޥǡΤǥ쥯ȥ
	 * @param mapName Ͽޤ̾
	 */
	MapData(String baseDir, String mapName) throws Exception {
		setBaseDir(baseDir);
		setMapName(mapName);
		loadRectangle();
	}

	void freeGyousei() {
		gyousei = null;
	}

	void freeMizu() {
		mizu = null;
	}

	void freeSi_tyo() {
		si_tyo = null;
	}

	/**
	 * @return
	 */
	String getBaseDir() {
		return baseDir;
	}

	/**
	 * @return
	 */
	Rectangle2D getBounds() {
		return rectangle;
	}

	/**
	 * @return
	 */
	Map getGyousei() throws Exception {
		if (gyousei == null) {
			loadGyousei();
		}
		return gyousei;
	}

	/**
	 * @return
	 */
	String getMapName() {
		return mapName;
	}

	/**
	 * @return
	 */
	Map getMizu() throws Exception {
		if (mizu == null) {
			loadMizu();
		}
		return mizu;
	}

	/**
	 * @return
	 */
	Map getSi_tyo() throws Exception {
		if (si_tyo == null) {
			loadSi_tyo();
		}
		return si_tyo;
	}

	boolean hasGyousei() {
		return gyousei != null;
	}

	boolean hasMizu() {
		return mizu != null;
	}

	boolean hasSi_tyo() {
		return si_tyo != null;
	}

	/**
	 * ̤ξե뤫ɤ߹ߤޤ
	 * @param arcs 
	 * @param in ץåȥȥ꡼
	 * @throws IOException
	 */
	private void loadArc(Map arcs, BufferedReader in) throws IOException {
		String line;
		String arcName = null;
		int type = 0;
		int tag = 0;
		GeneralPath path = null;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 4) {
				// ̤ϤޤȤ
				if (path != null) {
					arcs.put(arcName, new Arc(arcName, path, type, tag));
				}
				String code = tokenizer.nextToken(); // ޼ʬॳ
				if (code.equals("L1101")) {
					type = Arc.TYPE_GYOUSEI_PREFECTURE;
				} else if (code.equals("L1103")) {
					type = Arc.TYPE_GYOUSEI_CITY;
				} else if (code.equals("L1104")) {
					type = Arc.TYPE_GYOUSEI_VILLAGE;
				} else if (code.equals("L1106")) {
					type = Arc.TYPE_GYOUSEI_CHOME;
				} else if (code.equals("L5101")) {
					type = Arc.TYPE_MIZU_INSIDE;
				} else if (code.equals("L5106")) {
					type = Arc.TYPE_MIZU_SEASHORE;
				} else {
					type = Arc.TYPE_UNKNOWN;
				}
				tag = Integer.parseInt(tokenizer.nextToken()); // 勵
				arcName = tokenizer.nextToken(); // ֹ
				path = null;
			} else if (tokenizer.countTokens() == 2) {
				// ̤ɸΤȤ
				float x = Float.parseFloat(tokenizer.nextToken()); // x ɸ
				float y = Float.parseFloat(tokenizer.nextToken()); // y ɸ
				if (path != null) {
					if (tag == Arc.TAG_DETACHED || tag == Arc.TAG_EDGE_OF_MAP || tag == Arc.TAG_EDGE_OF_WORLD) {
						path.lineTo(x + (float) getBounds().getX(), y + (float) getBounds().getY());
					} else {
						path.lineTo(x + (float) getBounds().getX(), y + (float) getBounds().getY());
					}
				} else {
					path = new GeneralPath();
					path.moveTo(x + (float) getBounds().getX(), y + (float) getBounds().getY());
				}
			}
		}
		if (path != null) {
			arcs.put(arcName, new Arc(arcName, path, type, tag));
		}
	}

	/**
	 * θ̥եɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadGyousei() throws Exception {
		gyousei = new HashMap();
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ "gyousei"
							+ File.separator
							+ "gyousei.arc")));
		loadArc(gyousei, in);
	}

	/**
	 * 峦θ̥եɤ߹ߤޤ
	 * @throws Exception
	 */
	void loadMizu() throws Exception {
		mizu = new HashMap();
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ "mizu"
							+ File.separator
							+ "mizu.arc")));
		loadArc(mizu, in);
	}

	/**
	 * ݥꥴξե뤫ɤ߹ߤޤ
	 * @param polygons ݥꥴ
	 * @param ars ݥꥴ
	 * @param in ץåȥȥ꡼
	 * @throws IOException
	 */
	private void loadPolygon(Map polygons, Map arcs, BufferedReader in) throws IOException {
		String line;
		String polygonName = null;
		GeneralPath path = null;
		int type = 0;
		double x = 0;
		double y = 0;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 5) {
				// ݥꥴ󤬻ϤޤȤ
				if (path != null) {
					polygons.put(polygonName, new Polygon(polygonName, path, type, x, y));
				}
				String code = tokenizer.nextToken(); // ޼ʬॳ
				if (code.equals("A1105")) {
					type = Polygon.TYPE_SHI_KU_CHO_SON;
				} else if (code.equals("A1106")) {
					type = Polygon.TYPE_OAZA_CHOME;
				} else if (code.equals("A6241")) {
					type = Polygon.TYPE_RAILROAD;
				} else if (code.equals("A6242")) {
					type = Polygon.TYPE_PARK;
				} else if (code.equals("A6243")) {
					type = Polygon.TYPE_SCHOOL;
				} else if (code.equals("A6244")) {
					type = Polygon.TYPE_TEMPLE;
				} else if (code.equals("A6215")) {
					type = Polygon.TYPE_GRAVEYARD;
				} else if (code.equals("A6200")) {
					type = Polygon.TYPE_OTHER;
				} else if (code.equals("A5101")) {
					type = Polygon.TYPE_RIVER;
				} else if (code.equals("A5105")) {
					type = Polygon.TYPE_LAKE;
				} else if (code.equals("A3500")) {
					type = Polygon.TYPE_BUILDING;
				} else {
					type = Polygon.TYPE_UNKNOWN;
				}
				polygonName = tokenizer.nextToken(); // ֹ
				tokenizer.nextToken(); // ݥꥴ륢쥳ɤο
				x = Double.parseDouble(tokenizer.nextToken()); // ɽ x ɸ
				y = Double.parseDouble(tokenizer.nextToken()); // ɽ y ɸ
				path = null;
			} else if (tokenizer.countTokens() == 1) {
				// ݥꥴ̤ΤȤ
				int arcIndex = Integer.parseInt(tokenizer.nextToken()); // 쥳
				String arcName = new Integer(Math.abs(arcIndex)).toString();
				boolean isReverse = arcIndex < 0;
				if (path != null) {
					if (isReverse) {
						path.append(((Arc) arcs.get(arcName)).getReversalPath(), true);
					} else {
						path.append(((Arc) arcs.get(arcName)).getPath(), true);
					}
				} else {
					path = new GeneralPath();
					if (isReverse) {
						path.append(((Arc) arcs.get(arcName)).getReversalPath(), true);
					} else {
						path.append(((Arc) arcs.get(arcName)).getPath(), true);
					}
				}
			}
			if (path != null) {
				polygons.put(polygonName, new Polygon(polygonName, path, type, x, y));
			}
		}
	}

	/**
	 * Ͽޤΰե뤫ɤ߹ߤޤ
	 */
	private void loadRectangle() throws Exception {
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ mapName.toLowerCase()
							+ ".txt"),
					"SJIS"));
		String line;
		while ((line = in.readLine()) != null) {
			StringTokenizer tokenizer = new StringTokenizer(line, ",");
			if (tokenizer.countTokens() == 10) {
				String dummy = tokenizer.nextToken();
				double x1 = Double.parseDouble(tokenizer.nextToken());
				double y1 = Double.parseDouble(tokenizer.nextToken());
				double x2 = Double.parseDouble(tokenizer.nextToken());
				double y2 = Double.parseDouble(tokenizer.nextToken());
				setRectangle(new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1));
				break;
			}
		}
		in.close();
	}

	/**
	 * ĮΥݥꥴեɤ߹ߤޤ
	 * 
	 * @throws Exception
	 */
	void loadSi_tyo() throws Exception {
		si_tyo = new HashMap();
		BufferedReader in =
			new BufferedReader(
				new InputStreamReader(
					new FileInputStream(
						baseDir
							+ File.separator
							+ mapName.toUpperCase()
							+ File.separator
							+ "gyousei"
							+ File.separator
							+ "si_tyo.pgn")));
		loadPolygon(si_tyo, gyousei, in);
	}

	/**
	 * @param string
	 */
	private void setBaseDir(String string) {
		baseDir = string;
	}

	/**
	 * @param string
	 */
	private void setMapName(String string) {
		mapName = string;
	}

	/**
	 * @param rectangle2D
	 */
	private void setRectangle(Rectangle2D rectangle2D) {
		rectangle = rectangle2D;
	}

	public String toString() {
		return "[MapData name=" + mapName + ", gyousei=" + gyousei + "]";
	}
}
