#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 cpphs
version:              1.20.9.1
visibility:           public
id:                   cpphs-1.20.9.1-8u5B4l6K95R8QvpGeHGR6D
key:                  cpphs-1.20.9.1-8u5B4l6K95R8QvpGeHGR6D
license:              LicenseRef-LGPL
copyright:            2004-2017, Malcolm Wallace
maintainer:           Malcolm Wallace <Malcolm.Wallace@me.com>
author:               Malcolm Wallace <Malcolm.Wallace@me.com>
homepage:             http://projects.haskell.org/cpphs/
synopsis:
    A liberalised re-implementation of cpp, the C pre-processor.

description:
    Cpphs is a re-implementation of the C pre-processor that is both
    more compatible with Haskell, and itself written in Haskell so
    that it can be distributed with compilers.

    This version of the C pre-processor is pretty-much
    feature-complete and compatible with traditional (K&R)
    pre-processors.  Additional features include: a plain-text mode;
    an option to unlit literate code files; and an option to turn
    off macro-expansion.

category:             Development
abi:                  a69b44a89c9276876c01e0a3901b258f
exposed:              True
exposed-modules:
    Language.Preprocessor.Cpphs Language.Preprocessor.Unlit

hidden-modules:
    Language.Preprocessor.Cpphs.CppIfdef
    Language.Preprocessor.Cpphs.HashDefine
    Language.Preprocessor.Cpphs.MacroPass
    Language.Preprocessor.Cpphs.Options
    Language.Preprocessor.Cpphs.Position
    Language.Preprocessor.Cpphs.ReadFirst
    Language.Preprocessor.Cpphs.RunCpphs
    Language.Preprocessor.Cpphs.SymTab
    Language.Preprocessor.Cpphs.Tokenise TimeCompat

import-dirs:          /usr/lib/ghc-8.10.5/site-local/cpphs-1.20.9.1
library-dirs:         /usr/lib/ghc-8.10.5/site-local/cpphs-1.20.9.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.5/cpphs-1.20.9.1
hs-libraries:         HScpphs-1.20.9.1-8u5B4l6K95R8QvpGeHGR6D
depends:
    base-4.14.2.0 directory-1.3.6.0
    polyparse-1.13-4Tks6P3TcZl5fGSKCByHwM time-1.9.3

haddock-interfaces:   /usr/share/doc/haskell-cpphs/html/cpphs.haddock
haddock-html:         /usr/share/doc/haskell-cpphs/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

