/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.GUIPrefs;
import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.gui.ButtonFactory;
import com.izforge.izpack.gui.IzPackMetalTheme;
import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerBase;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.ResourceManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.TreeMap;
import javax.swing.GrayFilter;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;

public class GUIInstaller
extends InstallerBase {
    private InstallData installdata = new InstallData();
    protected String lnf;

    public GUIInstaller() throws Exception {
        this.loadInstallData(this.installdata);
        this.loadGUIInstallData();
        this.loadLookAndFeel();
        this.checkJavaVersion();
        this.loadLangPack();
        ResourceManager.create(this.installdata);
        this.loadGUI();
    }

    public void loadGUIInstallData() throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/GUIPrefs");
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        this.installdata.guiPrefs = (GUIPrefs)objectInputStream.readObject();
        objectInputStream.close();
    }

    private void checkJavaVersion() throws Exception {
        String string;
        String string2 = System.getProperty("java.version");
        if (string2.compareTo(string = this.installdata.info.getJavaVersion()) < 0) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("The application that you are trying to install requires a ");
            stringBuffer.append(string);
            stringBuffer.append(" version or later of the Java platform.\n");
            stringBuffer.append("You are running a ");
            stringBuffer.append(string2);
            stringBuffer.append(" version of the Java platform.\n");
            stringBuffer.append("Please upgrade to a newer version.");
            System.out.println(stringBuffer.toString());
            JOptionPane.showMessageDialog(null, stringBuffer.toString(), "Error", 0);
            System.exit(1);
        }
    }

    private void loadLangPack() throws Exception {
        String string;
        Object object;
        ArrayList arrayList = this.getAvailableLangPacks();
        int n = arrayList.size();
        if (n == 0) {
            throw new Exception("no language pack available");
        }
        if (n != 1) {
            object = new LanguageDialog(arrayList.toArray());
            ((LanguageDialog)object).setSelection(Locale.getDefault().getISO3Country().toLowerCase());
            ((Dialog)object).setModal(true);
            ((Dialog)object).show();
            string = (String)((LanguageDialog)object).getSelection();
            if (string == null) {
                throw new Exception("installation canceled");
            }
        } else {
            string = (String)arrayList.get(0);
        }
        this.installdata.xmlData.setAttribute("langpack", string);
        this.installdata.localeISO3 = string;
        this.installdata.setVariable("IS03_LANG", this.installdata.localeISO3);
        object = this.getClass().getResourceAsStream("/langpacks/" + string + ".xml");
        this.installdata.langpack = new LocaleDatabase((InputStream)object);
    }

    private ArrayList getAvailableLangPacks() throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        InputStream inputStream = this.getClass().getResourceAsStream("/langpacks.info");
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            arrayList.add(dataInputStream.readUTF());
        }
        dataInputStream.close();
        return arrayList;
    }

    protected void loadLookAndFeel() throws Exception {
        boolean bl;
        boolean bl2 = bl = System.getProperty("mrj.version") != null;
        if (this.installdata.kind.equalsIgnoreCase("standard") || this.installdata.kind.equalsIgnoreCase("web") || bl) {
            if (this.getClass().getResourceAsStream("/res/useNativeLAF") != null && !bl) {
                String string = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(string);
            }
            if (UIManager.getLookAndFeel() instanceof MetalLookAndFeel && !bl) {
                MetalLookAndFeel.setCurrentTheme(new IzPackMetalTheme());
                ButtonFactory.useHighlightButtons();
                this.installdata.buttonsHColor = new Color(182, 182, 204);
            }
            this.lnf = "swing";
        } else if (this.installdata.kind.equalsIgnoreCase("standard-kunststoff") || this.installdata.kind.equalsIgnoreCase("web-kunststoff")) {
            ButtonFactory.useHighlightButtons();
            this.installdata.buttonsHColor = new Color(255, 255, 255);
            Class<?> clazz = Class.forName("com.incors.plaf.kunststoff.KunststoffLookAndFeel");
            Class<?> clazz2 = Class.forName("javax.swing.plaf.metal.MetalTheme");
            Class[] classArray = new Class[]{clazz2};
            Class<?> clazz3 = Class.forName("com.izforge.izpack.gui.IzPackKMetalTheme");
            Method method = clazz.getMethod("setCurrentTheme", classArray);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            MetalTheme metalTheme = (MetalTheme)clazz3.newInstance();
            Object[] objectArray = new Object[]{metalTheme};
            UIManager.setLookAndFeel(lookAndFeel);
            method.invoke((Object)lookAndFeel, objectArray);
            this.lnf = "kunststoff";
        }
        ButtonFactory.useButtonIcons();
    }

    private void loadGUI() throws Exception {
        UIManager.put("OptionPane.yesButtonText", this.installdata.langpack.getString("installer.yes"));
        UIManager.put("OptionPane.noButtonText", this.installdata.langpack.getString("installer.no"));
        UIManager.put("OptionPane.cancelButtonText", this.installdata.langpack.getString("installer.cancel"));
        String string = this.installdata.langpack.getString("installer.title") + this.installdata.info.getAppName();
        new InstallerFrame(string, this.installdata);
    }

    class FlagRenderer
    extends JLabel
    implements ListCellRenderer {
        private TreeMap icons = new TreeMap();
        private TreeMap grayIcons = new TreeMap();

        public FlagRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            this.setText(string);
            if (bl) {
                this.setForeground(jList.getSelectionForeground());
                this.setBackground(jList.getSelectionBackground());
            } else {
                this.setForeground(jList.getForeground());
                this.setBackground(jList.getBackground());
            }
            if (!this.icons.containsKey(string)) {
                ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/res/flag." + string));
                this.icons.put(string, imageIcon);
                imageIcon = new ImageIcon(GrayFilter.createDisabledImage(imageIcon.getImage()));
                this.grayIcons.put(string, imageIcon);
            }
            if (bl || n == -1) {
                this.setIcon((ImageIcon)this.icons.get(string));
            } else {
                this.setIcon((ImageIcon)this.grayIcons.get(string));
            }
            return this;
        }
    }

    class LanguageDialog
    extends JDialog
    implements ActionListener {
        private JComboBox comboBox;
        private JButton okButton;

        public LanguageDialog(Object[] objectArray) {
            try {
                GUIInstaller.this.loadLookAndFeel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.addWindowListener(new WindowHandler());
            JPanel jPanel = (JPanel)this.getContentPane();
            this.setTitle("Language selection");
            GridBagLayout gridBagLayout = new GridBagLayout();
            jPanel.setLayout(gridBagLayout);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            ImageIcon imageIcon = this.getImage();
            JLabel jLabel = new JLabel(imageIcon);
            gridBagConstraints.gridy = 0;
            jPanel.add(jLabel);
            gridBagConstraints.fill = 2;
            JLabel jLabel2 = new JLabel("Please select your language (ISO3 code)", 0);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagLayout.addLayoutComponent(jLabel2, gridBagConstraints);
            jPanel.add(jLabel2);
            JLabel jLabel3 = new JLabel("for install instructions:", 0);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(0, 5, 5, 5);
            gridBagLayout.addLayoutComponent(jLabel3, gridBagConstraints);
            jPanel.add(jLabel3);
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.comboBox = new JComboBox<Object>(objectArray);
            this.comboBox.setRenderer(new FlagRenderer());
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 3;
            gridBagLayout.addLayoutComponent(this.comboBox, gridBagConstraints);
            jPanel.add(this.comboBox);
            this.okButton = new JButton("Ok");
            this.okButton.addActionListener(this);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 10;
            gridBagLayout.addLayoutComponent(this.okButton, gridBagConstraints);
            jPanel.add(this.okButton);
            this.getRootPane().setDefaultButton(this.okButton);
            if (System.getProperty("mrj.version") == null) {
                this.pack();
            } else {
                this.setSize(this.getPreferredSize());
            }
            Dimension dimension = this.getSize();
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2 - 10);
            this.setResizable(true);
        }

        public ImageIcon getImage() {
            ImageIcon imageIcon;
            try {
                imageIcon = new ImageIcon(this.getClass().getResource("/res/installer.langsel.img"));
            }
            catch (NullPointerException nullPointerException) {
                imageIcon = null;
            }
            return imageIcon;
        }

        public Object getSelection() {
            return this.comboBox.getSelectedItem();
        }

        public void setSelection(Object object) {
            this.comboBox.setSelectedItem(object);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.dispose();
        }

        class WindowHandler
        extends WindowAdapter {
            WindowHandler() {
            }

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        }
    }
}

