/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.installer.InstallerFrame;
import com.izforge.izpack.installer.IzPanel;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;

public class InstallPanel
extends IzPanel
implements AbstractUIProgressHandler {
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints gbConstraints = new GridBagConstraints();
    protected JLabel tipLabel;
    protected JLabel packOpLabel;
    protected JLabel overallOpLabel;
    protected JProgressBar packProgressBar;
    protected JProgressBar overallProgressBar;
    private volatile boolean validated = false;
    private int noOfPacks = 0;

    public InstallPanel(InstallerFrame installerFrame, InstallData installData) {
        super(installerFrame, installData);
        this.setLayout(this.layout);
        int n = 1;
        this.tipLabel = new JLabel(installerFrame.langpack.getString("InstallPanel.tip"), installerFrame.icons.getImageIcon("information"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, n++, 2, 1, 1.0, 0.0);
        this.gbConstraints.fill = 0;
        this.gbConstraints.anchor = 18;
        this.layout.addLayoutComponent(this.tipLabel, this.gbConstraints);
        this.add(this.tipLabel);
        this.packOpLabel = new JLabel(" ", 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, n++, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 16;
        this.layout.addLayoutComponent(this.packOpLabel, this.gbConstraints);
        this.add(this.packOpLabel);
        this.packProgressBar = new JProgressBar();
        this.packProgressBar.setStringPainted(true);
        this.packProgressBar.setString(installerFrame.langpack.getString("InstallPanel.begin"));
        this.packProgressBar.setValue(0);
        installerFrame.buildConstraints(this.gbConstraints, 0, n++, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 11;
        this.gbConstraints.fill = 2;
        this.layout.addLayoutComponent(this.packProgressBar, this.gbConstraints);
        this.add(this.packProgressBar);
        JSeparator jSeparator = new JSeparator();
        Dimension dimension = new Dimension(0, 10);
        jSeparator.setPreferredSize(dimension);
        jSeparator.setMinimumSize(dimension);
        jSeparator.setMaximumSize(dimension);
        installerFrame.buildConstraints(this.gbConstraints, 0, n++, 2, 1, 1.0, 0.0);
        this.layout.addLayoutComponent(jSeparator, this.gbConstraints);
        this.add(jSeparator);
        this.overallOpLabel = new JLabel(installerFrame.langpack.getString("InstallPanel.progress"), installerFrame.icons.getImageIcon("information"), 11);
        installerFrame.buildConstraints(this.gbConstraints, 0, n++, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 18;
        this.gbConstraints.fill = 0;
        this.layout.addLayoutComponent(this.overallOpLabel, this.gbConstraints);
        this.add(this.overallOpLabel);
        this.overallProgressBar = new JProgressBar();
        this.overallProgressBar.setStringPainted(true);
        this.overallProgressBar.setString("");
        this.overallProgressBar.setValue(0);
        installerFrame.buildConstraints(this.gbConstraints, 0, n++, 2, 1, 1.0, 0.0);
        this.gbConstraints.anchor = 11;
        this.gbConstraints.fill = 2;
        this.layout.addLayoutComponent(this.overallProgressBar, this.gbConstraints);
        this.add(this.overallProgressBar);
    }

    public boolean isValidated() {
        return this.validated;
    }

    public void startAction(String string, int n) {
        this.parent.blockGUI();
        this.noOfPacks = n;
        this.overallProgressBar.setMinimum(0);
        this.overallProgressBar.setMaximum(this.noOfPacks);
        this.overallProgressBar.setString("0 / " + Integer.toString(this.noOfPacks));
    }

    public void errorUnpack(String string) {
        this.packOpLabel.setText(string);
        this.idata.installSuccess = false;
        JOptionPane.showMessageDialog(this, string.toString(), this.parent.langpack.getString("installer.error"), 0);
    }

    public void stopAction() {
        this.parent.releaseGUI();
        this.parent.lockPrevButton();
        this.overallProgressBar.setValue(this.overallProgressBar.getValue() + 1);
        this.packProgressBar.setString(this.parent.langpack.getString("InstallPanel.finished"));
        this.packProgressBar.setEnabled(false);
        String string = Integer.toString(this.noOfPacks);
        this.overallProgressBar.setString(string + " / " + string);
        this.overallProgressBar.setEnabled(false);
        this.packOpLabel.setText(" ");
        this.packOpLabel.setEnabled(false);
        this.idata.installSuccess = true;
        this.idata.canClose = true;
        this.validated = true;
        if (this.idata.panels.indexOf(this) != this.idata.panels.size() - 1) {
            this.parent.unlockNextButton();
        }
    }

    public void progress(int n, String string) {
        this.packProgressBar.setValue(n + 1);
        this.packOpLabel.setText(string);
    }

    public void nextStep(String string, int n, int n2) {
        this.packProgressBar.setValue(0);
        this.packProgressBar.setMinimum(0);
        this.packProgressBar.setMaximum(n2);
        this.packProgressBar.setString(string);
        this.overallProgressBar.setValue(n - 1);
        this.overallProgressBar.setString(Integer.toString(n) + " / " + Integer.toString(this.noOfPacks));
    }

    public void panelActivate() {
        Dimension dimension = this.parent.getPanelsContainerSize();
        dimension.width -= dimension.width / 4;
        dimension.height = 150;
        this.setMinimumSize(dimension);
        this.setMaximumSize(dimension);
        this.setPreferredSize(dimension);
        this.parent.lockNextButton();
        this.parent.install(this);
    }
}

