/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.NumericUtils;
import org.musicbrainz.search.LuceneVersion;
import org.musicbrainz.search.index.ReleaseIndexField;
import org.musicbrainz.search.servlet.mmd1.ReleaseGroupType;
import org.musicbrainz.search.servlet.mmd1.ReleaseStatus;

public class ReleaseQueryParser
extends MultiFieldQueryParser {
    public ReleaseQueryParser(String[] strings, Analyzer a) {
        super(LuceneVersion.LUCENE_VERSION, strings, a);
    }

    protected Query newTermQuery(Term term) {
        if (term.field().equals(ReleaseIndexField.TYPE.getName())) {
            try {
                int typeId = Integer.parseInt(term.text());
                if (typeId >= ReleaseGroupType.getMinSearchId() && typeId <= ReleaseGroupType.getMaxSearchId()) {
                    TermQuery tq = new TermQuery(new Term(term.field(), ReleaseGroupType.getBySearchId((int)typeId).getName()));
                    return tq;
                }
                return super.newTermQuery(term);
            }
            catch (NumberFormatException nfe) {
                return super.newTermQuery(term);
            }
        }
        if (term.field().equals(ReleaseIndexField.STATUS.getName())) {
            try {
                int statusId = Integer.parseInt(term.text());
                if (statusId >= ReleaseStatus.getMinSearchId() && statusId <= ReleaseStatus.getMaxSearchId()) {
                    TermQuery tq = new TermQuery(new Term(term.field(), ReleaseStatus.getBySearchId((int)statusId).getName()));
                    return tq;
                }
                return super.newTermQuery(term);
            }
            catch (NumberFormatException nfe) {
                return super.newTermQuery(term);
            }
        }
        if (term.field().equals(ReleaseIndexField.NUM_TRACKS.getName()) || term.field().equals(ReleaseIndexField.NUM_TRACKS_MEDIUM.getName()) || term.field().equals(ReleaseIndexField.NUM_MEDIUMS.getName()) || term.field().equals(ReleaseIndexField.NUM_DISCIDS.getName()) || term.field().equals(ReleaseIndexField.NUM_DISCIDS_MEDIUM.getName())) {
            try {
                int number = Integer.parseInt(term.text());
                BytesRefBuilder bytes = new BytesRefBuilder();
                NumericUtils.intToPrefixCoded((int)number, (int)0, (BytesRefBuilder)bytes);
                TermQuery tq = new TermQuery(new Term(term.field(), bytes.toBytesRef().utf8ToString()));
                return tq;
            }
            catch (NumberFormatException nfe) {
                return super.newTermQuery(term);
            }
        }
        return super.newTermQuery(term);
    }

    public Query newRangeQuery(String field, String part1, String part2, boolean startInclusive, boolean endInclusive) {
        if (field.equals(ReleaseIndexField.NUM_TRACKS.getName()) || field.equals(ReleaseIndexField.NUM_TRACKS_MEDIUM.getName()) || field.equals(ReleaseIndexField.NUM_MEDIUMS.getName()) || field.equals(ReleaseIndexField.NUM_DISCIDS.getName()) || field.equals(ReleaseIndexField.NUM_DISCIDS_MEDIUM.getName())) {
            BytesRefBuilder bytes1 = new BytesRefBuilder();
            BytesRefBuilder bytes2 = new BytesRefBuilder();
            NumericUtils.intToPrefixCoded((int)Integer.parseInt(part1), (int)0, (BytesRefBuilder)bytes1);
            NumericUtils.intToPrefixCoded((int)Integer.parseInt(part2), (int)0, (BytesRefBuilder)bytes2);
            part1 = bytes1.toBytesRef().utf8ToString();
            part2 = bytes2.toBytesRef().utf8ToString();
        }
        TermRangeQuery query = (TermRangeQuery)super.newRangeQuery(field, part1, part2, startInclusive, endInclusive);
        return query;
    }
}

