/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet;

import com.google.common.base.Strings;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TimeLimitingCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.musicbrainz.search.servlet.AbstractDismaxSearchServer;
import org.musicbrainz.search.servlet.AbstractSearchServer;
import org.musicbrainz.search.servlet.CallableSearch;
import org.musicbrainz.search.servlet.ErrorMessage;
import org.musicbrainz.search.servlet.MusicBrainzSearcherFactory;
import org.musicbrainz.search.servlet.RateLimiterChecker;
import org.musicbrainz.search.servlet.RequestParameter;
import org.musicbrainz.search.servlet.ResourceType;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.ResultsWriter;
import org.musicbrainz.search.servlet.SearchServer;
import org.musicbrainz.search.servlet.mmd2.AllWriter;

public class SearchServerServlet
extends HttpServlet {
    final Logger log = Logger.getLogger(SearchServerServlet.class.getName());
    static final int DEFAULT_OFFSET = 0;
    static final int DEFAULT_MATCHES_LIMIT = 25;
    static final int MAX_MATCHES_LIMIT = 100;
    public static final String RESPONSE_XML = "xml";
    public static final String RESPONSE_JSON = "json";
    public static final String RESPONSE_JSON_NEW = "jsonnew";
    static final String WS_VERSION_1 = "1";
    static final String WS_VERSION_2 = "2";
    static final String CHARSET = "UTF-8";
    static final String TYPE_ALL = "all";
    static final String TYPE_TRACK = "track";
    private boolean isServletInitialized = false;
    private boolean isSearchAllEnabled = true;
    private final ExecutorService es = Executors.newCachedThreadPool();
    private final EnumMap<ResourceType, SearchServer> searchers = new EnumMap(ResourceType.class);
    private final EnumMap<ResourceType, SearchServer> dismaxSearchers = new EnumMap(ResourceType.class);
    private final String initMessage;
    private static String searchWebPage = "";
    private static boolean isRateLimiterEnabled = false;
    private static boolean isAdminRemoteEnabled = false;

    public SearchServerServlet() {
        this.initMessage = null;
    }

    public void init() {
        String init = this.getServletConfig().getInitParameter("init");
        if (init != null && init.equals("nfio")) {
            this.init(false);
        } else {
            this.init(true);
        }
    }

    public void init(boolean useMMapDirectory) {
        searchWebPage = this.getServletConfig().getInitParameter("search_webpage");
        String isAdminRemote = this.getServletConfig().getInitParameter("remoteadmin_enabled");
        isAdminRemoteEnabled = Boolean.parseBoolean(isAdminRemote);
        String rateLimiterEnabled = this.getServletConfig().getInitParameter("ratelimitserver_enabled");
        this.initRateLimiter(rateLimiterEnabled);
        String indexDir = this.getServletConfig().getInitParameter("index_dir");
        if (useMMapDirectory) {
            this.log.info("Start:Loading Indexes from " + indexDir + ",Type:mmap,MaxHeap:" + ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
        } else {
            this.log.info("Start:loading Indexes from " + indexDir + ",Type:nfio,MaxHeap:" + ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax());
        }
        for (ResourceType resourceType : ResourceType.values()) {
            AbstractDismaxSearchServer dismaxSearchServer;
            AbstractSearchServer searchServer;
            block12: {
                File indexFileDir = new File(indexDir + System.getProperty("file.separator") + resourceType.getIndexName() + "_index");
                searchServer = null;
                dismaxSearchServer = null;
                try {
                    MMapDirectory directory = useMMapDirectory ? new MMapDirectory(indexFileDir) : new NIOFSDirectory(indexFileDir);
                    SearcherManager searcherManager = new SearcherManager((Directory)directory, (SearcherFactory)new MusicBrainzSearcherFactory(resourceType));
                    searchServer = (AbstractSearchServer)resourceType.getSearchServerClass().getConstructor(SearcherManager.class).newInstance(searcherManager);
                    dismaxSearchServer = (AbstractDismaxSearchServer)resourceType.getDismaxSearchServerClass().getConstructor(AbstractSearchServer.class).newInstance(searchServer);
                }
                catch (CorruptIndexException e) {
                    if (resourceType.isUsedBySearchAll()) {
                        this.isSearchAllEnabled = false;
                    }
                }
                catch (IOException e) {
                    if (resourceType.isUsedBySearchAll()) {
                        this.isSearchAllEnabled = false;
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.WARNING, "Could not load " + resourceType.getIndexName() + " index: " + e.getMessage(), e);
                    if (!resourceType.isUsedBySearchAll()) break block12;
                    this.isSearchAllEnabled = false;
                }
            }
            SearchServer oldSearchServer = (SearchServer)this.searchers.get(resourceType);
            if (oldSearchServer != null) {
                try {
                    oldSearchServer.close();
                }
                catch (IOException e) {
                    this.log.severe("Caught exception during closing of index searcher within Init: " + resourceType.getIndexName() + ":" + e.getMessage());
                }
            }
            this.searchers.put(resourceType, searchServer);
            this.dismaxSearchers.put(resourceType, dismaxSearchServer);
        }
        this.isServletInitialized = true;
    }

    public void destroy() {
        for (SearchServer searchServer : this.searchers.values()) {
            if (searchServer == null) continue;
            try {
                searchServer.close();
            }
            catch (IOException e) {
                this.log.severe("Caught exception during closing of index searcher: " + e.getMessage());
            }
        }
        this.searchers.clear();
        for (SearchServer searchServer : this.dismaxSearchers.values()) {
            if (searchServer == null) continue;
            try {
                searchServer.close();
            }
            catch (IOException e) {
                this.log.severe("Caught exception during closing of index searcher: " + e.getMessage());
            }
        }
        this.dismaxSearchers.clear();
    }

    private void initRateLimiter(String rateLimiterEnabled) {
        String rateLimiterHost = this.getServletConfig().getInitParameter("ratelimitserver_host");
        String rateLimiterPort = this.getServletConfig().getInitParameter("ratelimitserver_port");
        isRateLimiterEnabled = Boolean.parseBoolean(rateLimiterEnabled);
        if (isRateLimiterEnabled) {
            RateLimiterChecker.init((String)rateLimiterHost, (String)rateLimiterPort);
        }
    }

    protected void reloadIndexes() {
        for (SearchServer searchServer : this.searchers.values()) {
            if (searchServer == null) continue;
            try {
                searchServer.reloadIndex();
            }
            catch (IOException e) {
                this.log.severe("Caught exception during reopening of index: " + e.getMessage());
            }
        }
    }

    private boolean isRequestFromLocalHost(HttpServletRequest request) {
        return isAdminRemoteEnabled || request.getRemoteAddr().equals("127.0.0.1") || request.getRemoteAddr().equals("0:0:0:0:0:0:0:1");
    }

    private void outputConfirmation(HttpServletResponse response, String msg) throws IOException {
        response.setCharacterEncoding(CHARSET);
        response.setContentType("text/plain; charset=UTF-8; charset=UTF-8");
        response.getWriter().println(msg);
        response.getWriter().close();
    }

    private boolean processedAdminCommand(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String init = request.getParameter(RequestParameter.INIT.getName());
        if (init != null) {
            if (this.isRequestFromLocalHost(request)) {
                this.init(init.equals("mmap"));
                this.outputConfirmation(response, "Indexes Loaded:");
                return true;
            }
            response.sendError(403);
            return true;
        }
        String rate = request.getParameter(RequestParameter.RATE.getName());
        if (rate != null) {
            if (this.isRequestFromLocalHost(request)) {
                this.initRateLimiter(rate);
                this.outputConfirmation(response, "Rate Limiter:" + rate);
                return true;
            }
            response.sendError(403);
            return true;
        }
        String reloadIndexes = request.getParameter(RequestParameter.RELOAD_INDEXES.getName());
        if (reloadIndexes != null) {
            if (this.isRequestFromLocalHost(request)) {
                this.reloadIndexes();
                this.outputConfirmation(response, "Indexes Reloaded");
                return true;
            }
            response.sendError(403);
            return true;
        }
        String gc = request.getParameter(RequestParameter.GC.getName());
        if (gc != null) {
            if (this.isRequestFromLocalHost(request)) {
                System.gc();
                this.outputConfirmation(response, "Garbage Collection Requested");
                return true;
            }
            response.sendError(403);
            return true;
        }
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String query = "";
        try {
            String responseVersion;
            RateLimiterChecker.RateLimiterResponse rateLimiterResponse;
            if (!this.isServletInitialized) {
                response.sendError(500, ErrorMessage.SERVLET_INIT_FAILED.getMsg(new Object[]{this.initMessage}));
                return;
            }
            request.setCharacterEncoding(CHARSET);
            if (this.processedAdminCommand(request, response)) {
                return;
            }
            String count = request.getParameter(RequestParameter.COUNT.getName());
            if (count != null) {
                ResourceType resourceType = ResourceType.getValue((String)count);
                if (resourceType == null) {
                    response.sendError(400, ErrorMessage.UNKNOWN_COUNT_TYPE.getMsg(new Object[]{count}));
                    return;
                }
                SearchServer searchServerCount = (SearchServer)this.searchers.get(resourceType);
                this.outputConfirmation(response, searchServerCount.getCount());
                return;
            }
            if (request.getParameterMap().size() == 0) {
                response.sendRedirect(searchWebPage);
                return;
            }
            String type = request.getParameter(RequestParameter.TYPE.getName());
            if (type == null) {
                response.sendError(400, ErrorMessage.UNKNOWN_RESOURCE_TYPE.getMsg(new Object[]{"none"}));
                return;
            }
            if (type.equals(TYPE_TRACK)) {
                type = ResourceType.RECORDING.getName();
            }
            ResourceType resourceType = null;
            if (!type.equalsIgnoreCase(TYPE_ALL)) {
                resourceType = ResourceType.getValue((String)type);
                if (resourceType == null) {
                    response.sendError(400, ErrorMessage.UNKNOWN_RESOURCE_TYPE.getMsg(new Object[]{type}));
                    return;
                }
            } else if (!this.isSearchAllEnabled) {
                response.sendError(500, ErrorMessage.INDEX_NOT_AVAILABLE_FOR_TYPE.getMsg(new Object[]{TYPE_ALL}));
                return;
            }
            if (isRateLimiterEnabled && !(rateLimiterResponse = RateLimiterChecker.checkRateLimiter((HttpServletRequest)request)).isValid()) {
                if (rateLimiterResponse.getHeaderMsg() != null) {
                    response.setHeader(RateLimiterChecker.HEADER_RATE_LIMITED, rateLimiterResponse.getHeaderMsg());
                }
                response.sendError(503, rateLimiterResponse.getMsg());
                return;
            }
            query = request.getParameter(RequestParameter.QUERY.getName());
            if (Strings.isNullOrEmpty((String)query)) {
                response.sendError(400, ErrorMessage.NO_QUERY_PARAMETER.getMsg());
                return;
            }
            String responseFormat = request.getParameter(RequestParameter.FORMAT.getName());
            if (Strings.isNullOrEmpty((String)responseFormat)) {
                Enumeration headers = request.getHeaders("Accept");
                while (headers.hasMoreElements()) {
                    String nextHeader = (String)headers.nextElement();
                    if (!nextHeader.equals("application/json")) continue;
                    responseFormat = RESPONSE_JSON_NEW;
                    break;
                }
                if (responseFormat == null) {
                    responseFormat = RESPONSE_XML;
                }
            }
            if (Strings.isNullOrEmpty((String)(responseVersion = request.getParameter(RequestParameter.VERSION.getName())))) {
                responseVersion = WS_VERSION_2;
            }
            Integer offset = 0;
            String strOffset = request.getParameter(RequestParameter.OFFSET.getName());
            if (!Strings.isNullOrEmpty((String)strOffset)) {
                offset = new Integer(strOffset);
            }
            Integer limit = 25;
            String strLimit = request.getParameter(RequestParameter.LIMIT.getName());
            String strMax = request.getParameter(RequestParameter.MAX.getName());
            if (!Strings.isNullOrEmpty((String)strLimit)) {
                limit = new Integer(strLimit);
                if (limit > 100) {
                    limit = 100;
                }
            } else if (!Strings.isNullOrEmpty((String)strMax) && (limit = new Integer(strMax)) > 100) {
                limit = 100;
            }
            boolean isExplain = false;
            String strIsExplain = request.getParameter(RequestParameter.EXPLAIN.getName());
            if (strIsExplain != null && strIsExplain.equals("true")) {
                isExplain = true;
            }
            boolean isPretty = false;
            String strIsPretty = request.getParameter(RequestParameter.PRETTY.getName());
            if (strIsPretty != null && strIsPretty.equals("true")) {
                isPretty = true;
            }
            boolean isDismax = false;
            String strIsDismax = request.getParameter(RequestParameter.DISMAX.getName());
            if (strIsDismax != null && strIsDismax.equals("true")) {
                isDismax = true;
            }
            try {
                if (resourceType != null) {
                    this.doSearch(response, resourceType, query, isDismax, isExplain, isPretty, offset, limit, responseFormat, responseVersion);
                } else {
                    this.doAllSearch(response, query, isDismax, offset, limit, responseFormat, isPretty);
                }
            }
            catch (TimeLimitingCollector.TimeExceededException tee) {
                this.log.info("Query timeout: " + query);
                response.sendError(408, ErrorMessage.REQUEST_TIMEOUT_EXCEEDED.getMsg());
                return;
            }
        }
        catch (ParseException pe) {
            response.sendError(400, ErrorMessage.UNABLE_TO_PARSE_SEARCH.getMsg(new Object[]{query}));
            return;
        }
        catch (NullPointerException npe) {
            if (this.isUnescapedBackslashIssue(npe.getStackTrace(), query)) {
                response.sendError(400, ErrorMessage.UNABLE_TO_PARSE_SEARCH_SLASHES_ARE_REGEXP.getMsg(new Object[]{query}));
            }
            this.log.log(Level.WARNING, query + ":" + npe.getMessage(), npe);
            response.sendError(400, npe.getMessage());
            return;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, query + ":" + e.getMessage(), e);
            response.sendError(400, e.getMessage());
            return;
        }
        catch (Throwable t) {
            this.log.log(Level.WARNING, query + ":" + t.getMessage(), t);
            response.sendError(400, t.getMessage());
            return;
        }
    }

    public boolean isUnescapedBackslashIssue(StackTraceElement[] stackTrace, String query) {
        return query.contains("/") && stackTrace[0].getClassName().equals("java.util.TreeMap") && stackTrace[0].getMethodName().equals("getEntry");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSearch(HttpServletResponse response, ResourceType resourceType, String query, boolean isDismax, boolean isExplain, boolean isPretty, Integer offset, Integer limit, String responseFormat, String responseVersion) throws ParseException, IOException {
        SearchServer searchServer = isDismax ? (SearchServer)this.dismaxSearchers.get(resourceType) : (SearchServer)this.searchers.get(resourceType);
        if (searchServer == null) {
            response.sendError(500, ErrorMessage.INDEX_NOT_AVAILABLE_FOR_TYPE.getMsg(new Object[]{resourceType}));
            return;
        }
        if (isExplain) {
            response.sendError(403, "explain is disable for public users");
            return;
        }
        long startLucene = System.currentTimeMillis();
        Results results = searchServer.search(query, offset.intValue(), limit.intValue());
        ResultsWriter writer = searchServer.getWriter(responseVersion);
        if (writer == null) {
            response.sendError(500, ErrorMessage.NO_HANDLER_FOR_TYPE_AND_FORMAT.getMsg(new Object[]{resourceType, responseFormat}));
            return;
        }
        response.setCharacterEncoding(CHARSET);
        if (responseFormat.equals(RESPONSE_XML)) {
            response.setContentType(writer.getMimeType());
        } else {
            response.setContentType(((org.musicbrainz.search.servlet.mmd2.ResultsWriter)writer).getJsonMimeType());
        }
        if (writer.getLastUpdateDate() != null) {
            response.setDateHeader("Last-Modified", writer.getLastUpdateDate().getTime());
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), CHARSET)));
        try {
            long startSer = System.currentTimeMillis();
            writer.write(out, results, responseFormat, isPretty);
            if (resourceType.getName() == "recording") {
                this.log.info("lucene:" + (System.currentTimeMillis() - startLucene) + " serialize:" + (System.currentTimeMillis() - startSer) + " query " + query);
            }
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAllSearch(HttpServletResponse response, String query, boolean isDismax, Integer offset, Integer limit, String responseFormat, boolean isPretty) throws Exception {
        SearchServer artistSearch = isDismax ? (SearchServer)this.dismaxSearchers.get(ResourceType.ARTIST) : (SearchServer)this.searchers.get(ResourceType.ARTIST);
        SearchServer releaseSearch = isDismax ? (SearchServer)this.dismaxSearchers.get(ResourceType.RELEASE) : (SearchServer)this.searchers.get(ResourceType.RELEASE);
        SearchServer releaseGroupSearch = isDismax ? (SearchServer)this.dismaxSearchers.get(ResourceType.RELEASE_GROUP) : (SearchServer)this.searchers.get(ResourceType.RELEASE_GROUP);
        SearchServer labelSearch = isDismax ? (SearchServer)this.dismaxSearchers.get(ResourceType.LABEL) : (SearchServer)this.searchers.get(ResourceType.LABEL);
        SearchServer recordingSearch = isDismax ? (SearchServer)this.dismaxSearchers.get(ResourceType.RECORDING) : (SearchServer)this.searchers.get(ResourceType.RECORDING);
        SearchServer workSearch = isDismax ? (SearchServer)this.dismaxSearchers.get(ResourceType.WORK) : (SearchServer)this.searchers.get(ResourceType.WORK);
        ArrayList<CallableSearch> searches = new ArrayList<CallableSearch>();
        searches.add(new CallableSearch(artistSearch, query, offset, limit));
        searches.add(new CallableSearch(releaseSearch, query, offset, limit));
        searches.add(new CallableSearch(releaseGroupSearch, query, offset, limit));
        searches.add(new CallableSearch(labelSearch, query, offset, limit));
        searches.add(new CallableSearch(recordingSearch, query, offset, limit));
        searches.add(new CallableSearch(workSearch, query, offset, limit));
        List results = this.es.invokeAll(searches);
        Results allResults = new Results();
        Results artistResults = (Results)results.get(0).get();
        Results releaseResults = (Results)results.get(1).get();
        Results releaseGroupResults = (Results)results.get(2).get();
        Results labelResults = (Results)results.get(3).get();
        Results recordingResults = (Results)results.get(4).get();
        Results workResults = (Results)results.get(5).get();
        AllWriter writer = new AllWriter(offset.intValue(), limit.intValue(), artistResults, releaseResults, releaseGroupResults, labelResults, recordingResults, workResults);
        response.setCharacterEncoding(CHARSET);
        if (responseFormat.equals(RESPONSE_XML)) {
            response.setContentType(writer.getMimeType());
        } else {
            response.setContentType(writer.getJsonMimeType());
        }
        if (writer.getLastUpdateDate() != null) {
            response.setDateHeader("Last-Modified", writer.getLastUpdateDate().getTime());
        }
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream(), CHARSET)));
        try {
            writer.write(out, allResults, responseFormat, isPretty);
        }
        finally {
            out.close();
        }
    }
}

