/*
 * Decompiled with CFR 0.152.
 */
package org.musicbrainz.search.servlet.mmd1;

import com.google.common.base.Strings;
import com.jthink.brainz.mmd.Label;
import com.jthink.brainz.mmd.LabelList;
import com.jthink.brainz.mmd.LifeSpan;
import com.jthink.brainz.mmd.Metadata;
import com.jthink.brainz.mmd.ObjectFactory;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.commons.lang.StringUtils;
import org.musicbrainz.search.MbDocument;
import org.musicbrainz.search.index.IndexField;
import org.musicbrainz.search.index.LabelIndexField;
import org.musicbrainz.search.index.MMDSerializer;
import org.musicbrainz.search.servlet.Result;
import org.musicbrainz.search.servlet.Results;
import org.musicbrainz.search.servlet.mmd1.Mmd1XmlWriter;

public class LabelMmd1XmlWriter
extends Mmd1XmlWriter {
    public Metadata write(Results results) throws IOException {
        ObjectFactory of = new ObjectFactory();
        Metadata metadata = of.createMetadata();
        LabelList labelList = of.createLabelList();
        for (Result result : results.results) {
            MbDocument doc = result.getDoc();
            Label label = of.createLabel();
            result.setNormalizedScore(results.getMaxScore());
            label.getOtherAttributes().put(this.getScore(), String.valueOf(result.getNormalizedScore()));
            org.musicbrainz.mmd2.Label labelv2 = (org.musicbrainz.mmd2.Label)MMDSerializer.unserialize((String)doc.get((IndexField)LabelIndexField.LABEL_STORE), org.musicbrainz.mmd2.Label.class);
            label.setId(labelv2.getId());
            label.setType(StringUtils.capitalize((String)labelv2.getType()));
            label.setName(labelv2.getName());
            if (!Strings.isNullOrEmpty((String)labelv2.getSortName())) {
                label.setSortName(labelv2.getSortName());
            }
            if (labelv2.getLabelCode() != null) {
                label.setLabelCode(labelv2.getLabelCode());
            }
            if (!Strings.isNullOrEmpty((String)labelv2.getDisambiguation())) {
                label.setDisambiguation(labelv2.getDisambiguation());
            }
            if (labelv2.getLifeSpan() != null) {
                String begin = labelv2.getLifeSpan().getBegin();
                String end = labelv2.getLifeSpan().getEnd();
                if (begin != null || end != null) {
                    LifeSpan lifespan = of.createLifeSpan();
                    if (begin != null) {
                        lifespan.setBegin(begin);
                    }
                    if (end != null) {
                        lifespan.setEnd(end);
                    }
                    label.setLifeSpan(lifespan);
                }
            }
            labelList.getLabel().add(label);
        }
        labelList.setCount(BigInteger.valueOf(results.getTotalHits()));
        labelList.setOffset(BigInteger.valueOf(results.getOffset()));
        metadata.setLabelList(labelList);
        return metadata;
    }
}

